/* -----------------------------------------------
Title: Common script
Author: Jarid Love
Last Modified: 10 Jun 2008
----------------------------------------------- */

// set path variables
var isSSL = (location.protocol == "https:")?true:false;
var isStage = (location.href.indexOf("stage") > 0) ? true : false;
var isTest = (location.href.indexOf("wwwtest.provo.novell.com") > 0) ? true : false;
var isDev = (location.href.indexOf("wwwdev.provo.novell.com") > 0) ? true : false;
var redirect = (location.href.indexOf("forceRedirect=false") > 0) ?  false: true;
function getSecureUrl() {
	return (isTest)?"https://secure-wwwtest.provo.novell.com":(isStage)?"https://secure-wwwstage.provo.novell.com":"https://secure-www.novell.com";
}

var s = (isDev)?"http://wwwdev.provo.novell.com":(isTest)?"http://wwwtest.provo.novell.com":(isStage)?"http://wwwstage.provo.novell.com":"http://www.novell.com";
var ss = (isSSL)? getSecureUrl() : s;
var n_domain = location.host; 
var n_dirs = location.pathname.split("/");
var n_root = (n_dirs.length>2)?n_dirs[1]:null;
var n_root2 = (n_dirs.length>3)?n_dirs[2]:null;

// environment version detection variables
var isDOM = (document.getElementById)?true:false; // all DOM based browsers including IE
var isNS4 = (document.layers)?true:false;
var isIE = (document.all)?true:false;
var isMac = (navigator.appVersion.indexOf("Mac") != -1)?true:false;
var isWin = (navigator.appVersion.indexOf("Win") != -1)?true:false;
var usragent = navigator.userAgent.toLowerCase();
var isOperaBadDom = (usragent.substr(usragent.indexOf("opera")+6,1)<=6)?true:false; // this detects opera 6 or below which have crappy DOM support
var isOperaGoodDom = (usragent.substr(usragent.indexOf("opera")+6,1)>6)?true:false;
var isKonqueror = (usragent.indexOf("konqueror")>=0)?true:false;
var langCompatible = (isDOM && n_domain.indexOf("novell.com") >= 0);

// script for localization
function readCookie(name) {
	var cks = document.cookie.split(';');
	for(var i=cks.length-1; i >= 0; i--) {
		var c = cks[i];
		while(c.charAt(0)==' ') c = c.substring(1,c.length);
		if(c.indexOf(name+"=")==0) return c.substring(name.length+1,c.length);
	}
	return null;
}

function getPageCharset() {
	var mt = document.getElementsByTagName('meta');
	for(var i=0; i<mt.length; i++) {
		var ct = mt[i].getAttribute('content');
		if(ct != null && ct.toLowerCase().indexOf('charset=') != -1) return ct.substring(ct.toLowerCase().indexOf('charset=')+8);
	}
	return "iso-8859-1";
}

var n_lang = readCookie("novell_language");
var n_country = readCookie("novell_country");
var n_cnt=(n_country!=null && n_country.length>3)?n_country.substring(0,2):"US";
var n_enc = getPageCharset();

// language redirection
var langOverride = getQueryParm("lang");
if(langOverride != null) {
	n_lang = n_root;
	redirect = false;
}

function siteSupportsLang() {
	var n_lang_sites = ["supportstage.provo.novell.com","support.novell.com",s.substring(7,s.length)]; // sites that support localization
	for(var i = n_lang_sites.length-1;i > -1; i--) if(n_domain == n_lang_sites[i]) return true;
	return false;
}

function isNonEnglishDir(dir) {
	if(dir == null) return false;
	var langDirs = ["de-de","es-es","fr-fr","it-it","nl-nl","cs-cz","zh-cn","zh-tw","ja-jp","hu-hu","pl-pl","pt-br","ru-ru","sv-se","fi-fi","da-dk","no-no"];
	for(var i = langDirs.length-1; i > -1; i--) if(langDirs[i] == dir) return true;
	return false;
}

function isFilteredRootDir(dir) {
	switch(dir) {
		case "communities" :
		case "rc" :
		case "cgi-bin" :
		case "servlet" :
		case "global" :
		case "ICSLogin" :
		case "ICHAINLogout" :
			return true;
		default :
			return false;
	}
}

function setLang(lang) {
	// 31536000000 = 365 days * 24 hours * 60 min * 60 s * 1000 ms
	document.cookie = "novell_language="+lang+";expires="+(new Date(new Date().getTime()+31536000000)).toGMTString()+";path=/;domain=.novell.com";
}
function setCountry(co,coname) {
	var durration = (co == "") ? 0 : 31536000000; // 31536000000 = 365 days * 24 hours * 60 min * 60 s * 1000 ms
	document.cookie = "novell_country="+co+"|"+coname+";expires="+(new Date(new Date().getTime()+durration)).toGMTString()+";path=/;domain=.novell.com";
}

if(siteSupportsLang() && langCompatible && typeof is404Page == "undefined") {
	if(n_lang==null) {
		if(typeof defaultPageLang != "undefined" && typeof defaultPageCntry != "undefined") {
			n_lang = defaultPageLang;
			n_country = defaultPageCntry;
			n_co_array = n_country.split("|");
			setCountry(n_co_array[0],n_co_array[1]);
		}
		else n_lang = (isNonEnglishDir(n_root)) ? n_root : "en-us"; // no language selected or cookies not supported so default to lang of current lang dir
		setLang(n_lang);
	}
	else if(redirect==true && !isFilteredRootDir(n_root)) {
		var isPlone = (typeof is_plone != 'undefined' && is_plone) ? true : false;
		if(isPlone || location.pathname.indexOf(".htm") >= 0 || location.pathname.lastIndexOf('/') == location.pathname.length-1) {
			if((n_lang != "en-us" && n_root != n_lang) || (n_lang == "en-us" && isNonEnglishDir(n_root)) || (n_root2 == null && n_cnt != "US") || (n_lang == n_root && n_root2 != null && (n_root2.length == 2 || isPlone) && n_root2 != n_cnt)) {
				// not in correct lang location
				if(isPlone) {
					// file is plone generated so redirect to lang path
					var targetUrl = location.protocol+"//"+location.hostname;
					if(n_lang != "en-us" || (n_lang == "en-us" && n_cnt != "US")) {
						targetUrl += "/"+n_lang;
						if(n_cnt != "US") {
							targetUrl += "/"+n_cnt;
						}
					}
					var targetPath = (isNonEnglishDir(n_root) || n_root == "en-us") ?  location.pathname.substring(6) : location.pathname;
					targetPath = (n_root2 != null && n_root2.length == 2 && n_root2.search(/[A-Z][A-Z]/) > -1) ? targetPath.substring(3) : targetPath;
					targetUrl += targetPath + location.search;
					if(targetUrl != location.href) window.location.replace(targetUrl);
				}
				else {
					// temporary code for home page
					if(location.pathname == "/" && (n_lang == "de-de" || n_lang == "it-it" || n_lang == "es-es" || n_lang == "fr-fr" || n_lang == "ja-jp" || n_lang == "zh-cn" || n_lang == "zh-tw" || n_lang == "pl-pl" || n_lang == "nl-nl" || n_lang == "pt-br" || n_lang == "ru-ru" || n_lang == "sv-se")) window.location.replace("http://www.novell.com/"+n_lang+"/");
					
					// the following include checks the file system to see if there is a better location to redirect to based on country/lang
					document.write('<script type="text/javascript" src="/common/util/langredirect.php?url='+escape(location.href)+'"></script>');
				}
			}
		}
	}
}

// include menu generating script if compatible and layout css
if(isDOM) { 
	if(window.name == "printer_friendly") {
		document.write('<link rel="stylesheet" type="text/css" href="/common/inc/printerfriendly.css" title="Printer Friendly" />');
		var s_prop15=location.href;
	}
	document.write('<script type="text/javascript" src="/common/inc/nav/main.js"><\/script>');
	var hasHdrNav = true; 
}

function showPrinterFriendly() {
	if(document.getElementById("contentcontainer")) {
		var pfwindow = window.open(location.href,"printer_friendly");
		pfwindow.focus();
	}
	else window.open(s+'/inc/pf/pf.jsp?url='+escape(location.href)+'&sourceid=PrinterFriendlyFromFooter');
}

// include text for header/footer
function loadHdrTransltion(suffix) {
	suffix = (suffix == 'en-us' || n_lang == null) ? "" : '_' + suffix;
	document.write('<script type="text/javascript" src="/common/inc/local/hdr_txt'+suffix+'.js"><\/script>');
}
if(n_domain.indexOf("novell.de") >= 0) loadHdrTransltion("de-de");
else if(n_domain.indexOf("novell.co.jp") >= 0) loadHdrTransltion("ja-jp");
else loadHdrTransltion((typeof navlang!="undefined") ? navlang : n_lang);

// random int method
function getRandomInt(min, max) {
	return (min >= max) ? max : Math.floor(((max+1 - min)*Math.random())+min);
}

// fn to open a new window when linking to an external site
function openExternal(URL, w, h, s, n, r) {	// It is possible to bypass w and h by passing in 'noW', 'noH'
	var attr = "";
	if(typeof w != "undefined" && w!= 'noW') attr += "width=" + w;
	if(typeof h != "undefined" && h != 'noH') attr += ",height=" + h;
	if(attr.length > 0) { // when no width or height is specified, use window core defaults, do not add any other values
		attr += (typeof s != "undefined" && s == true) ? ',scrollbars=yes' : ',scrollbars=no'; // default on sized window = no scrollbars
		attr += (typeof r != "undefined" && r == false) ? ',resizable=no' : ',resizable=yes'; // default on sized window = resizable
	}
	if(attr.charAt(0)==",") attr = attr.substring(1);
	var winExt = (!n) ? window.open(URL,'_blank',attr) : window.open(URL,n,attr);
	if(winExt && winExt.blur) winExt.focus();
}

function getQueryParm(name) {
	var params = document.params;
	if(!params) {
		document.params = (location.search.substring(1)).split("&");
		params = document.params;
	}
	for(var i = 0; i < params.length; i++) {
		var param = params[i].split("=");
		if(param[0] == name) return param[1];
	}
	return null;
}

// code to track adwords
var gAdword = getQueryParm("google_adword");
if(gAdword && gAdword != null) document.cookie = "google_adword=GooglePS:"+gAdword+";path=/;domain=.novell.com";

// code to track newsletter links
var gnews = getQueryParm("gnews");
if(gnews && gnews != null) document.cookie = "g_newsletter=GlobalNews:"+gnews+";path=/;domain=.novell.com";
