program checkpci;

uses dos, pciunit,crt,xSetUnit;

Function WordToHex (W:Word):String;
Const    HEXZiffern:String ='0123456789ABCDEF';
VAR S:String[4];

    Nibble:Byte;
begin
  S:='';
  While W<>0 do
    Begin
      Nibble:= W Mod 16;
      W:=W DIV 16;
      S:=Hexziffern[Nibble+1]+S;
    End;
  while Length(S)<4 do S:='0'+S;
  WordToHex:=s;
end;
var
  PCIInfo : PCIInfoStruc;
  PCIBios : Boolean;

  BaseClass, SubClass, Prog : Byte;
  Index:Word;
  Bus,DevNr,FuncNr,ReturnCode:Byte;
  SLOT:String[10];

  RouteBufferInfo:RouteBufferInfoType;
  Res:byte;
  i,anz:integer;
  intx:char;
  exIRQ:word;
  pciversion : Word;

  vendorid, func, deviceid :Word;
  tmp : string;

begin
  clrscr;
  Writeln('CHECKPCI Vers. 4  De/30.11.00');
  ShowPCIinfo (PCIBIOS,PCIVersion);

  if not PCIBIOS then
  begin
    XSET('PCI=0');
    writeln('kein PCI-BIOS vorhanden');
    halt(10);
  end
  else
  begin
    XSET('PCI=1');
    BaseClass:=02; {Netzwerk-Controller}
    SubClass:=00; {01- Ethernet, 02-Token-Ring, 00-everything }
    Prog:=0;
    Index:=0;
    Find_PCI_Class_Code(BaseClass, SubClass, Prog, Index, BUS, DEVNR, FUNCNR, RETURNCODE);
    If ReturnCode<>0 Then
    Begin
      Writeln('Find_PCI_Class_Code:',ReturnCode,' dec., no network controller found!');
      Writeln('Description: ');
      Case ReturnCode of
        $81 : Writeln('function not supported');
        $82 : Writeln('wrong Vendor ID');
        $86 : Writeln('device not found');
        $87 : Writeln('wrong register number');
        $88 : Writeln('IRQ can''t be set');
        $89 : Writeln('data buffer too small');
      End;
      {zweite Strategie zur Identifizierung der Olicom TR-Karten:}
      {direkt nach Vendor und device ID suchen}
      VendorID:=$108d; {Olicom}
      DeviceID:=$0001;
      Find_PCI_Device (VendorID, DeviceId, Index,Bus,DevNr,FuncNr,ReturnCode);
      If ReturnCode<>0 Then
      Begin
        Writeln('Find_PCI_Device (Olicom 108dh):',
        ReturnCode,' dec., no device found!');
        writeln('keine PCI Netzwerkkarte gefunden');
        Halt(10);
      End
       Else Writeln ('Olicom-Adapter per Find_PCI_device gefunden!');
    End;

    with RouteBufferInfo do
    begin
      BufferSize      :=high(RouteBufferArray)*16;
      RouteBufferptr  :=@RouteBuffer;
      Get_PCI_Interrupt_Routing_Options (RouteBufferInfo,exIRQ,res);
      case Res of
        $81:Writeln ('IRQ-Routing not supported by BIOS');
        $89:Writeln ('IRQ Routing Options Buffer too small');
      end;
      If Res <> 0 then exit;
      anz:=Buffersize div 16;
      If anz = 0 then
      Begin
        Writeln ('no PCI information');
        Halt(10);
      End
      else for i:=1 to anz do with Routebuffer[i] do
      begin
      If (PCIBusNumber=BUS) and (PCIDeviceNumber shr 3=DevNr) Then
      {gotcha, that's the one !!!}
      Begin
        Str(SlotNumber,Slot);
        Vendorid:=read_config (xword,bus,devNr,0,0,res);

        TMP:=WordToHex(vendorID); {Str(vendorid,tmp);}
        Writeln ('Network controller found on SLOT:', Slot);
        Writeln ('VendorID:',tmp);
        XSET('NETWORK='+ Tmp);

        func:=read_config (xword,bus,devNr,0,2,res);
        TMP:=WordToHex(func);
        Writeln ('NFunc:',tmp);
        XSET('NETMOD='+ tmp);
      End;
    end;

{Grafikkarte Erweiterung}
    BaseClass:=03; {Grafikkarte -Controller}
    SubClass:=00; {00-everything}
    Prog:=0;
    Index:=0;

    Find_PCI_Class_Code(BaseClass, SubClass, Prog, Index, BUS, DEVNR, FUNCNR, RETURNCODE);

    If ReturnCode<>0 Then
    Begin
      Writeln('Find_PCI_Class_Code:',ReturnCode,' dec., no Graphic controller found!');
      Writeln('Description: ');
      Case ReturnCode of
        $81 : Writeln('function not supported');
        $82 : Writeln('wrong Vendor ID');
        $86 : Writeln('device not found');
        $87 : Writeln('wrong register number');
        $88 : Writeln('IRQ can''t be set');
        $89 : Writeln('data buffer too small');
      End;
    end;
    with RouteBufferInfo do
    begin
      BufferSize      :=high(RouteBufferArray)*16;
      RouteBufferptr  :=@RouteBuffer;
      Get_PCI_Interrupt_Routing_Options (RouteBufferInfo,exIRQ,res);
      case Res of
        $81:Writeln ('IRQ-Routing not supported by BIOS');
        $89:Writeln ('IRQ Routing Options Buffer too small');
      end;
      If Res <> 0 then exit;
      anz:=Buffersize div 16;
      If anz = 0 then
      Begin
        Writeln ('no PCI information');
        Halt(10);
      End
      else
      begin
        Vendorid:=read_config (xword,bus,devNr,0,0,res);
        TMP:=WordToHex(vendorID);
        Writeln ('Grafikkarte:');
        Writeln ('VendorID:',tmp);
        XSET('GRAPHIC='+ tmp);

        func:=read_config (xword,bus,devNr,0,2,res);
        TMP:=WordToHex(func);
        Writeln ('GFunc:',tmp);
        XSET('MOD='+ tmp);
      End
    end;

{ De 06.10.00 Sounderweiterung}
    BaseClass:=04; {Multimedia -Controller}
    SubClass:=01; {01-Audio}
    Prog:=0;
    Index:=0;
    XSET('SOUND=0');
    XSET('SOUNDMOD=0');

    Find_PCI_Class_Code(BaseClass, SubClass, Prog, Index, BUS, DEVNR, FUNCNR, RETURNCODE);

    If ReturnCode<>0 Then
    Begin
      Writeln('Find_PCI_Class_Code:',ReturnCode,' dec., no Multimedia controller found!');
      Writeln('Description: ');
      Case ReturnCode of
        $81 : Writeln('function not supported');
        $82 : Writeln('wrong Vendor ID');
        $86 : Writeln('device not found');
        $87 : Writeln('wrong register number');
        $88 : Writeln('IRQ can''t be set');
        $89 : Writeln('data buffer too small');
      End;
    end
    else
    begin
      with RouteBufferInfo do
      begin
        BufferSize      :=high(RouteBufferArray)*16;
        RouteBufferptr  :=@RouteBuffer;
        Get_PCI_Interrupt_Routing_Options (RouteBufferInfo,exIRQ,res);
        case Res of
          $81:Writeln ('IRQ-Routing not supported by BIOS');
          $89:Writeln ('IRQ Routing Options Buffer too small');
        end;
        If Res <> 0 then exit;
        anz:=Buffersize div 16;
        If anz = 0 then
        Begin
          Writeln ('no PCI information');
          Halt(10);
        End
        else
        begin
          Vendorid:=read_config (xword,bus,devNr,0,0,res);
          TMP:=WordToHex(vendorID);
          Writeln ('Soundkarte:');
          Writeln ('VendorID:',tmp);
          XSET('SOUND='+ tmp);

          func:=read_config (xword,bus,devNr,0,2,res);
          TMP:=WordToHex(func);
          Writeln ('SFunc:',tmp);
          XSET('SOUNDMOD='+ tmp);
        End
      end;
    end;

{ De 06.10.00 COM Erweiterung}
    BaseClass:=00; {CON -Controller}
    SubClass:=00; {00-everything}
    Prog:=0;
    Index:=0;
    Index:=0;
    XSET('COM=0');
    XSET('COMMOD=0');
    VendorID:=$10b5; {Exsys}
    DeviceID:=$9050;

   Find_PCI_Device (VendorID,DeviceID,Index,Bus,DevNr,FuncNr,ReturnCode);

    If ReturnCode<>0 Then
    Begin
      Writeln('Find_PCI_Class_Code:',ReturnCode,' dec., no COM Controller found!');
      Writeln('Description: ');
      Case ReturnCode of
        $81 : Writeln('function not supported');
        $82 : Writeln('wrong Vendor ID');
        $86 : Writeln('device not found');
        $87 : Writeln('wrong register number');
        $88 : Writeln('IRQ can''t be set');
        $89 : Writeln('data buffer too small');
      End;
    end
    else
    begin
      with RouteBufferInfo do
      begin
        BufferSize      :=high(RouteBufferArray)*16;
        RouteBufferptr  :=@RouteBuffer;
        Get_PCI_Interrupt_Routing_Options (RouteBufferInfo,exIRQ,res);
        case Res of
          $81:Writeln ('IRQ-Routing not supported by BIOS');
          $89:Writeln ('IRQ Routing Options Buffer too small');
        end;
        If Res <> 0 then exit;
        anz:=Buffersize div 16;
        If anz = 0 then
        Begin
          Writeln ('no PCI information');
          Halt(10);
        End
        else
        begin
          Vendorid:=read_config (xword,bus,devNr,0,0,res);
          TMP:=WordToHex(vendorID);
          Writeln ('COM:');
          Writeln ('VendorID:',tmp);
          XSET('COM='+ tmp);

          func:=read_config (xword,bus,devNr,0,$0a,res);
          TMP:=WordToHex(func);
          Writeln ('CFunc:',tmp);
          XSET('COMMOD='+ tmp);
        End
      end;
    end;



  end; {if not PCIBIOS}
end;
end.