Unit PCIunit; { V 1.0 / as / c't 2/96 }
{$A-,G+}
interface

const IntelID  =$8086;

const MercuryID=$04A3; { 82434LX }
const NeptunID =$04A3; { 82434NX }
const iPCI2ISA =$0484; { 82378IB }
const PIIXID   =$122e;
const SaturnID =$0483;
const TritonID =$122D;
const OrionID  =$85C4;

Type carray4=array[1..4] of char;
Type Breite=(xbyte,xword,xdword);
Type string2=string[2];
Type string4=string[4];
Type string8=string[8];

const Kennread :array[xbyte..xdword] of byte = ($08,$09,$0A);
const Kennwrite:array[xbyte..xdword] of byte = ($0B,$0C,$0D);

Type BIOS32datstruc= record
     sign:carray4;
     Entrypoint:longint;
     Revision:byte;
     Checksum:byte;
     reserve:array[1..5] of byte;
     end;

Type PCIinfostruc= record
     PCIVersion:word;
     Hardware,PCI_Busse,Status:Byte;
     BIOS32_dat:^BIOS32datstruc;
     BIOS32_Version:byte;
     BIOS32_Service_Directory:longint;
     end;


{ IRQ-Routing Typen und Variablen }
Type INTEntry=record
     Link            :Byte;
     IRQBitMAP       :Word;
     end;

Type RouteEntry=record
     PCIBusNumber    :byte;
     PCIDeviceNumber :byte;
     INTmap          :array['A'..'D'] of INTentry; {INTA ...INTD }
     SlotNumber      :byte;
     Reserve         :byte;
     end;

Type Routebufferarray=array[1..16] of RouteEntry;

Type RouteBufferInfoType= record
     BufferSize: word;
     RouteBufferPtr:^Routebufferarray;
     end;

Var  Routebuffer:RouteBufferarray;


Var Hostbus,Hostdev,Hostfunc,HostRevision:byte;
    HostVendorId,HostDeviceId: word;


Function PCI_BIOS_present (var PCIInfo:PCIinfostruc):boolean;

Function  Read_Config
  {Entry}    (B:Breite; Bus,DeviceNr,FunctionNr:Byte; Register:word;
  {Exit}      var ReturnCode:byte): longint;

Procedure Write_config
   {Entry}   (B:Breite; Bus,DeviceNr,FunctionNr:Byte; Register:word;
              wert:longint; var ReturnCode:byte);

Procedure Find_PCI_Device (VendorID, DeviceId, Index:word;
                           var Bus,DevNr,FuncNr,ReturnCode:byte);

Procedure Find_PCI_Class_Code (BaseClass,SubClass,Prog:byte;Index:word;
                            var Bus,DevNr,FuncNr,ReturnCode:byte);

Procedure ShowPCIinfo (var PCIBIOSfound:boolean; VAR PCIVersion : Word);

Procedure ShowIRQ;


Procedure Get_PCI_Interrupt_Routing_Options
 (var RouteBufferInfo:RouteBufferInfoType;var exIRQ:word; var ReturnCode:byte);


Procedure Set_PCI_IRQ
  (IntPin,    IRQNum,  Bus,    Device, Func:Byte; var returnCode:byte);
  { $A..$D   , 0..15 ,  0..255 ,0..31, 0..7 }

Procedure SetPAM (seg:word;attr:byte); { Fr alle Intel-PCI- Chips }

implementation
uses dos;

var PCIsysinfo:PCIinfostruc;

Procedure errorexit (x:string;n:word);
begin
writeln (x); halt(n);
end;

Function Hexbyte(zahl:byte):string2;
Const Ziffern:Array[0..15] of char='0123456789ABCDEF';
Begin
  hexbyte[0]:=#2;
  hexbyte[1]:=Ziffern[zahl shr 4];
  hexbyte[2]:=Ziffern[zahl and $0F];
end;

Function  Checksum (segm,anz:word):boolean;
var i,sum:word;
begin
 sum:=0;
 for i:=0 to anz-1 do inc (sum,byte(ptr(segm,i)^));
 checksum:=lo(sum)=0;
end;

Function PCI_BIOS_present (var PCIInfo:PCIinfostruc):boolean;
const Sign32:carray4 ='_32_';
var s:word;
var reg:registers;

begin
with reg,PCIinfo do
 begin
  ax:=$B101;
  intr ($1A,reg);
  PCI_BIOS_present:= (AH=0) and ((Fcarry and Flags)=0) and (DX=$4350);
  Hardware:=al;
  PCI_Busse:=cl;
  PCIVersion:=bx;

 for s:=$E000 to $FFFF do
 if carray4 (ptr(s,0)^)=Sign32 then if checksum (s,16) then break;
 if s <> $FFFF then
  begin
  BIOS32_Dat:=ptr(s,0);
  BIOS32_Service_Directory:=BIOS32_dat^.entrypoint;
  BIOS32_Version:=BIOS32_dat^.revision;
  end
  else
  BIOS32_Dat:=nil;
 end;
PCIsysinfo:=pciinfo;
end;

Procedure Find_PCI_Device;

var reg:registers;
begin
with reg do
 begin
  ax:=$B102;
  cx:=DeviceID;
  dx:=VendorID;
  SI:=Index;
  intr ($1A,reg);
  Bus:=BH;
  DevNr:=BL shr 3;
  FuncNr:=BL and $F;
  ReturnCode:=ah;
  end;
end;

Procedure Find_PCI_Class_Code;

var rax,rbx:word;
var classcode:array[0..3] of byte;
begin
Classcode[0]:=Prog;      Classcode[1]:=SubClass;
Classcode[2]:=BaseClass; ClassCode[3]:=0;
asm
  mov ax,$B103;
  mov si,index;
  db $66; mov cx,word ptr Classcode;
  int $1A
  mov rax,ax
  mov rbx,bx
  end;
bus:=hi(rbx);
DevNr:=lo(rbx) shr 3;
FuncNr:=hi(rbx) and $FF;
ReturnCode:=hi(rax);
end;

Function Read_Config;

var ID, res:Byte;
    ecx,wert:longint;
begin
 ID:= Kennread[B];
 asm
 mov ah,$B1
 mov al,ID
 mov BH,Bus
 mov BL,DeviceNr;
 shl bl,3
 or  bl,FunctionNr
 mov DI,Register;
 INT 1Ah
 Mov Res,ah
 db 66h; mov word ptr ecx,cx;
 end;
 ReturnCode:=res;
 case B of
 xbyte :wert:=ecx and $FF;
 xword :wert:=ecx and $FFFF;
 xdword:wert:=ecx;
 end;
Read_config:=wert;
end;

Procedure Write_config;
var res,ID:byte;
begin
ID:=KennWrite[b];
asm
 mov ah,$B1;
 mov aL,ID
 mov BH,Bus
 mov BL,DeviceNr;
 shl bl,3
 or  bl,FunctionNr;
 mov DI,Register;
 db $66;mov cx,word ptr wert
 INT 1Ah
 Mov Res,ah
 end;
ReturnCode:=res;
end;

Procedure GetHost (var bus,dev,func:byte; var Vendorid,DeviceiD:word;
                   var Revision:byte);
var res:byte;
begin
Find_PCI_Class_Code (6,0,0,0,bus,dev,func,res);
If res >  0 then errorexit  ('Hostbridge nicht gefunden',3);
Vendorid:=read_config (xword,bus,dev,func,0,res);
DeviceId:=read_config (xword,bus,dev,func,2,res);
Revision:=read_config (xbyte,bus,dev,func,8,res);
end;

Procedure ShowPCIinfo (var PCIBIOSfound:boolean; VAR PCIVersion : word);
var PCIinfo:PCIinfostruc;
    res:byte;
begin
PCIVersion:=0;
PCIBIOSfound:=PCI_BIOS_Present(PCIinfo);
If PCIBIOSFound then PCIVersion:=PCIInfo.pciversion;
If PCIBIOSfound
 then with PCIinfo do begin
  Writeln ('PCI-BIOS gefunden, Version   : ', hexbyte(hi (PCIVersion)),
                                           '.',hexbyte(lo(PCIversion)));
  Writeln ('Konfigurations-Mechanismus   : ', hardware and 3);
  Writeln ('Special-Cycle-Mechanismus    : ', (hardware shr 4) and 3);
  Writeln ('PCI-Busse                    : ', PCI_Busse+1);
  Write   ('32-Bit-PCI-BIOS              : ');

  If BIOS32_dat <> nil  then Writeln  (' Revision:', BIOS32_Version)
                        else Writeln  ('nicht gefunden');
 GetHost(HostBus,HostDev,HostFunc,HostVendorID,HostDeviceID,HostRevision);
  end;
end;


Procedure Set_PCI_IRQ;
{IntPin = 'A' .. 'D'}
var reg:registers;
begin
 reg.ax:=$B10F;
 reg.cl:=IntPin;
 reg.ch:=IRQNum;
 Reg.Bx:=(bus shl 8) + (Device shl 3) +Func;
 Reg.ds:=$F000;
 intr ($1A,reg);
  returnCode:=reg.ah;
end;

Procedure Get_PCI_Interrupt_Routing_Options;
var reg:registers;
begin
 reg.ax:=$B10E;
 reg.bx:=0;
 Reg.ds:=$F000;
 Reg.es:=seg(RouteBufferInfo);
 Reg.di:=ofs(RouteBufferInfo);
 Intr ($1A,reg);
 exIRQ:=reg.bx;
 returnCode:=reg.ah;
end;

Procedure Write_IRQbits (x:word);
var i:integer;
begin
If x <> 0 then Write('IRQ ')
          else Write('Kein IRQ');
for i:=0 to 15 do
 begin
 if odd (x) then
  begin
  Write (i);
  if x > 1 then Write (',');
  end;
 x:= x shr 1;
 end;
end;


Procedure ShowIRQ;
{ Gibt eine Liste mglicher IRQ-Routings fr PCI-Devices aus }
{ sowie die aktuell exklusiv fr PCI reservierten IRQs }
var RouteBufferInfo:RouteBufferInfoType;
var Res:byte;
var i,anz:integer;
var intx:char;
var exIRQ:word;


begin
with RouteBufferInfo do
 begin
 BufferSize      :=high(RouteBufferArray)*16;
 RouteBufferptr  :=@RouteBuffer;
 Get_PCI_Interrupt_Routing_Options (RouteBufferInfo,exIRQ,res);
 case Res of
 $81:Writeln ('IRQ-Routing vom BIOS nicht untersttzt');
 $89:Writeln ('Puffer fr IRQ Routing Options Buffer zu klein');
 end;
 If Res <> 0 then exit;
 anz:=Buffersize div 16;
 If anz = 0 then Writeln ('Keine PCI-Informationen')
 else for i:=1 to anz do with Routebuffer[i] do
  begin
  Writeln ('PCI-Bus/Device/Slot-Nummer   : ',PCIBusNumber,'/',
                                          PCIDeviceNumber shr 3,'/',
                                          SlotNumber);
  For Intx:='A' to 'D' do with Intmap[Intx] do
   begin
   case Link of
   $FF:begin
       Write ('INT',Intx,'                         : exklusiv ');
       Write_IRQBits(IRQBitMap);
       Writeln;
       end;
   $00:begin end;
   else
       begin
       Write ('INT',Intx,'                         : Link= ',hexbyte(Link),' ');
       Write_IRQBits(IrqBitMap);
       Writeln;
       end;
    end;
   end;
  end;
  Write ('Exklusiv fr PCI reserviert  : ');
  Write_IRQBits (exIRQ);
  Set_PCI_IRQ ($C,15,0,6,0,res);
 end;
end;


Procedure SetPAM (seg:word;attr:byte); { Fr alle Intel-PCI- Chips }
{ segmente $C000, $C400, $C800, $CC00,
           $D000, $D400, $D800, $DC00,
           $E000, $E400, $E800, $EC00

Attribut [0..$F] binr:

 x111     : read write Cacheable
 x011     : read write not Cacheable
 x010     : Write only not Cacheable
 x101     : Read only, cacheable
 x001     : Read only not Cacheable
 x000     : Read/Write to PCI Bus

Bei Saturn: x=1: PCI/ISA-Busmaster-Zugriff auf UMB
Bei Orion : Bit2,3 ohne Bedeutung
}


var index,res:byte;
    b,bmc,bopc:byte;
    hostbus,hostdev,hostfunc:byte;
    VendorId,DeviceId: word;

begin
index:= hi(seg) div 8 + $42;
if not index in [$5A..$5F] then errorexit ('Fehler bei Segment',1);
Find_PCI_Class_Code (6,0,0,0,hostbus,hostdev,hostfunc,res);
If res >  0 then errorexit  ('Hostbridge nicht gefunden',3);
VendorID:=read_config (xword,hostbus,hostdev,hostfunc,0,res);
DeviceID:=read_config (xword,hostbus,hostdev,hostfunc,2,res);
If VendorID <> $8086 then errorexit ('keine Intel-Hostbridge',2);
b:=read_config (xbyte,hostbus,hostdev,hostfunc,index,res);
if res > 0 then errorexit ('Fehler beim Lesen',3);
if hi(seg) mod 8 = 0 then bmc:= (b and $F0) or attr { Lo-Byte}
                     else bmc:= (b and $0F) or (attr shl 4);

If DeviceId =  $84C4 then { Oh weh, Orion mit verdeckten OMC }
  begin
  attr:=(not attr) and 3; { Speicher bei PCI-Bridge ausblenden }
  if hi(seg) mod 8 = 0 then Bopc:= (b and $F0) or attr
                       else Bopc:= (b and $0F) or (attr shl 4);
   Write_config (xbyte,hostbus,hostdev,hostfunc,index,bopc,res);
   if res > 0 then errorexit ('Fehler beim Schreiben',1);
                          { Speicher bei Memory-Controller einblenden }
   Write_config (xbyte,hostbus,hostdev-5,0,index,bmc,res);
  end
 else
   Write_config (xbyte,hostbus,hostdev,hostfunc,index,bmc,res);
if res > 0 then errorexit ('Fehler beim Schreiben',1);
end;


end. {PCI-Unit }