program filechex;
{

FILECHEX filename [DATE=MM/DD/YY] [TIME=HH:MM] [SIZE=bytes]

If more than one criteria is specified, the file must meet them all to pass.


Error Codes:

255 Usage Error
128 File Not Found
 64 Size does not match
 32 Date does not match
 16 Time does not match
  8 Syntax Error

}

Uses
      DOS;

const
      COPYRIGHT: STRING = 'Copyright (c) 1994, Robert Rawson, All Rights Reserved';
      version: real=1.01;
      SyntaxErr = 8;
      TimeErr = 16;
      DateErr = 32;
      SizeErr = 64;
      FNFErr = 128;
      UsageErr = 255;


var
    DirectoryEntry: SearchRec;
    dt: datetime;
    Hour, Min, Year, Day, Month: Word;
    Size: LongInt;
    code: integer;
    PARM: string;
    Colon, Slash: byte;
    i, j: Integer;
    InternalErrorCode: byte;





Function LZERO (num:integer;DIG: BYTE): string;

{Inserts leading zeroes in front of an integer}
Const zeroes: string= '00000000000000000000000000000000000000000000000000';

var Junque: string;
begin
Str (num, Junque);
LZERO := Copy (zeroes,1,DIG-Length(Junque))+Junque;
end;






Function UpperStr (targ: string):string;

{
 converts a string into all upper case for easier parsing.
 uses the Turbo Pascal UPPER function
}

var Junque: string;
begin

Junque := '';
For j := 1 to length (targ) do
   Junque := Junque + UPCASE(targ[j]);
UpperStr := Junque;

end;





Procedure SyntaxError;

{displays message and exits}

begin
Writeln ('FILECHEX: Syntax Error');
halt(SyntaxErr);
end;



{MAIN}
begin

if Paramcount < 2 then
   begin
   Writeln ('FILECHEX: Version ',Version:1:2);
   Writeln ('          ', Copyright);
   writeln;
   writeln ('USAGE: FILECHEX filename option [option] [option]');
   writeln;
   writeln ('       options are:   DATE=MM/DD/YY');
   writeln ('                      TIME=HH:MM');
   writeln ('                      SIZE=bytes');
   writeln;
   writeln ('FileChex is used to test a file against specified criteria. If the');
   writeln ('file matches the criteria, the program returns with DOS errorlevel');
   writeln ('set to zero. Otherwise, it will return a non-zero return code');
   writeln;
   halt (UsageErr);
   end;

FindFirst (paramstr(1),AnyFile-Directory-VolumeID,DirectoryEntry);
if DOSError <> 0 then
   begin
   WRITELN ('FILECHEX: File ',Upperstr(paramstr(1)),' not found.');
   Halt(FNFErr);
   end;

UnPackTime (DirectoryEntry.Time, DT);
InternalErrorCode := 0;


{this is the main parsing loop}

For I := 2 to paramcount do
   begin
   PARM := Upperstr(Paramstr(I));


   IF copy (PARM,1,5) = 'DATE=' THEN
      BEGIN
      PARM := COPY (PARM,6,255);
      Slash := Pos ('/', PARM);
      if Slash=0 then
         SyntaxError
      else
         begin
         val (copy (parm,1,slash-1),month,code);
         if code <> 0 then
            SyntaxError
         else
            begin
            PARM := Copy (PARM,Slash+1,255);
            Slash := Pos ('/', PARM);
            if Slash=0 then
               SyntaxError
            else
               begin
               Val (copy(parm,1,slash-1),day,code);
               if code <> 0 then
                  SyntaxError
               else
                  begin
                  Val (copy(parm,slash+1,255),year,code);
                  if code <> 0 then
                     SyntaxError
                  else
                     begin
                     if Year < 1980 then
                        if Year in [80..99] then
                           Year := Year + 1900
                        else
                           Year := Year + 2000;
                     If (Year <> DT.Year) or
                        (Month <> DT.Month) or
                        (Day <> DT.Day) then
                           InternalErrorCode := InternalErrorCode + DateErr;
                     end;
                  end;
               end;
            end;
         end;
      END;


   IF copy (PARM,1,5) = 'TIME=' THEN
      BEGIN
      PARM := Copy(PARM,6,255);
      Colon := pos (':',PARM);
      if Colon = 0 then
         SyntaxError
      else
         begin
         Val (copy(parm,1,colon-1),hour,code);
         if code <> 0 then
            SyntaxError
         else
            begin
            Val(copy(parm,colon+1,255),min,code);
            if code <> 0 then
               SyntaxError
            else
               begin
               If (hour <> dt.hour) or
                  (min <> dt.min) then
                     InternalErrorCode := InternalErrorCode + TimeErr;

               end;
            end;
         end;
      END;


   IF copy (PARM,1,5) = 'SIZE=' THEN
      BEGIN
      Val (Copy(PARM,6,255), Size, code);
      if code <> 0 then
         SyntaxError
      else
         if Size <> DirectoryEntry.Size then
            InternalErrorCode := InternalErrorCode + SizeErr;
      END;
   end;

If DT.YEAR < 1999 then
   DT.YEAR := DT.YEAR - 1900
else
   IF DT.YEAR >= 2000 then
      DT.YEAR := DT.YEAR - 2000;

writeln ('FILECHEX: RC=',LZERO(InternalErrorCode,3),' ',LZERO(DT.MONTH,2),'/',
                                       LZERO(DT.DAY,2),'/',
                                       LZERO(DT.YEAR,2),' ',
                                       LZERO(DT.HOUR,2),':',
                                       LZERO(DT.MIN,2),' ',
                                       DirectoryEntry.SIZE:12,' ',	
                                       UpperStr(PARAMSTR(1)));
Halt (InternalErrorCode);
end.