{

 NetWare Library Functions v1.02
 for Turbo Pascal v3.02a
 (c) 1989, 1990 Robert Rawson

 5/22/90 - added PRIMARY as an OPTION on function UserName
 07/29/90 - New Functions: LogNetworkMessage
                           BroadcastToConsole
 09/21/90 - New Function: GetNumberOfLocalDrives
 10/24/90 - Implemented sempahore functions
 }


Const COPYRIGHT: String[255] = 'Copyright (C) 1989, 1990 Novell, Inc.';
      NYBBLES: Array [0..15] of Char = '0123456789ABCEDF';
      CurrentSeg: Integer = 0;       {Current property value segment read from NetWare}
      CurrentMember: Integer = 32;   {Current member to look at within the set}
      LastSeg: Boolean = FALSE;      {Are we looking at the last segment?}
      MembersPerSeg = 32;            {Maximum Number of Members in each segment}
      VERBOSE: BOOLEAN = TRUE;
      BinderySearchMode:
      STRING = 'PRIMARY';
      SemaphoreTableSize = 10;
      SemaphoreTableInitialized: Boolean = FALSE;
      SemaphoreResult: Integer = 0;
      TimeoutFailure = $FE;
      ASCIIZMAX = 127;

type
   ASCIIZ = array [1..ASCIIZMAX] of char;


   levels = (FATAL, WARNING, INFORM);  {Enumerated type used by the error procedure}
   PropertyValue = array [1..128] of byte;
   SemTableLMNT = record
      Name: STRING;
      HandleLSW: Integer;
      HandleMSW: Integer;
      end;

var
   CurrentSet: PropertyValue;           {global buffer for ReadProperty call}
   mode: byte;                          {contains previous error mode}
   SemTable: Array [1..SemaphoreTableSize] of SemTableLMNT;
   ch1: char;



procedure error (severity: levels; Message: STRING);

{This procedure displays error messages

INPUT: Severity - a variable of enumerated type LEVELS which indicates the
                  type of error message. FATAL errors cause the procedure to
                  exit the program and return to the parent process with
                  ERRORLEVEL=1.
        Message - The text to be displayed.

OUTPUT: Messages to the screen and FATAL errors return errorlevel=1.
}

begin

Case severity of
   FATAL: if VERBOSE then
             Begin
                Writeln ('  error: ',Message);
                Error (INFORM, 'Terminating.');
                Halt (1);
             end
          else
             halt(1);
 WARNING: If VERBOSE then
             Writeln ('warning: ',message);
  INFORM: If VERBOSE then
             Writeln ('         ',message);
  end;

end;

Function SemTableDex (SemID: STRING): Integer;

Var I, DEX: integer;

Begin

i := 1;
DEX := 0;
While I < SemaphoreTableSize do
   begin
   if SemTable[i].Name = SemID then
      DEX := I;

   i := i + 1;
   end;

SemTableDex := DEX;

end;

Function OpenSemaphore (SemID: STRING; InitialValue: integer): Integer;

var CPU: Registers;
    I: integer;

Begin


if not SemaphoreTableInitialized then
   begin
   for I := 1 to SemaphoreTableSize do
      begin
      SemTable[I].Name := '';
      SemTable[i].HandleMSW := 0;
      SemTable[i].HandleLSW := 0;
      end;
   SemaphoreTableInitialized := TRUE;
   end;



CPU.AH := $C5;
CPU.AL := $00;
CPU.DS := Seg (SemId);
CPU.DX := Ofs (SemId);
CPU.CL := InitialValue;

MSDOS (CPU);

SemaphoreResult := CPU.AL;

If SemaphoreResult = 0 then
   begin
   i := 1;
   while (I < SemaphoreTableSize) and (SemTable[i].Name <> '') do
      i := i + 1;
   if SemTable[i].Name <> '' then
      error (FATAL, 'OpenSemaphore ran out of local table entries');
   SemTable[i].Name := SemID;
   SemTable[i].HandleLSW := CPU.CX;
   SemTable[i].HandleMSW := CPU.DX;
   end;

OpenSemaphore := CPU.BL;
End;

Procedure WaitOnSemaphore (SemID: STRING; TimeOut: integer);

Var CPU: Registers;
    DEX: integer;

Begin

DEX := SemTableDEX(SemID);
if DEX = 0 then
   error (FATAL, 'WaitOnSemaphore called with an invalid semaphore ID');

CPU.AH := $C5;
CPU.AL := $02;
CPU.CX := SemTable[DEX].HandleLSW;
CPU.DX := SemTable[DEX].HandleMSW;
CPU.BP := TimeOut;

MSDOS (CPU);

SemaphoreResult := CPU.AL;

End;

Procedure SignalSemaphore (SemID: STRING);

Var CPU: Registers;
    DEX: integer;


Begin

DEX := SemTableDEX(SemID);
if DEX = 0 then
   error (FATAL, 'SignalSemaphore called with an invalid semaphore ID');

CPU.AH := $C5;
CPU.AL := $03;
CPU.CX := SemTable[DEX].HandleLSW;
CPU.DX := SemTable[DEX].HandleMSW;

MSDOS (CPU);

SemaphoreResult := CPU.AL;

End;

Function SemaphoreValue (SemID: STRING):Integer;

Var CPU: Registers;
    DEX: integer;


Begin

DEX := SemTableDEX(SemID);
if DEX = 0 then
   error (FATAL, 'SemaphoreValue called with an invalid semaphore ID');

CPU.AH := $C5;
CPU.AL := $01;
CPU.CX := SemTable[DEX].HandleLSW;
CPU.DX := SemTable[DEX].HandleMSW;

MSDOS (CPU);

SemaphoreResult := CPU.AL;

SemaphoreValue := CPU.CX;

End;

Function SemaphoreCount (SemID: STRING):Integer;

Var CPU: Registers;
    DEX: integer;


Begin

DEX := SemTableDEX(SemID);
if DEX = 0 then
   error (FATAL, 'SemaphoreCount called with an invalid semaphore ID');

CPU.AH := $C5;
CPU.AL := $01;
CPU.CX := SemTable[DEX].HandleLSW;
CPU.DX := SemTable[DEX].HandleMSW;

MSDOS (CPU);

SemaphoreResult := CPU.AL;

SemaphoreCount := CPU.DL;

End;

Procedure CloseSemaphore (SemID: STRING);

Var CPU: Registers;
    DEX: integer;

Begin

DEX := SemTableDEX(SemID);
if DEX = 0 then
   error (FATAL, 'SemaphoreCount called with an invalid semaphore ID');

CPU.AH := $C5;
CPU.AL := $04;
CPU.CX := SemTable[DEX].HandleLSW;
CPU.DX := SemTable[DEX].HandleMSW;

MSDOS (CPU);

SemaphoreResult := CPU.AL;

SemTable[DEX].NAME := '';
SemTable[DEX].HandleMSW := 0;
SemTable[DEX].HandleLSW := 0;

End;

Function date: STRING;

CONST
   YEAR = 1;
   MONTH = 2;
   DAY = 3;
   HOUR = 4;
   MINUTE = 5;
   SECOND = 6;
   DAYOFWEEK = 7;

var YR, MO, DY: STRING;
var cpu: registers;
    reply: array [YEAR..DAYOFWEEK] of byte;


begin

CPU.ah := $E7;
CPU.DS := seg (reply);
CPU.DX := ofs (reply);
msdos (CPU);

yr := '';
mo := '';
dy := '';


STR (reply[YEAR],yr);
str (reply[MONTH],MO);
str (reply[DAY],dy);

Date := MO+'/'+DY+'/'+YR;

end;

Function time: STRING;

CONST
   YEAR = 1;
   MONTH = 2;
   DAY = 3;
   HOUR = 4;
   MINUTE = 5;
   SECOND = 6;
   DAYOFWEEK = 7;

var HH, MM, SS: STRING;
var cpu: registers;
    reply: array [YEAR..DAYOFWEEK] of byte;


begin

CPU.ah := $E7;
CPU.DS := seg (reply);
CPU.DX := ofs (reply);
msdos (CPU);

HH := '';
MM := '';
SS := '';


str (reply[HOUR],HH);
str (reply[MINUTE],MM);
str (reply[SECOND],SS);

Time := HH+':'+MM+':'+SS;

end;

Function GetDriveFlagTable: STRING;

type TableType= array [1..32] of byte;

var CPU: Registers;
    Table: ^TableType;
    RSTRING: STRING;
    I: Integer;

begin

CPU.AH := $EF;
CPU.AL := $01;
MSDOS (CPU);

Table := ptr (CPU.ES, CPU.SI);
RSTRING := '';

for I := 1 to 32 do
   if Table^[i] = 0 then
      RSTRING := RSTRING + ' '
   else
      if (Table^[I] and $01) <> 0 then
         RSTRING := RSTRING + 'N'
      else
         if (Table^[I] and $02) <> 0 then
            RSTRING := RSTRING + 'T'
         else
            if (Table^[I] and $80) <> 0 then
               RSTRING := RSTRING + 'L'
            else
               RSTRING := RSTRING + '?';

GetDriveFlagTable := RSTRING;

end;

Function GetNumberOfLocalDrives: Byte;

Var CPU: Registers;

begin

CPU.AL := $DB;
MSDOS(CPU);
GetNumberOfLocalDrives := CPU.AL;

end;

Procedure WriteHEX (BY:BYTE);

{  INPUT: byte
  OUTPUT: byte is displayed}

begin
write (NYBBLES [by DIV 16], NYBBLES [by mod 16]);
end;


Procedure LogNetworkMessage (Message: STRING);

Type ReqBuff = record
        LEN: integer;
        SUBFUNCTION: byte;
        Message: string[80];
     end;

     ReplyBuff = integer;

var cpu: registers;
    Request: ReqBuff;
    Reply: ReplyBuff;


begin

CPU.AH := $E3;
CPU.DS := Seg(Request);
CPU.SI := Ofs(Request);
CPU.ES := Seg(Reply);
CPU.DI := Ofs(Reply);

Request.LEN := length(Message)+2;
Request.SubFunction := $0D;
Request.MESSAGE := Message;
Reply := 0;

MSDOS(CPU);

end;


Procedure EndCap;

var cpu: registers;

begin

CPU.AH := $DF;
CPU.DL := $01;
MSDOS(CPU);

if CPU.AL <> 0 then
    error (FATAL, 'Unknown error returned during EndLPTCapture');

end;

Procedure Capture;

var cpu: registers;

begin

CPU.AH := $DF;
CPU.DL := $00;
MSDOS(CPU);

if CPU.AL <> 0 then
    error (FATAL, 'Unknown error returned during StartLPTCapture');

end;

Procedure GetCurrentDriveLetter (Var DriveLetter: STRING);

{Get your current drive letter in DOS. This is standard MS-DOS.

INPUT: None
OUTPUT: Current default drive letter}
var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

cpu.ah := $19;
cpu.al := $00;

msdos (CPU);

DriveLetter := CHR (ORD('A')+CPU.AL)+':';

end;

function PrimaryNumber: Integer;

{Get the server number of the primary server

INPUT: None
OUTPUT: The number within the shell table of the primary server (the first one
        logged into by the user. If the user has logged out of the primary
        server, this function returns 0}

var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

CPU.AH := $F0;
CPU.AL := $05;

MSDOS (CPU);

PrimaryNumber := CPU.AL;

end;









function EffectiveNumber: Integer;

{Get the server number of the effective server

INPUT: None
OUTPUT: The number within the shell table of the current effective file server
}

var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

CPU.AH := $F0;
CPU.AL := $02;

MSDOS (CPU);

EffectiveNumber := CPU.AL;

end;







function PreferredNumber: Integer;


{Get the server number of the Preferred server

INPUT: None
OUTPUT: The number within the local shell table of the preferred server. If no
        preferred server has been set, this function returns 0.}

var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

CPU.AH := $F0;
CPU.AL := $01;

MSDOS (CPU);

PreferredNumber := CPU.AL;

end;







Procedure SetPreferredServer (Svr:integer);

{Set the preferred server; all NetWare calls after this point which are
not disk specific will refer to this server.

INPUT: Svr - a valid server number between 1 and 8
OUTPUT: Preferred server is set.

}

var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

CPU.AH := $F0;
CPU.AL := $00;
CPU.DL := Svr;

MSDOS (CPU);

end;






function primary: STRING;

{Returns a string containing the primary server. If the user has logged out
of the primary server, the "preferred" server is returned. If no "preferred"
server has been set, the "effective" (i.e, most current) server is returned.

INPUT: None
OUTPUT: A string containing the name of the current primary, preferred
        or effective file server}

Type
    ServerNameTable = array [1..8, 1..48] of char;
                                           {Array to put server name into}

var
    I: Integer;
    D, B: Byte;
    Server: STRING;
    cpu: registers;                      {Used to make DOS/NetWare calls}
    FSnames: ^ServerNameTable;   {Will point to the shell internal name table}


begin

{Locate File Server Name Table in Shell}

CPU.AH := $EF;
CPU.AL := $04;

MSDOS (CPU);

{Point array to shell table (indicated by register pair ES:SI) }

FSNames := ptr (CPU.ES, CPU.SI);

server := '';
i := 1;
D := PrimaryNumber;

{If we have logged out of our primary connection, use either our preferred
or effective connection in it's place}

if D = 0 then
   begin
   D := PreferredNumber;
   if D = 0 then
      D := EffectiveNumber;
   end;

{Copy choosen server name from shell table into a local string}

While (FSNames^ [D,I] <> CHR(0)) and (I<=48) do
   begin
   Server := server + FSNames^ [D,I];
   I := I + 1;
   end;

{Return the result to the calling routine}

Primary := server;

end;


function DOSVersion: real;

{Returns a real equal to the DOS major and minor versions combined

INPUT: None
OUTPUT: A real number indicating the MS-DOS major and minor version numbers
}

var DOSVER: Integer;
    cpu: registers;                      {Used to make DOS/NetWare calls}



begin

cpu.ah := $30;

msdos (cpu);


DOSVER := CPU.Al*100+cpu.ah;

DOSversion := DOSVER / 100;

end;






function ConnectionNumber: byte;

{Returns the user's connection number of the currently selected file server.
 This is the preferred file server if one has been set, otherwise it is the
 effective file server.

INPUT: none
OUTPUT: User's current connection ID (set by the file server upon LOGIN)
}

var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

CPU.AH := $DC;

MSDOS (CPU);

CONNECTIONNUMBER := CPU.AL;

end;





Function UserName:STRING;

{Get the users information, locate the name field, and return it in a string.

INPUT: none
OUTPUT: A string containing the username on the primary, preferred or
        effective server.
}

type reqbuff = record
                 length: integer;
                 SubFunc: byte;
                 Conn: byte;
               end;

     repbuff = record
               length: integer;
               ObjectID: ARRAY [1..2] of INTEGER;
               ObjectType: integer;
               ObjectName: array [1..48] of char;
               LoginTime: array [1..7] of byte;
               end;

var request: reqbuff;
    reply: repbuff;
    I:integer;
    UID: STRING;
    qonexion: byte;
    var cpu: registers;                      {Used to make DOS/NetWare calls}
    CurrentPreferredServer: integer;

begin

{Save the current preferred server}

CurrentPreferredServer := PreferredNumber;

{If the primary option is set, then set the Preferred server to the primary
server; if the primary server has been logged out of, no preferred server
will be set (PrimaryNumber=0) therefore SetPreferredServer will be set to
No preferred server, therefore all calls following this will refer to the
effective (currently selected) file server}

if UPCASE (BinderySearchMode[1]) = 'P' then
   SetPreferredServer (PrimaryNumber);

{Get the connection number}

qonexion := ConnectionNumber;

{Get my user information from server}

CPU.AH := $E3;
CPU.DS := seg (request);
CPU.SI := ofs (request);
CPU.ES := seg (reply);
CPU.DI := ofs (reply);

Request.Subfunc := $16;
Request.length := 2;
request.conn := qonexion;

reply.length := 62;

MSDOS (CPU);

{Copy user name into string from ObjectName field in reply buffer}

i := 1;
UID := '';

while reply.ObjectName[i] <> chr(0) do
   begin
   UID := UID + reply.ObjectName[i];
   i := i + 1;
   end;

{Restore preferred file server to value before returning UserName}

SetPreferredServer (CurrentPreferredServer);

{Return User Name to calling routine}

UserName := UID;


end;

Function GetObjectName ( D3, D2, D1, D0: byte): STRING;

{ Given a target four byte bindery object ID, this procedure returns the
  associated user name


  INPUT: A Bindery Object ID
 OUTPUT: The name associated with that bindery ID}

type reqbuf = record
                length: integer;
                subfunct: byte;
                ObjectID: array [1..4] of byte;
              end;

     replyBuf = record
                 length: integer;
                 ObjectId: array [1..4] of byte;
                 ObjectType: integer;
                 ObjectName: array [1..48] of char;
                end;

var Request: reqbuf;
    reply: replybuf;
    I: integer;
    ObjStr: STRING;
    CurrentPreferredServer: integer;
    var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

{Save the current preferred server}

CurrentPreferredServer := PreferredNumber;

{If the primary option is set, then set the Preferred server to the primary
server; if the primary server has been logged out of, no preferred server
will be set (PrimaryNumber=0) therefore SetPreferredServer will be set to
No preferred server, therefore all calls following this will refer to the
effective (currently selected) file server}

if UPCASE (BinderySearchMode[1]) = 'P' then
   SetPreferredServer (PrimaryNumber);

{Set up the data structure}

request.length := 5;
Request.Subfunct := $36;
Request.ObjectId[1] := D3;
Request.ObjectId[2] := D2;
Request.ObjectId[3] := D1;
Request.ObjectId[4] := D0;
Reply.Length := 54;

CPU.AH := $E3;
CPU.DS := seg (request);
CPU.SI := ofs (request);
CPU.ES := seg (reply);
CPU.DI := ofs (reply);

{Call NetWare}

MSDOS (CPU);

With CPU do
   if al <> 0 then
      Error (FATAL, 'Error during GetObjectID');

{Get data into a Turbo Pascal string}

I := 1;
ObjSTR := '';

While Reply.ObjectName[I] <> CHR(0) do
   begin
   ObjStr := ObjStr + Reply.ObjectName[i];
   i := i + 1;
   end;

GetObjectName := ObjStr;

{Restore preferred file server to value before returning}

SetPreferredServer (CurrentPreferredServer);

end;


Function FullName (user:STRING): STRING;

type reqbuff = record
                length: integer;
                subfunct: byte;
                ObjType: integer;
                ObjLen: byte;
                RestOfBuf: array [1..65] of byte;
              end;

     replybuf = record
                Length: integer;
                PropValue: array [1..128] of char;
                MoreSegs: byte;
                PropFlags: byte;
               end;

Var Request: ReqBuff;
    Reply: ReplyBuf;
    I, J, K: Integer;
    SequenceNumber, PropNameLength: byte;
    errstr, result, groupnames, PropName: STRING;
    var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

      {initialize request buffer. Since the structure may vary in
       length, you cannot use a simple Pascal RECORD structure to
       provide it.}

      Request.Length := 69;                   {Size of Request Buffer}
      Request.SubFunct := $3D;                {Sub Function for Read Property Value}
      Request.ObjType := swap(1);             {Object Type 1=User; must be in Hi-Lo format}
      Request.ObjLen := length (User);        {Length of user name}
      for i := 1 to Request.ObjLen do         {Fill in User Name converting CHARs to BYTEs}
         Request.RestOfBuf[i] := ord(user[i]);

      {Variables are used here to make the code more readable}

      SequenceNumber := i+1;
      PropNameLength := i+2;
      PropName := 'IDENTIFICATION';

      Request.RestOfBuf[SequenceNumber] := 1;                   {Describes which segment of the set}

      Request.RestOfBuf[PropNameLength] := Length (PropName);   {copies property name into request buffer}
      for j := 1 to length (PropName) do
         Request.RestOfBuf[j+i+2] := ord(PropName[j]);

      Reply.Length := 130;           {NetWare calls nearly always require the reply buffer
                                      length to be explicitly specified or else they hang.}

      {call NetWare to get a segment of the set}

      CPU.AH := $E3;
      CPU.DS := seg (request);
      CPU.SI := ofs (request);
      CPU.ES := seg (reply);
      CPU.DI := ofs (reply);
      MSDOS (CPU);
      If CPU.AL <> 0 then
         begin
         str (cpu.al, errstr);
         error (FATAL,'Error '+errstr+' during ReadProperty');
         end;
      {Set appropriate global to reflect having just read a set}

      result := '';
      i := 1;

      while reply.PropValue[i] <> chr(0) do
         begin
         result := result + reply.PropValue[i];
         i := i + 1;
         end;

      FullName := result;

end;



Function SetErrorMode (mode: byte):byte;

var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

CPU.AH := $DD;
CPU.DL := mode;

MSDOS (CPU);

SetErrorMode := CPU.AL;

end;


Function MemberOf (TargUser, GroupName: STRING): boolean;

Var CurrentSeg, CurrentMember: integer;
    LastSeg: BOOLEAN;
    NetWareUser, MemberName: STRING;
    CurrentPreferredServer: integer;


Function Member (user:STRING): STRING;

{This function will scan the bindery for the property, "GROUPS_I'M_IN". On
 iterative calls it will return the name of each item in the set by making
 calls to 'GetObjectId'.

  INPUT: Name of the target user
 OUTPUT: Multiple calls to procedure 'ServeGroupName' passing parameter of
         each group name user belongs to.
GLOBALS: CurrentSeg - the current segment read from the server.
         CurrentMember - the next member to read from the segment
         LastSeg - a flag indicating whether this is the last segment or not.

}

type reqbuff = record
                length: integer;
                subfunct: byte;
                ObjType: integer;
                ObjLen: byte;
                RestOfBuf: array [1..65] of byte;
              end;

     replybuf = record
                Length: integer;
                PropValue: PropertyValue;
                MoreSegs: byte;
                PropFlags: byte;
               end;

Var Request: ReqBuff;
    Reply: ReplyBuf;
    I, J, K: Integer;
    SequenceNumber, PropNameLength: byte;
    groupnames, PropName: STRING;
    var cpu: registers;                      {Used to make DOS/NetWare calls}

begin

Repeat  {Loop since there may be deleted members which need
         to be skipped. Any member with ObjectNumber=00000000
         can be ignored, but this does not indicate end of
         data.}

   {If we need to call NetWare to get another segment}

   If (CurrentMember >= MembersPerSeg) and (not LastSeg) then
      begin

      {Increment the segment index and reset the member pointer}

      CurrentSeg := CurrentSeg + 1;
      CurrentMember := 0;

      {initialize request buffer. Since the structure may vary in
       length, you cannot use a simple Pascal RECORD structure to
       provide it.}

      Request.Length := 69;                   {Size of Request Buffer}
      Request.SubFunct := $3D;                {Sub Function for Read Property Value}
      Request.ObjType := swap(1);             {Object Type 1=User; must be in Hi-Lo format}
      Request.ObjLen := length (User);        {Length of user name}
      for i := 1 to Request.ObjLen do         {Fill in User Name converting CHARs to BYTEs}
         Request.RestOfBuf[i] := ord(user[i]);

      {Variables are used here to make the code more readable}

      SequenceNumber := i+1;
      PropNameLength := i+2;
      PropName := 'GROUPS_I''M_IN';

      Request.RestOfBuf[SequenceNumber] := CurrentSeg;          {Describes which segment of the set}

      Request.RestOfBuf[PropNameLength] := Length (PropName);   {copies property name into request buffer}
      for j := 1 to length (PropName) do
         Request.RestOfBuf[j+i+2] := ord(PropName[j]);

      Reply.Length := 130;           {NetWare calls nearly always require the reply buffer
                                      length to be explicitly specified or else they hang.}

      {call NetWare to get a segment of the set}

      CPU.AH := $E3;
      CPU.DS := seg (request);
      CPU.SI := ofs (request);
      CPU.ES := seg (reply);
      CPU.DI := ofs (reply);
      MSDOS (CPU);
      If CPU.AL <> 0 then
         error (FATAL,'Error during ReadProperty');

      {Set appropriate global to reflect having just read a set}

      CurrentSet := Reply.PropValue;
      LastSeg := (Reply.MoreSegs = 0);
      end;      {end of block which gets a segment from NetWare}

   {Search through members until you find a valid one.}

   GroupNames := '';
   repeat
      with reply do {if REPLY.PROPVALUE <> 00000000 then}
         if (CurrentSet[CurrentMember*4+1] or
             CurrentSet[CurrentMember*4+2] or
             CurrentSet[CurrentMember*4+3] or
             CurrentSet[CurrentMember*4+4]) <> 0 then {get name associated with ID}
             GroupNames := GetObjectName(CurrentSet[CurrentMember*4+1],
                                            CurrentSet[CurrentMember*4+2],
                                            CurrentSet[CurrentMember*4+3],
                                            CurrentSet[CurrentMember*4+4]);

      currentMember := CurrentMember + 1;   {increment the member pointer}

   until (GroupNames <> '') or (CurrentMember >= MembersPerSeg); {Until we find a real group or
                                                                  run out of members in the current segment}

until (GroupNames <> '') or ((CurrentMember >= MembersPerSeg) and LastSeg); {until we find a real group or
                                                                             we run out of members and
                                                                              we run out of segments too...}

{return the parameter}

Member := GroupNames;

end;

Procedure MemberReset;

{This procedure resets the member pointers to read-scan the bindery from
 the begining.

INPUT: None
OUTPUT: GLOBAL variables CurrentMember, CurrentSeg, and LastSeg}

begin

CurrentMember := 32;
CurrentSeg := 0;
LastSeg := FALSE;

end;

begin

{Save the current preferred server}

CurrentPreferredServer := PreferredNumber;

{If the primary option is set, then set the Preferred server to the primary
server; if the primary server has been logged out of, no preferred server
will be set (PrimaryNumber=0) therefore SetPreferredServer will be set to
No preferred server, therefore all calls following this will refer to the
effective (currently selected) file server}

if UPCASE (BinderySearchMode[1]) = 'P' then
   SetPreferredServer (PrimaryNumber);

MemberReset;
NetWareUser := TargUser;

repeat

   MemberName  := Member(NetWareUser);

until (MemberName = GroupName) or (MemberName = '');

MemberOf := not (MemberName = '');

{Restore preferred file server to value before returning}

SetPreferredServer (CurrentPreferredServer);

end;

Function IsUser (User: STRING): Boolean;

Type ReqBuf = record
                length: integer;
                SubFunction: byte;
                ObjectType: integer;
                Name: string[47];
              end;

     RepBuf = record
                length: integer;
                ObjectId: array [0..3] of byte;
                ObjectType: integer;
                ObjectName: array [0..48] of char;
              end;

Var cpu: registers;                      {Used to make DOS/NetWare calls}
    Request: reqBuf;
    Reply: repBuf;
    CurrentPreferredServer: integer;

begin

{Save the current preferred server}

CurrentPreferredServer := PreferredNumber;

{If the primary option is set, then set the Preferred server to the primary
server; if the primary server has been logged out of, no preferred server
will be set (PrimaryNumber=0) therefore SetPreferredServer will be set to
No preferred server, therefore all calls following this will refer to the
effective (currently selected) file server}

if UPCASE (BinderySearchMode[1]) = 'P' then
   SetPreferredServer (PrimaryNumber);

Repeat
   Request.length := length(user) + 7;
   Request.SubFunction := $35;
   Request.ObjectType := swap (1);
   Request.Name := User;
   Reply.Length := 57;

   CPU.AH := $E3;
   CPU.DS := seg (request);
   CPU.SI := ofs (request);
   CPU.ES := seg (reply);
   CPU.DI := ofs (reply);
   MSDOS (CPU);

if CPU.AL = $FE then
   begin
   Error (warning, 'Bindery Access Error - Bindery locked');
   delay (10000);
   end;

until CPU.AL <> $FE;

Case CPU.AL of

   $96: Error (FATAL,'Bindery Access Error - server is out of memory');
   $EF: Error (FATAL,'Calling program presented an invalid name');
   $F0: Error (FATAL,'Calling program presented a name with wildcards');
   $FF: Error (FATAL,'Bindery Access Error');
end;

{Restore preferred file server to value before returning}

SetPreferredServer (CurrentPreferredServer);

IsUser := (CPU.AL = 0);
end;

Function GetAnObjectsNumber (ObjType: integer; ObjName: STRING): STRING;

{returns the ascii of the HEX bindery ID}

type ReqBuf = record
                 Len: integer;
                Func: byte;
             ObjType: integer;
             ObjName: string[47];
              end;

     RecvBuf = record
                 Len: integer;
               ObjId: array [1..4] of byte;
             ObjName: array [1..48] of char;
               end;

var Request: reqbuf;
    Reply: recvbuf;
    cpu: registers;
    ans: STRING;
    i: integer;
begin

Request.Len := 52;
Request.Func := 53;
Request.ObjType := swap(ObjType);
Request.ObjName := ObjName;
Reply.Len := 53;

CPU.AH := $E3;
CPU.DS := Seg(request);
CPU.SI := Ofs(request);
CPU.ES := Seg (reply);
CPU.DI := Ofs (reply);

msdos(cpu);

if cpu.al <> 0 then
   ans := 'NOTFOUND'
else
   begin
   ans := '';
   for I := 1 to 4 do
      Ans := Ans + Nybbles[Reply.ObjID[i] div $10] + Nybbles[Reply.ObjID[i] mod $10];
   end;

GetAnObjectsNumber := ans;
end;
