/*               						*
 *  PWMANGLE.C  						*
 *								*
 *  Author: Rob Rawson 						*
 * Version: 1.0							*
 *    Date: September 19, 1994					*
 *Language: WATCOM C v7.0					*
 *								*
 * Purpose: This utility is designed to generate a random       *
 *  	    password for a user ID. The intent of this is to    *
 *          secure a user from a workstation using it to log in *
 *          that may otherwise be used for other purposes. For  *
 *          example, the NetView agent does not need to log in  *
 *          in the traditional sense, but must exist for a      *
 *          RACF user to effectively administer the server from *
 *          NetView. Since this ID must be SUPERVISOR equivilent*
 *          this utility will allow the user ID to be secured.	*
 *								*
 *   Input: Bindery User Name                                   *
 *  Output: ERRORLEVEL 2 = USAGE ERROR                          *
 *          ERRORLEVEL 1 = ERROR RETURNED FROM BINDERY CALL     *
 *          ERRORLEVEL 0 = SUCCESSFUL 				*
 *			   also object password changed randomly*
 *								*
 *  Dependencies: Must be linked with SNIT.LIB			*
 *								*/

#include <nit.h>
#include <niterror.h>
#include <stdlib.h>
#include <time.h>
#include <dos.h>

int main( int argc, char *argv[] )

{
int				completionCode;
char    			objectName[48];
WORD    			objectType;
char    			oldPassword[128];
char    			newPassword[128];
int				i;
time_t				now;
register struct tm		*tyme;

if (argc == 1)
    {
    printf ("USAGE: PWMANGLE <username>\n");
    return(2);
    }

printf ("Password Mangler version 1.0\nCopyright (c) 1994, Rob Rawson\n\n");

strcpy (objectName, argv[1]);
strupr (objectName);
objectType = OT_USER;
strcpy (oldPassword, NULL);


/* seed random number generator using the system clock */
now = time( NULL );
tyme = localtime( &now );
srand(tyme->tm_mon * tyme->tm_sec * tyme->tm_min);

/* generate a random password */
for (i=0; i<128; ++i)
   newPassword[i] = (0x40+(rand()/1300));
newPassword[128] = 0;

/* assume no old password or SUPERVISOR running utility*/
for (i=1; i<128; ++i)
   oldPassword[i] = 0;

/* change the password */
if (completionCode=ChangeBinderyObjectPassword(&objectName,
					       objectType,
					       &oldPassword,
 					       &newPassword))
   {
   printf ("Error %d occured mangling password for user %s\n",completionCode, objectName);
   return(1);
   }
printf ("Password for user %s succsessfully mangled.\n\n",objectName);

return(0);
}