/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File: setbcast.c
**
**   Desc: This code will set the BroadCast mode to
**         0x0000 Receive all broadcasts
**         0x0001 Recieve only server broadcasts. User messages not stored.
**         0x0002 Desable broadcasts. User messages not stored. Server
**                messages are stored but notification is not given to the
**                workstation.
**         0x0003 Both user and server messages are stored but message
**                notification is not sent to the workstation.  The client
**                can poll for messages.
**
**
**   Programmers:
**   Ini   Who         Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**	 Ag    Anders Gustafsson  Pedago Interaktiv Ab (www.pedago.fi)
**
**   History:
**
**   ------------------------------------------------------------------
**   09-25-95   ARM		First code.
**   March 8, 2001 Ag	Fixed for obsolete calls. Do not call strtoul() if
**						no argument passed. Changed mode to nuint16
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

        /*------------------------------------------------------------------
        **   ANSI
        */
        #include <stdlib.h>          /* exit()                */
        #include <stdio.h>           /* sprintf()             */
        #include <string.h>
        #include <conio.h>           /* clrscr()              */
        /*------------------------------------------------------------------
        **   NetWare
        */
        //#define NWDOS
        #include <nwcalls.h>
        #include <ntypes.h>
		#include <nwclxcon.h> 

        extern unsigned _stklen = (1024 * 8);


/****************************************************************************
**   Program Start
*/
void main(int argc,char *argv[])
{
        NWCCODE        ccode,rc;
        NWCONN_HANDLE  connHandle;
		nuint32       connRef;
        nuint16			mode;
		nuint32			scanIterator;
		nuint32			total, changed;
		nuint			connNum;
		char			Server[NW_MAX_SERVER_NAME_LEN];
		//
		NWCCTranAddr tranAddr; 
		nuint8 networkAddress[12];  
		tranAddr.len = 12; tranAddr.buffer = networkAddress;  
		//
		if (argc>=2) mode=(atoi(argv[1]));

        if (argc<2 || mode<0 || mode>3)
        {
                //clrscr();
                printf(" setbcast <mode number>\n");
                printf(" Where mode is one of the following:\n");
                printf("0x0000 Receive all broadcasts\n");
                printf("0x0001 Recieve only server broadcasts. User messages not stored.\n");
                printf("0x0002 Disable broadcasts. User messages not stored. Server \n");
                printf("       messages are stored but notification is not given to the \n");
                printf("       workstation.\n");
                printf("0x0003 Both user and server messages are stored but message \n");
                printf("       notification is not sent to the workstation.  The client\n");
                printf("       can poll for messages.\n");
                exit(1);
        }

        /*-----------------------------------------------------------------------
        **Initialize NWCalls
        */
        ccode = NWCallsInit( NULL, NULL );
        if (ccode)
        {
                printf( "\nNWCallsInit failed: %04x", ccode );
                exit(1);
        }
		//
		// Loop through the connections..
		//
		scanIterator=0;
		rc=0;
		total=0;
		changed=0;
		while (rc != NWE_NO_MORE_ENTRIES){
//			rc = NWCCScanConnRefs(&scanIterator, &connRef);
			rc = NWCCScanConnInfo(&scanIterator,
				NWCC_INFO_NONE,
				NULL,
				//NWCC_RETURN_LICENSED+NWCC_RETURN_UNLICENSED+NWCC_RETURN_PUBLIC+NWCC_RETURN_PRIVATE,
				NWCC_RETURN_PUBLIC+NWCC_RETURN_PRIVATE,
				NWCC_INFO_VERSION_1,
				NWCC_INFO_CONN_NUMBER,
				&connNum,
				&connRef);
			//
			if(!rc){
				++total;
				ccode = NWCCGetConnRefInfo(
					connRef,
					NWCC_INFO_SERVER_NAME,
					sizeof(Server),
					&Server);
				//
				//tranAddr.len = 12;
				//tranAddr.buffer = networkAddress;
				//ccode = NWCCGetConnRefInfo(
				//	connRef,
				//	NWCC_INFO_TRAN_ADDR,
				//	sizeof(tranAddr),
				//	&tranAddr);
				//
				//printf("\nServer: %s, transport: %d\n",Server, tranAddr.type);
				//
				ccode = NWCCOpenConnByRef(
					/* conn ref     */  connRef,
					/* open state   */  NWCC_OPEN_LICENSED,
                    /* reserved     */  NWCC_RESERVED,
                    /* conn handle  */  &connHandle
					);

				if (ccode)
					{
						printf("NWCCOpenConnByRef(%s) failed with error code=0x%04x\n\n", Server, ccode);
					}
				else{				
						ccode = NWSetBroadcastMode(connHandle, mode);
						if (ccode)
							printf( "\nNWSetBroadcastMode(%s): failed %04x", Server, ccode );
						else ++changed;
				}

			} // if !rc

		} // while

		switch(mode)
			{
			case 0x0000 : printf("Broadcast mode set to 0x0000\n");
				break;
			case 0x0001 : printf("Broadcast mode set to 0x0001\n");
				break;
			case 0x0002 : printf("Broadcast mode set to 0x0002\n");
				break;
			case 0x0003 : printf("Broadcast mode set to 0x0003\n");
				break;
         default     : printf("Should NEVER get here!!!!!\n");
                       break;
      }
		printf("On %d connections out of %d\n",changed,total);
} 