// syntheticTime.cpp
// =================
//
// Reports if a DS server is using synthetic time.
//
//
// Version 0.90. May 05, 2005. (PK) Initial code.
// Version 1.00. May 31, 2005. Released as part of eDir CoolTip
//                             article @ Novell.
////////////////////////////////////////////////////////////////////
//

/*----------------------------------------------------------------
syntheticTime, reports if an eDirectry server is using synthetic time.
Copyright (C) 2005  Peter Kuo (www.DreamLAN.com)
==================================================================
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.

(A COPY OF THE GPL LICENSE CAN BE FOUND IN THE COPYING.TXT FILE
 ENCLOSED AS PART OF THIS PROGRAM ZIP FILE.)
----------------------------------------------------------------*/

// ANSI definitions
#include <windows.h>
#include <stdio.h>
#include <time.h>

// NDK definitions
#define N_PLAT_WNT4
#define N_ARCH_32
#include <nwcalls.h>
#include <nwlocale.h>
#include <nwdsbuft.h>
#include <nwdsdefs.h>
#include <nwdserr.h>
#include <nwdsmisc.h>
#include <nwdspart.h>


// -----------------------------------------------
// For simplicity, no error checking is performed.
// -----------------------------------------------
void main ( int argc, char *argv[] )
{
	LCONV			lconvInfo;
	NWDSContextHandle	Cx;
	NWDS_ITERATION		iterHandle;
	NWDS_BUFFER		*outBuf;
	nflag32			DSPFlags;
	pnstr8			infoPtr;
	pnstr8			infoPtrEnd;
	int				i;
	union TInfo
	{
		char				dataC[MAX_DN_CHARS];
		BYTE				dataByte[MAX_DN_BYTES];
		NWDS_TimeStamp_T	dataTS;
	} *info = NULL;
	nuint32			dataLen;
	pnstr8			serverName;
	NWCOUNT			nReplicas;
	int				statusCode = -1;
					//  0 = no synthetic time in use
					// >0 = synthetic time in use
					// -1 = no server object name supplied
					// -2 = server has no replica
					// -3 = failed to obtain info from server
	long		timeDiff;
	int			hours, minutes, seconds;


	fprintf (stderr, "syntheticTime v1.0, Copyright (C) 2005  Peter Kuo (www.DreamLAN.com)\n\n");
	fprintf (stderr, " +---------------------------------------------------+\n");
	fprintf (stderr, " | syntheticTime comes with ABSOLUTELY NO WARRANTY.  |\n");
	fprintf (stderr, " | This  is  free software, and you  are welcome to  |\n");
	fprintf (stderr, " | redistribute or modify it under the GPL licensing |\n");
	fprintf (stderr, " | terms.                                            |\n");
	fprintf (stderr, " +---------------------------------------------------+\n\n");

	if ( argc != 2 ) {
		fprintf (stderr, "\tUsage: syntheticTime server_object_name.context\n\n");
		fprintf (stderr, "\te.g. syntheticTime SLES9.SiteA\n\n");
		exit (-1);
	}


// Init. the client API.
	NWCallsInit (NULL, NULL);


// Unicode table must be loaded in order to use DS calls.
	NWLlocaleconv (&lconvInfo);
	NWInitUnicodeTables (lconvInfo.country_id, lconvInfo.code_page);


// Set up context.
	NWDSCreateContextHandle(&Cx);

	NWDSSetContext(
		Cx,
		DCK_NAME_CONTEXT,
		"[Root]");


////////////////////////////////////////////////////////////////////////////
// Grunt work takes place here

	serverName=(char *)malloc(MAX_DN_CHARS+1);
	info=(TInfo *)malloc(MAX_DN_BYTES+1);


/*
 * If a server defined in the NDS is not up, the
 * NWDSListPartitionExtInfo() API will take some
 * time to time-out.
 */

	//fprintf (stderr, "\nServer %s:\n", argv[1]);
	NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &outBuf);

	iterHandle = NO_MORE_ITERATIONS;
	DSPFlags = DSP_OUTPUT_FIELDS |
		DSP_PARTITION_DN |
		DSP_MODIFICATION_TIMESTAMP;

	do {
		if ( NWDSListPartitionsExtInfo (
				Cx,
				&iterHandle,
				argv[1],
				DSPFlags,
				outBuf) != 0 ) {
			fprintf (stderr, "Cannot obtain info from [%s].\n", argv[1]);
			statusCode = -3;
			break;
		}

		NWDSGetServerName (
			Cx,
			outBuf,
			serverName,
			&nReplicas);

		//fprintf (stderr, "\n\tServer %s:\n", serverName);
		if ( !nReplicas ) {
			fprintf (stderr, "\t -> contains no replicas?\n\n");
			statusCode = -2;
			break;
		}
		//else
		//	fprintf (stderr, "\t -> contains %d replica(s).\n\n", nReplicas);


		// Assume no synthetic time to start
		statusCode = 0;

		for ( i = 0; i < (int)nReplicas; i++ ) {
			NWDSGetPartitionExtInfoPtr (
				Cx,
				outBuf,
				&infoPtr,
				&infoPtrEnd);

			NWDSGetPartitionExtInfo (
				Cx,
				infoPtr,
				infoPtrEnd,
				DSP_PARTITION_DN,
				&dataLen,
				(void *)info);
			fprintf (stderr, "\n\t Replica %s: ", info->dataC);
		
			NWDSGetPartitionExtInfo (
				Cx,
				infoPtr,
				infoPtrEnd,
				DSP_MODIFICATION_TIMESTAMP,
				&dataLen,
				(void *)info);

			//printf ("DSP_MODIFICATION_TIMESTAMP = %ld, %ld\n", info->dataTS.wholeSeconds, info->dataTS.eventID);
			//printf ("time()                     = %ld\n", time(NULL));


			// Now see if synthetic time is being used:
			//  a -ve or zero timeDiff means everything is OK'
			//  a +vd timeDiff means synthetic time is being issued
			// NOTE: it is assumed that the workstation's time
			//       is sync'ed with the target server's. If,
			//       for instance, workstation is in a different
			//       time zone than the server, the timeDiff will be
			//       calculated incorrectly.
			timeDiff = info->dataTS.wholeSeconds - time(NULL);
			if ( timeDiff <= 0 ) {
				fprintf (stderr, "No synthetic time in use.\n");
			}
			else {
				hours = timeDiff / 3600;
				minutes = (timeDiff - (hours * 3600)) / 60;
				seconds = timeDiff - (hours * 3600) - (minutes * 60);
				fprintf (stderr, "Synthetic time in effect.\n");
				fprintf (stderr, "\t Last \"real\" timestamp is %02d:%02d:%02d (%ld seconds) in the future.\n", hours, minutes, seconds, timeDiff);
				statusCode++;
			}
		}
	} while ( iterHandle != NO_MORE_ITERATIONS );


// Cleanup
	free(serverName);
	free(info);

	if ( iterHandle != NO_MORE_ITERATIONS )
		NWDSCloseIteration (Cx, iterHandle, DSV_LIST_PARTITIONS);

	NWDSFreeBuf (outBuf);
////////////////////////////////////////////////////////////////////////////

	NWFreeUnicodeTables ();
	NWDSFreeContext (Cx);

	exit (statusCode);
}
