import java.net.*;
import java.io.*;
import java.util.*; // pour currentDateFormated
import java.text.*; // pour currentDateFormated

public class NwQuotaD
{
    protected static final String VERSION_NUMBER = "1.0";
    protected static int port = 48000;
    protected static String filter = "";
    protected static boolean showOnlyAlert = true;
    protected static String logFileName = "nwquotalog.txt";
    protected static boolean filtrePositif = true;
    
    // main function
    public static void main(String[] args) {
        System.out.print("NwQuotaD V. "+VERSION_NUMBER);
        System.out.println("  NwQuota alert message logguer");
        System.out.println("    Hit q to quit after next incoming packet");
        parseArgs(args);
        System.out.println(" Following parameters will be used");
        System.out.print(" port="+port);
        System.out.print(" showOnlyAlert="+showOnlyAlert);
        System.out.print(" logFile="+logFileName);
        System.out.println(" filter="+filter+"("+filtrePositif+")");
        new NwQuotaD();
    }
    
    protected static void parseArgs(String[] args) {
        boolean failed = false;
        int tmpPort = port;
        boolean tmpShowOnlyAlert = showOnlyAlert;
        String tmpFilter="";
        
        System.out.println(" Parsing command line arguments ...");
        // on check qu'il y a au moins 3 arguments
        if ((args.length!=3) && (args.length!=2)) failed = true;
        // on parse le port
        if (!failed) {
            try {
                tmpPort = Integer.parseInt(args[0]);
            } catch (NumberFormatException e) {
                failed = true;
            }
        }
        
        // on parse le 'y' ou le 'n'
        if (!failed) {
            if (args[1].toUpperCase().equals("Y")) {
                tmpShowOnlyAlert = true;
            } else if (args[1].toUpperCase().equals("N")) {
                tmpShowOnlyAlert = false;
            } else failed = true;
        }
        
        // on parse le filtre
        if ((!failed) && (args.length==3)) {
            tmpFilter = args[2].toUpperCase();
        }
        
        if (failed) {
            System.out.println("  Parsing failed : you have to respect cmd line syntax :");
            System.out.println("     java NwQuotaD <port_number> <showOnlyAlert:y|n> [optional:_filter]");
            System.out.println("     Ex : java NwQuotaD 49000 N +LETTRES.BASTIONS.UNIGE");
            System.out.println("     Ex : java NwQuotaD 49000 N -students");
            System.out.println("          java NwQuotaD 45000 Y");
            
            System.out.println("   NwQuotaD will start using default parameters.");
        } else {
            port = tmpPort;
            showOnlyAlert=tmpShowOnlyAlert;
            filter = tmpFilter;
        }
        
        // on enlve le + ou le - du filtre.
        if (filter.startsWith("+")) {
            filtrePositif = true;
            filter = filter.substring(1);
        } 
          
        if (filter.startsWith("-")) {
            filtrePositif = false;
            filter = filter.substring(1);
        } 
    }
    
    // main constructor
    public NwQuotaD() {
        DatagramSocket ds = null;
        byte[] buf = new byte[256];
        String result = null;

        // on bind le socket
         try {
            ds = new DatagramSocket(port);
        } catch (IOException e) {
            System.out.println("Exception "+e);
        }
        System.out.println("   Now waiting for incoming packets");
        
        // main loop
        String tmpStr;
        while (true) {
            try {
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                ds.receive(packet);
                result = new String(packet.getData(),0, packet.getLength());
                tmpStr = result.toUpperCase();
                
                // on discard le paquet si ce n'est pas un message "danger" et si
                // la command line option nous le demandait.
                if ((showOnlyAlert) && (tmpStr.indexOf("DANGER")==-1)) continue;
                                
                // on discard le paquet s'il ne correspond pas au filtre
                if ((filter!=null) && (!filter.equals(""))) {
                    if (filtrePositif) {
                        System.out.print("Filtre posisif : ");
                        if (tmpStr.indexOf(filter.toUpperCase())==-1) {
                            System.out.println(" ignoring !");
                            continue;
                        } else System.out.println(" Accepting ");
                    } else {
                        System.out.print("Filte negatif : ");
                        if (tmpStr.indexOf(filter.toUpperCase())!=-1) {
                            System.out.println(" ignoring !");
                            continue;
                        } else System.out.println(" Accepting ");
                    }
                }
                
                result = getCurrentDateFormated()+","+result;
                dumpToFile(result);
                System.out.println(result);
                
            } catch (IOException e) {System.out.println("NwQuotaD : IO Exception during socket operation ");}
        }
    }
    
    protected String getCurrentDateFormated() {
      SimpleDateFormat formatter = new SimpleDateFormat ("dd-MM-yyyy HH:mm:ss");
      return formatter.format(new Date());
    }
    
    protected void dumpToFile(String res) {
        try {
                PrintWriter ostr = new PrintWriter(new FileOutputStream(logFileName,true));
                ostr.println(res);
                ostr.flush();
                ostr.close();
            } catch (IOException e) {
               System.out.println("NwQuotaD : IO Exception during entry file writting "+e);
            } //try / catch 
    }
}