/*
NWQuota 
Rev 1.21
Copyright (C) July 2000 University Of Geneva
Jean-Francois.Burdet@adm.unige.ch
http://www.unige.ch/~burdetj/nwquota.html

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
Or see http://www.gnu.org/copyleft/gpl.html

Abstract :
----------
NwQuota is a small Win32 systray utility (distributed under GPL),
wich provides a simple way to monitor space restrictions on any 
Novell Netware mapped drive. When the network drive steps some 
pre-defined thresholds, the systray icons changes from "OK-Green" 
to "Warning-Yellow", the after passing a second threshold it becomes 
"Danger-Red". It can also display the directory and/or volume 
restrictions on a nice windows using progress bar, wich makes the 
result undertandable by anyone (wich is not the case with ndir /spa ). 

For full documentation see nwquota.html

Thanks and credit to :
- pjn@indigo.ie for its CTrayNotifyIcon v1.4 class. (http://indigo.ie/~pjn/)
- case@dcs.kcl.ac.uk for its CToken class.
- Bert Schinkel for its german translation
*/


// DialQuota.cpp : implementation file
//


#include "stdafx.h"
#include "DialQuota.h"
#include "resource.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CDialQuota dialog


CDialQuota::CDialQuota(CWnd* pParent /*=NULL*/)
	: CDialog(CDialQuota::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialQuota)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	// sera probablement overid
	showQuotaAndQuit = FALSE;
	autoShowWindow = FALSE;

}





void CDialQuota::DoDataExchange(CDataExchange* pDX)
{
	
	DDX_Control(pDX, IDC_PCACTHELP, pAccountInfoUrl);
	DDX_Control(pDX, IDC_NWQUOTAHLP ,nwQuotaInfoUrl);

	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialQuota)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialQuota, CDialog)
	//{{AFX_MSG_MAP(CDialQuota)
	ON_BN_CLICKED(IDC_CHECK_AUTO_SHOW, OnCheckAutoShow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialQuota message handlers



void CDialQuota::OnOK() 
{
	// TODO: Add extra validation here
	if (showQuotaAndQuit == TRUE) {
	 AfxGetApp()->m_pMainWnd->DestroyWindow();
	 }
	else 
	{		
		CDialog::OnOK();
	} 
}


void CDialQuota::OnCheckAutoShow() 
{
	// TODO: Add your control notification handler code here
	CButton *cb;
	cb = (CButton*) this->GetDlgItem(IDC_CHECK_AUTO_SHOW);
	autoShowWindow = cb->GetCheck();
}

 

void CDialQuota::disableAutoShowCheckBox()
{
	((CButton*) this->GetDlgItem(IDC_CHECK_AUTO_SHOW))->ShowWindow(SW_HIDE);
}

void CDialQuota::updateCheckBox(BOOL chk)
{
		autoShowWindow=chk;
		((CButton*) this->GetDlgItem(IDC_CHECK_AUTO_SHOW))->SetCheck(chk);
}

BOOL CDialQuota::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_stcPrBal.SubclassDlgItem(IDS_ACTBAL, this);
	cTextOriginal = m_stcPrBal.GetTextColor();
	
	pAccountInfoUrl.SetURL(_T("http://www.unige.ch/dinf/etudiants/imprimer.html"));
	pAccountInfoUrl.SetUnderline(false);

	nwQuotaInfoUrl.SetURL(_T("http://www.unige.ch/dinf/serveurs/novell/quota.htm"));
	nwQuotaInfoUrl.SetUnderline(false);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CDialQuota::PostNcDestroy() 
 {

 	CDialog::PostNcDestroy();
 }

