/*
NWQuota 
Rev 1.21
Copyright (C) July 2000 University Of Geneva
Jean-Francois.Burdet@adm.unige.ch
http://www.unige.ch/~burdetj/nwquota.html

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
Or see http://www.gnu.org/copyleft/gpl.html

Abstract :
----------
NwQuota is a small Win32 systray utility (distributed under GPL),
wich provides a simple way to monitor space restrictions on any 
Novell Netware mapped drive. When the network drive steps some 
pre-defined thresholds, the systray icons changes from "OK-Green" 
to "Warning-Yellow", the after passing a second threshold it becomes 
"Danger-Red". It can also display the directory and/or volume 
restrictions on a nice windows using progress bar, wich makes the 
result undertandable by anyone (wich is not the case with ndir /spa ). 

For full documentation see nwquota.html

Thanks and credit to :
- pjn@indigo.ie for its CTrayNotifyIcon v1.4 class. (http://indigo.ie/~pjn/)
- case@dcs.kcl.ac.uk for its CToken class.
- Bert Schinkel for its german translation
*/


#include "stdafx.h"
#include "nwquota.h"
#include "MainFrm.h"
#include "unige_NWGetDriveSpaceRestriction.h"
#include "unige_NWgetAccBalance.h"
#include <afxcmn.h> // pour progress Bar
#include <Windows.h> // pour formatage en mo

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WM_TRAYNOTIFY WM_USER + 100


IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_QUOTA, OnQuota)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
  ON_MESSAGE(WM_TRAYNOTIFY, OnTrayNotification)
END_MESSAGE_MAP()

CMainFrame::CMainFrame()
{
  etatIcone = ETAT_INCONNU;
  ancienEtat = ETAT_INCONNU;
    
  // init du dialog
  dialQuota = new CDialQuota();
  dialQuota->Create(IDD_QUOTADLG, this);
  
  
  // valeurs par dfaut : sera overid probablement
  seuil_bas = 75; seuil_haut = 95; scan_delay = 300;
  showFrameOnThreshold = FALSE;
  showQuotaAndQuit= FALSE;

  m_hIcons[0] = CTrayNotifyIcon::LoadIconResource(IDR_HD_VERT);
  m_hIcons[1] = CTrayNotifyIcon::LoadIconResource(IDR_HD);
  m_hIcons[2] = CTrayNotifyIcon::LoadIconResource(IDR_HD_JAUNE);
  m_hIcons[3] = CTrayNotifyIcon::LoadIconResource(IDR_HD);
  m_hIcons[4] = CTrayNotifyIcon::LoadIconResource(IDR_HD_ROUGE);
  m_hIcons[5] = CTrayNotifyIcon::LoadIconResource(IDR_HD_INCONNU);

  // on charge les ressource de chaine
  strcpy(moFree,"");
  tooltip1.LoadString(IDS_TIP1);
  tooltip2.LoadString(IDS_TIP2);
  tooltip3.LoadString(IDS_TIP3);

}

CMainFrame::~CMainFrame()
{
	if (dialQuota) delete dialQuota;
	if (reportingSocket) delete reportingSocket;
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;


 if (!m_TrayIcon.Create(this, IDR_TRAYPOPUP, _T("NwQuota"), m_hIcons[5], WM_TRAYNOTIFY))
  {
    AfxMessageBox(_T("Failed to create tray icon"), MB_OK | MB_ICONSTOP);
    return -1;
  }


 // on cr le socket de report.
  AfxSocketInit( 0 );
  reportingSocket = new CAsyncSocket();
  reportingSocket->Create(0, SOCK_DGRAM);
  reportAlarm = reportingSocket->Connect(ipToReport, portToReport);
  
  alarmSent = FALSE;

   // on dmarre le Timer
	 SetTimer(1, scan_delay*1000, NULL);
  
	// on dsactive la checkbox "affiche fentre automatiquement
	// dans le cas ou cela est ncessaire
	if (!showFrameOnThreshold) {
		dialQuota->disableAutoShowCheckBox();
	}
	// on affecte la variable d'tat correspondante.
	dialQuota->updateCheckBox(showFrameOnThreshold);
	
	// on initialise la var d'tat pour le "showAndQuit only".
	((CDialQuota *)dialQuota)->showQuotaAndQuit = showQuotaAndQuit;
	
	// on met a jour le quota Novell
	OnTimer(1);
	
	if (showQuotaAndQuit == TRUE) {
		OnQuota();
	}

	return 0;
}

LRESULT CMainFrame::OnTrayNotification(WPARAM wParam, LPARAM lParam)
{
  //Delegate all the work back to the default implementation in
  //CTrayNotifyIcon.
  return m_TrayIcon.OnTrayNotification(wParam, lParam);
}

void CMainFrame::CheckNwQuota()
{
	// on fait l'appel
	resultNWCall = unige_NWGetDriveRestriction(path_to_check, serverName, userName,sPath,
										&currentDirUse, &maxDirUse, &freeDir,
										&currentVolUse, &maxVolUse);
	// on calcule l'etat de l'icone :
	// undef, vert, jaune, rouge
	switch(resultNWCall) {
	case NWCALLS_FAILED:
	case INPUT_VAR_NULL_ERROR :
		etatIcone = ETAT_INCONNU;
		percentUsed=0;
		strcpy(userName,"??");
		strcpy(serverName, "??");
		break;
	case DIR_QUOTA_EXISTS :
		if (maxDirUse == 0 ) {// restriction totale
			etatIcone = ETAT_DANGER_ROUGE;
			absFree = 0;
			percentUsed = 100;
		} else {
			percentUsed = (int) (((double)1.0- (double)freeDir / (double)maxDirUse) * (double)100.0);
			if (freeDir<0) percentUsed = 100;
			absFree = freeDir; // 4kB units
			
			if (seuilsRelatifs) {
				if (percentUsed<seuil_bas) etatIcone = ETAT_OK_VERT;
				else if ((percentUsed>=seuil_bas) && (percentUsed<seuil_haut)) etatIcone = ETAT_ATTENTION_JAUNE;
				else if (percentUsed>=seuil_haut) etatIcone = ETAT_DANGER_ROUGE;
				else etatIcone = ETAT_INCONNU;
			} else {
				if (absFree>seuil_bas) etatIcone = ETAT_OK_VERT;
				else if ((absFree<=seuil_bas) && (absFree>seuil_haut)) etatIcone = ETAT_ATTENTION_JAUNE;
				else if (absFree<=seuil_haut) etatIcone = ETAT_DANGER_ROUGE;
				else etatIcone = ETAT_INCONNU;
			}
		}

		break;
	case VOL_QUOTA_EXISTS : 
		if (maxVolUse == 0 ) {// restriction totale
			etatIcone = ETAT_DANGER_ROUGE;
			percentUsed = 100;
			absFree = 0;
		} else {
			percentUsed = (int) ( (double)currentVolUse/(double)maxVolUse* (double)100.0);
			if (currentVolUse>maxVolUse) percentUsed = 100;
			absFree = (maxVolUse - currentVolUse); // 4Kb units
				
			if (seuilsRelatifs) {
				if (percentUsed<seuil_bas) etatIcone = ETAT_OK_VERT;
				else if ((percentUsed>=seuil_bas) && (percentUsed<seuil_haut)) etatIcone = ETAT_ATTENTION_JAUNE;
				else if (percentUsed>=seuil_haut) etatIcone = ETAT_DANGER_ROUGE;
				else {
					etatIcone = ETAT_INCONNU;
					percentUsed = 0;
				}
			} else {
				if (absFree<0) absFree=0;
				if (absFree>seuil_bas) etatIcone = ETAT_OK_VERT;
				else if ((absFree<=seuil_bas) && (absFree>seuil_haut)) etatIcone = ETAT_ATTENTION_JAUNE;
				else if (absFree<=seuil_haut) etatIcone = ETAT_DANGER_ROUGE;
				else {
					etatIcone = ETAT_INCONNU;
					absFree = 0;
				}
			}
			
		}
		break;
	case VOL_AND_DIR_QUOTA_EXISTS :
		// Les deux quotas existent : on ne tiendra compte que de celui qui est le plus
		// haut en valeur relative pour dterminer l'tat de l'icone.
		int res, resV, resD;
		if ( (maxVolUse==0) || (maxDirUse==0) ) {
			etatIcone = ETAT_DANGER_ROUGE;
			percentUsed=100;
			absFree = 0;
		} else {

			resV = (int) ( (double)currentVolUse/(double)maxVolUse* (double)100.0);
			resD = (int) ((1.0- (double)freeDir / (double)maxDirUse) * (double)100.0);
			if (freeDir==0) resD = 100;
			if (currentVolUse>maxVolUse) resV = 100;
			if (resV>=resD) percentUsed=resV; else percentUsed=resD; // on prend le quota le plus occup

			resV = maxVolUse - currentVolUse;
			resD = freeDir;
			if (resV<0) resV=0;
			if (resV<=resD) absFree=resV; else absFree=resD; // on prend le quota le plus occup
															 // unite : block de 4K
				
				
			if (seuilsRelatifs) {
				if (percentUsed<seuil_bas) etatIcone = ETAT_OK_VERT;
				else if ((percentUsed>=seuil_bas) && (percentUsed<seuil_haut)) etatIcone = ETAT_ATTENTION_JAUNE;
				else if (percentUsed>=seuil_haut) etatIcone = ETAT_DANGER_ROUGE;
				else {
					etatIcone = ETAT_INCONNU;
					percentUsed = 0;
				}
			} else {
				
				if (absFree>seuil_bas) etatIcone = ETAT_OK_VERT;
				else if ((absFree<=seuil_bas) && (absFree>seuil_haut)) etatIcone = ETAT_ATTENTION_JAUNE;
				else if (absFree<=seuil_haut) etatIcone = ETAT_DANGER_ROUGE;
				else {
					etatIcone = ETAT_INCONNU;
					absFree = 0;
				}
			}
		}
		break;
	case NO_QUOTA : 
		etatIcone = ETAT_OK_VERT;
		percentUsed = 0;
		resV = maxVolUse - currentVolUse;
		resD = freeDir;
		if (resV<0) resV=0;
		if (resV<=resD) res=resV; else res=resD; // on prend le quota le plus occup
		absFree = res; //4Kb units
		break;
	default :
		etatIcone = ETAT_INCONNU;
		percentUsed = 0;
	}


	// On affiche ventuellement la fentre si on franchi le seuil.
	// et si l'utilisateur n'a pas dcoch l'option dans la fentre de dialogue.
	if (dialQuota->autoShowWindow) {
		// on affiche si le seuil rouge est franchi et que l'tat prcdent tait inconnu ou OK
		if ( (ancienEtat==ETAT_INCONNU) ||(ancienEtat==ETAT_OK_VERT) || (ancienEtat==ETAT_ATTENTION_JAUNE)) {
			if ( (etatIcone==ETAT_DANGER_ROUGE) ) {
				
				UpdateDialogQuota();
				showDetailedWindow();
				
			}
		}
	}

	// pour s'assurer que l'ventuelle alarme soit quand mme gnre si
	// on passe de jaune a rouge :
	if ((ancienEtat==ETAT_ATTENTION_JAUNE) && (etatIcone==ETAT_DANGER_ROUGE)) alarmSent=FALSE;

	//
	ancienEtat = etatIcone;

}

void CMainFrame::OnQuota() 
{
	OnTimer(1);
	showDetailedWindow();
	
}

void CMainFrame::UpdateToolTip()
{
	char tmpBuffer[512];
	sprintf(tmpBuffer, "%s %d%% %s %s - %s %s.", tooltip1, 
						percentUsed, tooltip2, path_to_check, moFree, tooltip3);
	// ToolTip strings cannot be bigger than 64 char !
	// so, toolTipBuffer is a 64 wide buffer.
	tmpBuffer[63]=0x0;
	strcpy(toolTipBuffer, tmpBuffer);
	m_TrayIcon.SetTooltipText(toolTipBuffer);

}

void CMainFrame::OnTimer(UINT nIDEvent) 
{
	// c'est l'heure de bosser !

	CheckNwQuota();
	CheckNwActBal();
	UpdateDialogQuota();
	UpdateDialogActBal();
	UpdateToolTip();
	dispatchUdpAlarm();

	// on rgle l'icone en fonction du rsultat.
	switch(etatIcone) {
	case ETAT_INCONNU :
		m_TrayIcon.SetIcon(m_hIcons[5]);
		break;
	case ETAT_OK_VERT :
		m_TrayIcon.SetIcon(m_hIcons[0]);
		break;
	case ETAT_ATTENTION_JAUNE : 
		m_TrayIcon.SetIcon(m_hIcons+1,2, 1300);
		break;
	case ETAT_DANGER_ROUGE :
		m_TrayIcon.SetIcon(m_hIcons+3,2, 1300);
		break;
	}
	
	// call Papa ...
	CFrameWnd::OnTimer(nIDEvent);
}



void CMainFrame::OnDestroy() 
{
	KillTimer(1);
	CFrameWnd::OnDestroy();
}

void CMainFrame::UpdateDialogQuota()
{
	char pUsedBuf[15], currentDirUseBuf[15], currentVolUseBuf[15],
		 maxDirUseBuf[15], maxVolUseBuf[15], nwquotaparamBuf[30],
		 freeDirBuf[15], freeVolBuf[15];
		 
	CProgressCtrl *progr;
		
	// on met le curseur.
	progr = (CProgressCtrl *) dialQuota->GetDlgItem(IDC_PROGRESS);
	progr->SetRange(1,100);
	progr->SetStep(1);
	progr->SetPos(percentUsed);

	// on affiche les param du progr (scan time, seuils)
	if (seuilsRelatifs) {
		sprintf(nwquotaparamBuf, "%s/%ds/%d%%/%d%%", path_to_check,
				scan_delay, seuil_bas, seuil_haut);
	} else {
			sprintf(nwquotaparamBuf, "%s/%ds/%dMb/%dMb", path_to_check,
				scan_delay, seuil_bas, seuil_haut);
	}
	dialQuota->SetDlgItemText(IDS_NWQUOTAPARAM, nwquotaparamBuf);

	dialQuota->SetDlgItemText(IDS_PATHTOCHECK, path_to_check);

	// on met userName and Co
	dialQuota->SetDlgItemText(IDS_LOGIN_NAME, userName);
	dialQuota->SetDlgItemText(IDS_SERVER_NAME, serverName);
	dialQuota->SetDlgItemText(IDS_NW_PATH, sPath);

	sprintf(pUsedBuf, "%d%%", percentUsed); 

	dialQuota->SetDlgItemText(IDS_PERCENT_QUOTA_USED, pUsedBuf);

	


	switch (resultNWCall) {
	case NWCALLS_FAILED :
	case INPUT_VAR_NULL_ERROR :
		strcpy(currentDirUseBuf, "??");
		strcpy(currentVolUseBuf, "??");
		strcpy(maxDirUseBuf, "??");
		strcpy(maxVolUseBuf, "??");
		strcpy(freeDirBuf, "??");
		strcpy(freeVolBuf, "??");
		strcpy(moFree,"");
		strcpy(moMax,"");
		break;
	case DIR_QUOTA_EXISTS :
		sprintf(currentDirUseBuf, "%.2lf Mb", (float)currentDirUse/256.0);
		sprintf(maxDirUseBuf, "%.2lf Mb", (float)maxDirUse/256.0);
		sprintf(maxVolUseBuf, "");
		sprintf(currentVolUseBuf, "%.2lf Mb", (float)currentVolUse/256.0);
		if (freeDir>=0) sprintf(freeDirBuf, "%.2lf Mb", (float) (freeDir)/256.0);
		  else strcpy(freeDirBuf,"0.00 Mb");
		strcpy(freeVolBuf, "");
		strcpy(moFree,freeDirBuf);
		strcpy(moMax,maxDirUseBuf);
		break;
	case VOL_QUOTA_EXISTS :
		
		sprintf(currentDirUseBuf, "%.2lf Mb", (float)currentDirUse/256.0);
		sprintf(maxDirUseBuf, "");
		sprintf(maxVolUseBuf, "%.2lf Mb", (float)maxVolUse/256.0);
		sprintf(currentVolUseBuf, "%.2lf Mb", (float)currentVolUse/256.0);
		if (currentVolUse<maxVolUse) sprintf(freeVolBuf, "%.2lf Mb", (float) (maxVolUse-currentVolUse)/256.0);
		 else strcpy(freeVolBuf,"0.00 Mb");
		strcpy(freeDirBuf, "");
		strcpy(moFree,freeVolBuf);
		strcpy(moMax,maxVolUseBuf);
		
		break;
	case VOL_AND_DIR_QUOTA_EXISTS :
		sprintf(currentDirUseBuf, "%.2lf Mb", (float)currentDirUse/256.0);
		sprintf(maxDirUseBuf, "%.2lf Mb", (float)maxDirUse/256.0);
		sprintf(maxVolUseBuf, "%.2lf Mb", (float)maxVolUse/256.0);
		sprintf(currentVolUseBuf, "%.2lf Mb", (float)currentVolUse/256.0);
		if (freeDir>=0) sprintf(freeDirBuf, "%.2lf Mb", (float) (freeDir)/256.0);
		  else strcpy(freeDirBuf,"0.00 Mb");
		if (currentVolUse<maxVolUse) sprintf(freeVolBuf, "%.2lf Mb", (float) (maxVolUse-currentVolUse)/256.0);
		 else strcpy(freeVolBuf,"0.00 Mb");	strcpy(moFree,"");
		strcpy(moMax,"");
		break;
	case NO_QUOTA :
		sprintf(currentDirUseBuf, "%.2lf Mb", (float)currentDirUse/256.0);
		sprintf(currentVolUseBuf, "%.2lf Mb", (float)currentVolUse/256.0);
		sprintf(maxVolUseBuf, "");
		sprintf(maxDirUseBuf, "");
		strcpy(freeDirBuf, "");
		strcpy(freeVolBuf, "");
		strcpy(moFree,"");
		strcpy(moMax,"");
	}

	dialQuota->SetDlgItemText(IDS_CURDIRUSE, currentDirUseBuf);
	dialQuota->SetDlgItemText(IDS_CURVOLUSE, currentVolUseBuf);
	dialQuota->SetDlgItemText(IDS_MAXDIRUSE, maxDirUseBuf);
	dialQuota->SetDlgItemText(IDS_MAXVOLUSE, maxVolUseBuf);
	dialQuota->SetDlgItemText(IDS_FREEDIR, freeDirBuf);
	dialQuota->SetDlgItemText(IDS_FREEVOL, freeVolBuf);

	// on met a jour le text de status.
	textStatus.LoadString(IDS_TEXT_STATUS_UNKNOWN);
	if (etatIcone==ETAT_OK_VERT) textStatus.LoadString(IDS_TEXT_STATUS_OK);
	else if (etatIcone==ETAT_ATTENTION_JAUNE) textStatus.LoadString(IDS_TEXT_STATUS_WARN);
	else if (etatIcone==ETAT_DANGER_ROUGE) textStatus.LoadString(IDS_TEXT_STATUS_ALERT);
	dialQuota->SetDlgItemText(IDS_TEXT_STATUS, textStatus);
	
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	// Use the specific class name you established earlier.
	cs.lpszClass = _T(nomFenetre);
	return CFrameWnd::PreCreateWindow(cs);
}


void CMainFrame::FormatResultMo(char *buf, nuint32 nb)
{
	sprintf(buf, "%.2lf Mb",(float)nb / 1024.0);
}


void CMainFrame::showDetailedWindow()
{
	
	dialQuota->ShowWindow(SW_SHOW);
	dialQuota->SetFocus();
}

void CMainFrame::dispatchUdpAlarm()
{
	char sendBuffer[128];
	
	if (reportAlarm) {
	 if ( (!alarmSent) && ((etatIcone==ETAT_ATTENTION_JAUNE) || 
						   (etatIcone==ETAT_DANGER_ROUGE) )
						   ) {
		 alarmSent=TRUE;
		 if (etatIcone==ETAT_ATTENTION_JAUNE) {
			 sprintf(sendBuffer, "Warning,%s,%d%%,%s free,%s max", userName, percentUsed, moFree, moMax);
			reportingSocket->Send(sendBuffer, strlen(sendBuffer),0);
		 } else if (etatIcone==ETAT_DANGER_ROUGE) {
			 sprintf(sendBuffer, "Danger,%s,%d%%,%s free,%s max", userName, percentUsed, moFree, moMax);
			 reportingSocket->Send(sendBuffer, strlen(sendBuffer),0);
		 }
	 }
	}
}



void CMainFrame::CheckNwActBal()
{
	unige_NWGetActBal(&actbal);

}

void CMainFrame::UpdateDialogActBal()
{
	char tmpBuffer1[30],tmpBuffer2[30];
	
	if (actbal.unlimited) {
		// dialQuota->SetDlgItemText(IDS_ACTUNL, "Illimit");
		dialQuota->SetDlgItemText(IDS_ACTUNL, "");
	} else {
//		sprintf(tmpBuffer1,"%d.%.2d Fr", actbal.low_balance / 100, abs(actbal.low_balance % 100));
		sprintf(tmpBuffer1,"%d.%.2d", actbal.low_balance / 100, abs(actbal.low_balance % 100));
		dialQuota->SetDlgItemText(IDS_ACTUNL, tmpBuffer1);
		
		(dialQuota->m_stcPrBal).SetTextColor(dialQuota->cTextOriginal);
		if (actbal.balance-actbal.low_balance<100) (dialQuota->m_stcPrBal).SetTextColor(RGB(255,255,0));
		if (actbal.balance-actbal.low_balance<50) (dialQuota->m_stcPrBal).SetTextColor(RGB(255,0,0));
		
			
	}

	// sprintf(tmpBuffer2, "%d.%.2d Fr", actbal.balance / 100, abs(actbal.balance % 100) );
	sprintf(tmpBuffer2, "%d.%.2d", actbal.balance / 100, abs(actbal.balance % 100) );
	dialQuota->SetDlgItemText(IDS_ACTBAL, tmpBuffer2);

}
