#include "stdafx.h"
#include "app.h"
#include "View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


LRESULT CMouseTracer::WindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam)
{
  //We simply trace the message if it is a mouse message
  if (nMsg >= WM_MOUSEFIRST && nMsg <= WM_MOUSELAST)
    TRACE(_T("Mouse Message;%x, Wparam:%x, lParam;%x\n"), nMsg, wParam, lParam);

  return Default();
}

LRESULT CKeyboardTracer::WindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam)
{
  //We simply trace the message if it is a keyboard message
  if (nMsg >= WM_KEYFIRST && nMsg <= WM_KEYLAST)
    TRACE(_T("Keyboard Message;%x, Wparam:%x, lParam;%x\n"), nMsg, wParam, lParam);

  return Default();
}


LRESULT CDummyHooker::WindowProc(UINT /*nMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/)
{
  //Do nothing
  return Default();
}



IMPLEMENT_DYNCREATE(CHookWndView, CEditView)

BEGIN_MESSAGE_MAP(CHookWndView, CView)
	//{{AFX_MSG_MAP(CHookWndView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_COMMAND(ID_FILE_KEYBOARDHOOK, OnFileKeyboardhook)
	ON_UPDATE_COMMAND_UI(ID_FILE_KEYBOARDHOOK, OnUpdateFileKeyboardhook)
	ON_COMMAND(ID_FILE_MOUSEHOOK, OnFileMousehook)
	ON_UPDATE_COMMAND_UI(ID_FILE_MOUSEHOOK, OnUpdateFileMousehook)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CHookWndView::CHookWndView()
{
}

CHookWndView::~CHookWndView()
{
}

void CHookWndView::OnDraw(CDC* /*pDC*/)
{
  //Do nothing CView handles everything
}

void CHookWndView::OnFileKeyboardhook() 
{
	if (m_KeyboardHook.IsHooked())
    m_KeyboardHook.UnHook();
  else
    m_KeyboardHook.Hook(&m_Edit);
}

void CHookWndView::OnUpdateFileKeyboardhook(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_KeyboardHook.IsHooked());
}

void CHookWndView::OnFileMousehook() 
{
	if (m_MouseHook.IsHooked())
    m_MouseHook.UnHook();
  else
    m_MouseHook.Hook(&m_Edit);
}

void CHookWndView::OnUpdateFileMousehook(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_MouseHook.IsHooked());
}

int CHookWndView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  //Let the parent do its thing
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Create the edit control
  CRect r;
  if (!m_Edit.Create(WS_VISIBLE | WS_CHILD | ES_MULTILINE, r, this, 100))
    return -1;

  //Install the mouse hook
  m_MouseHook.Hook(&m_Edit);

  /* Uncomment the following code to test out the other methods of CHookWnd
  int nSize = m_MouseHook.SizeOfHookChain();
  BOOL bRet = m_MouseHook.FirstInChain();
  bRet      = m_MouseHook.MiddleOfChain();
  bRet      = m_MouseHook.LastInChain();
  */

  //And install the keyboard hook
  m_KeyboardHook.Hook(&m_Edit);

  /* Uncomment the following code to test out the other methods of CHookWnd
  nSize =  m_KeyboardHook.SizeOfHookChain();
  nSize =  m_MouseHook.SizeOfHookChain();
  bRet  = m_KeyboardHook.FirstInChain();
  bRet  = m_MouseHook.FirstInChain();
  bRet  = m_KeyboardHook.MiddleOfChain();
  bRet  = m_MouseHook.MiddleOfChain();
  bRet  = m_KeyboardHook.LastInChain();
  bRet  = m_MouseHook.LastInChain();
  */

  //Install the mouse hook
  m_DummyHook.Hook(&m_Edit);

  /* Uncomment the following code to test out the other methods of CHookWnd
  nSize =  m_KeyboardHook.SizeOfHookChain();
  nSize =  m_MouseHook.SizeOfHookChain();
  nSize =  m_DummyHook.SizeOfHookChain();
  bRet  = m_KeyboardHook.FirstInChain();
  bRet  = m_MouseHook.FirstInChain();
  bRet  = m_DummyHook.FirstInChain();
  bRet  = m_KeyboardHook.MiddleOfChain();
  bRet  = m_MouseHook.MiddleOfChain();
  bRet  = m_DummyHook.MiddleOfChain();
  bRet  = m_KeyboardHook.LastInChain();
  bRet  = m_MouseHook.LastInChain();
  bRet  = m_DummyHook.LastInChain();
  */

  //Add text to the edit control to tell the user 
  //that they should type something into this control
  m_Edit.SetWindowText(_T("Please Type something in here!!\r\nMessages should appear in your Output window\r\n"));
  	
	return 0;
}

void CHookWndView::OnSize(UINT nType, int cx, int cy) 
{
  //Let the parent do its thing
	CView::OnSize(nType, cx, cy);

  //Make the edit control the full size of the client window	
  m_Edit.MoveWindow(0, 0, cx, cy);	
}





