/*
NWQuota 
Rev 1.21
Copyright (C) July 2000 University Of Geneva
Jean-Francois.Burdet@adm.unige.ch
http://www.unige.ch/~burdetj/nwquota.html

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
Or see http://www.gnu.org/copyleft/gpl.html

Abstract :
----------
NwQuota is a small Win32 systray utility (distributed under GPL),
wich provides a simple way to monitor space restrictions on any 
Novell Netware mapped drive. When the network drive steps some 
pre-defined thresholds, the systray icons changes from "OK-Green" 
to "Warning-Yellow", the after passing a second threshold it becomes 
"Danger-Red". It can also display the directory and/or volume 
restrictions on a nice windows using progress bar, wich makes the 
result undertandable by anyone (wich is not the case with ndir /spa ). 

For full documentation see nwquota.html

Thanks and credit to :
- pjn@indigo.ie for its CTrayNotifyIcon v1.4 class. (http://indigo.ie/~pjn/)
- case@dcs.kcl.ac.uk for its CToken class.
- Bert Schinkel for its german translation
*/



#include "stdafx.h"
#include "nwquota.h"
#include "MainFrm.h"
#include "Token.h"
#include <string.h>
#include <stdio.h>


#include "winbase.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//runonce
static BOOL bClassRegistered = FALSE;


BEGIN_MESSAGE_MAP(CTrayApp, CWinApp)
	//{{AFX_MSG_MAP(CTrayApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CTrayApp::CTrayApp()
{
  bDisplayingAboutBox = FALSE;
  showQuotaAndQuit = FALSE;
  showDialOnThreshold = FALSE;
  strcpy(instanceName , "LaSuperAppsDeJF");
}

CTrayApp theApp;



BOOL CTrayApp::InitInstance()
{

	// First, we check that the SystemTray is available
	// This is needed because some users reported that if NwQuota is launched
	// inside a login script, the Explorer.exe (and systray window) may not be
	// available at this moment, but a bit latter.
	// burdetj / 05.juil.2000
	int maxRetries = 6;
	int cptRetries=1;

	// we try for 1mn sleeping once in while
	while ( (FindWindow("Shell_TrayWnd", NULL)==NULL) && (cptRetries<maxRetries)) {
		cptRetries++;
		Sleep(10*1000);
	}

	// if it still fails, we quit..
	if  ( (FindWindow("Shell_TrayWnd", NULL)==NULL) && (cptRetries>=maxRetries)) {
		return FALSE;
	}
	
	// end of SYSTRAY check.

	// command line arg check. If not ok, switching to default.
	if (!CheckCmdLine()) {
		strcpy(localPathToCheck,"H:\\");
		localDelay = DEFAULT_SCAN_DELAY;
		localSeuilBas = DEFAULT_SEUIL_BASE;
		localSeuilHaut = DEFAULT_SEUIL_HAUT;
		showQuotaAndQuit = FALSE;
		showDialOnThreshold = FALSE;
		seuilsRelatifs = TRUE;
		localPortToReport = 0;
		strcpy(localIpToReport,"0");
	}	

    
	// if we run two instance of NwQuota checking the same 
	// path, the 2nd instance will die by itself.

	strcat(instanceName, localPathToCheck);

	if(!FirstInstance()) {
		// NwQuota is already running : we quit, quietly. 
      return FALSE;
	}
	
	    // Register your unique class name that you wish to use
    WNDCLASS wndcls;
    memset(&wndcls, 0, sizeof(WNDCLASS));   // start with NULL
    wndcls.style = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
    wndcls.lpfnWndProc = ::DefWindowProc;
    wndcls.hInstance = AfxGetInstanceHandle();
    wndcls.hIcon = LoadIcon(IDR_HD); // or load a different
    wndcls.hCursor = LoadCursor( IDC_ARROW );
    wndcls.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wndcls.lpszMenuName = NULL;

    wndcls.lpszClassName = _T(instanceName);

    // Register the new class and exit if it fails
    if(!AfxRegisterClass(&wndcls))
      {
        TRACE("Class Registration Failed\n");
        return FALSE;
      }
    bClassRegistered = TRUE;

	// end runonce



	CMainFrame* pMainFrame = new CMainFrame;

	// passing args to the main frame of NwQuota.
	pMainFrame->seuil_bas = localSeuilBas;
	pMainFrame->seuil_haut = localSeuilHaut;
	pMainFrame->scan_delay = localDelay;
	pMainFrame->path_to_check = localPathToCheck;
	pMainFrame->showQuotaAndQuit = showQuotaAndQuit;
	pMainFrame->showFrameOnThreshold = showDialOnThreshold;
	pMainFrame->seuilsRelatifs = seuilsRelatifs;
	pMainFrame->portToReport = localPortToReport;
	pMainFrame->ipToReport = localIpToReport;

	pMainFrame->nomFenetre = instanceName;


	m_pMainWnd = pMainFrame;

    if (!pMainFrame->Create(NULL, _T("NwQuota")))
	  return FALSE;
  
	m_pMainWnd->ShowWindow(SW_HIDE);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}


void CTrayApp::OnAppAbout()
{
  //avoid bringing up two versions of the dialog
  if (bDisplayingAboutBox)
    return;

  bDisplayingAboutBox = TRUE;
  CDialog(IDD_ABOUTBOX).DoModal();
  bDisplayingAboutBox = FALSE;
}


void CTrayApp::OnAppExit() 
{
	
	m_pMainWnd->DestroyWindow();
}

BOOL CTrayApp::CheckCmdLine()
{
	BOOL result= FALSE;
	CString *tokens = new CString[NB_CMD_LINE_ARGS];
	int cptTok = 0;
	// we need to be sure that their is not leading or trailing space
	// in the command line args
	CString *tmpCmdLine = new CString();
	*tmpCmdLine = AfxGetApp()->m_lpCmdLine;
	tmpCmdLine->TrimLeft();tmpCmdLine->TrimRight();
	
	
	// creating tokens
	CToken *tok= new CToken(tmpCmdLine->GetBuffer(256));
	tok->SetToken(" ");
	while((tok->MoreTokens()) && (cptTok<NB_CMD_LINE_ARGS)) {
		tokens[cptTok] = tok->GetNextToken();
		cptTok++;
	}

	
	if ((cptTok!=NB_CMD_LINE_ARGS) || (tok->MoreTokens())) {
		result = FALSE; 
	} else {
		// on copie les params
		strcpy(localPathToCheck, tokens[0].GetBuffer(256));
		tokens[0].ReleaseBuffer();
		// NWCalls needs localPathToCheck to be UPPERCASE
		strupr( localPathToCheck );

		localDelay = atoi(tokens[1].GetBuffer(10));
		tokens[1].ReleaseBuffer();

		localSeuilBas = atoi(tokens[2].GetBuffer(10));
		tokens[2].ReleaseBuffer();

		localSeuilHaut = atoi(tokens[3].GetBuffer(10));
		tokens[3].ReleaseBuffer();

		if (	(strcmp(tokens[4].GetBuffer(10),"A")==0) ||
				(strcmp(tokens[4].GetBuffer(10),"a")==0)
		   ) {
			seuilsRelatifs = FALSE;
		} else if (	(strcmp(tokens[4].GetBuffer(10),"%")==0) ) {
			seuilsRelatifs = true;
		} else { return FALSE; }
		tokens[4].ReleaseBuffer();
	
		showQuotaAndQuit = FALSE;
		if (	(strcmp(tokens[5].GetBuffer(10),"y")==0) ||
				(strcmp(tokens[5].GetBuffer(10),"Y")==0)
		   ) {
			showQuotaAndQuit = TRUE;
		}
		tokens[5].ReleaseBuffer();

		showDialOnThreshold = FALSE;
		if (	(strcmp(tokens[6].GetBuffer(10),"y")==0) ||
				(strcmp(tokens[6].GetBuffer(10),"Y")==0)
		   ) {
			showDialOnThreshold = TRUE;
		}
		tokens[6].ReleaseBuffer();

		
		strcpy(localIpToReport, tokens[7].GetBuffer(50));
		tokens[7].ReleaseBuffer();

		localPortToReport = atoi(tokens[8].GetBuffer(10));
		tokens[8].ReleaseBuffer();
		

		result=TRUE;
	}

	
	
	// cleanup
	delete tok;
	delete []tokens;
	delete tmpCmdLine;
		
	return result;

}


BOOL CTrayApp::FirstInstance()
{
	

        CWnd *pWndPrev, *pWndChild;

        // Determine if another window with your class name exists...
		pWndPrev = CWnd::FindWindow(_T(instanceName),NULL);
        if (pWndPrev)
        {
          // If so, does it have any popups?
          pWndChild = pWndPrev->GetLastActivePopup();

          // If iconic, restore the main window
          if (pWndPrev->IsIconic())
             pWndPrev->ShowWindow(SW_RESTORE);

          // Bring the main window or its popup to
          // the foreground
          pWndChild->SetForegroundWindow();

          // and you are done activating the previous one.
          return FALSE;
        }
        // First instance. Proceed as normal.
        else
          return TRUE;

}

int CTrayApp::ExitInstance() 
{
	if(bClassRegistered)
          ::UnregisterClass(_T(instanceName),AfxGetInstanceHandle());
    
	return CWinApp::ExitInstance();
}


