// pour les precompiled headers
#include "stdafx.h"

#include <nwcalls.h>
#include <nwnet.h>
#include <nwlocale.h> // conv unicode
#include "unige_NWgetAccBalance.h"

#define NUM_OF_ATTRS 3   /* obtain three attributes */

int unige_NWGetActBal(balance_struct * pbalstr) {

	NWDSContextHandle   context;
	char			currentUser[512];
	nint32              lIterationHandle = NO_MORE_ITERATIONS;
    pBuf_T              pInBuf;
	nuint32      luSyntax;
    pBuf_T              pOutBuf;
	nuint32      luAttrCount;
    nuint32      luAttrValCount=1;
	nstr8        strAttrName[MAX_DN_CHARS+1];
	nuint               i;
	NWCCODE         ccode;		
	LCONV           lConvInfo; // pour conv unicode
	pnstr8          strAttrNames[] = {"Account Balance", "Allow Unlimited Credit","Minimum Account Balance"};

	//
	pbalstr->balance=0;
	pbalstr->low_balance=0;
	pbalstr->unlimited=true;
	strcmp(pbalstr->userName,"");
	
	// Initilisation de la librairie
	ccode = NWCallsInit(NULL,NULL);if(ccode) return ccode;
	
	NWLlocaleconv(&lConvInfo);
	ccode = NWInitUnicodeTables(lConvInfo.country_id,
                               lConvInfo.code_page);
    if(ccode) return ccode;

	/* Create an NDS Context */
    ccode = NWDSCreateContextHandle(&context);
	if(ccode) {
       FreeUnicodeTables();
	   return ccode;
    }

	// on verifie que l'utilisateur est authentifi
	// if(!NWIsDSAuthenticated()) return DSERR_CONN_NOT_AUTHENTICATED;

	/* Allocate and initialize input buffer a directory services
      read operation. */
	ccode = NWDSAllocBuf(DEFAULT_MESSAGE_LEN, &pInBuf);
	if(ccode) {
      FreeContext(context);
	  return ccode;
	}

    ccode = NWDSInitBuf(context, DSV_READ, pInBuf);
    if(ccode) {
       FreeInBuf(pInBuf, context);
	   return ccode;
    }

    /* Allocate the output buffer to hold returned values */
    ccode = NWDSAllocBuf(DEFAULT_MESSAGE_LEN, &pOutBuf);
    if(ccode){
        FreeInBuf(pInBuf, context);
		return ccode;
    }

   /* To prepare for the read, place the names of the attributes
      into the input buffer */
   for(i = 0; i < NUM_OF_ATTRS; i++)
   {
      ccode = NWDSPutAttrName(context, pInBuf, strAttrNames[i]);
      if(ccode) {
         NWDSFreeBuf(pOutBuf);
         FreeInBuf(pInBuf, context);
		 return ccode;
      }
   }

   // on obtient le nom du user en cours.
   ccode = NWDSWhoAmI(context, currentUser); 
   if (ccode) {
	   NWDSFreeBuf(pOutBuf);
       FreeInBuf(pInBuf, context);
	   return ccode;
   }

   // on copie dans le param de retour, on enlve les 3 char du debut ("cn=")
   strcpy(pbalstr->userName, (const char *)_mbsninc((const unsigned char *)currentUser,3));

 
   /* Perform the read.  The second arg to NWDSRead specifies that
      attribute values are to be returned. The third attribute, FALSE,
      indicates that only attribute information is desired. */
   ccode = NWDSRead(context, currentUser, DS_ATTRIBUTE_VALUES, FALSE,
                    pInBuf, &lIterationHandle, pOutBuf);
   if(ccode) {
      NWDSFreeBuf(pOutBuf);NWDSFreeBuf(pInBuf);NWDSFreeContext(context);NWFreeUnicodeTables();
	  return ccode;
   }
   
   // Now the pOutBuf is full, let's read it.

   // first we check how many attributes were returned
    ccode = NWDSGetAttrCount(context, pOutBuf, &luAttrCount);
   if(ccode) {
      NWDSFreeBuf(pOutBuf);NWDSFreeBuf(pInBuf);NWDSFreeContext(context);NWFreeUnicodeTables();
      return ccode;
   }

   // we iterate through the attributes
   for(i = 0; i < luAttrCount; i++) {
      ccode = NWDSGetAttrName(context, pOutBuf, strAttrName, &luAttrValCount, &luSyntax);
      if(ccode) {    
		  NWDSFreeBuf(pOutBuf);NWDSFreeBuf(pInBuf);NWDSFreeContext(context);NWFreeUnicodeTables();
		  return ccode; 
	  }
	
	  if (strcmp(strAttrName,"Account Balance")==0) 
		  ccode = NWDSGetAttrVal(context, pOutBuf, luSyntax, (void *)&(pbalstr->balance));
	  if (strcmp(strAttrName,"Minimum Account Balance")==0) 
		  ccode = NWDSGetAttrVal(context, pOutBuf, luSyntax, (void *)&(pbalstr->low_balance));
	  if (strcmp(strAttrName,"Allow Unlimited Credit")==0) 
		  ccode = NWDSGetAttrVal(context, pOutBuf, luSyntax, (void *)&(pbalstr->unlimited));
      if(ccode) {    
		  NWDSFreeBuf(pOutBuf);NWDSFreeBuf(pInBuf);NWDSFreeContext(context);NWFreeUnicodeTables();
		  return ccode; 
	  }


   } //for



   // Now freeing ressources
   NWDSFreeBuf(pOutBuf);
   NWDSFreeBuf(pInBuf);
   NWDSFreeContext(context);
   NWFreeUnicodeTables();

   return 1;
	
}

/* Clean up Functions, called on error condition only */
void FreeInBuf(pBuf_T pBuf, NWDSContextHandle context)
{
   NWDSFreeBuf(pBuf);
   FreeContext(context);
}

void FreeContext(NWDSContextHandle context)
{
   NWDSFreeContext(context);
   FreeUnicodeTables();
}

void FreeUnicodeTables()
{
   NWFreeUnicodeTables();
   exit(1);
}


