/*
NWQuota 
Rev 1.21
Copyright (C) July 2000 University Of Geneva
Jean-Francois.Burdet@adm.unige.ch
http://www.unige.ch/~burdetj/nwquota.html

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
Or see http://www.gnu.org/copyleft/gpl.html

Abstract :
----------
NwQuota is a small Win32 systray utility (distributed under GPL),
wich provides a simple way to monitor space restrictions on any 
Novell Netware mapped drive. When the network drive steps some 
pre-defined thresholds, the systray icons changes from "OK-Green" 
to "Warning-Yellow", the after passing a second threshold it becomes 
"Danger-Red". It can also display the directory and/or volume 
restrictions on a nice windows using progress bar, wich makes the 
result undertandable by anyone (wich is not the case with ndir /spa ). 

For full documentation see nwquota.html

Thanks and credit to :
- pjn@indigo.ie for its CTrayNotifyIcon v1.4 class. (http://indigo.ie/~pjn/)
- case@dcs.kcl.ac.uk for its CToken class.
- Bert Schinkel for its german translation
*/


/*
J.-F. Burdet 22.02.2000
Cette fonction permet de lire le quota de disque affect  un lecteur
o chemin rseau pass en entre.
Elle retourne en sortie le nom du user, le chemin, le serveur associ 
a ce chemin.

La valeur de retour indique : (cf .h file)
*/

// pour les precompiled headers
#include "stdafx.h"

#include <nwclxcon.h>

// Les deux lignes suivante pour NWGetDirSpaceLimitList
#define N_PACK_1
#include <nwdirect.h>
#include <nwcalls.h>
#include "unige_NWGetDriveSpaceRestriction.h"


// Since a user reports some buggy display with very big quotas, now dirUse results
// are returned in unit of 4Kb blocks.

int unige_NWGetDriveRestriction(char * drvPath, char * serverName, char * userName, 
								char * serverPath,	
								nuint32 *currentDirUse, nuint32 *maxDirUse, nuint32 *dirFree,
								nuint32 *currentVolUse, nuint32 *maxVolUse) {

	NWCONN_HANDLE	connHandle;					
	NWDIR_HANDLE	dirHandle, newDirHandle;	
	NWCCODE         ccode;		
	NW_LIMIT_LIST	limitList;
	bool			dir_quota_exists = false, vol_quota_exists = false;

	nstr8			volumeName[48];
	nuint16			volNumber;
	nuint32			userId, volBlockMax = 0, volBlockInUse= 0;
	nuint			cNumber;

	nstr8			tmpNWNSpaceSrc[256], tmpNWNSpaceDst[256];
	NW_NS_PATH		tmpNWNSpace = { tmpNWNSpaceSrc, tmpNWNSpaceDst, 256};
	
	
	
	//
	// prepa de l'enviro NW
	//
	if ((serverName==NULL) || (serverPath == NULL) || (currentDirUse==NULL) ||
		(maxDirUse==NULL) || (maxVolUse==NULL) || (currentVolUse==NULL) )
		return INPUT_VAR_NULL_ERROR;

	// Initilisation de la librairie
	ccode = NWCallsInit(NULL,NULL);
	if(ccode)   {
		return NWCALLS_FAILED;
	}

	// on obtient le le connHandle du chemin ainsi que le chemin
	// netware correspondant
	ccode = NWParseNetWarePath (drvPath, &connHandle, &dirHandle,serverPath);
	if(ccode)   {
			return NWCALLS_FAILED;
	}


	// The preceding NWParseNetwarePath, can return a 8.3 name on some
	// platforms (Win9x) ... so we need to call NWGetNSPath twice :
	// - 1st time, we try DOS NAME SPACE
	// - 2nd time we try LONG NAME Space
	// .... Thanks Dmitry !
	strcpy(tmpNWNSpace.srcPath, serverPath);
	ccode = NWGetNSPath(connHandle, 0, 0, NW_NS_DOS, NW_NS_LONG,  &tmpNWNSpace);
	// failed ? let's try again
	if (ccode) ccode = NWGetNSPath(connHandle, 0, 0, NW_NS_LONG, NW_NS_LONG,  &tmpNWNSpace);
	if(ccode)   {
			return NWCALLS_FAILED;
	}
	strcpy(serverPath,tmpNWNSpace.dstPath);
		

	// Getting volume name
	ccode = NWParsePath(drvPath,NULL,NULL,volumeName, NULL);
	if(ccode)   {
			return NWCALLS_FAILED;
	}

	
	// getting volume number
	ccode = NWGetVolumeNumber(connHandle, volumeName, &volNumber);
	if(ccode)   {
			return NWCALLS_FAILED;
	}

	// on obtient le numero de connexion pour avoir le user name
	ccode = NWCCGetConnInfo(connHandle,NWCC_INFO_CONN_NUMBER,sizeof(cNumber),&cNumber);
	if(ccode)   {
			return NWCALLS_FAILED;
	}

	// Obtention du userName
	ccode = NWGetConnectionInformation(connHandle, 
										(nuint16)cNumber, 
										userName, 
										NULL, NULL, NULL);
	if(ccode)   {
			return NWCALLS_FAILED;
	}

	// il faut obtenir l'obj ID de l'objet ayant le connHandle
	ccode = NWCCGetConnInfo(connHandle,NWCC_INFO_USER_ID,
							sizeof(userId),&userId);

	if(ccode)   {
			return NWCALLS_FAILED;
	}

	
	// Lecture restriction volume
	ccode = NWGetObjDiskRestrictions(connHandle,(nuint8)volNumber,userId,
										&volBlockMax,&volBlockInUse);

	// Reading serverName
	ccode = NWGetFileServerInformation(connHandle, serverName, 
											0,0,0,0,0,0,0,0,0);
	if(ccode)   {
		return NWCALLS_FAILED;
	}

	// Lecture restriction sur le rpertoire
	ccode = NWAllocTemporaryDirectoryHandle(connHandle,0,serverPath,&newDirHandle,0);
	if(ccode)   {
		return NWCALLS_FAILED;
	}

	// on obtient maintenant les restrictions sur le repertoire.
	// je n'utilise pas la version GetDirSpace...2 pour avoir une meilleure
	// compatibilite avec les vieux clients
	// ccode = NWGetDirSpaceLimitList(connHandle, newDirHandle, (pnuint8) &limitList);
	ccode = NWGetDirSpaceLimitList(connHandle, newDirHandle, (pnuint8) &limitList);
	// cleanup
	NWDeallocateDirectoryHandle(connHandle, newDirHandle);

	if(ccode)   {
		return NWCALLS_FAILED;
	}

	

	
    /* 

	The we try getting restrictions. If there is restrictions on directory upper
	than the one scanned, they will appear in the list. We must choose the restrictions
	leaving the less space to the user :

	To find the actual amount of space available to a directory, scan all of the current
	fields and use the smallest one. You must omit values of 0x7FFFFFFF and convert 
	values that are larger than 0x7FFFFFFF to zero. If no entries are returned, no space
	restrictions exist for the specified directory.
	*/

	int cptList;
	nuint32 smallestCur;
	nuint32 curTmp;
	

	*currentDirUse=0;*maxDirUse=0;*dirFree=0;
	if (limitList.numEntries>0) {
		/* 1st we get directory usage */
		*currentDirUse=(limitList.list[0].max-limitList.list[0].current);

		/* 2nd, we find restriction */
		smallestCur = limitList.list[0].current;
		
		
		if (smallestCur> 0x7FFFFFFF ) smallestCur = 0;
		if (smallestCur<0) smallestCur = 0;
		*dirFree=smallestCur;
		for (cptList=0;cptList<limitList.numEntries;cptList++) {
			curTmp = limitList.list[cptList].current;
			if (curTmp == 0x7FFFFFFF ) continue;
			if (curTmp > 0x7FFFFFFF ) curTmp = 0;

			if (curTmp<=smallestCur) {
				if (limitList.list[cptList].max<0x7FFFFFFF) { // il y a une limite
					dir_quota_exists=true;
					*maxDirUse=limitList.list[cptList].max;
					*dirFree=curTmp;
				} else { // no limit ou limit = 0
					if (limitList.list[cptList].max!=0x7FFFFFFF) 
						dir_quota_exists=true; // cas de la restriction totale : limit = 0
						*maxDirUse=0;
						*dirFree=0;
				}
				smallestCur = curTmp;
			} 
		}

		  
		

	}

	// on fait les restrictions de volumes
	*maxVolUse=0; *currentVolUse=0;
	if (volBlockMax!= 0x40000000) { // si il y restrictions
		vol_quota_exists = true;
		*maxVolUse = volBlockMax  ;
		*currentVolUse = volBlockInUse;
	} else { // pas de restriction
		*maxVolUse = 0;
		*currentVolUse = volBlockInUse;
	}

	// on dtermine la valeur a retourner.
	if ((vol_quota_exists) && (dir_quota_exists)) return VOL_AND_DIR_QUOTA_EXISTS;
	 else if (vol_quota_exists) return VOL_QUOTA_EXISTS;
	 else if (dir_quota_exists) return DIR_QUOTA_EXISTS;
	 else return NO_QUOTA;

}

