/*
NWQuota 
Rev 1.21
Copyright (C) July 2000 University Of Geneva
Jean-Francois.Burdet@adm.unige.ch
http://www.unige.ch/~burdetj/nwquota.html

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
Or see http://www.gnu.org/copyleft/gpl.html

Abstract :
----------
NwQuota is a small Win32 systray utility (distributed under GPL),
wich provides a simple way to monitor space restrictions on any 
Novell Netware mapped drive. When the network drive steps some 
pre-defined thresholds, the systray icons changes from "OK-Green" 
to "Warning-Yellow", the after passing a second threshold it becomes 
"Danger-Red". It can also display the directory and/or volume 
restrictions on a nice windows using progress bar, wich makes the 
result undertandable by anyone (wich is not the case with ndir /spa ). 

For full documentation see nwquota.html

Thanks and credit to :
- pjn@indigo.ie for its CTrayNotifyIcon v1.4 class. (http://indigo.ie/~pjn/)
- case@dcs.kcl.ac.uk for its CToken class.
- Bert Schinkel for its german translation
*/


/*
J.-F. Burdet 22.02.2000
Cette fonction permet de lire le quota de disque affect  un lecteur
o chemin rseau pass en entre.
Elle retourne en sortie le nom du user, le chemin, le serveur associ 
a ce chemin.

Valeur de retour : cf plus bas
*/

int unige_NWGetDriveRestriction(char * drvPath, char * serverName, char * userName, 
								char * serverPath,	
								nuint32 *currentDirUse, nuint32 *dirRestriction, nuint32 *dirFree,
								nuint32 *currentVolUse, nuint32 *maxVolUse);



// Valeurs de retour

// Un appel a une procedure Novell a chou : cela signifie sans doute que :
// - l'utilisateur n'est pas loggu
// - le drvPath ne pointe pas sur un chemin rseau
// - le drvPath ne pointe pas sur un chemin Novell
// - ...
#define NWCALLS_FAILED 1

// Un quota de rpertoire  t trouv : 
// - currentDirUse, maxDirUse et currentVolUse ont des valeur pertinantes
#define DIR_QUOTA_EXISTS 2

// Un quota de volume  t trouv : 
// - currentVolUse, maxVolUse et currentDirUse ont des valeur pertinantes
#define VOL_QUOTA_EXISTS 3

// Un quota de volume et un quota de rpertoire ont t trouvs : 
// - currentVolUse, maxVolUse,currentDirUse et maxDirUse ont des valeur pertinantes
#define VOL_AND_DIR_QUOTA_EXISTS 4

// Aucun quota n'a t trouv.
// - currentVolUse et currentDirUse ont des valeurs pertinantes.
#define NO_QUOTA 5

// Un des buffers pour valeurs de sorties (p.ex serverName, userName) est NULL
#define INPUT_VAR_NULL_ERROR 6

