unit aspi;


interface

type SenseType = Array [1..14] of byte;

Procedure ASPIInit;
Procedure SCSIStartStop(adapter, target_id, lun, start, eject :byte );

(**********************************************************************)


implementation

uses dos,crt;

var  ASPICall : record
                 case integer of
                  1: ( LoWord,Hiword: word);
                  2: (Dword        : Longint);
                end;
      F :       file;

type Srbio = Record
                cmd       : byte;
                status    : byte;
                adapter   : byte;
                flags     : byte;
                dummy1    : LongInt;
                target_id : byte;
                lun       : byte;
                alloc_len : LongInt;
                sense_len : byte;
                buf_off   : Word;
                buf_seg   : Word;
                Link_off  : Word;
                Link_seg  : Word;
                cdb_len   : byte;
                adapter_status : byte;
                target_status  : byte;
                post_off  : Word;
                post_seg  : Word;
                workspace : array [1..34] of byte;

                subcmd    : byte;
                sublun    : byte;
                dummy2    : byte;
                dummy3    : byte;
                starteject : byte;
                controll  : byte;
                sense     : sensetype;
             End;

var srb : Srbio;
    Err : byte;



Function ASPIreq:byte;
label weiter;
var i: byte;
var srbofs : word;
    srbseg : word;
begin

   srbofs := ofs(srb);
   srbseg := seg(srb);
   (* aspiCall( @srb ); *)
   srb.status := 0;
(*   writeln('Calling ASPI');*)
   asm
      mov  ax,srbseg
      push ax
      mov  ax,srbofs
      push ax
      call ASPICALL.DWORD
   end;
   for i:=1 to 20 do
                    begin
                      if srb.status <> 0 then goto weiter;
                    end;
weiter:
   if srb.status = 1 then ASPIreq := 0
                     else ASPIreq := 1;
end (* ASPIreq *) ;


Procedure SCSIStartStop(adapter, target_id, lun, start, eject :byte );

var i: byte;

begin
   Fillchar(srb,sizeof(srb),0);
   srb.cmd := 2;
   srb.adapter := 0;
   srb.target_id := target_id;
   srb.lun       := lun;
   srb.sense_len := 14;
   srb.cdb_len   := 6;
   srb.subcmd    := $1b;
   srb.sublun    := lun shl 5;
   srb.starteject := start + (eject shl 1);

   srb.status    := 0;
   srb.adapter   := 0;
   srb.flags     := 0;
   srb.alloc_len := 0;
   srb.buf_off   := 0;
   srb.buf_seg   := 0;
   srb.Link_off  := 0;
   srb.Link_seg  := 0;
   srb.adapter_status    := 0;
   srb.target_status     := 0;
   srb.post_off  := 0;
   srb.post_seg  := 0;
   srb.controll  := 0;

   Err := aspireq;

(*
   if Err = 1 then begin
                        for i:= 1 to 14 do Mysense[i] := srb.sense[i];
                   end;
*)
end (* SCSIStartStop *);


Procedure ASPIInit;

var
Regs : Registers;

begin

    Assign(F,'SCSIMGR$');

    {$I-}
    Reset(F);
    {$I+}

    If IOResult <>0 then
                        begin
                          Writeln('Error opening ASPI Manager');
                          halt(1);
                        end;

(*
 * This is an ioctl(READ) to the "SCSIMGR$".
 * It returns the entrypoint of the aspi-module (far pointer)
 * in the 4 bytes, pointed to by the dx register.
 *)
  with FileRec(F) Do  (* fuer Handle *)
  begin
   regs.ax := $4402;
   regs.cx := 4;
   regs.dx := Ofs(ASPICall);
   regs.ds := Seg(ASPICall);
   regs.bx := handle;
   MsDos(regs);
  end;
  close(f);

  (* Host Adapter Inquiry *)
  srb.cmd := 0 ;
  srb.adapter := 0 ; (* Adapter 0 *)

  Err := aspireq;

  if Err <> 0 then halt(1);

  writeln(' Found ', Mem[seg(srb):ofs(srb)+8] ,' adapters');

end (* AspiInit *);


begin  (* Init Aspi *)
end.
