              JUMPS
              .MODEL TPASCAL

INCLUDE       INTMAC.INC

              .DATA

EXTRN         IntProg    : FAR
EXTRN         Aktivate   : FAR
EXTRN         InAktivate : FAR
EXTRN         TimerProc  : FAR
EXTRN         DosFreiProc: FAR

EXTRN         SaveInt00  : DWord
EXTRN         SaveInt1b  : DWord
EXTRN         SaveInt3f  : DWord
EXTRN         PrefixSeg  : WORD
EXTRN         OvrHeapSize: WORD

EXTRN         InDosByte  : Byte
EXTRN         DiskBios   : Byte
EXTRN         VidBios    : Byte
EXTRN         MakeInt    : Byte
EXTRN         InUse      : Byte

              .CODE
              ASSUME CS:CODE, DS:NOTHING, ES:NOTHING, SS:NOTHING


OrgSS         DW ?
OrgSP         DW ?
OrgDS         DW ?

OldSS         DW ?
OldSP         DW ?
AXSave        DW ?

TurboSS       DW ?
TurboSP       DW ?

UrInt         DD ?

UrInt10       DD ?
UrInt9        DD ?
UrInt8        DD ?
UrInt28       DD ?

NowInt10      DD ?
NowInt9       DD ?
NowInt8       DD ?

Request       DB ?
Aktiv         DB ?
IntAktiv      DB ?
Protokoll     DB ?
InDisk        DB ?
InVideo       DB ?
InDosBytePtr  DD ?
MakeIntCS     DB ?
RetCS         DW ?
RetIP         DW ?
RetFlags      DW ?

; ====================================================================
; = Hier steht der Int                                               =
; ====================================================================

Inthandler      proc Far                        ; Achtung bei Modell Tpascal
intRoutine:                                     ; leitet tasm jedes proc
                                                ; mit MOV bp,sp PUSH bp ein!
                pushf
                cmp     Protokoll,01h
                jne     RetIntMain

                cmp     IntAktiv,01h          ; Wenn Turbo Aktiv dann
                je      RetIntMain              ; nicht Nochmal in turbo

                jmp     DoIntMain

RetIntMain:     popf
                jmp     Urint

DoIntMain:      MOV     IntAktiv,1

                sti                              ; Int's erlauben

                push    bp
                Mov     bp,sp
                push    ds
                push    es
                push    ax
                push    bx

                mov     AX,seg data             ; Turbo DatenSeg laden
                Mov     DS,AX
                assume  ds:data

                Mov     AX,[bp+4]
                Mov     RetIP,AX
                Mov     AX,[bp+6]
                Mov     RetCS,AX
                Mov     AX,[bp+8]
                Mov     RetFlags,AX

                mov     al,InDisk               ; Speichere Werte nach TurboDS
                mov     DiskBios,al
                mov     al,InVideo
                mov     VidBios,al
                les     bx,IndosByteptr
                mov     al,es:[bx]
                mov     InDosByte,Al

                pop     bx
                pop     ax
                pop     es
                pop     ds
                pop     bp

                StoreOldStack
                GetTurboStack

                Push    RetFlags
                Push    RetCS
                Push    RetIP

                PUSHF                            ; INTPROC IST ALS INTERUPT DECLARIERT
                call    IntProg                  ; Turbo Int starten

                Pop     RetIP
                Pop     RetCS
                Pop     RetFlags

                GetOldStack

                push    bp
                Mov     bp,sp
                push    ds
                PUSH    AX
                mov     AX,seg data             ; Turbo DatenSeg laden
                Mov     DS,AX
                assume  ds:data

                Mov     AX,RetIP                ; Lege RetFlags auf PRG-Stack
                Mov     [bp+4],AX
                Mov     AX,RetCS
                Mov     [bp+6],AX
                Mov     AX,RetFlags
                Mov     [bp+8],AX

                mov     al,makeint
                mov     makeintCS,al
                POP     AX
                pop     ds
                pop     bp
                assume  ds:nothing

                cli

                MOV     IntAktiv,0             ; Ab jetzt wieder Ins Pascal

                cmp     MakeintCS,01h          ; Soll der alte Int noch
                                                 ; ausgefhrt werden
                je      DoInt                  ; oder Soll einfach
                                                 ; mit Iret zum Caller
                                                 ; zurck gegangen werden?
                popf
                iret

DoInt:          popf
                sti                              ; Interupts erlauben
                jmp  UrInt                       ; Ur Interrupt aufrufen

; ====================================================================
; = Dos Frei IRQ 28h                                                 =
; = Prft den Request                                                =
; ====================================================================

DosFrei:        cli                             ; Ints verbieten
                cmp Aktiv,01h
                je  ReturnDosFrei

DoTimer:        Mov Aktiv,01h
                sti                             ; Ints erlauben


                cmp     request,0
                je      EndDosFrei


                call    DoCheckAkt

EndDosFrei:
                cmp     IntAktiv,0
                jne     NoDosFrei

                call    PascalDosFrei


NoDosFrei:      Mov     Aktiv,0
ReturnDosFrei:  jmp     urint28


; ====================================================================
; = Timer Tick 08                                                    =
; = Prft den Request     und ruft Turbo auf sofern Dos Inaktiv ist  =
; ====================================================================

UserTimer:      pushf
                call    UrInt8
                cli                             ; Ints verbieten
                cmp     Aktiv,01h
                je      ReturnTimer

                Mov     Aktiv,01h

                push    bx
                push    ax
                push    es
                cmp     request,0
                je      Endtimer

                les     BX,InDosBytePtr
                Mov     AL,ES:[BX]
                or      AL,AL
                jne     Endtimer

                call    DoCheckAkt


EndTimer:       cli                             ; Ints verbieten
                cmp     IntAktiv,0
                jne     NoTimer
                call    PascalTimer
NoTimer:        pop     es
                pop     ax
                pop     bx
                mov     Aktiv,0
                sti                             ; Ints erlauben
ReturnTimer:    iret

; ====================================================================
; = UnterProgramm das berprft ob video und Platte frei sind        =
; = und falls das zutrift das program aktiviert                      =
; ====================================================================
DoCheckAkt      proc    near

                StoreRegs
                cli                              ;Ints verbieten
                Mov     AL,InVideo
                or      AL,InDisk
                jne     ReturnAkt

                StoreOldStack                     ; Alte Segmente merken
                GetTurboStack                     ; TurboSegmente einstellen

                GetTurboDS                        ; Hole Turbo DSeg

                Mov     IntAktiv,1              ;  jetzt braucht man
                                                  ;  kein Protokoll
                Mov     InDosByte,0               ; Dos ist jetz frei
                Mov     DiskBios ,0               ; Dos ist jetz frei
                Mov     VidBios  ,0               ; Dos ist jetz frei
                sti                               ; Int's erlauben

                cmp     Request,01h               ; ist Proc1 gemeint ?
                jne     Proc2                     ; Nein dann Proc2
                call    Aktivate                  ; Call Turbo Aktivate
                jmp     BackFromAKT               ; Alles wiederherstellen

Proc2:          cmp     Request,02h               ; ist Proc2 gemeint ?
                jne     BackFromAkt
                call    InAktivate                ; Call Turbo InAktivate

BackFromAKT:    cli                               ; Int's verbieten
                Mov     IntAktiv,0
                mov     request,0

                mov     al,InUse
                mov     Protokoll,al

                GetOldStack                       ; Alte Segmente herstellen

ReturnAkt:      ReStoreRegs                       ; Register zurckholen

                ret

DoCheckAkt      endp

; ====================================================================
; ====================================================================
PascalTimer     proc    near

                cli                               ; Int's verbieten
                StoreRegs
                StoreOldStack                     ; Alte Segmente merken
                GetTurboStack                     ; TurboSegmente einstellen

                GetTurboDS                        ; Hole Turbo DSeg

                Mov     IntAktiv,1              ;  jetzt braucht man
                                                  ;  kein Protokoll
                push    ds
                push    es
                push    ax
                push    bx

                mov     AX,seg data             ; Turbo DatenSeg laden
                Mov     DS,AX
                assume  ds:data
                mov     al,InDisk
                mov     DiskBios,al
                mov     al,InVideo
                mov     VidBios,al
                les     bx,IndosByteptr
                mov     al,es:[bx]
                mov     InDosByte,Al

                pop     bx
                pop     ax
                pop     es
                pop     ds
                sti                               ; Int's erlauben

                call    TimerProc                 ; Call Turbo Aktivate

                cli                               ; Int's verbieten
                Mov     IntAktiv,0

                mov     al,InUse
                mov     Protokoll,al

                GetOldStack                       ; Alte Segmente herstellen

                ReStoreRegs                       ; Register zurckholen

                sti

                ret

PascalTimer     endp

; ====================================================================
; ====================================================================
PascalDosFrei   proc    near

                cli                               ; Int's verbieten
                StoreRegs
                StoreOldStack                     ; Alte Segmente merken
                GetTurboStack                     ; TurboSegmente einstellen

                GetTurboDS                        ; Hole Turbo DSeg

                Mov     IntAktiv,1              ;  jetzt braucht man
                                                  ;  kein Protokoll
                push    ds
                push    es
                push    ax
                push    bx

                mov     AX,seg data             ; Turbo DatenSeg laden
                Mov     DS,AX
                assume  ds:data
                mov     al,InDisk
                mov     DiskBios,al
                mov     al,InVideo
                mov     VidBios,al
                mov     InDosByte,0             ; DosFrei !!!

                pop     bx
                pop     ax
                pop     es
                pop     ds
                sti                               ; Int's erlauben

                call    DosFreiProc               ; Call Turbo Aktivate

                cli                               ; Int's verbieten
                Mov     IntAktiv,0

                mov     al,InUse
                mov     Protokoll,al

                GetOldStack                       ; Alte Segmente herstellen

                ReStoreRegs                       ; Register zurckholen

                sti

                ret

PascalDosFrei   endp

; ====================================================================
; = Int 9 Routine                                                    =
; = Schreibt den SchiftStatus nach jedemTastendruck in Var           =
; ====================================================================

KeyInt9:        pushf                            ; wegen Call und Int
                call UrInt9                   ; Original Int 9 aufrufen
                push ES
                push AX
                mov AX,00h
                mov ES,AX
                mov AL,byte ptr ES:[0417h]       ;

                and AL,14d                       ; Crtl Alt Left  Shift
                cmp AL,14d                       ;

                jne weiter

                mov request,1
weiter:
                mov AL,byte ptr ES:[0417h]       ;
                and AL,13d                       ; Crtl Alt Right  Shift
                cmp AL,13d
                jne ende1
                mov request,2

ende1:          pop AX
                pop ES
                Iret

; ====================================================================
; = Video Int 10 wird nur zur Kontrolle verbogen                     =
; ====================================================================

VideoInt10:
                cli                               ; Int's verbieten
                mov InVideo,01h
                pushf
                call UrInt10
                mov InVideo,00h
                sti                               ; Int's erlauben
                retf 02h

IntHandler    endp

; ====================================================================
; = Initialisiert alle Parameter                                     =
; ====================================================================

              ASSUME DS:Data
Install       PROC FAR   IntToUse : Word , PtrToProc : dword
              PUBLIC Install
                mov AXSave,AX
                mov AX,SS
                mov TurboSS,AX
                mov AX,SP
                mov TurboSP,AX
                mov AX,AXSave

                mov Request    ,0
                mov Aktiv      ,0
                mov IntAktiv   ,0
                mov Protokoll  ,0
                mov InDisk     ,0
                mov InVideo    ,0

                mov ah,34h                       ; Funktion 34
                int 21h                          ; Get Adrresse vom

                mov word ptr IndosBytePtr,bx              ; InDosbyte
                mov word ptr indosBytePtr+2,es

                
                GetInt   IntToUse,UrInt          ;
                SetIntTo IntToUse,IntRoutine     ;

                GetInt   28h,UrInt28             ;
                SetIntTo 28h,DosFrei             ;

                GetInt   08h,UrInt8              ;
                SetIntTo 08h,UserTimer           ;

                GetInt   09h,UrInt9              ;
                SetIntTo 09h,KeyInt9             ;

                GetInt   10h,UrInt10             ;
                SetIntTo 10h,VideoInt10          ;


                SetInt   00h,SaveInt00
                SetInt   1bh,SaveInt1b
                SetInt   3fh,SaveInt3f

                ret

                Mov     Ax,[PrefixSeg]             ;Berechne Lnge Des PRG's
                Mov     es,ax
                Mov     DX,ES:[OvrHeapSize]
                sub     DX,AX


                Mov     AX,3100h                ; Terminate and Stay resident
                int     21h

Install       ENDP
CODE          ENDS
              END

