               .MODEL  TPASCAL
               .CODE

;******************************************************************************
;* Variablen die von diesem Modul benutzt werden                              *
;******************************************************************************
                Turbo_DS   dw (?)
                Turbo_ES   dw (?)
                Turbo_AX   dw (?)
                ScreenSeg  dw (?)

;******************************************************************************
;* Speichert die Turbo Werte                                                  *
;******************************************************************************
SaveAll         PROC FAR
                  MOV CS:Turbo_AX,AX
                  MOV AX,DS
                  MOV CS:Turbo_DS,AX
                  MOV AX,ES
                  MOV CS:Turbo_ES,AX
                  MOV AX,CS:Turbo_AX
                  RET
SaveAll         ENDP

;******************************************************************************
;* Speichert die Turbo Werte                                                  *
;******************************************************************************
RestAll         PROC FAR
                  MOV CS:Turbo_AX,AX
                  MOV AX,CS:Turbo_DS
                  MOV DS,AX
                  MOV AX,CS:Turbo_ES
                  MOV ES,AX
                  MOV AX,CS:Turbo_AX
                  RET
RestAll         ENDP

;******************************************************************************
;* Macros                                                                     *
;******************************************************************************
CalcOffs        MACRO Spalte,Zeile,Adresse
                  MOV AX,Zeile                    ; Zeile in AX
                  DEC AX                          ; wegen 1..80
                  MOV BX,0A0h                     ; 160 Char's / Zeile
                  MUL BX                          ; AX := AX * 160
                  MOV BX,AX                       ; in BX zwischenspeichern
                  MOV AX,Spalte                   ; erste Spalte
                  DEC AX                          ; - 1
                  MOV CX,02h                      ; Wert 2
                  MUL CX                          ; wegen Attr
                  ADD AX,BX                       ; BX addieren
                  MOV Adresse,AX                  ; Rckgabe in AX
                ENDM

CalcDiff        MACRO Wert1,Wert2,Differenz
                  MOV AX,Wert1
                  MOV BX,Wert2
                  SUB AX,BX
                  INC AX
                  MOV Differenz,AX
                ENDM

;******************************************************************************
;* Initialisiert die Window Toolbox                                           *
;******************************************************************************
WindowToolInit  PROC FAR ScrSeg:word
                  PUBLIC WindowToolInit
                  CALL SaveAll                    ; Turbo Werte sichern
                  MOV AX,ScrSeg
                  MOV ScreenSeg,AX
                  CALL RestAll                    ; Turbo Werte herstellen
                  RET                             ; Rckkehr
WindowToolInit  ENDP

;******************************************************************************
;* Speichert eine Region auf dem Bildschirm                                   *
;******************************************************************************
StoreRegion     PROC FAR X1:WORD, Y1:WORD, X2:WORD, Y2:WORD, MemPtr:DWORD
                  PUBLIC StoreRegion
                  CALL SaveAll                    ; Turbo Werte sichern

                  MOV AX,Y1                       ; Links oben
                  DEC AX                          ; wegen 1..80
                  MOV BX,0A0h                     ; 160 Char's / Zeile
                  MUL BX                          ; AX := AX * 160
                  MOV BX,AX                       ; in BX zwischenspeichern
                  MOV AX,X1                       ; erste Spalte
                  DEC AX
                  MOV CX,02h
                  MUL CX                          ; wegen Attr
                  ADD AX,BX                       ; BX addieren
                  MOV SI,AX                       ; Screen Start Ofs

                  LES DI,MemPtr                   ; Window Ptr holen

                  MOV AX,ScreenSeg                ; Segmet des
                  MOV DS,AX                       ; Bildschirmspeichers

                  MOV AX,Y2                       ; Differenz der beiden
                  SUB AX,Y1                       ; Y Koordinaten ergibt
                  MOV BX,AX                       ; Zeilenzahl
                  INC BX

                  MOV AX,X2                       ; Differenz der beiden
                  SUB AX,X1                       ; X Koordinaten ergibt
                  MOV DX,AX                       ; Spalten
                  INC DX

                  MOV CX,BX                       ; Zeilenzahl
StoreAll:         PUSH SI                         ; wegen inc merken
                  PUSH CX                         ; Ausenschleife
                  MOV CX,DX                       ; Spaltenzahl
                  CLD                             ; Aufwrtszhlen
StoreLine:        MOVSW
                  LOOP StoreLine
                  POP CX                          ; Ausenschleife
                  POP SI                          ; SI wieder holen
                  ADD SI,0A0h                     ; nchste Zeile
                  LOOP StoreAll

                  CALL RestAll                    ; Turbo Werte herstellen
                  RET                             ; Rckkehr
StoreRegion     ENDP


;******************************************************************************
;* Speichert eine Region auf dem Bildschirm zurck                            *
;******************************************************************************
RestoreRegion   PROC FAR X1:WORD, Y1:WORD, X2:WORD, Y2:WORD, MemPtr:DWORD
                  PUBLIC RestoreRegion
                  CALL SaveAll                    ; Turbo Werte sichern

                  MOV AX,Y1                       ; Links oben
                  DEC AX                          ; wegen 1..80
                  MOV BX,0A0h                     ; 160 Char's / Zeile
                  MUL BX                          ; AX := AX * 160
                  MOV BX,AX                       ; in BX zwischenspeichern
                  MOV AX,X1                       ; erste Spalte
                  DEC AX
                  MOV CX,02h
                  MUL CX                          ; wegen Attr
                  ADD AX,BX                       ; BX addieren
                  MOV DI,AX                       ; Screen Start Ofs

                  LDS SI,MemPtr                   ; Memory Ptr holen

                  MOV AX,ScreenSeg                ; Segmet des
                  MOV ES,AX                       ; Bildschirmspeichers

                  MOV AX,Y2                       ; Differenz der beiden
                  SUB AX,Y1                       ; Y Koordinaten ergibt
                  MOV BX,AX                       ; Zeilenzahl
                  INC BX

                  MOV AX,X2                       ; Differenz der beiden
                  SUB AX,X1                       ; X Koordinaten ergibt
                  MOV DX,AX                       ; Spalten
                  INC DX

                  MOV CX,BX                       ; Zeilenzahl
RStoreAll:        PUSH DI                         ; wegen inc merken
                  PUSH CX                         ; Ausenschleife
                  MOV CX,DX                       ; Spaltenzahl
                  CLD                             ; Aufwrtszhlen
RStoreLine:       MOVSW
                  LOOP RStoreLine
                  POP CX                          ; Ausenschleife
                  POP DI                          ; SI wieder holen
                  ADD DI,0A0h                     ; nchste Zeile
                  LOOP RStoreAll

                  CALL RestAll                    ; Turbo Werte herstellen
                  RET                             ; Rckkehr
RestoreRegion   ENDP

;******************************************************************************
;* Lscht eine BildschirmRegion wahlweise kann auch Farbe benutzt werden      *
;******************************************************************************
ClearRegion     PROC FAR X1:WORD, Y1:WORD, X2:WORD, Y2:WORD, Color:BYTE
                  PUBLIC ClearRegion
                  CALL SaveAll                    ; Turbo Werte sichern

                  MOV AX,Y1                       ; Links oben
                  DEC AX                          ; wegen 1..80
                  MOV BX,0A0h                     ; 160 Char's / Zeile
                  MUL BX                          ; AX := AX * 160
                  MOV BX,AX                       ; in BX zwischenspeichern
                  MOV AX,X1                       ; erste Spalte
                  DEC AX
                  MOV CX,02h
                  MUL CX                          ; wegen Attr
                  ADD AX,BX                       ; BX addieren
                  MOV DI,AX                       ; Screen Start Ofs

                  MOV AX,ScreenSeg                ; Segmet des
                  MOV ES,AX                       ; Bildschirmspeichers

                  MOV AX,Y2                       ; Differenz der beiden
                  SUB AX,Y1                       ; Y Koordinaten ergibt
                  MOV BX,AX                       ; Zeilenzahl
                  INC BX

                  MOV AX,X2                       ; Differenz der beiden
                  SUB AX,X1                       ; X Koordinaten ergibt
                  MOV DX,AX                       ; Spalten
                  INC DX

                  MOV CX,BX                       ; Zeilenzahl
                  MOV AH,Color
                  MOV AL,' '

ClearAll:         PUSH DI                         ; wegen inc merken
                  PUSH CX                         ; Ausenschleife
                  MOV CX,DX                       ; Spaltenzahl
                  CLD                             ; Aufwrtszhlen
ClearLine:        MOV ES:[DI],AX
                  INC DI
                  INC DI
                  LOOP ClearLine
                  POP CX                          ; Ausenschleife
                  POP DI                          ; SI wieder holen
                  ADD DI,0A0h                     ; nchste Zeile
                  LOOP ClearAll

                  CALL RestAll                    ; Turbo Werte herstellen
                  RET                             ; Rckkehr
ClearRegion     ENDP

;******************************************************************************
;* Zeichnet eine Box auf den Bildschirm                                       *
;******************************************************************************
DrawFrame       PROC FAR  X1:WORD, Y1:WORD ,X2:WORD ,Y2:WORD, lo:BYTE, ro:BYTE, lu:BYTE, ru:BYTE, wo:BYTE, wu:BYTE, sl:BYTE, sr:BYTE, Col:BYTE
                  PUBLIC DrawFrame
                  CALL SaveAll                    ; Turbo Werte sichern
                  CalcOffs X1,Y1,SI               ; Offset links oben
                  CalcOffs X1,Y2,DI               ; Offset links unten
                  CalcDiff X2,X1,CX               ; Anzahl der Spalten

                  MOV AX,ScreenSeg                ; Segmet des
                  MOV ES,AX                       ; Bildschirmspeichers

                  MOV  AL,lo
                  MOV  AH,Col
                  MOV  BL,lu
                  MOV  BH,Col
                  MOV  ES:[SI],AX
                  MOV  ES:[DI],BX
                  ADD  SI,02h
                  ADD  DI,02h

                  SUB CX,02h
                  CMP  CX,00h
                  JZ NoWaag

                  MOV  AL,wo
                  MOV  AH,Col
                  MOV  BL,wu
                  MOV  BH,Col

WaagFrame:        MOV  ES:[SI],AX
                  MOV  ES:[DI],BX
                  ADD SI,02h
                  ADD DI,02h
                  LOOP WaagFrame

NoWaag:           MOV  AL,ro                      ; Ecke rechts oben
                  MOV  AH,Col                     ;
                  MOV  BL,ru                      ;       und
                  MOV  BH,Col                     ;
                  MOV  ES:[SI],AX                 ;
                  MOV  ES:[DI],BX                 ; Ecke rechts unten

                  CalcOffs X1,Y1,SI               ; Offset links oben
                  CalcOffs X2,Y1,DI               ; Offset rechts oben
                  CalcDiff Y2,Y1,CX               ; Anzahl der Spalten
                  ADD SI,0A0h
                  ADD DI,0A0h                     ; nchste Zeile
                  SUB CX,02h                      ; bis zur vorletzten

                  CMP CX,00h
                  JZ  FrameExit
                  MOV  AL,sl                      ; linke
                  MOV  AH,Col                     ; und
                  MOV  BL,sr                      ; Rechte
                  MOV  BH,Col                     ;     .
SenkFrame:        MOV  ES:[SI],AX                 ;     .
                  MOV  ES:[DI],BX                 ;     .
                  ADD SI,0A0h                     ;     .
                  ADD DI,0A0h                     ;     .
                  LOOP SenkFrame                  ; Seitenlinie
FrameExit:

                  CALL RestAll                    ; Turbo Werte herstellen
                  RET                             ; Rckkehr
DrawFrame       ENDP

;******************************************************************************
;* Lscht das Attribut einer Region auf Schwarz
;******************************************************************************
ClearAttr       PROC FAR X1:WORD, Y1:WORD, X2:WORD, Y2:WORD, Color:BYTE
                  PUBLIC ClearAttr
                  CALL SaveAll                    ; Turbo Werte sichern

                  MOV AX,Y1                       ; Links oben
                  DEC AX                          ; wegen 1..80
                  MOV BX,0A0h                     ; 160 Char's / Zeile
                  MUL BX                          ; AX := AX * 160
                  MOV BX,AX                       ; in BX zwischenspeichern
                  MOV AX,X1                       ; erste Spalte
                  DEC AX
                  MOV CX,02h
                  MUL CX                          ; wegen Attr
                  ADD AX,BX                       ; BX addieren
                  MOV DI,AX                       ; Screen Start Ofs

                  MOV AX,ScreenSeg                ; Segmet des
                  MOV ES,AX                       ; Bildschirmspeichers

                  MOV AX,Y2                       ; Differenz der beiden
                  SUB AX,Y1                       ; Y Koordinaten ergibt
                  MOV BX,AX                       ; Zeilenzahl
                  INC BX

                  MOV AX,X2                       ; Differenz der beiden
                  SUB AX,X1                       ; X Koordinaten ergibt
                  MOV DX,AX                       ; Spalten
                  INC DX

                  MOV CX,BX                       ; Zeilenzahl

AttrClearAll:     PUSH DI                         ; wegen inc merken
                  PUSH CX                         ; Ausenschleife
                  MOV CX,DX                       ; Spaltenzahl
                  CLD                             ; Aufwrtszhlen

AttrClearLine:    MOV AX,ES:[DI]
                  MOV BH,Color
                  AND AH,00001111b
                  AND BH,11110000b
                  OR  AH,BH
                  MOV ES:[DI],AX
                  INC DI
                  INC DI
                  LOOP AttrClearLine
                  POP CX                          ; Ausenschleife
                  POP DI                          ; SI wieder holen
                  ADD DI,0A0h                     ; nchste Zeile
                  LOOP AttrClearAll

                  CALL RestAll                    ; Turbo Werte herstellen
                  RET                             ; Rckkehr
ClearAttr       ENDP

SetAttr         PROC FAR X1:WORD, Y1:WORD, X2:WORD, Y2:WORD, Color:BYTE
                  PUBLIC SetAttr
                  CALL SaveAll                    ; Turbo Werte sichern

                  MOV AX,Y1                       ; Links oben
                  DEC AX                          ; wegen 1..80
                  MOV BX,0A0h                     ; 160 Char's / Zeile
                  MUL BX                          ; AX := AX * 160
                  MOV BX,AX                       ; in BX zwischenspeichern
                  MOV AX,X1                       ; erste Spalte
                  DEC AX
                  MOV CX,02h
                  MUL CX                          ; wegen Attr
                  ADD AX,BX                       ; BX addieren
                  MOV DI,AX                       ; Screen Start Ofs

                  MOV AX,ScreenSeg                ; Segmet des
                  MOV ES,AX                       ; Bildschirmspeichers

                  MOV AX,Y2                       ; Differenz der beiden
                  SUB AX,Y1                       ; Y Koordinaten ergibt
                  MOV BX,AX                       ; Zeilenzahl
                  INC BX

                  MOV AX,X2                       ; Differenz der beiden
                  SUB AX,X1                       ; X Koordinaten ergibt
                  MOV DX,AX                       ; Spalten
                  INC DX

                  MOV CX,BX                       ; Zeilenzahl

AttrSetAll:     PUSH DI                         ; wegen inc merken
                  PUSH CX                         ; Ausenschleife
                  MOV CX,DX                       ; Spaltenzahl
                  CLD                             ; Aufwrtszhlen

AttrSetLine:    MOV AX,ES:[DI]
                  MOV BH,Color
                  ;AND AH,00001111b
                  ;AND BH,11110000b
                  ;OR  AH,BH
                  mov  ah,bh
                  MOV ES:[DI],AX
                  INC DI
                  INC DI
                  LOOP AttrSetLine
                  POP CX                          ; Ausenschleife
                  POP DI                          ; SI wieder holen
                  ADD DI,0A0h                     ; nchste Zeile
                  LOOP AttrSetAll

                  CALL RestAll                    ; Turbo Werte herstellen
                  RET                             ; Rckkehr
SetAttr       ENDP



CODE            ENDS
		END

