{$A+,B-,D+,E+,F-,I+,L+,N+,O-,R+,S+,V+}
unit ScrHndl;

{******************************************************************************}
{* Globale proceduren                                                         *}
{******************************************************************************}

interface
uses crt,dos;

const Double       =1;
      Single       =2;
      DoubleSingle =3;
      SingleDouble =4;
      Gray50       =5;
      Gray25       =6;
      Gray75       =7;
      Special      =8;
      NoBorder     =9;
      remove       = true;

      Maxlines     = 50;

type Zeile      = string [80];
     ScreenType = Array [1..Maxlines,1..80] of Word;
     ScreenPtr  = ^ScreenType;

  procedure RestoreCursorPos;
   {************************************************************************}
   {* Stellt die gemerkte Cursorposition wieder her                        *}
   {************************************************************************}

  procedure StoreCursorPos;
   {************************************************************************}
   {* Speichert die momentane Cursorposition                               *}
   {************************************************************************}

  procedure GetVideoMode     (var Mode,Colums,Page:byte);
   {************************************************************************}
   {* Ermittelt parameter der Video Karte                                  *}
   {************************************************************************}


  function  PageNr           : byte;
   {************************************************************************}
   {* Ermittelt die Aktuelle Video Seite                                   *}
   {************************************************************************}

  function  VideoMode        : byte;
    {***********************************************************************}
    {* ermittelt der gesetzten Video Mode                                  *}
    {***********************************************************************}

  procedure SetVideoMode     ( mode:byte);
   {************************************************************************}
   {* Ermittelt parameter der Video Karte                                  *}
   {************************************************************************}

  function  CheckXY          (X,Y:byte) : boolean;
  function  CheckPlace       (X,Y,Len   : byte) : boolean;
    {************************************************************************}
    {*         Suche nach freien Platz                                      *}
    {************************************************************************}

  function  GetLine          (LNr  : byte) : Zeile;
    {************************************************************************}
    {*           Lese Ganze Zeile von Bildscirm                             *}
    {************************************************************************}

  procedure Cursor           (Art  : boolean);
   {************************************************************************}
   {* Schaltet Cursor an oder aus                                          *}
   {************************************************************************}

  function  ReadXY           (X,Y  : byte)    : char;
   {************************************************************************}
   {*        Lese CH at x,y                                                 }
   {************************************************************************}

  procedure DrawBox          (X1,Y1,X2,Y2:word; Art,Col  :byte);
    {************************************************************************}
    {*    Zeichnet eine Box  Art bestimmnt die LinienArt, Col die Farbe     *}
    {************************************************************************}

  procedure MakeWindow       (X1,Y1,X2,Y2:word; Col,Frame:byte);
    {************************************************************************}
    {*     Macht Ein Window mit Box                                         *}
    {************************************************************************}
  procedure ShadowWindow     (X1,Y1,X2,Y2:word; Col,Frame:byte);
    {************************************************************************}
    {*         Geniert ein Window mir Schatten                              *}
    {************************************************************************}

  procedure MarginWindow     (X1,Y1,X2,Y2:word; Col,Frame:byte);
    {************************************************************************}
    {*    Zeichnet Ein Window fr z.B. das BigMenu                          *}
    {************************************************************************}

  function  Menu             (X,Y:word; Col:byte; S:string):byte;
    {************************************************************************}
    {*      Zeichnet ein PopUpMenu                                          *}
    {************************************************************************}

  function  BigMenu          (remove:boolean;Col:byte;PreSet:Byte;
                              MenuTitel,S,C:string):byte;
    {************************************************************************}
    {*    Zeichnet ein Menu mit MarginWindow                                *}
    {************************************************************************}
  function  LineMenu         (Line:word; Col:byte; S:string):byte;
    {************************************************************************}
    {*      Zeichent ein Menu (in einer Zeile)                              *}
    {************************************************************************}

  procedure RemoveLastWindow;
    {************************************************************************}
    {*          Lscht das letze Window                                     *}
    {************************************************************************}

  procedure PushScreen;

  procedure PopScreen;

{******************************************************************************}
{*                                                                            *}
{* Art bzw. Frame bestimmt die Linien Art:                                    *}
{*   1 = Double Lines              ,  2 = Single Line ,                       *}
{*   3 = horiz Double/vert Single  ,  4 = vert Double/horiz Single            *}
{*                                                                            *}
{*   5 = Gray 50% , 6 = Gray 25%  ,  7 = Gray 75%                             *}
{*                                                                            *}
{*   8 = Horiz Double/vert Half Block                                         *}
{*                                                                            *}
{*   9 = Space (no Border)                                                    *}
{*                                                                            *}
{*                                                                            *}
{*   Die Windows knnen einander berlappen                                   *}
{*                                                                            *}
{*   Der Menpunkte im String von Menus werden Durch \ begrenzt               *}
{*                                                                            *}
{*       z.B: Menu(10,10,4,'Menupunkt1\Menupunkt2\Ende\');                    *}
{*                                                                            *}
{******************************************************************************}

{******************************************************************************}
{* Implementationsteil                                                        *}
{******************************************************************************}

implementation

type
      Stack_Ptr        =^Stack_Rec;
      Stack_Rec        =record
                            Memory :ScreenPtr;
                            Before :Pointer;
                        end;

      PtrTabType       = record
                           X1  : byte;
                           Y1  : byte;
                           X2  : byte;
                           Y2  : byte;
                           Ptr : pointer;
                         end;
      ColorStyleType   = array [1..8,1..5] of byte;
      MenuItemStr      = string [60];
      MenuType         = array [1..20] of MenuItemStr;
      FirstChType      = array [1..20] of byte;

const MaxAnzPages = 20;
      Border      = 1;
      Page        = 2;
      Text        = 3;
      HText       = 4;
      Bar         = 5;
      ColorStyle : ColorStyleType = (($0F,$07,$07,$0F,$1F),
                                     ($1E,$13,$1F,$1D,$6F),
                                     ($2E,$23,$2F,$2E,$5F),
                                     ($3F,$33,$3F,$3E,$0F),
                                     ($4E,$43,$4F,$4E,$3F),
                                     ($5E,$53,$5F,$5E,$2F),
                                     ($6E,$63,$6F,$6E,$1F),
                                     ($7E,$73,$7F,$7E,$0F));
var   Stack :Stack_Ptr;
      DisplayPtr : ScreenPtr;

      OldPosX,OldPosY : byte;
      PtrTab          : array [1..MaxAnzPages]      of PtrTabType;
      WindowDeep      : byte;
      ScreenBase      : Word;

{******************************************************************************}
{* Proceduren in Assembler geschrieben Scrhndl.ASM bzw OBJ                    *}
{******************************************************************************}

{$F+}
{$L SCRHNDL.OBJ}
  procedure WindowToolInit  (ScrSeg:word);                      external;
    {*******************************************************************}
    {* Procedure die am Anfang aufgerufewn wird                        *}
    {*******************************************************************}

  procedure StoreRegion     (X1,Y1,X2,Y2:word; MemPtr:pointer); external;
    {*******************************************************************}
    {* Speichert eine Region vom Bildschirm nach MemPtr                *}
    {*******************************************************************}

  procedure RestoreRegion   (X1,Y1,X2,Y2:word; MemPtr:pointer); external;
    {*******************************************************************}
    {* Speichert eine Region zurck                                    *}
    {*******************************************************************}

  procedure ClearRegion     (X1,Y1,X2,Y2:word; Color:byte);     external;
    {*******************************************************************}
    {* Speichert eine Region zurck                                    *}
    {*******************************************************************}

  procedure ClearAttr       (X1,Y1,X2,Y2:word; Color:byte);     external;
    {*******************************************************************}
    {* Setzt die Hintergrundfarbe der Region                           *}
    {*******************************************************************}

  procedure SetAttr       (X1,Y1,X2,Y2:word; Color:byte);     external;
    {*******************************************************************}
    {* Setzt die Farbe der Region                                      *}
    {*******************************************************************}


  procedure DrawFrame       (X1,Y1,X2,Y2:word; lo,ro,lu,ru,wo,wu,sl,sr:char; Col:byte); external;
    {*******************************************************************}
    {* Zeichnet eine Box auf dem Bildschirm                            *}
    {*******************************************************************}

 {$F-}


{******************************************************************************}
{* Schaltet den Cursor an oder aus ber den Int 10h                           *}
{******************************************************************************}

procedure Cursor(Art  : boolean);
var Reg : Registers;
begin
  Reg.AH := $01;
  if not  Art then begin Reg.CH := 11;  Reg.CL := 12; end
  else Reg.CH := 6; Reg.CL := 7;
  Intr ($10,Reg);
end;


{******************************************************************************}
{* Ermittelt parameter der Video Karte                                        *}
{******************************************************************************}

procedure GetVideoMode     (var Mode,Colums,Page:byte);
var Reg : Registers;
begin
  Reg.AX := $0F00;
  Intr ($10,Reg);
  Mode   := Reg.AL;
  Colums := Reg.BL;
  Page   := Reg.BH;
end;

procedure SetVideoMode  ( mode:byte);
var Reg : Registers;
begin
  Reg.AH := $00;
  Reg.AL := Mode;
  Intr ($10,Reg);
end;

{******************************************************************************}
{* Ermittelt die Aktuelle Video Seite                                         *}
{******************************************************************************}

function PageNr:byte;
var PN,MD,CL : byte;
begin
  GetVideoMode (MD,CL,PN);
  PageNr := PN;
end;

{******************************************************************************}
{* ermittelt der gesetzten Video Mode                                         *}
{******************************************************************************}

function VideoMode:byte;
var PN,MD,CL : byte;
begin
  GetVideoMode (MD,CL,PN);
  VideoMode := MD;
end;

{******************************************************************************}
{* Speichert die momentane Cursorposition                                     *}
{******************************************************************************}

procedure StoreCursorPos;
var Reg : Registers;
begin
  Reg.AX := $0300;
  Reg.BH := PageNr;
  Intr($10,Reg);
  OldPosX:=Reg.DL;
  OldPosY:=Reg.DH;
end;

{******************************************************************************}
{* Stellt die gemerkte Cursorposition wieder her                              *}
{******************************************************************************}

procedure RestoreCursorPos;
var Reg : Registers;
begin
  Reg.AX := $0200;
  Reg.BH := PageNr;
  Reg.DL:=OldPosX;
  Reg.DH:=OldPosY;
  Intr($10,Reg);
end;

{******************************************************************************}
{*                      ????????????????????                                  *}
{******************************************************************************}

function  CheckXY(X,Y:byte) : boolean;
var Reg : Registers;
begin
  Reg.AX := $0200;       (* Set Cursor Pos to x,y *)
  Reg.BH := PageNr;
  Reg.DH := x;
  Reg.DL := y;
  Intr ($10,Reg);
  Reg.AX := $0800;       (* Read Ch At Cursor *)
  Reg.BH := PageNr;
  Intr ($10,Reg);
  if (Reg.AH <>   0) and
     (Reg.AH <>  32) and
     (Reg.AH <> 255) then CheckXY := false
  else CheckXY := true;
end;

{******************************************************************************}
{*               Suche nach freien Platz                                      *}
{******************************************************************************}

function  CheckPlace       (X,Y,Len   : byte) : boolean;
var I : integer;
begin
  Cursor (false);
  I := 0;
  while (I<=Len) and CheckXY (X+I,Y) do inc (I);
  CheckPlace := (I=Len);
end;

{******************************************************************************}
{*        Lese CH at x,y                                                      *}
{******************************************************************************}

function  ReadXY(X,Y  : byte)    : char;
var Reg : Registers;
begin
  Reg.AX := $0200;
  Reg.BH := PageNr;
  Reg.DH := Y;
  Reg.DL := X;
  Intr ($10,Reg);
  Reg.AX := $0800;
  Reg.BH := PageNr;
  Intr ($10,Reg);
  ReadXY := char (Reg.AL);
end;

{******************************************************************************}
{*           Lese Ganze Zeile von Bildscirm                                   *}
{******************************************************************************}

function GetLine(LNr  : byte) : Zeile;
var S : Zeile;
    I : integer;
begin
  S := '';
  StoreCursorPos;
  for I := 0 to 79 do S := concat (S,ReadXY(I,LNr));
  GetLine := S;
  RestoreCursorPos;
end;

{******************************************************************************}
{*       Abfrage ob x und y gltig sind                                       *}
{******************************************************************************}

function ValidXY (X1,Y1,X2,Y2:word):boolean;
begin
  If (X1<X2) and (Y1<Y2) then ValidXY := true
  else ValidXY := false;
end;

procedure KeyCheckTo (var C:char; var Akt:byte);
var
  Ch : char;
begin
  Ch := readkey;
  if Ch = #00 then begin
    Ch := readkey;
    C  := #00;
    Akt := ord (ch);
  end
  else begin
    C   := Ch;
    Akt := 0;
  end;
end;

function ZentLine (S:string; SL:byte):string;
const
  LeerStr = '                                          ';
var
  D,R : byte;
begin
  if length (S) >= SL then ZentLine := S
  else begin
    D := (SL-length(S)) div 2;
    R := SL - length(S) - D;
    ZentLine := concat ( copy(LeerStr,1,D),S,copy(LeerStr,1,R));
  end;
end;

procedure GetDrawChar (Art:byte; var lo,ro,lu,ru,wo,wu,sl,sr : char);
begin
  case Art of
     Double : begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
     Single : begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
DoubleSingle: begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
SingleDouble: begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
      Gray50: begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
      Gray25: begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
      Gray75: begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
     Special: begin lo:=(''); ro:=(''); lu:=(''); ru:=(''); sl:=(''); wo:=(''); sr:=(''); wu:=(''); end;
    NoBorder: begin lo:=(' '); ro:=(' '); lu:=(' '); ru:=(' '); sl:=(' '); wo:=(' '); sr:=(' '); wu:=(' '); end;
  end;
end;

procedure StretchWindow (X1,Y1,X2,Y2:word; Art,Col:byte);
var
  I,XMitte,YMitte         : byte;
  lo,ro,lu,ru,wo,wu,sl,sr : char;
  XDiff,YDiff             : word;
  Breite,Hoehe            : word;

begin
  if not ValidXY (X1,Y1,X2,Y2) then exit;
  Breite    := (X2-X1);  Hoehe := (Y2-Y1);
  XMitte    := Breite div 2 + X1;
  YMitte    := Hoehe  div 2 + Y1;
  GetDrawChar (2,lo,ro,lu,ru,wo,wu,sl,sr);
  for I := 6 downto 2 do begin;
    if keypressed then exit;
    YDiff := Hoehe div (I); XDiff := Breite div (I);
    if (YDiff>0) and (XDiff>0) then begin
      ClearRegion (XMitte-XDiff,YMitte-YDiff,XMitte+XDiff,YMitte+YDiff,Col);
      DrawFrame   (XMitte-XDiff,YMitte-YDiff,XMitte+XDiff,YMitte+YDiff,lo,ro,lu,ru,wo,wu,sl,sr,Col);
      delay (20);
    end;
  end;
end;

{******************************************************************************}
{*    Zeichnet eine Box  Art bestimmnt die LinienArt, Col die Farbe           *}
{******************************************************************************}

procedure DrawBox(X1,Y1,X2,Y2:word; Art,Col  :byte);
var
  I                       : byte;
  lo,ro,lu,ru,wo,wu,sl,sr : char;
begin
  if not ValidXY (X1,Y1,X2,Y2) then exit;
  GetDrawChar (Art,lo,ro,lu,ru,wo,wu,sl,sr);
  DrawFrame (X1,Y1,X2,Y2,lo,ro,lu,ru,wo,wu,sl,sr,Col);
end;


function WindowSize (X1,Y1,X2,Y2:word):word;
var Size : word;
begin
  Size := (Y2-Y1+1) * (X2-X1+1);
  Size := Size * 2;
  WindowSize := Size;
end;

{******************************************************************************}
{*     Macht Ein Window mit Box                                               *}
{******************************************************************************}

procedure MakeWindow(X1,Y1,X2,Y2:word; Col,Frame:byte);
var MemPtr : pointer;
begin
  if not ValidXY (X1,Y1,X2,Y2) then exit;
  Cursor (false);
  inc (WindowDeep);
  GetMem (MemPtr,WindowSize (X1,Y1,X2,Y2));
  PtrTab [WindowDeep].X1 := X1;
  PtrTab [WindowDeep].Y1 := Y1;
  PtrTab [WindowDeep].X2 := X2;
  PtrTab [WindowDeep].Y2 := Y2;
  PtrTab [WindowDeep].Ptr := MemPtr;
  StoreRegion   (X1  ,Y1  ,X2,Y2,MemPtr);
  ClearRegion (X1,Y1,X2,Y2,ColorStyle [Col,Page]);
  DrawBox (X1,Y1,X2,Y2,Frame,ColorStyle [Col,Border]);
  TextAttr := ColorStyle [Col,Text];
  Window (X1+1,Y1+1,X2-1,Y2-1);
  Cursor(true);
end;

{******************************************************************************}
{*         Geniert ein Window mir Schatten                                    *}
{******************************************************************************}

procedure ShadowWindow(X1,Y1,X2,Y2:word; Col,Frame:byte);
var MemPtr : pointer;
begin
  if not ValidXY (X1,Y1,X2,Y2) then exit;
  Cursor (false);
  inc (WindowDeep);
  GetMem (MemPtr,WindowSize (X1,Y1,X2+2,Y2+1));
  PtrTab [WindowDeep].X1 := X1;
  PtrTab [WindowDeep].Y1 := Y1;
  PtrTab [WindowDeep].X2 := X2+2;
  PtrTab [WindowDeep].Y2 := Y2+1;
  PtrTab [WindowDeep].Ptr := MemPtr;
  StoreRegion   (X1  ,Y1  ,X2+2,Y2+1,MemPtr);
  StretchWindow (X1  ,Y1  ,X2  ,Y2  ,Frame,ColorStyle [Col,Border]);
  ClearAttr     (X2  ,Y1+1,X2+2,Y2+1,$0);
  ClearAttr     (X1+2,Y2+1,X2  ,Y2+1,$0);
  ClearRegion (X1,Y1,X2,Y2,ColorStyle [Col,Page]);
  DrawBox (X1,Y1,X2,Y2,Frame,ColorStyle [Col,Border]);
  TextAttr := ColorStyle [Col,Text];
  Window (X1+1,Y1+1,X2-1,Y2-1);
  Cursor(true);
end;

{******************************************************************************}
{*    Zeichnet Ein Window fr z.B. das BigMenu                                *}
{******************************************************************************}

procedure MarginWindow(X1,Y1,X2,Y2:word; Col,Frame:byte);
var MemPtr : pointer;
begin
  if not ValidXY (X1,Y1,X2,Y2) then exit;
  Cursor (false);
  inc (WindowDeep);
  GetMem (MemPtr,WindowSize (X1,Y1,X2+2,Y2+1));
  PtrTab [WindowDeep].X1 := X1;
  PtrTab [WindowDeep].Y1 := Y1;
  PtrTab [WindowDeep].X2 := X2+2;
  PtrTab [WindowDeep].Y2 := Y2+1;
  PtrTab [WindowDeep].Ptr := MemPtr;
  StoreRegion   (X1  ,Y1  ,X2+2,Y2+1,MemPtr);
  StretchWindow (X1+2,Y1+1,X2-2,Y2-1,Frame,ColorStyle [Col,Border]);
  ClearAttr     (X2  ,Y1+1,X2+2,Y2+1,$0);
  ClearAttr     (X1+2,Y2+1,X2  ,Y2+1,$0);
  ClearRegion   (X1,Y1,X2,Y2,ColorStyle [Col,Page]);
  DrawBox       (X1+2,Y1+1,X2-2,Y1+3,Frame,ColorStyle [Col,Border]);
  DrawBox       (X1+2,Y2-3,X2-2,Y2-1,Frame,ColorStyle [Col,Border]);
  TextAttr := ColorStyle [Col,Text];
  Window        (X1+3,Y1+2,X2-3,Y2-2);
  Cursor(true);
end;

{******************************************************************************}
{*          Lscht das letze Window                                           *}
{******************************************************************************}

procedure RemoveLastWindow;
var X1,Y1,X2,Y2:word;
    MemPtr : pointer;
begin
  if WindowDeep > 0 then begin
    X1 := PtrTab [WindowDeep].X1;
    Y1 := PtrTab [WindowDeep].Y1;
    X2 := PtrTab [WindowDeep].X2;
    Y2 := PtrTab [WindowDeep].Y2;
    if not ValidXY (X1,Y1,X2,Y2) then exit;
    MemPtr := PtrTab [WindowDeep].Ptr;
    RestoreRegion (X1,Y1,X2,Y2,MemPtr);
    FreeMem (PtrTab [WindowDeep].Ptr,WindowSize (X1,Y1,X2,Y2));
    dec(WindowDeep);
    window (1,1,80,25);
  end;
end;

{******************************************************************************}
{*           Konvertiert den MenuStr zu einem Array                           *}
{******************************************************************************}

procedure MenuStrToArray (    MenuStr   : string;
                          var MenuArray : MenuType;
                          var Anz       : byte;
                          var Wide      : byte);
var I,P : integer;
begin
  I := 1;
  repeat
    P := pos ('\',MenuStr);
    if P <> 0 then begin
      MenuArray [I] := copy (MenuStr,1,pred(P));
      if Length (MenuArray [I]) > Wide then Wide := pred (length (MenuArray [I]));
      delete (MenuStr,1,P);
      inc (I);
    end;
  until P = 0;
  Anz := pred (I);
end;

procedure ZentArray  (var MenuArray : MenuType; Anz,Wide:byte);
var I,P : integer;
begin
  for I := 1 to Anz do begin
    MenuArray [I] := ZentLine (MenuArray [I],Wide+1);
  end;
end;

{******************************************************************************}
{*   Suche unabhngige Anfachsbuchstaben                                      *}
{******************************************************************************}

procedure GetFirstChar (var MenuArray  : MenuType;
                        var FCharArray : FirstChType;
                            Anz        : byte;
                        var Wide       : byte);
var P,I : byte;
begin
  for I := 1 to Anz do begin
    P := pos ('[',MenuArray [I]);
    if P <> 0 then begin
      if length (MenuArray [I]) = Wide then dec (Wide);
      delete (MenuArray [I],P,1);
      FCharArray [I] := pred (P);
    end
    else FCharArray [I] := 0;
  end;
end;

{******************************************************************************}
{*      Zeichnet ein PopUpMenu                                                *}
{******************************************************************************}

function  Menu(X,Y:word; Col:byte; S:string):byte;
var
  Item                : MenuType;
  Anz,L,P,I,X_Dim,Akt : byte;
  Ch,Ch2              : char;
  FirstChar           : FirstChType;

begin
  X_Dim := 0;
  MenuStrToArray (S,Item,Anz,X_Dim);
  GetFirstChar   (Item,FirstChar,Anz,X_Dim);
  ShadowWindow (X,Y,X+X_Dim+4,Y+Anz+1,Col,Double);
  Cursor (false);

  TextAttr := ColorStyle [Col,Text];

  for I := 1 to Anz do begin
    gotoxy (2,I);
    write  (Item [I]);
    gotoxy (2+FirstChar [I],I);
    TextAttr := ColorStyle [Col,HText];
    write (copy(Item [I],FirstChar [I]+1,1));
    TextAttr := ColorStyle [Col,Text];
  end;

  I := 1;
  repeat
    SetAttr   (X+2,Y+I,X+2+X_Dim,Y+I,ColorStyle [Col,Bar]);
    KeyCheckTo (Ch,Akt);
    gotoxy (2,I);
    write  (Item [I]);
    gotoxy (2+FirstChar [I],I);
    TextAttr := ColorStyle [Col,HText];
    write (copy(Item [I],FirstChar [I]+1,1));
    TextAttr := ColorStyle [Col,Text];
   (*ClearAttr (X+2,Y+I,X+2+X_Dim,Y+I,ColorStyle [Col,Text]);*)

    if Akt <> 0 then begin
      case Akt of
           72: begin
                 if I > 1 then dec (I)
                 else I := Anz;
               end;
           80: begin
                 if I < Anz then inc (I)
                 else I := 1;
               end;
      end;
    end
    else begin
      for P := 1 to Anz do begin
        S := copy (Item [P],FirstChar [P],1);
        Ch2 := S [1];
        Ch2 := upcase (Ch2);
        Ch  := upcase (Ch);
        if Ch = Ch2 then begin
          I  := P;
          Ch := #13;
        end;
      end;
    end;
  until (ch=#13) or (ch=#27);
  Cursor (True);
  RemoveLastWindow;
  if ch=#13 then Menu := I
  else Menu := 0;
end;

{******************************************************************************}
{*      Zeichent ein Menu (in einer Zeile)                                    *}
{******************************************************************************}

function  LineMenu(Line:word; Col:byte; S:string):byte;
var
  Item       : MenuType;
  Anz,L,PStep,
  I,X_Dim,P,
  Akt        : byte;
  Ch,Ch2     : char;
  FirstChar  : FirstChType;

begin
  X_Dim := 0;
  MenuStrToArray (S,Item,Anz,X_Dim);
  GetFirstChar   (Item,FirstChar,Anz,X_Dim);

  MakeWindow (1,Line,80,Line+2,Col,Single);
  Cursor (false);
  TextAttr := ColorStyle [Col,Text];
  PStep := 78 div Anz;

  for I := 1 to Anz do begin
    P := 1 + PStep * (I-1) + PStep div 2;
    gotoxy (P,1);
    write  (Item [I]);
    gotoxy (P+FirstChar [I],1);
    TextAttr := ColorStyle [Col,HText];
    write (copy(Item [I],FirstChar [I],1));
    TextAttr := ColorStyle [Col,Text];
  end;

  I := 1;
  repeat
    P := 2 + PStep * (I-1) + PStep div 2;
    L := length (Item [I])-1;
    ClearAttr (P, Line+1,P+L, Line+1,ColorStyle [Col,Bar]);
    KeyCheckTo (Ch,Akt);
    ClearAttr (P, Line+1,P+L, Line+1,ColorStyle [Col,Text]);

    if Akt <> 0 then begin
      case Akt of
           75: begin
                 if I > 1 then dec (I)
                 else I := Anz;
               end;
           77: begin
                 if I < Anz then inc (I)
                 else I := 1;
               end;
      end;
    end
    else begin
      for P := 1 to Anz do begin
        S := copy (Item [P],FirstChar [P],1);
        Ch2 := S [1];
        Ch2 := upcase (Ch2);
        Ch  := upcase (Ch);
        if Ch = Ch2 then begin
          I  := P;
          Ch := #13;
        end;
      end;
    end;
  until (ch=#13) or (ch=#27);
  Cursor (True);
  RemoveLastWindow;
  if ch=#13 then LineMenu := I
  else LineMenu := 0;
end;

{******************************************************************************}
{*    Zeichnet ein Menu mit MarginWindow                                      *}
{******************************************************************************}

function  BigMenu          (remove:boolean;Col:byte;PreSet:Byte;
                              MenuTitel,S,C:string):byte;
var  St                  : string;
     Item,Remark         : MenuType;
     Ch,Ch2              : char;
     FirstChar           : FirstChType;
     I,X,Y,BarDim,RemDim,
     Anz,Anz2,P,Akt,XMax,YMax,
     X1,Y1,X2,Y2,RemLine,
     YItem,XItem,xItem1  : byte;
begin
  RemDim := 0;   BarDim := 0;
  MenuStrToArray (S,Item,Anz,BarDim);
  GetFirstChar   (Item,FirstChar,Anz,BarDim);
  MenuStrToArray (C,Remark,Anz2,RemDim);
  BarDim := BarDim + 2;

  if RemDim > BarDim then XMax := RemDim
  else XMax := BarDim;
  if length (MenuTitel) > XMax then XMax := length(MenuTitel);
  MenuTitel := ZentLine (MenuTitel,XMax);

  ZentArray      (Remark,Anz,XMax);
  XMax      := XMax + 8;
  YMax      := Anz  + 9;
  RemLine   := Anz  + 6;
  X1 := 40 - XMax div 2;  X2 := 40 + XMax div 2; if odd (XMax) then inc (X2);
  Y1 := 12 - YMax div 2;  Y2 := 12 + YMax div 2; if odd (YMax) then inc (Y2);
  MarginWindow (X1,Y1,X2,Y2,Col,Double);

  Cursor (false);
  TextAttr := ColorStyle [Col,HText];
  gotoxy (2,1); write (MenuTitel);
  TextAttr := ColorStyle [Col,Text];
  XItem1:= (XMax - BarDim) div 2 - 1;
  for I := 1 to Anz do begin
    gotoxy (XItem1,I+3);      write  (Item [I]);
    gotoxy (XItem1+FirstChar [I],I+3);
    TextAttr := ColorStyle [Col,HText];
    write (copy(Item [I],FirstChar [I],1));
    TextAttr := ColorStyle [Col,Text];
  end;

  XItem := (XMax - BarDim) div 2 + X1;
  i:=Preset;

  If Preset<1 then i:=1;

  If Preset>Anz then i:=Anz;

  repeat
    YItem := Y1 + 4 + I;
    SetAttr (XItem,YItem,XItem+BarDim,YItem,ColorStyle [Col,Bar]);
    gotoxy (2,RemLine); write (Remark [I]);
    KeyCheckTo (Ch,Akt);
    ClearAttr (XItem,YItem,XItem+BarDim,YItem,ColorStyle [Col,Text]);
    gotoxy (XItem1,I+3);      write  (Item [I]);
    gotoxy (XItem1+FirstChar [I],I+3);
    TextAttr := ColorStyle [Col,HText];
    write (copy(Item [I],FirstChar [I],1));
    TextAttr := ColorStyle [Col,Text];
    (*ClearAttr (XItem,YItem,XItem+BarDim,YItem,ColorStyle [Col,Text]);*)


    if Akt <> 0 then begin
      case Akt of
           72: begin
                 if I > 1 then dec (I)
                 else I := Anz;
               end;
           80: begin
                 if I < Anz then inc (I)
                 else I := 1;
               end;
      end;
    end
    else begin
      for P := 1 to Anz do begin
        S := copy (Item [P],FirstChar [P],1);
        Ch2 := S [1];
        Ch2 := upcase (Ch2);
        Ch  := upcase (Ch);
        if Ch = Ch2 then begin
          I  := P;
          Ch := #13;
        end;
      end;
    end;
  until (ch=#13) or (ch=#27);
  Cursor (True);
  If remove then RemoveLastWindow;
  if ch=#13 then BigMenu := I
  else BigMenu := 0;
end;

PROCEDURE PushScreen;
(* Speichert den Bildschirminhalt auf dem Stack *)
var NewStack:Stack_Ptr;
begin
     New(NewStack);
     NewStack^.before:=Stack;
     Stack:=NewStack;
     New(Stack^.Memory);
     Stack^.Memory^:=DisplayPtr^;
end;


PROCEDURE PopScreen;
(* Restauriert den Bildschirminhalt vom Stack.	*)
var TempPtr:Pointer;
begin
     DisPlayPtr^ := Stack^.Memory^;
     Dispose(Stack^.Memory);
     TempPtr:=Stack^.Before;
     Dispose(Stack);
     Stack:=TempPtr;
end;

{******************************************************************************}
{*         Initialisierungteil                                                *}
{******************************************************************************}

begin
  WindowDeep := 0;
  If VideoMode<>7 then ScreenBase:=$b800
                  else ScreenBase:=$b000;
  WindowToolInit(ScreenBase);
  FillChar (PtrTab,sizeof(PtrTab),#00);
end.

