/**
 * $Header:   I:\tc\lib\xc\_getopt.c_v   1.3   16 Sep 1990 14:33:16   Robi  $
 *
 * _GETOPT.C - Analyse von Kommandozeilenoptionen,  la AT&T mit Erweiterungen
 *
 * $Log:   I:\tc\lib\xc\_getopt.c_v  $
 * 
 *    Rev 1.3   16 Sep 1990 14:33:16   Robi
 * Definition gendert (_Cdecl)
 * 
 *    Rev 1.2   16 Sep 1990 13:52:44   Robi
 * bei einer x: Option wird jetzt NULL als Argument bergeben
 * 
**/

#include <stdio.h>
#include <string.h>
#include <io.h>
#include "user\getopt.h"

#define ERR(s, c)	if(opterr){\
	char errbuf[2];\
	errbuf[0] = c; errbuf[1] = '\n';\
	(void) write(2, argv[0], (unsigned)strlen(argv[0]));\
	(void) write(2, s, (unsigned)strlen(s));\
	(void) write(2, errbuf, 2);}


int	opterr = 1;		/* when set >= 0, getopt sends error messages */
int	optind = 1;		/* option counter */
int	optopt;			/* current option character */
char	*optarg;	/* current option argument, if any requested */

int _Cdecl getopt(int argc, char ** argv, const char *opts)
{
	static int sp = 1;
	register int c;
	register char *cp;

	if(sp == 1)
		/* no more options avail ? */
		if(optind >= argc ||
			argv[optind][0] != '-' || argv[optind][1] == '\0')
			return(EOF);
	/* null option ? */
		else if(strcmp(argv[optind], "--") == 0)
		{
			optind++;
			return(EOF);
		}
	/* get next option char */
	optopt = c = argv[optind][sp];
	/* is option in option string ? */
	if(c == ':' || (cp=strchr(opts, c)) == NULL)
	{
		ERR(": illegal option -- ", c);
		/* no, try next argument */
		if(argv[optind][++sp] == '\0')
		{
			optind++;
			sp = 1;
		}
		return('?');
	}
	/* option argument reqiured ? */
	if(*++cp == ':')
	{
		/* get option argument from current or next arg */
		if(argv[optind][sp+1] != '\0')
			optarg = &argv[optind++][sp+1];
		/* no more args avail */
		else if(++optind >= argc)
		{
			ERR(": option requires an argument -- ", c);
			sp = 1;
			return('?');
		}
		else
		{	/* get option argument from current arg */
			optarg = argv[optind++];
			if(*optarg == '-')
			{
				optarg = NULL;
				optind--;
			}
		}
		sp = 1;
	}
	else
	{
		/* next arg */
		if(argv[optind][++sp] == '\0')
		{
			sp = 1;
			optind++;
		}
		optarg = NULL;
	}
	return(c);
}
