{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q+,R+,S+,T-,V+,X+,Y+}
{$M 65520,0,655360}
unit gmenu;

interface

uses menus;

type
  PMyStatusLine = ^TMyStatusline;
  TMyStatusline = object(TStatusline)
    function Hint(AHelpCtx: Word): String; virtual;
  end;

const MenuMaster=false;
var MenuExecute :boolean;

procedure MakeMenu;

implementation

uses objects,app,nwbindry,nwiproc,tvutil,setenv,msgbox,views,drivers,uomenu;

var mf         :text;
    cmNextItem :word;
    lc         :word;
    MenuValid  :boolean;
    Infos :array[1..100] of
      record
        title:string[80];
        hint:string[80];
        pfad:string[80];
        prog:string[12];
        Param:string[80];
        groups:string[80];
        RightPath:string[80];
        Waitflag:boolean;
      end;


procedure Abbruch(x:word;s1:string);
var s:string;
begin
  str(x,s);
  messagebox('Fehler in Mendatei, Zeile '+s+':'^m+s1,nil,mfError+mfOkButton);
  MenuValid:=false;
end;

procedure strip(var s:string);
begin
  while ((s[1]=' ') or (s[1]=#9)) and (length(s)>0) do delete(s,1,1);
end;

function nextitem :PMenuItem;
const
  id_count = 12;
  name : array[1..id_count] of string[8]
         = ({1}'TITLE',{2}'SUB',{3}'HINT',{4}'NAME',{5}'PARAM',{6}'ENDTITLE',
            {7}'END',{8}'#',{9}'PATH',{10}'GROUPS',{11}'RIGHTS',{12}'WAIT');

var s    :string;
    next :boolean;
    id   :byte;
    v    :boolean;
    s1   :string[40];
    x    :byte;
    sub  :PMenuItem;
begin
  { Initialisierungen }
  nextitem:=nil;
  if not MenuValid then exit;
  next:=false;

  repeat
    readln(mf,s); strip(s); inc(lc);
{ debug:    writeln('freier Speicher: ',MemAvail,'  ',cmNextItem,'  ',lc);}

    { Zeilenaufbau: <Zeilenschluesselwort> <Zeilenrest> }
    { Zeilenschluesselwort erkennen }
    id:=1;
    while (id<=id_count) and (copy(s,1,length(name[id]))<>name[id])
      do inc(id);
    { Rest der Zeile abhaengig vom Schluesselwort ausprobieren }
    if id<=id_count then
      begin
        { Zeilenrest isolieren }
        delete(s,1,length(name[id])); strip(s);
        case id of
          1: infos[cmNextItem].title:=s;        { Variable setzen }
          3: infos[cmNextItem].hint:=s;         { Variable setzen }
          4: infos[cmNextItem].prog:=s;         { Variable setzen }
          5: infos[cmNextItem].param:=s;        { Variable setzen }
          7: next:=true;                        { END (auch submenu) }
          8: ;                                  { # = garnix }
          9: infos[cmNextItem].pfad:=s;         { Variable setzen }
          10: infos[cmNextItem].groups:=s;      { Variable setzen }
          11: infos[cmNextItem].rightpath:=s;   { Variable setzen }
          12: infos[cmNextItem].waitflag:=true; { Variable setzen }
          { Untermenue }
          2: begin   { Submenu }
               sub:=nextitem;
               if sub<>nil then
                 begin
                   nextitem:=newSubMenu(s,0,newmenu(sub),nextitem);
                   next:=true;
                 end;
             end;
          { ENDTITLE }
          6: begin    { ENDTITLE }
{ VALIDATE }
               with infos[cmNextItem] do
                 begin
                   s1:=groups;
                   if (s1<>'') and (s1[length(s1)]<>';') then s1:=s1+';';
                   v:=true;
                   while (length(s1)>0) and v do
                     begin
                       x:=pos(';',s1);
                       if s1[1]='-' then
                         begin
                           if isGroupMember(copy(s1,2,x-2),GetMyName) then v:=false;
                         end else
                         if not isGroupMember(copy(s1,1,x-1),GetMyName) then v:=false;
                       delete(s1,1,x);
                     end;
                   if isSupEq or     { supervisor darf immer alles sehen }
                     ((MenuMaster or v)
                     and isrights(pfad+'\'+Prog)
                     and ((RightPath='') or isrights(RightPath))) then
                     begin
{ END VALIDATE }
                       inc(cmNextItem);
                       nextitem:=newitem(infos[cmNextItem-1].title,'',0,
                                    cmNextItem+999,cmNextItem+999,nextitem);
                       next:=true;
                     end else
                       { aufrumen, wenn kein Zugriff }
                       fillchar(infos[cmNextItem],sizeof(infos[cmNextItem]),0);
                 end;
               end;
          else Abbruch(lc,s);
        end
      end
    else if s<>'' then abbruch(lc,s);
  until next
end;

procedure MakeMenu;
var M:PMenuPopup;
    b:trect;
    MenueQuelle :string;
    OnMenu:string;
    ioerg, w,i:word;
begin
  { Menuedatei oeffnen }
  if paramstr(1)='' then MenueQuelle:='main.gm'
                    else MenueQuelle:=paramstr(1);
  assign(mf,MenueQuelle);
  {$I-}
  reset(mf);
  {$I+}
  ioerg:=IOResult;
  if ioerg<>0 then abbruch(ioerg,'IOResult "'+MenueQuelle+'"');
  cmNextItem:=1; lc:=0;
  MenuValid:=true;
  fillchar(infos,sizeof(infos),0);
  { Menue einlesen }
  b.assign(10,5,40,20);
  M:=new(PMenuPopup,init(b,newmenu(nextitem)));
  { Menuedatei schliessen }
  close(mf);
  { Menue auf Bildschirm }
  if not MenuValid then exit;
  desktop^.insert(m);
  w:=desktop^.execview(M);

  if w>1000 then

  { Execute Menu Command }
  with infos[w-1000] do
    begin
      for i:=1 to length(Prog) do Prog[i]:=upcase(Prog[i]);
      if pos('.BAT',Prog)>0 then OnMenu:='CALL '
                            else OnMenu:='';
      OnMenu:=OnMenu+Prog+' '+Param;
      if WaitFlag then setextenv('GATMENUWAIT=1')
                  else setextenv('GATMENUWAIT=0');

      setextenv('GATMENUPATH='+Pfad);
      setextenv('GATMENUON='+OnMenu);

      MenuExecute:=true;
    end;
end;

function TMyStatusLine.Hint(AHelpCtx: Word): String;
begin
  if AHelpCtx >0 then
    Hint:=infos[AHelpCtx-1000].hint
  else hint:=''
end;

begin
  MenuExecute:=false;
end.
