unit uomenu;

interface

uses menus,objects,views,drivers,dos;

const
  cmProgInfo = 150;
  cmRunProg  = 151;

type
  POMenuItem = ^TOMenuItem;
  TOMenuItem = object(TObject)
    Titel:string[40];
    PrgPath:String[127];
    PrgName:String[12];
    Param:String[127];
    RightPath:String[127];
    Groups:String[127];
    MemoLength:word;
    MemoText:Pointer;
    WaitFlag:boolean;
    constructor Load(var S: TStream);
    procedure Store(var S: TStream); virtual;
    function Valid:boolean;
    destructor done; virtual;
  end;

  POMenuColl = ^TOMenuColl;
  TOMenuColl = object(TSortedCollection)
    function Compare(Key1, Key2: Pointer): Integer; virtual;
    function KeyOf(Item: Pointer): Pointer; virtual;
  end;

  POmenuList = ^TOmenuList;
  TOmenuList = object(TListViewer)
    menu:POMenuColl;
    constructor Init(var Bounds: TRect; ANumCols: Integer; AHScrollBar,
                     AVScrollBar: PScrollBar);
    destructor done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function GetText(Item: Integer; MaxLen: Integer): String; virtual;
    procedure EditItem(Insert:Boolean);
    procedure DeleteItem;
    procedure ExecItem;
    procedure SaveMenu;
    procedure LoadMenu;
    procedure ShowInfo;
  end;

var MenuMaster:boolean;
    MenuExecute:boolean;
    MenuFileName:string;

function MakeOmenu:PWindow;
procedure RegisterMenu;
function IsSupEq:boolean;


implementation


uses Dialogs,app,msgbox,editors,
     nwfile,nwbindry,nwmisc,
     setenv,crt,tvutil,nwiproc;

type
  PMySColl = ^TMySColl;
  TMySColl = object(TStringCollection)
    constructor Init(ALimit, ADelta: Integer);
    function Compare(Key1, Key2: Pointer): Integer; virtual;
  end;

const
  ROmenuitem: TStreamRec = (
    ObjType: 2099;
    VmtLink: Ofs(TypeOf(TOMenuItem)^);
    Load: @TOmenuItem.Load;
    Store:@TOmenuItem.Store);
  ROmenucoll: TStreamRec = (
    ObjType: 2098;
    VmtLink: Ofs(TypeOf(TOMenucoll)^);
    Load: @TOmenucoll.Load;
    Store:@TOmenucoll.Store);

    MenuVersion : byte = 1;


{ ========== OMySColl ================ }

constructor TMySColl.init;
begin
  inherited init(ALimit,ADelta);
  duplicates:=true;
end;

function TMySColl.compare;
begin
  compare:=-1;
end;


{ ========== OMenuItem =============== }

constructor TOmenuitem.load;
var Ver:byte;
begin
  inherited init;
  S.read(Ver,sizeof(Ver));
  S.read(Titel,sizeof(Titel));
  S.read(PrgName,sizeof(PrgName));
  S.read(PrgPath,sizeof(PrgPath));
  S.read(Param,sizeof(Param));
  S.read(RightPath,sizeof(RightPath));
  S.read(WaitFlag,sizeof(WaitFlag));
  S.read(MemoLength,sizeof(MemoLength));
  getmem(MemoText,MemoLength);
  S.read(MemoText^,MemoLength);
  S.read(Groups,sizeof(Groups));
end;

procedure TOmenuitem.store;
begin
  S.write(MenuVersion,sizeof(MenuVersion));
  S.write(Titel,sizeof(Titel));
  S.write(PrgName,sizeof(PrgName));
  S.write(PrgPath,sizeof(PrgPath));
  S.write(Param,sizeof(Param));
  S.write(RightPath,sizeof(RightPath));
  S.write(WaitFlag,sizeof(WaitFlag));
  S.write(MemoLength,sizeof(MemoLength));
  S.write(MemoText^,MemoLength);
  S.write(Groups,sizeof(groups));
end;


function TOMenuItem.valid;
var v:boolean;
    s,me:string;
    x:byte;
begin
  s:=groups;
  if (s<>'') and (s[length(s)]<>';') then s:=s+';';
  v:=true;
  while (length(s)>0) and v do
    begin
      x:=pos(';',s);
      if s[1]='-' then
        begin
          if isGroupMember(copy(s,2,x-2),GetMyName) then v:=false;
        end else
          if not isGroupMember(copy(s,1,x-1),GetMyName) then v:=false;
      delete(s,1,x);
    end;
  valid:=(    (MenuMaster or v)
          and isrights(PrgPath+'\'+PrgName)
          and ((RightPath='') or isrights(RightPath))
         );
end;


destructor TOMenuItem.done;
begin
  freemem(MemoText,MemoLength);
  inherited done;
end;


{ ========== OMenuCol  =============== }

function TOMenuColl.Compare(Key1, Key2: Pointer): Integer;
begin
  if PString(Key1)^ < PString(Key2)^ then compare:=-1
    else begin
    if PString(Key1)^ = PString(Key2)^ then compare:=0
         else compare:=1;
    end;
end;

function TOMenuColl.KeyOf(Item: Pointer): Pointer;
begin
  KeyOf:=@POMenuItem(Item)^.Titel;
end;

{ ========== OMenuList =============== }

constructor TOMenuList.Init(var Bounds: TRect; ANumCols: Integer; AHScrollBar,
                 AVScrollBar: PScrollBar);
begin
  inherited Init(Bounds,ANumCols,AHScrollBar,AVScrollBar);
  if MenuMaster then HelpCtx:=1;
  loadmenu;
end;

destructor TOmenuList.done;
begin
  savemenu;
  dispose(menu,done);
  inherited done;
end;

procedure TOMenuList.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(event);
  case event.what of
    evKeydown:
      case Event.keycode of
        kbIns: if MenuMaster then EditItem(True);
        kbDel: if MenuMaster then DeleteItem;
        kbEnter: if MenuMaster then begin
                   if(menu^.count>0) then EditItem(False) end
                 else ExecItem;
        else exit;
      end;
    evCommand:
      case Event.Command of
        cmProgInfo: ShowInfo;
        cmRunProg : ExecItem;
      else exit;
      end;
    else exit;
  end;
  clearevent(event);
end;

function TOmenuList.GetText(Item: Integer; MaxLen: Integer): String;
begin
  with POmenuItem(menu^.at(item))^ do
    if MenuMaster then
      if valid then GetText:=' '+Titel
               else GetText:='  '+Titel
    else GetText:=Titel;
end;


procedure TOmenuList.EditItem(Insert:boolean);
{$I menuitem.src}
var d:Pdialog;
    mi:POMenuItem;
begin
  d:=makedialog;
  if not Insert then
    with POmenuItem(menu^.at(focused))^ do
      begin
        datarec.titel:=Titel;
        datarec.PrgName:=PrgName;
        datarec.PrgPath:=PrgPath;
        datarec.Param:=Param;
        if WaitFlag then datarec.WaitFlag:=1
                    else datarec.WaitFlag:=0;
        datarec.RightPath:=RightPath;
        datarec.Groups:=Groups;
        datarec.MemoLength:=MemoLength;
        move(MemoText^,datarec.MemoText,MemoLength);
        d^.setdata(datarec);
      end;
  if application^.execview(d) <> cmCancel then
    begin
      if not Insert then
        Menu^.Atfree(focused); { Alten Eintrag lschen }

      d^.getdata(Datarec);
      mi:=new(POmenuItem,init);
      mi^.titel:=datarec.titel;
      upstring(datarec.prgname);
      mi^.prgname:=datarec.prgname;
      upstring(datarec.prgpath);
      mi^.prgpath:=datarec.prgpath;
      mi^.param:=datarec.param;
      upstring(datarec.rightpath);
      mi^.rightpath:=datarec.rightpath;
      mi^.waitflag:=(datarec.waitflag=1);
      upstring(datarec.groups);
      mi^.groups:=datarec.groups;
      mi^.MemoLength:=datarec.Memolength;
      getmem(mi^.Memotext,mi^.MemoLength);
      move(datarec.Memotext,mi^.MemoText^,mi^.MemoLength);

      menu^.insert(mi);
      setrange(menu^.count);
      FocusItem(menu^.indexof(mi));
      drawview;
    end;
  dispose(d,done);
end;

procedure TOmenuList.ShowInfo;
 {$I prginfo.src}
var d:Pdialog;
    t:text;
    path,line,uline:string;
begin
  if menu^.count =0 then exit;
  with POMenuItem(menu^.at(focused))^ do
    begin
      GetTrueEntryName(PrgPath+'\'+PrgName,path);
      if copy(path,length(path)-3,4)<>'.BAT' then
        begin
          messagebox('Die Datei '+path+' ist enhlt keine Beschreibung.',nil,mfOkButton);
          exit;
        end;
      assign(t,path);
      {$I-} reset(t); {$I+}
      if ioresult<>0 then
        begin
          messagebox('Kann Datei'^m+path+^m'nicht ffnen.',nil,mfOkButton);
          exit;
        end;
      Datarec.listbox.ps:=new(PMySColl,init(1,1));
      Datarec.listbox.Focused:=0;
      while not eof(t) do
        begin
          readln(t,line);
          uline:=line; Upstring(uline);
          if copy(uline,1,5)='REM *' then
            begin
              delete(line,1,5);
              Datarec.listbox.ps^.insert(newstr(line+' '));
            end;
        end;
      close(t);
      d:=makedialog;
      d^.setdata(Datarec);
      application^.execview(d);
      dispose(datarec.listbox.ps,done);
      dispose(d,done);
    end;
end;

procedure TOmenuList.DeleteItem;
begin
  if Menu^.count > 0 then
    with POMenuItem(Menu^.at(focused))^ do
    if messagebox('Lsche "'+titel+'" ?',nil,
                  mfYesButton+mfNoButton) = cmYes then
      begin
        Menu^.Atfree(focused);
        setrange(menu^.count);
        drawview;
      end;
end;

procedure TOMenuList.ExecItem;
var OnMenu:string;
begin
  OnMenu:='';
  if Menu^.count > 0 then
    with POMenuItem(Menu^.at(focused))^ do
    { if messagebox('Execute:'^m+Prog+' # '+Param,nil,mfOkButton) <> cmCancel then}
       begin
         savemenu;
         if pos('.BAT',PrgName)>0 then OnMenu:='CALL '
                                  else OnMenu:='';
         OnMenu:=OnMenu+PrgName+' '+Param;
         if WaitFlag then setextenv('OMENUWAIT=1')
                     else setextenv('OMENUWAIT=0');

         setextenv('OMENUPATH='+PrgPath);
         setextenv('OMENUON='+OnMenu);

         MenuExecute:=true;
         message(application,evcommand,cmQuit,nil);
       end;
end;

procedure TOmenuList.SaveMenu;
var s:TBufStream;
begin
  if not MenuMaster then exit;
  s.init(MenuFileName,stCreate,1024);
  s.put(menu);
  if not s.status=stOK then messagebox('Fehler beim Speichern!',nil,mfOkbutton+mfError);
  s.done;
end;

procedure TOmenuList.LoadMenu;
var s:TBufStream;
    i:word;
begin
  s.init(MenuFileName,stOpenRead,1024);
  menu:=POMenuColl(s.get);
  s.done;
  if menu=nil then menu:=new(POMenuColl,init(1,1));

  if not MenuMaster then                     { lschen was nicht aktiv ist }
  i:=0;
  while i<menu^.count do
    if not POmenuitem(menu^.at(i))^.valid
      then menu^.atfree(i)
      else inc(i);

  setrange(menu^.count);
  drawview;
end;



{ ========== Procedure =============== }

function MakeOmenu:PWindow;
var R:trect;
    win:PDialog;
    s:string[10];
begin
 if MenuMaster then s:='Wartung' else s:='Men';
 r.assign(10,5,40,20);
 win:=new(PDialog,init(r,s));
 win^.options:=win^.options or ofCentered;
 r.assign(1,1,29,14);
 win^.insert(new(POMenuList,init(r,1,nil,nil)));
 MakeOmenu:=win;
end;

function IsSupEq:boolean;
Var accLevel:Byte;
    objId   :LongInt;
begin
  GetBinderyAccessLevel(accLevel,objId);
  IF accLevel=(BS_SUPER_READ or BS_SUPER_WRITE)
   then isSupEq:=true else isSupEq:=false;
end;

procedure RegisterMenu;
begin
  RegisterType(ROmenuitem);
  RegisterType(ROmenuColl);
end;

begin
  MenuMaster:=IsSupEq;
  MenuExecute:=false;

  MenuFileName:=Paramstr(1);
  if not isrights(MenuFileName) then MenuFileName:='omenu.mnu';
end.