/*-------------------------------------------------------------+
| allein.c: stellt sicher, da whrend eines aufgerufenen      |
|           Prozesses niemand im Netzwerk arbeitet.            |
+--------------------------------------------------------------+
|                                                              |
| Aufruf: allein programmname                                  |
|                                                              |
| bentigt der zu startende Prozess Parameter, so sind Name und|
| Parameter in Anfhrungsstriche einzuschlieen:               |
|                                                              |
|      allein "programmname parameter-1 ... parameter-n"       |
|                                                              |
| Funktionsweise:                                              |
|                                                              |
| 1) Zunchst wird geprft, ob der File Server unter NetWare   |
|    2.1x luft                                                |
| 2) Alle weiteren Logins werden unterbunden                   |
| 3) Auf der File Server Console wird dies angezeigt           |
| 4) Die Kontrolle ber eingehende Broadcast Messages wird     |
|    bernommen.                                               |
|                                                              |
| sofern noch andere Stationen eingeloggt sind:                |
|                                                              |
| 5) Alle eingeloggten Benutzer erhalten eine Warnung, da sie |
|    sich binnen 4 min auszuloggen haben. Whrend der Wartezeit|
|    wird geprft, ob evtl. Broadcast Messages eingegangen sind|
|    (diese werden angezeigt) oder ob Knig Benutzer vielleicht|
|    durch Drcken einer Taste seinen Willen kund tut, das     |
|    Programm abzubrechen.                                     |
|                                                              |
| 6) Nach 4 min wird an alle noch im System befindlichen User  |
|    eine Meldung verschickt, da in 60 sec die Verbindung     |
|    unterbrochen wird.                                        |
|                                                              |
| 7) Nach 60 sec werden alle Verbindungen unterbrochen, alle   |
|    Dateien geschlossen, alle Transaktionen rckgngig gemacht|
|                                                              |
| 8) Die als Parameter bergebene Prozess (Programm oder Batch)|
|    wird gestartet.                                           |
|                                                              |
| 9) Nach Beendigung der Datensicherung werden neue Logins     |
|    wieder zugelassen                                         |
|                                                              |
|--------------------------------------------------------------|
|                                                              |
| Compilieren mit: (wahlweise auch Compact oder Huge Modell)   |
|                                                              |
| Turbo-C 2.0.........: tcc -ml -OZ -a  allein.c               |
| IBM C/2 oder MSC 5.1: cl  -AL -Gs -Ox allein.c               |
|                                                              |
| ACHTUNG: Unbedingt in einem Modell mit LANGEN POINTERN       |
|          bersetzen                                          |
|                                                              |
+--------------------------------------------------------------+
| begonnen: 08.04.1990             letzte nderung: 02.05.1990 |
+-------------------------------------------------------------*/

#include <conio.h>
#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "allein.h"

/*
|  das folgende define belegt die union REGS, die struct SREGS
|  s und das Feld subfunc - das in (fast) jedem Request Buffer
|  vorhanden ist - vor und lst dann eine INT 0x21 aus. Diese
|  Folge ist fr mehr als die Hlfte aller Novell API Funk-
|  tionen zweckmig. Der Code in der zweiten und dritten
|  Zeile entspricht den Macros FP_OFF() bzw. FP_SEF(). Da
|  jedoch IBM C/2 Version 1.10 Schwierigkeiten mit der
|  Entwicklung von Macros in Macros hat wurde er explizit mit
|  ausformuliert.
*/

#define bufint(fc,sfc,q,p) r.h.ah = fc; q.subfunc = sfc; \
   r.x.si = (unsigned)&(q);                              \
   s.ds   = ((unsigned)((unsigned long)&(q) >> 16));     \
   r.x.di = (unsigned)&(p);                              \
   s.es   = ((unsigned)((unsigned long)&(p) >> 16));     \
   intdosx(&r, &r, &s);

union  REGS        r;
struct SREGS       s;

/*-------------------------------------------------------------+
| Hilfsfunktionen, mit denen Variablen in das Intelformat      |
| konvertiert werden.                                          |
+--------------------------------------------------------------+
|
*/

int swapint(int i)
{
  char *c;
  char tmp;

  c    = (char*) &i;
  tmp  = c[0];
  c[0] = c[1];
  c[1] = tmp;
  return(i);
}

long swaplong(long l)
{
  char *c;
  char tmp;

  c    = (char*) &l;
  tmp  = c[0];
  c[0] = c[3];
  c[3] = tmp;
  tmp  = c[1];
  c[1] = c[2];
  c[2] = tmp;
  return(l);
}

/*-------------------------------------------------------------+
| nw_btc(): Broadcast to Console (0xE1 - 0x09)                 |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion sendet eine Meldung an den
|                  Default File Server, wo sie auf der Console
|                  angezeigt wird.
| VORAUSSETZUNGEN: logged in
| PARAMETER......: ein String der Lnge 1..60
| RUECKGABE......: 0x00: erfolgreich
| BEMERKUNGEN....: -
|
*/

int nw_btc (byte *message)
{
  RQ_BTC                     rq;
  RP_BTC                     rp;

  rq.messlen = strlen(message);
  rq.buflen  = rq.messlen + 2;
  strncpy (rq.message, message, 60);

  rp.buflen  = 0;

  bufint(0xE1, 0x09, rq, rp);
  return(r.h.al);
}

/*-------------------------------------------------------------+
| nw_ccn(): Clear Connection Number (0xE3 - 0xD2)              |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion loggt eine Station aus und
|                  detached sie.
| VORAUSSETZUNGEN: User mu Supervisorrechte haben
| PARAMETER......: log. Stationsadresse
| RUECKGABE......: 0x00 Successful
|                  0xC6 keine Console Rechte
| BEMERKUNGEN....: alle offenen Dateien werden geschlossen, alle
|                  aktiven Transaktionen rckgngig gemacht. Man
|                  kann sich mit dieser Funktion auch selber
|                  ausloggen, also Vorsicht!
|
*/

int nw_ccn(byte logconn)
{
  RQ_CCN                     rq;
  RP_CCN                     rp;

  rq.buflen  = 2;
  rq.logconn = logconn;

  rp.buflen  = 0;

  bufint(0xE3, 0xD2, rq, rp);
  return(r.h.al);
}

/*-------------------------------------------------------------+
| nw_dfsl(): Disable File Server Login (0xE3 - 0xCB)           |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion sperrt weitere Logins auf den
|                  File Server.
| VORAUSSETZUNGEN: Console Operator Rights
| PARAMETER......: -
| RUECKGABE......: 0x00: Operation erfolgreich
|                  0xC6: Keine Console Operator Rechte
| BEMERKUNGEN....: Entspricht der Eingabe von DISABLE LOGIN an
|                  der File Server Console.
|
*/

int nw_dfsl(void)
{
  RQ_DFSL                    rq;
  RP_DFSL                    rp;

  rq.buflen  = 1;
  rp.buflen  = 0;

  bufint(0xE3, 0xCB, rq, rp);
  return(r.h.al);
}

/*-------------------------------------------------------------+
| nw_efsl(): Enable File Server Login (0xE3 - 0xCC)            |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion gibt Logins auf den File
|                  Server wieder frei.
| VORAUSSETZUNGEN: Console Operator Rights
| PARAMETER......: -
| RUECKGABE......: 0x00: Operation erfolgreich
|                  0xC6: Keine Console Operator Rechte
| BEMERKUNGEN....: Entspricht der Eingabe von ENABLE LOGIN auf
|                  der File Server Console.
|
*/

int nw_efsl(void)
{
  RQ_EFSL                    rq;
  RP_EFSL                    rp;

  rq.buflen  = 1;
  rp.buflen  = 0;

  bufint(0xE3, 0xCC, rq, rp);
  return(r.h.al);
}

/*-------------------------------------------------------------+
| nw_gbal(): Get Bindery Access Level (0xE3 - 0x46)            |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion ermittelt den Security Access
|                  Level auf die Bindery.
| VORAUSSETZUNGEN: Logged in
| PARAMETER......: -
| RUECKGABE......: Security Acess Level
| BEMERKUNGEN....: Die Funktion wird hier mibraucht, um zu
|                  ermitteln, ob der Benutzer das Recht hat,
|                  andere User auszuloggen. Dazu sind Supervisor
|                  Rechte erforderlich.
|
*/

int nw_gbal(void)
{
  RQ_GBAL                    rq;
  RP_GBAL                    rp;

  rq.buflen  = 1;
  rp.buflen  = 5;

  bufint(0xE3, 0x46, rq, rp);
  return((r.h.al == 0) ? (int) rp.acclevel : -1);
}

/*-------------------------------------------------------------+
| nw_gbm(): Get Broadcast Message (0xE1 - 0x01)                |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion holt eine Broadcast Message
|                  vom Default File Server, falls dort eine
|                  gespeichert wurde.
| VORAUSSETZUNGEN: Broadcast Mode wurde auf 3 (Store & Ignore)
|                  gesetzt
| PARAMETER......: -
| RUECKGABE......: Pointer auf reply buffer falls erfolgreich
|                  sonst NULL.
| BEMERKUNGEN....: -
|
*/

RP_GBM *nw_gbm(void)
{
  RQ_GBM                     rq;
  static RP_GBM              rp;

  rq.buflen  = 1;
  rp.buflen  = 56;

  bufint(0xE1, 0x01, rq, rp);
  return((r.h.al == 0) ? &rp : NULL);
}

/*-------------------------------------------------------------+
| nw_gci(): Get Connection Information (0xE3 - 0x16)           |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion liefert Informationen ber
|                  eine eingeloggte Station.
| VORAUSSETZUNGEN: Logged in
| PARAMETER......: logische Stationsnummer
| RUECKGABE......: NULL.: Operation war nicht erfolgreich
|                  sonst: Zeiger auf eine Struktur vom
|                         Typ RP_GCI
| BEMERKUNGEN....: Die API Reference NetWare 2.15 Revision 1.00
|                  enthlt hier einen Tippfehler. Die Lnge des
|                  Reply Buffers ist dort mit 61 angegeben, 62
|                  ist richtig. Das Verhalten beim Aufruf
|                  dieser Funktion mit der falschen Lnge ist
|                  unterschiedlich, meistens hngt sich die
|                  Station auf, unter NetWare 2.12 ergab der
|                  16. Aufruf der Funktion einen GPI (general
|                  protection interrupt) auf dem File Server.
|
*/

RP_GCI *nw_gci(byte logconn)
{
  RQ_GCI                     rq;
  static  RP_GCI             rp; /* Seit c't 9/90
                                    (Zeile 320) gendert! */
  rq.buflen  = 2;
  rq.logconn = logconn;

  rp.buflen  = 62;    /* ist in der API Referenz irrtuemlich
                         mit 61 angegeben */

  bufint(0xE3, 0x16, rq, rp);
  return((r.h.al == 0) ? &rp : NULL);
}

/*-------------------------------------------------------------+
| nw_gcn(): Get connection number (0xDC)                       |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion liefert die logische
|                  Stationsnummer der eigenen Workstation.
| VORAUSSETZUNGEN: Netzwerktreiber geladen und attached.
| PARAMETER......: -
| RUECKGABE......: Pointer auf Reply buffer
| BEMERKUNGEN....: -
|
*/

RP_GCN *nw_gcn(void)
{
  RP_GCN                     rp;

  r.x.ax = 0xDC00;
  intdos (&r, &r);

  rp.connection = r.h.al;
  rp.firstdig   = r.h.ch;
  rp.secdig     = r.h.cl;

  return(&rp);
}

/*-------------------------------------------------------------+
| nw_gfsi(): Get file server information (0xE3 - 0x11)         |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion liefert Informationen ber
|                  den Default File Server.
| VORAUSSETZUNGEN: logged in
| PARAMETER......: -
| RUECKGABE......: Pointer auf Reply Buffer bei erfolgreicher
|                  Durchfhrung, sonst NULL.
| BEMERKUNGEN....: -
|
*/

RP_GFSI *nw_gfsi(void)
{
  RQ_GFSI                    rq;
  static RP_GFSI             rp;

  rq.buflen  = 1;
  rp.buflen  = 139;

  bufint(0xE3, 0x11, rq, rp);
  return((r.h.al == 0) ? &rp : NULL);
}

/*-------------------------------------------------------------+
| nw_sbm(): Send Broadcast Message (0xE1 - 0x00)               |
+--------------------------------------------------------------+
|
| FUNKTION.......: abweichend von der API-Funktion kann hier
|                  nur eine Meldung an eine Station gleichzeitig
|                  verschickt werden.
| VORAUSSETZUNGEN: logged in
| PARAMETER......: Zielstation und Meldung (1..55 Zeichen)
| RUECKGABE......: 0x00: erfolgreich
| BEMERKUNGEN....:
|
*/

int nw_sbm(byte station, char *message)
{
  RQ_SBM                     rq;
  RP_SBM                     rp;

  if (strlen(message) > 54)
  {
    message[55] = 0;
  }

  rq.count   = 1;
  rq.station = station;
  rq.messlen = strlen(message);
  if (rq.messlen > 55)
  {
    rq.messlen = 55;
  }
  strncpy(rq.message, message, 55);
  rq.buflen  = rq.messlen + 4;

  rp.buflen  = 2;

  bufint(0xE1, 0x00, rq, rp);
  return(r.h.al);
}

/*-------------------------------------------------------------+
| nw_sbmod(): Set Broadcast Mode (0xDE)                        |
+--------------------------------------------------------------+
|
| FUNKTION.......: Diese Funktion entspricht in etwa dem CASTOFF
|                  und CASTON Befehl, hat aber ein paar
|                  Mglichkeiten mehr. Man kann hier die Shell
|                  veranlassen, eine Meldung nicht in der 25.
|                  Zeile des Bildschirms darzustellen und sich
|                  evtl. eintreffende Meldungen selber abholen,
|                  ohne die Kontrolle zu verlieren.
| VORAUSSETZUNGEN: logged in
| PARAMETER......: -
| RUECKGABE......: eingestellter Modus
| BEMERKUNGEN....: -
|
*/

int nw_sbmod(byte newmode)
{
  r.h.ah      = 0xDE;
  r.h.dl      = newmode;

  intdosx(&r, &r, &s);

  return(r.h.al);
}

/*-------------------------------------------------------------+
| waitsec(): Warten und auf Broadcast Messages lauschen        |
+--------------------------------------------------------------+
|
|  In main() wird der Broadcast Mode auf 3 (Store & Ignore)
|  gesetzt, damit ist es mglich, auch beim Eingehen von
|  Meldungen nicht die Kontrolle ber den Programmflu zu
|  verlieren. Man mu allerdings dann laufend nachfragen, ob
|  evtl. eine Meldung fr die Station eingegangen ist (polling).
|
*/

void waitsec(int sec)
{
  RP_GBM *gbm;
  int     c, diff;
  time_t  start, tmp;

  start = time(NULL);
  while (!kbhit() && ((diff = (int)(time(NULL) - start)) < sec))
  {
    fprintf(stderr, "warte... %4d\r", diff);
    if (((gbm = nw_gbm()) != NULL) && (gbm->messlen > 0))
    {
      gbm->message[gbm->messlen] = '\0';
      fprintf(stderr, "\n\aMeldung erhalten: %s\n\n",
                      gbm->message);
    }

    tmp = time(NULL); /* nur alle 2 sec prfen */
    while ((time(NULL) - tmp) < 2L)
      ;
  }

  if (kbhit())
  {
    fprintf(stderr,
            "*** Programm durch Benutzer abgebrochen ***\a\n");
    exit(1);
  }
}

/*-------------------------------------------------------------+
| chkver(): prft, ob NetWare 2.1x                             |
+--------------------------------------------------------------+
|
| falls nicht NetWare 2.1x aktiv ist, so bricht das Programm
| hier ab, ansonsten wird die Anzahl der max untersttzten
| Verbindungen zurckgegeben.
|
*/

int chkver(void)
{
  RP_GFSI *gsi;

  if ((gsi = nw_gfsi()) == NULL ||
       gsi->vers        !=  2   ||
       gsi->subvers     <  10   ||
       gsi->subvers     >  19   )
  {
    fprintf(stderr,
           "\nProgramm nicht fr NetWare %d.%02d freigegeben\n",
           gsi->vers,
           gsi->subvers);
    exit(3);
  }
  fprintf(stderr,
          "\nNetWare %d.%02d auf File Server %s\n",
          gsi->vers,
          gsi->subvers,
          gsi->servnam);
  fprintf(stderr,
         "%d Verbindungen mglich, %d momentan in Benutzung.\n",
         swapint(gsi->connsup),
         swapint(gsi->connuse));

  return((int) swapint(gsi->connsup));
}

/*-------------------------------------------------------------+
| sendmess(): schickt eine Meldung bzw. logged aus.            |
+--------------------------------------------------------------+
|
| Wird ein char Pointer bergeben, so wird diese Meldung an alle
| eingeloggten Stationen versandt; ist der Pointer NULL, so
| werden alle Stationen - auer der eigenen - ausgeloggt.
|
*/

int sendmess(int maxconn, char *message)
{
  int i;
  int stcount = 0;  /* Anzahl der noch eingeloggten Stationen */
  int mystation = 0; /* Meine logische Stationsnummer         */
  RP_GCI *gci;    /* Antwortpuffer Get Connection Information */
  RP_GCN *gcn;    /* Antwortpuffer Get Connection Number      */

  gcn = nw_gcn(); /* eigene Stationsnummer erfragen           */
  mystation = gcn->connection;

  for (i = 1; i <= maxconn; i++)
  {
    if (i != mystation)  /* an alle Stationen auer meiner... */
    {
      if ((gci = nw_gci(i))      != NULL &&
           swaplong(gci->objid)  >  0    &&
           swapint(gci->objtype) == 1)
      {
        stcount++;
        if (message != NULL)
        {
         fprintf(stderr,
                 "schicke Meldung an %s[%d]\n",
                  gci->objname, i);
         nw_sbm(i, message);  /* ...eine Meldung schicken...  */
        }
        else
        {
          fprintf(stderr,
                  "unterbreche Verbindung %s[%d]\n",
                  gci->objname, i);
          nw_ccn(i);               /* ...oder Schluss machen. */
        }
      }
    }
  }
  return(stcount);
}

/*-------------------------------------------------------------+
| ende(): Freigabe der Login-Funktion als Exit-Prozedur        |
+--------------------------------------------------------------+
|
|  Logins werden wieder erlaubt, der Empfang von Broadcast
|  Messages wieder auf den Default-Wert eingestellt.
|
*/

void ende(void)
{
  nw_efsl();
  nw_btc("ALLEIN - Login Funktion freigegeben.");
  nw_sbmod(0);
}

/*-------------------------------------------------------------+
| main(): Main eben...                                         |
+--------------------------------------------------------------+
|
*/

main(int argc, char **argv)
{
  int maxconn;               /* max untersttzte Verbindungen */

  fprintf(stderr, "\nALLEIN -- (c) by AM & MB 1990\n\n");

  if (argc != 2)
  {
    fprintf(stderr, "Fehler in der Parametervorgabe\n");
    exit(3);
  }

  maxconn = chkver();

  if (nw_gbal() != 0x33)
  {
    fprintf(stderr,
            "Keine Supervisor Rechte -- Programmabbruch!\n\n");
    exit(3);
  }

  if (nw_dfsl())
  {
    fprintf(stderr,
          "Kein DISABLE LOGIN mglich -- Programmabbruch!\n\n");
    exit(3);
  }

  if (atexit(ende))
  {
    fprintf(stderr, "interner Fehler.\n");
    exit(3);
  }

  nw_sbmod(3);         /* Store and Ignore Broadcast Messages */
  nw_btc("ALLEIN - Login Funktion gesperrt.");
  if (sendmess(maxconn, "Bitte binnen 4 min. ausloggen!"))
  {
    waitsec(240);
    fprintf(stderr, "\n");
    if (sendmess(maxconn,
                 "Verbindung wird in 60 sec. unterbrochen!"))
    {
      waitsec(60);
      fprintf(stderr, "\n");
      sendmess(maxconn, NULL);
    }
  }
  system(argv[1]);     /* Das angegebene Programm ausfhren,  */
}
