/*-------------------------------------------------------------+
|  allein.h: Headerfile mit Strukturdefinitionen fr           |
|            Novell API Funktionen                             |
+--------------------------------------------------------------+
|
|  RQ_... Request Buffer
|  RP_... Reply Buffer
|
*/

/*
|  diese defines dienen der Kennzeichnung der Novell Datentypen,
|  also der "verkehrten" Integers
*/

#define  byte      unsigned char
#define  word      unsigned int
#define  dword     unsigned long


typedef struct
{
  unsigned         buflen;
  byte             subfunc;
  byte             messlen;
  byte             message[60];
} RQ_BTC;

typedef struct
{
  unsigned         buflen;
} RP_BTC;


typedef struct
{
  unsigned         buflen;
  byte             subfunc;
  byte             logconn;
} RQ_CCN;

typedef struct
{
  unsigned         buflen;
} RP_CCN;


typedef struct
{
  unsigned                   buflen;
  byte                       subfunc;
} RQ_EFSL;

typedef struct
{
  unsigned                   buflen;
} RP_EFSL;


typedef struct
{
  unsigned                   buflen;
  byte                       subfunc;
} RQ_DFSL;

typedef struct
{
  unsigned                   buflen;
} RP_DFSL;


typedef struct
{
  unsigned                   buflen;
  byte                       subfunc;
} RQ_GBAL;

typedef struct
{
  unsigned                   buflen;
  byte                       acclevel;
  dword                      objid;
} RP_GBAL;


typedef struct
{
  unsigned                   buflen;
  byte                       subfunc;
} RQ_GBM;

typedef struct
{
  unsigned                   buflen;
  byte                       messlen;
  byte                       message[56];
} RP_GBM;


typedef struct
{
  unsigned                   buflen;
  byte                       subfunc;
} RQ_GFSI;

typedef struct
{
  unsigned         buflen;
  byte             servnam[48];
  byte             vers;
  byte             subvers;
  word             connsup;
  word             connuse;
  word             maxvol;
  byte             osrev;
  byte             sftlev;
  byte             ttslev;
  word             peakvol;
  byte             accver;
  byte             vapver;
  byte             queuever;
  byte             pserver;
  byte             conver;
  byte             seclev;
  byte             bridver;
  byte             filler[60];
} RP_GFSI;


typedef struct
{
  unsigned         buflen;
  byte             subfunc;
  byte             logconn;
} RQ_GCI;

typedef struct
{
  unsigned         buflen;
  dword            objid;
  word             objtype;
  byte             objname[48];
  byte             loginyear;
  byte             loginmonth;
  byte             loginday;
  byte             loginhour;
  byte             loginmin;
  byte             loginsec;
  byte             loginwday;
  byte             filler;   /* !!! */
} RP_GCI;


typedef struct
{
  byte             connection;
  byte             firstdig;
  byte             secdig;
} RP_GCN;


typedef struct
{
  unsigned         buflen;
  byte             subfunc;
  byte             count;
  byte             station;
  byte             messlen;
  byte             message[55];
} RQ_SBM;

typedef struct
{
  unsigned         buflen;
  byte             count;
  byte             result;
} RP_SBM;
