Program  CheckSpace {Version 1.01};

{-----------------------------------------------------------------------------
CheckSpace berprft in einem Novellnetz oder lokal das gewnschte Laufwerk 
eines Servers auf Blockgre, Speicherplatzverbrauch und verschwendeten Platz
bei verschiedenen Blockgren.

- prft momentan nur das aktuelle Laufwerk

 Freeware             (C)opyright 1995 by Stefan Braunstein  Fido: 2:2476/709
-----------------------------------------------------------------------------}
Uses  Dos , CRT , { Turbo Standard Units}
      Tools;      { eigene, gesammelte Routinen}      

{.DEFINE TEST}

{$M 65000,15000,100000}
{$R+,S+,I+,V-,P+}

Const
        Version = '1.01';

Type    S3 = String[3]; S12 = String[12]; S60 = String[60]; S80 = String[80];
        S2 = String[2];


Const
        Rd    = 0;  {Konstanten fr FileMode}
        Wr    = 1;
        RdWr  = 2;

        CR    = #13+#10;

Var
      Out      : Text;
      B4,B8,B16,
      B32,B64,
      B0,
      FCount   : LongInt;
      VErr     : Integer;
      AktX,AktY,
      EL       : Byte;
      Param,
      AktPath,
      TempPath : S60;

      rx,ry,rz : Real;
      lx,ly,lz : LongInt;
      wx,wy,wz : Word;
      ix,iy,iz : Integer;
      sx,sy,sz : String;
      bx,by,bz : Byte;


{-----------------------------------------------------------------------------}
Procedure Init;      {initialisiert das System}

Begin

   CursorOff;
   Param:=UpC(ParamStr(1));

   EL:=0;
   FCount:=0;
   B0:=0; B4:=0; B8:=0; B16:=0; B32:=0; B64:=0;

   GetDir(0,AktPath);
   TempPath := GetEnv('TEMP');

  If TempPath[Length(TempPath)] ='\' Then
     Dec(TempPath[0]);

End;

{--------------------------------------------------------------------------}
Function MB (BB: LongInt) : String;

Begin
  Str(BB,sx);
  If Length(sx) >6 Then Begin
     sx:=Copy(sx,1,Length(sx)-6)+','+Copy(sx,Length(sx)-5,2)+' MB';
  End
  Else If Length(sx) >3 Then Begin
          sx:=Copy(sx,1,Length(sx)-3)+','+Copy(sx,Length(sx)-2,2)+' KB';
       End;
  MB:=sx;
End;

{--------------------------------------------------------------------------}
Procedure SearchDirectories(path: STRING);

Var
  SRecord : SearchRec;
  ShowPath: String;
Begin

  IF Length(path) > 0 THEN                    (* Suche nach Dateien: *)
    IF path[Length(path)] <> '\' THEN
      path := path + '\';
  SRecord.Name := '';
  FindFirst(path+'*.*', ReadOnly+Hidden+Archive, SRecord);

  IF SRecord.Name <> '' THEN Begin
    GotoXY(2,AktY);
    WriteLn(Path,Space(40));
  End;

  WHILE DosError = 0 Do Begin
    Inc(FCount);  
    GotoXY(5,AktY+1);
{    WriteLn(SRecord.Name,Space(40));}
    Inc(B0,SRecord.Size);
    lx:=SRecord.Size Div 4096;
    If SRecord.Size Mod 4096 <> 0 Then
       Inc(lx);
    Inc(B4,4096*lx);
    lx:=SRecord.Size Div 8192;
    If SRecord.Size Mod 8192 <> 0 Then
       Inc(lx);
    Inc(B8,8192*lx);
    lx:=SRecord.Size Div 16384;
    If SRecord.Size Mod 16384 <> 0 Then
       Inc(lx);
    Inc(B16,16384*lx);
    lx:=SRecord.Size Div 32768;
    If SRecord.Size Mod 32768 <> 0 Then
       Inc(lx);
    Inc(B32,32768*lx);
    lx:=SRecord.Size Div 65536;
    If SRecord.Size Mod 65536 <> 0 Then
       Inc(lx);
    Inc(B64,65536*lx);

    FindNext(SRecord);
  End;
  
  (* Suche nach Verzeichnissen: *)
  FindFirst(path + '*.*', Directory, SRecord);
  WHILE DosError = 0 DO BEGIN
     IF (SRecord.Attr AND Directory <> 0) AND
        (SRecord.Name[1] <> '.') THEN
        SearchDirectories(path + SRecord.Name);
     FindNext(SRecord);
  End;
End;

{-----------------------------------------------------------------------------}
Procedure GetSpace;

Begin

   SearchDirectories(Copy(AktPath,1,3));
   rx:=DiskSize(Ord(AktPath[1])-64);
   ry:=rx*0.023;
   GotoXY(AktX,AktY);
   WriteLn(Out,' Drive  ',Copy(AktPath,1,2),Space(30),FCount,' Files     ',MB(B0),' / ',MB(DiskSize(Ord(AktPath[1])-64)));
   WriteLn(Out,Dup('',79));
   WriteLn(Out,'                      4 KB         8 KB        16 KB       32 KB       64 KB'+CR);
   WriteLn(Out,' Plattenbedarf      ',MB(B4),'   ',MB(B8),'   ',MB(B16),'   ',MB(B32),'   ',MB(B64));
   WriteLn(Out,' RAMBedarf           ',MB(Round(ry/4)),'   ',MB(Round(ry/8)),'      ',MB(Round(ry/16)),'     ',
                                       MB(Round(ry/32)),'    ',MB(Round(ry/64)));
   WriteLn(Out,' RAMBedarf + NS      ');
   WriteLn(Out,Dup('',79));

End;

{-----------------------------------------------------------------------------}
{Hauptprogramm}

Begin
   ClrScr;
   WriteLn(CR+CR+' CheckSpace  ' +Version+Space(38)+'(c) 1995 St. Braunstein');
   WriteLn(Dup('',79));
   AktX :=WhereX;  AktY :=WhereY;
   Assign(Out,'');
   Append(Out);
   Init;
   GetSpace;
   CursorNorm;
   Close(Out);
End.
