Unit Tools;

{$F+}

Interface

uses CRT ,DOS;

Type
        Screen  = Array[0..3999] of Byte;
        ScrChar    = Array[0..1]of Char;   { 0:Character - 1:Color   }
        HexStr     = String[2];

        S1 = String[1];
        S2 = String[2];
        S5 = String[5];
        S8 = String[8];
        S10 = String[10];
Const
        OPSYS : Array[1..4] of S5 = ('DOS','OS/2','Windows','Deskview');
        CPU   : Array[1..4] of S5 = ('8086','80286','80386','80486');

        Cpu8086  = 1; Cpu80286 = 2;  Cpu80386 = 3; Cpu80486 = 4;

        Rd=0; Wr=1; RdWr=2;  {Konstanten fr FileMode}
        StdIn=0; StdOut=1; StdErr=2;

        Hex1    : Array[0..15] of Char = '0123456789ABCDEF';

        IntScreen  : ^Screen = nil;

Var

    ScrBase    : ^ScrChar;
    WindBuffS  : Word;
    Register   : Registers;

Procedure    CursorNorm;
Procedure    CursorBlock;
Procedure    CursorOff;
Function     CursorSize:Word;
Procedure    ReadScrPart(x1,y1,x2,y2:Byte);
Function     ScrMode:Byte;
Procedure    SetCursorSize(OldCursor:Word);
Procedure    WriteScrPart(x1,y1,x2,y2:byte);
Function  SplitString(Var SStr: String;Trenn:S1):String;
Function  RedirName(ReDirNr:integer;Name:PathStr) : word;
Function  RedirFile(ReDirNr:integer;var Datei:File) : word;
Function  RedirHandle(ReDirNr:integer; Handle:byte) : word;
Procedure UnRedir(RedirInfo:word);
Function  WhatCPU:  Word;
Procedure CPUSpeed(Var MHz, KHz:  Word);
Procedure Frame(L,O,R,U,Typ:Byte);
Procedure Keyboard(Del:Boolean;Text:String);
Function  LastPos(ch:Char;S:String):Byte;
Procedure WarmBoot;
Procedure ColdBoot;
Function  FileExist(FName:String):Boolean;
Function  Wild(flname,card:String):Boolean;
Function  MakeDir(Namen:String):Boolean;
Function  CheckPrinter(PrinterNr:Byte) : Boolean;
Function  DUpCase(UpChr:Char) : Char;
Function  UpC(UpString:String) : String;
Function  LeadingZero(Zahl:String) : String;
Function  Hex(w:Word):String;
Function  RTrim(Text:String) : String;
Function  LTrim(Text:String) : String;
Function  AllTrim(Text:String) : String;
Function  Dup(Zeichen:Char;Anzahl:Integer) : String;
Function  Space(Anzahl:Integer) : String;
Function  DStr(Zahl:LongInt) : String;
Function  CStr(CString:String) : String;
Function  Max(X,Y:LongInt) : LongInt;
Function  Min(X,Y:LongInt) : LongInt;
Procedure Beep;

Implementation

{---------------------------------------------------------------------------}
Function  SplitString(Var SStr: String;Trenn:S1):String;

Begin
  SplitString:=Copy(SStr,1,Pos(Trenn,SStr)-1); 
  SStr:=LTrim(Copy(SStr,Pos(Trenn,SStr)+1,250));
End;

{---------------------------------------------------------------------------}
Function FileExist(FName:String):Boolean;

Var FInfo : SearchRec;
    XFile : Text;

Begin
   FindFirst(FName,Archive+ReadOnly,FInfo);
   If DOSError = 0 Then
      FileExist:=True
   Else
      FileExist:=False;
End;

{---------------------------------------------------------------------------}
Procedure Beep;
 begin
  sound(500);
  delay(200);
  NoSound;
 end;

{---------------------------------------------------------------------------}

Procedure Frame(L,O,R,U,Typ:Byte);

Var
x : Byte;

Begin
  GotoXY(L,O);
  Write(''+Dup('',R-L-1)+'');
  For x := 1 to U-O-1 Do Begin
     GotoXY(L,O+x);Write(''); GotoXY(R,O+x);Write('');
  End;
  GotoXY(L,U);
  Write(''+Dup('',R-L-1)+'');
End;


{---------------------------------------------------------------------------}
Function  LeadingZero(Zahl:String) : String;

Begin
  If Length(Zahl) <2 Then
     LeadingZero:='0'+Zahl
  Else
     LeadingZero:=Zahl;
End;


{---------------------------------------------------------------------------}

Function Dup (Zeichen : Char ; Anzahl : Integer) : String;

Var
      x : Byte  ;
      S : String;

Begin
  S := '';
  For x := 1 to Anzahl Do
    S := S + Zeichen ;
  Dup := S;
End;

{---------------------------------------------------------------------------}
Function Space (Anzahl : Integer) : String;

Var
      x : Byte  ;
      S : String;

Begin
  S := '';
  For x := 1 to Anzahl Do
    S := S + ' ' ;
  Space := S;
End;


{---------------------------------------------------------------------------}
Function  DStr(Zahl:LongInt) : String;

Var
    S : String;

Begin
   Str(Zahl,S);
   DStr:=S;
End ;


{---------------------------------------------------------------------------}
Function  CStr(CString:String) : String;

Var
    zwx : Word;

Begin
  zwx:=1 ;
  While (zwx<=Length(CString)) And (CString[zwx] <> Chr(0)) Do
     Inc(zwx);
  CStr :=Copy(CString,1,zwx-1);
End ;


{---------------------------------------------------------------------------}

Function  RTrim(Text:String ) : String;

Begin
  If Length(Text) > 0 Then Begin
     While  Text[Length(Text)] = ' ' Do
       Text:=Copy(Text,1,Length(Text)-1);
     RTrim:=Text ;
  End
  Else
     RTrim:='';
End;

{---------------------------------------------------------------------------}

Function  LTrim(Text:String ) : String;

Begin
  If Length(Text) > 0 Then Begin
     While  (Text[1] = ' ') And (Length(Text) > 0)  Do
       Text:=Copy(Text,2,Length(Text)-1);
     LTrim:=Text ;
  End
  Else
     LTrim:='';
End;


{---------------------------------------------------------------------------}

Function  AllTrim(Text:String) : String;

Var  x : Byte ;
     S : String ;
Begin
  s := '' ;
  For x := 1 to Length(Text) Do
    If Text[x] <> ' ' Then
     s := s + Text[x] ;
  AllTrim := S ;

End;

{---------------------------------------------------------------------------}
Procedure Keyboard ( Del : Boolean ; Text : String ) ;

Var
        x  : Byte ;
        MaxLen : Byte ;

Begin

  If Del Then
    MemW[$40:$1C] := MemW[$40:$1A] ;

  MaxLen := (MemW[$40:$1A] + 32 - MemW[$40:$1C] ) Div 2 - 1 ;

  If Length(Text) > MaxLen Then
    Text := Copy(Text,1,MaxLen) ;

  x := 1 ;
  While x <= Length(Text) Do
  Begin
    If Text[x] <> '@' Then
    Begin
      MemW[$40:MemW[$40:$1C]] := Ord(Text[x]) ;
      If MemW[$40:$1C] < $3C Then
        Inc(Mem[$40:$1C],2)
      Else
        MemW[$40:$1C] := $1E ;
    End
    Else
    Begin
      MemW[$40:MemW[$40:$1C]] := 0 ;
      Inc (x) ;
      Inc(Mem[$40:$1C]) ;
      MemW[$40:MemW[$40:$1C]] := Ord(Text[x]) ;
      If MemW[$40:$1C] < $3D Then {  SBX  ??  3B  3C  }
        Inc(Mem[$40:$1C])
      Else
        MemW[$40:$1C] := $1E ;
    End ;
    Inc(x) ;
  End ;
End ;


{---------------------------------------------------------------------------}

Function Hex  ;

Var  x, Chx : Integer ;
     HexStr : String ;

Begin
  HexStr := '' ;
  For x := 1 to 4 Do
  Begin
    Chx := ( w and $F000 ) shr 12 ;
    w := w shl 4 ;
    If Chx < 10 Then
      HexStr := HexStr + (Chr ( Chx + Ord ('0')) )
    Else
      HexStr := HexStr + (Chr ( Chx - 10 + Ord ('A'))) ;
  End ;
  Hex := HexStr ;

End ;


{---------------------------------------------------------------------------}

Procedure WarmBoot ;

Begin

  Inline (184/64/0/142/216/184/52/18/163/114/0/234/0/0/255/255) ;

End ;

{---------------------------------------------------------------------------}

Procedure ColdBoot ;

Begin

  Inline (184/64/0/142/216/184/52/0/163/114/0/234/0/0/255/255) ;

End ;


{---------------------------------------------------------------------------}
Function  UpC(UpString:String) : String;
Var xx : Byte;

Begin
   UpC:=UpString;
   For xx := 1 to Length(UpString) Do
      UpC[xx]:=DUpCase(UpString[xx]);
End ;

{---------------------------------------------------------------------------}

Function DUpCase ;

Begin
  Case UpChr of
    '' :  DUpCase := '' ;
    '' :  DUpCase := '' ;
    '' :  DUpCase := '' ;
  Else
    DUpCase :=UpCase(UpChr);
  End ;

End ;


{---------------------------------------------------------------------------}
Function MakeDir ;

Var
    Dir , S1 ,  S2   : String ;
    x                : Byte ;

Begin

  MakeDir := False ;
  GetDir (0,Dir) ;
  ChDir( Dir[1] + ':\') ;
  S2 := Copy(Namen,4,Length(Namen)-2) ;
  While Length (S2) > 0  Do
  Begin

    If Pos('\',S2) > 0 Then
      S1 := Copy(S2,1,Pos('\',S2) -1)
    Else
      S1 := S2 ;
    Delete ( S2,Pos(S1,S2),Length(S1)+1) ;

    {$I-} MkDir (S1) ; {$I+}

    x := IOResult ;

    If ( x <> 0 ) And ( x <> 5 )  Then
    Begin
      ChDir(Dir) ;
      Exit ;
    End
    Else
      ChDir(S1) ;
  End ;
  ChDir(Dir) ;
  MakeDir := True ;

End ;

{---------------------------------------------------------------------------}
Function  Max(X,Y:LongInt) : LongInt;

Begin

   If X > Y Then
      Max:=X
   Else
      Max:=Y;
End;

{---------------------------------------------------------------------------}
Function  Min(X,Y:LongInt) : LongInt;

Begin

   If X < Y Then
      Min:=X
   Else
      Min:=Y;
End;


{---------------------------------------------------------------------------}

Function LastPos(ch : Char; S : String): Byte;
  { Returns the last position of ch in S or zero if ch not in S }
  Var
    x   : Word;
    len : Byte Absolute S;
  begin
    x := succ(len);
    Repeat
      dec(x);
    Until (x = 0) or (S[x] = ch);
    LastPos := x;
  end;  { LastPos }


{---------------------------------------------------------------------------}
Function Wild(flname,card:String):Boolean;
{Returns True if the wildcard description in 'card' matches 'flname'
according to Dos wildcard principles.  The 'card' String MUST have a period!
Example: Wild('test.tat','t*.t?t' returns True}

Var
   name,temp:String[12];
   c:Char;
   p,i,n,l:Byte;
   period:Boolean;

begin
    wild:=True;
    {test For special Case first}
    if flname='*.*' then Exit;
    wild:=False;
    p:=pos('.',card);
    i:=pos('.',flname);
    if p > 0 then period:=True else Exit; {not a valid wildcard if no period}
    N:=1;
    Repeat
       if card[n]='*' then n:=p-1 else
        if (upCase(flname[n]) <> upCase(card[n])) then
         if card[n]<>'?' then Exit;
                inc(n);
    Until n>=p;
    n:=p+1; {one position past the period of the wild card}
    l:=length(flname);
    inc(i); {one position past the period of the Filename}
    Repeat
    if n > length(card) then Exit;
    c:=upCase(card[n]);
         if c='*' then i:=l+1 {in order to end the loop}
          else
             if (upCase(flname[i]) = c) or (c = '?') then
                begin
                inc(n);
                inc(i);
                end
             else Exit;
    Until i > l;

    wild:=True;

end;

{---------------------------------------------------------------------------}
Function WhatCPU;  Assembler;

        Asm  { Function WhatCPU }
                        MOV            DX,Cpu8086
                        PUSH           SP
                        POP            AX
                        CMP            SP,AX
                        JNE            @OUT
                        MOV            DX,Cpu80286
                        PUSHF
                        POP            AX
                        OR             AX,4000h
                        PUSH           AX
                        POPF
                        PUSHF
                        POP            AX
                        TEST           AX,4000h
                        JE             @OUT
                        MOV            DX,Cpu80386
                        DB 66h; MOV BX,SP
                        DB 66h, 83h, 0E4h, 0FCh
                        DB 66h; PUSHF
                        DB 66h; POP AX
                        DB 66h; MOV CX, AX
                        DB 66h, 35h, 00h
                        DB 00h, 04h, 00
                        DB 66h; PUSH AX
                        DB 66h; POPF
                        DB 66h; PUSHF
                        DB 66h; POP AX
                        DB 66h, 25h,00h
                        DB 00h, 04h,00h
                        DB 66h, 81h,0E1h,00h
                        DB 00h, 04h,00h
                        DB 66h; CMP AX,CX
                        JE @Not486
                        MOV DX, Cpu80486
                @Not486:
                        DB 66h; PUSH CX
                        DB 66h; POPF
                        DB 66h; MOV SP, BX
                @Out:
                        MOV AX, DX
        End;        { Function WhatCPU }

{---------------------------------------------------------------------------}
Procedure CPUSpeed;

        Const
             Processor_cycles: Array[0..4] of Byte = (165,165,25,103,42);

        Var
             Ticks,
             Cycles,
             CPS:                                                                                LongInt;
             Which_CPU:              Word;

        Function i86_to_i286:  Word;  Assembler;

                Asm  { Function i86_to_i286 }
                        CLI
                        MOV                CX,1234
                        XOR                DX,DX
                        XOR                AX,AX
                        MOV                AL,$B8
                        OUT                $43,AL
                        IN                 AL,$61
                        OR                 AL,1
                        OUT                $61,AL
                        XOR                AL,AL
                        OUT                $42,AL
                        OUT                $42,AL
                        XOR                AX,AX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IDIV        CX
                        IN                AL,$42
                        MOV                AH,AL
                        IN                AL,$42
                        XCHG              AL,AH
                        NEG                AX
                        STI
                End;  { Function i86_to_i286 }

        Function i386_to_i486:  Word;        Assembler;

                Asm  { Function i386_to_i486 }
                        CLI
                        MOV                AL,$B8
                        OUT                $43,AL
                        IN                 AL,$61
                        OR                 AL,1
                        OUT                $61,AL
                        XOR                AL,AL
                        OUT                $42,AL
                        OUT                $42,AL
                        DB 66H,$B8,00h,00h,00h,80h;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        DB 66H,0FH,$BC,$C8;
                        IN                AL,42H
                        MOV   AH,AL
                        IN                AL,42H
                        XCHG        AL,AH
                        NEG                AX
                        STI
                End;  { Function i386_to_486 }

        Begin  { Procedure CPUSpd }
                Which_CPU := WhatCPU;
                If Which_cpu < 3 Then
                        Ticks := i86_to_i286
                Else
                        Ticks := i386_to_i486;
                Cycles := 20 * Processor_cycles[Which_CPU];
                CPS := (Cycles * 119318) Div Ticks;
                MHz := CPS Div 100000;
                KHz := (CPS Mod 100000 + 500) Div 1000
        End;  { Procedure CPUSpd }

{---------------------------------------------------------------------------}
Function CheckPrinter ;

Var   Regs :  Registers;
      Taste : Char ;

Begin

  With Regs Do
  Begin
    AH := 02 ;
    DX := PrinterNr-1 ;
    Intr($17,Regs) ;
    If AH = $90 Then
      CheckPrinter := True
    Else
      CheckPrinter := False ;
  End ;

End ;

{---------------------------------------------------------------------------}
{ Beschreibung
   Mit den folgenden Befehlen knnen Ein/Ausgaben von Programmen die ber
   Exec(...) aufgerufen werden in Dateien umgeleitet werden.
   Es gibt 3 verschiedene Aufrufe zum Umleiten der Ein/Ausgabe. Alle
   Funktionen erwarten den umzuleitenden Std-File und

var
   OldHdl                    : word;

begin
   OldHdl := RedirName(StdOut,'t1.fil');
   exec(paramStr(1),'');
   UnRedir(OldHdl);

   OldHdl := RedirName(StdIn,'t1.fil');
   exec('c:\DOS\more.com','');
   UnRedir(OldHdl);

   Alle drei Funktionen geben ein Word zurueck mit dem die Redirection wieder
   aufgehoben werden muss. Wenn eine Redirection nicht aufgehoben wird, so geht
   ein Filehandle fuer das Programm verloren. Bei oefteren Aufruf wird das Prg
   irgendwann wegen zu wenig Filehandles abbrechen.

   UnRedir hebt eine RedirRection wieder auf.

}
{---------------------------------------------------------------------------}
Function  RedirName(ReDirNr:integer;Name:PathStr) : word;

var
   Tmp : file;

begin
   assign(Tmp,Name);
   If ReDirNr=StdOut Then
      rewrite(tmp);
   reset(tmp);
   RedirName := RedirFile(ReDirNr,Tmp);
   close(Tmp);

end;

{---------------------------------------------------------------------------}
Function  RedirFile(ReDirNr:integer;var Datei:File) : word;

Var
   Dup                       : byte;
   R                         : Registers;

begin

   RedirFile := RedirHandle(RedirNr,FileRec(Datei).Handle);

end;

{---------------------------------------------------------------------------}
Function  RedirHandle(ReDirNr:integer; Handle:byte) : word;
var
   Dup                       : byte;
   R                         : Registers;

begin {RedirHandle}
   { StdErr Handle duplizieren. Wir brauchen es nachher wieder }
   R.AH := $45;                             {Duplicate File-Handle}
   R.BX := ReDirNr;
   MsDos(R);
   Dup := R.AX;                             {Stdin/out/err ist gesichert}

   { StdErr verbiegen auf File }
   R.AH := $46;                             {Force Duplicate File-Handle}
   R.BX := Handle;                          {Handle von FIle}
   R.CX := ReDirNr;                         {Stdin/out/err}
   MsDos(r);

   RedirHandle :=  (RedirNr shl 8) or Dup;

end;

{---------------------------------------------------------------------------}
Procedure UnRedir(RedirInfo:word);
var
   R                         : Registers;
   OldFile                   : byte;
   RedirFile                 : byte;
begin {UnRedir}

   RedirFile := hi(ReDirInfo);
   OldFile := lo(RedirInfo);

   R.AH := $46;                             {Force Duplicate Handle}
   R.BX := OldFile;                         {Gesicherter StdErr}
   R.CX := ReDirFile;                       {StdIn/Out/Err}
   MsDos(R);

   { DUplizierten Handle schliessen}
   R.AH := $3E;                             {Close Handle}
   R.BX := OldFile;                         {gesicherter Stdin/out/err}
   MsDos(R);

end;

{---------------------------------------------------------------------------}
Procedure CursorOff;
Begin
 With Register do
  Begin
   if ScrMode = 7 then
    CX := $3000
   else
    CX := $2000;
    AX := $0100;
   End;
  intr($10,Register);
End;
{---------------------------------------------------------------------------}
Procedure CursorNorm;
Begin
 With Register do
  Begin
   if ScrMode = 7 then
    CX := $0B0C
  else
    CX := $0607;
    AX := $0100;
  End;
   intr($10,Register);
End;
{---------------------------------------------------------------------------}
Procedure CursorBlock;
Begin
 With Register do
  Begin
   if ScrMode = 7 then
    CX := $000C
  else
    CX := $0007;
    AX := $0100;
  End;
   intr($10,Register);
End;
{---------------------------------------------------------------------------}
Function CursorSize:Word;
Var
 Regs : Registers;
 Temp : Word;
 begin
   With Regs do
    begin
      AH := $0F;
      Intr($10,Regs);
      AH := $03;
      Intr($10,Regs);
      CursorSize := CX;
     end;
  end;
{---------------------------------------------------------------------------}
Procedure GetKey(Var Ch2:S2);
(* diese Prozedur liefert in ch2 einen 2-Byte-Tastaturkode zurueck *)
begin
  if KeyPressed then Ch2[1] := ReadKey
   else Ch2[1] := #0;
  if KeyPressed then Ch2[2] := ReadKey
   else Ch2[2] := #0;
end;
{---------------------------------------------------------------------------}
Procedure ReadScrPart(x1,y1,x2,y2:Byte);
Var
 tempBase : ^Byte;
 length   : Integer;
 Position : Integer;
 y        : Integer;
  Begin
   dec(y1);
   dec(x1);
     length := (x2-x1) shl 1;
      for y := y1 to y2 do
       Begin
        TempBase := ptr(seg(ScrBase^),(y*160)+(x1*2));
        Position := (y-y1) * length + WindBuffs;
        Move(TempBase^,IntScreen^[Position],length);
       End;
     WindBuffS := WindBuffS + (length * (y2 - y1 + 1) + 4);
   End;

Function ScrMode:Byte;
  Begin
    Register.AH := $0F;
    Intr($10,Register);
    ScrMode := Register.AL;
  End;

Procedure SetCursorSize(OldCursor:Word);
Var
 Regs : Registers;
 begin
  With Regs do
   begin
    AH := $01;
    CX := OldCursor;
    Intr($10,Regs);
   end;
 end;
{---------------------------------------------------------------------------}
Procedure WriteScrPart(x1,y1,x2,y2:Byte);
Var
 tempBase : ^Byte;
 length   : Integer;
 Position : Integer;
 y        : Integer;
 Begin
  dec(y1);
  dec(x1);
   length := (x2-x1) shl 1;
   WindBuffS := WindBuffS - (length * (y2 - y1 + 1) + 4);
   for y := y1 to y2 do
     Begin
      TempBase := ptr(seg(ScrBase^),(y*160)+(x1*2));
      Position := (y-y1) * length + WindBuffS;
      Move(IntScreen^[Position],TempBase^,length);
     End;
  End;
{---------------------------------------------------------------------------}
begin
 If ScrMode  = 7 Then 
    ScrBase:=Ptr($b000,0)
  Else 
    ScrBase := Ptr($b800,0);
  New(Intscreen);
end.
