
;----------------------------------------------------
;
;       CONTROL -- remotely control a PC across
;       a NetWare (IPX) LAN. (see SLAVE.ASM)
;
;       Version 1.0
;
;       (c) 1990 Barry Nance
;
;----------------------------------------------------

                DOSSEG
                .MODEL small

StdIn           =       0000
StdOut          =       0001
StdErr          =       0002

OPEN_SOCKET             =       00h
CLOSE_SOCKET            =       01h
GET_LOCAL_TARGET        =       02h
SEND_PACKET             =       03h
LISTEN_FOR_PACKET       =       04h
SCHEDULE_EVENT          =       05h
CANCEL_EVENT            =       06h
GET_INTERVAL_MARKER     =       08h
GET_INTERNETWORK_ADDRESS =      09h
RELINQUISH_CONTROL      =       0Ah
DISCONNECT              =       0Bh

ECB             Struc
                DD      ?
 ESR_Address    DD      ?
 In_Use_Flag    DB      ?
 Return_Code    DB      ?
 Socket_Number  DW      ?
                DB      16 Dup(?)
 Immediate_Addr DB      6 Dup(?)
 Packet_Count   DW      ?
 Packet1_Addr   DD      ?
 Packet1_Size   DW      ?
 Packet2_Addr   DD      ?
 Packet2_Size   DW      ?
ECB             EndS

IPX_Header      Struc
 Checksum       DW      ?
 Len            DW      ?
 Trans_Control  DB      ?
 Packet_Type    DB      ?
 Dest_Network   DB      4 Dup(?)
 Dest_Node      DB      6 Dup(?)
 Dest_Socket    DW      ?
 Source_Network DB      4 Dup(?)
 Source_Node    DB      6 Dup(?)
 Source_Socket  DW      ?
IPX_Header      EndS

                .DATA

send_ecb        ECB     <>
recv_ecb        ECB     <>
send_header     IPX_Header <>
recv_header     IPX_Header <>

Msg2            DB      "Looking for SLAVE -- Press ESC to quit."
                DB      13, 10
Msg2Len         =       $-Msg2

Msg3            DB      "Early versions of DOS not supported."
                DB      13, 10
Msg3Len         =       $-Msg3

Msg4            DB      "ERROR--IPX not active."
                DB      13, 10
Msg4Len         =       $-Msg4

Msg5            DB      "Missing or invalid User ID."
                DB      13, 10
Msg5Len         =       $-Msg5

Msg6            DB      "ERROR -- SLAVE not found."
                DB      13, 10
Msg6Len         =       $-Msg6

Msg8            DB      13, 10, 13, 10
                DB      "CONTROL program finished."
                DB      13, 10
Msg8Len         =       $-Msg8

dos_major       DB      0
dos_minor       DB      0
PSP             DW      0

EGAFlagPtr      Label   DWord
EGAFlagOfs      DW      0487h
EGAFlagSeg      DW      0

VideoPtr        Label   DWord
VideoOfs        DW      0
VideoSeg        DW      0

Done            DB      1
LocSave         DW      0
ShapeSave       DW      0

Screen_Data     Label   Byte
  ScreenPos     DW      0
  CursorShape   DW      0
  CursorLoc     DW      0
  Head2         DW      0
  ScreenPkt     DB      500 Dup(0)

Kbd_Data        Label   Byte
  KbdFlag1      DB      0
  KbdFlag2      DB      0
  AltInput      DB      0
  Sess_Flag     DW      0
  Tail          DW      0
  KbdBuffer     DW      16 Dup(0)

Connection_Rqst Label   Byte
  RequestLen1   DW      53
  SubFunction   DB      15h
  ObjType       DW      0100h
  ObjNameLen    DB      48
  ObjName       DB      48 Dup(0)

Connection_Reply Label  Byte
  ReplyLen1     DW      101
  NumberConnect DB      0
  ConnectNum    DB      100 Dup(0)

Internet_Rqst   Label   Byte
  RequestLen2   DW      2
  SubFunction2  DB      13h
  ConnectNumber DB      0

Internet_Reply  Label   Byte
  ReplyLen2     DW      12
  NetworkNumber DB      4 Dup(0)
  NodeAddress   DB      6 Dup(0)
  SocketNumber  DW      0

GetLocalRqst    Label   Byte
  LocalNetwork  DB      4 Dup(0)
  LocalNode     DB      6 Dup(0)
  LocalSocket   DW      0

                .STACK 200h
                .CODE
scan_code       DB      0
In_Int10        DB      0

IPX             Label   DWord
IPX_ofs         DW      0
IPX_seg         DW      0

oldint09        Label   DWord
oldint09_ofs    DW      0
oldint09_seg    DW      0

oldint10        Label   DWord
oldint10_ofs    DW      0
oldint10_seg    DW      0

SS_Save1        DW      0
SP_Save1        DW      0
StackSeg1       DW      0
StackOfs1       DW      0

                DW      256 Dup(0)
OurStack1       DW      0

SS_Save2        DW      0
SP_Save2        DW      0
StackSeg2       DW      0
StackOfs2       DW      0

                DW      256 Dup(0)
OurStack2       DW      0

;---------------------------------------

                Assume  CS:_TEXT, DS:_DATA, ES:Nothing

Cancel_Recv     Proc    Near
                push    ds
                pop     es
                mov     bx, CANCEL_EVENT
                mov     si, offset recv_ecb
                call    cs:IPX
                ret
Cancel_Recv     EndP


;
;       enter Receive with:
;       DX:AX - address of buffer
;       CX    - number of bytes to receive
;       BP:BX - address of ESR routine
;

Recv_Msg        Proc    Near
                push    ds
                pop     es
                mov     word ptr recv_ecb.ESR_Address+2, bp
                mov     word ptr recv_ecb.ESR_Address, bx
                mov     recv_ecb.Socket_Number, 6161h
                mov     recv_ecb.Packet_Count, 2
                mov     recv_ecb.Packet1_Size, 30
                mov     bx, offset recv_header
                mov     word ptr recv_ecb.Packet1_Addr+2, dx
                mov     word ptr recv_ecb.Packet1_Addr, bx
                mov     recv_ecb.Packet2_Size, CX
                mov     word ptr recv_ecb.Packet2_Addr+2, dx
                mov     word ptr recv_ecb.Packet2_Addr, ax
                mov     bx, LISTEN_FOR_PACKET
                mov     si, offset recv_ecb
                call    cs:IPX
                ret
Recv_Msg        EndP

;---------------------------------------

;
;       enter Send with:
;       DX:AX - address of buffer
;       CX    - number of bytes to send
;       BP:BX - address of ESR routine
;       DI    - destination socket
;

Send_Msg        Proc    Near
                push    ds
                pop     es
                mov     word ptr send_ecb.ESR_Address+2, bp
                mov     word ptr send_ecb.ESR_Address, bx
                mov     send_ecb.Socket_Number, 6161h
                mov     send_ecb.Packet_Count, 2
                mov     send_ecb.Packet1_Size, 30
                mov     bx, offset send_header
                mov     word ptr send_ecb.Packet1_Addr+2, dx
                mov     word ptr send_ecb.Packet1_Addr, bx
                mov     send_ecb.Packet2_Size, CX
                mov     word ptr send_ecb.Packet2_Addr+2, dx
                mov     word ptr send_ecb.Packet2_Addr, ax

                mov     send_header.Dest_Socket, di

                mov     cx, 6
                mov     si, offset NetworkNumber
                mov     di, offset GetLocalRqst
        rep     movsw
                mov     si, offset GetLocalRqst
                mov     di, offset send_ecb.Immediate_Addr
                mov     bx, GET_LOCAL_TARGET
                call    cs:IPX

                mov     send_header.Packet_Type, 4
                mov     cx, 5
                mov     si, offset NetworkNumber
                mov     di, offset send_header.Dest_Network
        rep     movsw

                mov     bx, SEND_PACKET
                mov     si, offset send_ecb
                call    cs:IPX
                ret
Send_Msg        EndP

;---------------------------------------

                Assume  CS:_TEXT, DS:Nothing, ES:Nothing

Int_09:         sti
                push    ax

I9_get_scan:    in      al, 60h
                mov     cs:scan_code, al
                pop     ax

I9_chain_old:   pushf
                cli
                call    cs:oldint09

                cli
                mov     cs:SS_Save1, ss
                mov     cs:SP_Save1, sp
                mov     ss, cs:StackSeg1
                mov     sp, cs:StackOfs1
                sti

I9_save_regs:   push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax
                cld

ChkCtrl5:       mov     ax, 0040h
                mov     es, ax
                test    byte ptr es:[0017h], 04h    ; Ctrl
                jz      NotCtrl5
                cmp     cs:scan_code, 4Ch           ; Center 5
                je      SayToQuit

NotCtrl5:       jmp     I9_SendKbd

SayToQuit:      mov     Done, 1

I9_ChkLastSend: cmp     send_ecb.In_Use_Flag, 0
                je      BldLastBlk
                mov     bx, RELINQUISH_CONTROL
                call    cs:IPX
                jmp     I9_ChkLastSend

BldLastBlk:     mov     Sess_Flag, -1
                mov     dx, ds
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, 0
                mov     bx, 0
                mov     di, 6262h
                call    Send_Msg

GotoExit:       jmp     Int09Exit


I9_SendKbd:     cmp     Done, 0
                je      Chk_Changed

                jmp     Int09Exit

Chk_Changed:    mov     ax, 0040h
                mov     es, ax

                mov     al, es:[0017h]
                cmp     al, KbdFlag1
                jne     I9_Send_It

                mov     al, es:[0018h]
                cmp     al, KbdFlag2
                jne     I9_Send_It

                mov     ax, es:[001Ch]
                cmp     ax, Tail
                jne     I9_Send_It

                jmp     short Int09Exit

I9_Send_It:     cmp     send_ecb.In_Use_Flag, 0
                jne     GotoExit

I9_SaveKbd:     push    ds
                pop     es
                mov     ax, 0040h
                mov     ds, ax
                mov     si, 0017h
                mov     di, offset Kbd_Data
                mov     cx, 39
        rep     movsb
                push    es
                pop     ds
                mov     Sess_Flag, 0

                mov     dx, ds
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, 0
                mov     bx, 0
                mov     di, 6262h
                call    Send_Msg

Int09Exit:      Assume  CS:_TEXT, DS:Nothing
                pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

I9_Sw_Stack2:   cli
                mov     ss, cs:SS_Save1
                mov     sp, cs:SP_Save1

                iret

;---------------------------------------

Int_10:         mov     cs:In_Int10, 1
                pushf
                call    cs:OldInt10
                mov     cs:In_Int10, 0
                iret

;---------------------------------------

ScreenRecv:     mov     cs:SS_Save2, ss
                mov     cs:SP_Save2, sp
                mov     ss, cs:StackSeg2
                mov     sp, cs:StackOfs2

                sti
                cld
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax

                cmp     Done, 0
                je      Chk_RetCode

                jmp     ScreenRecvExit

Chk_RetCode:    cmp     recv_ecb.Return_Code, 0
                je      EchoScreen

                jmp     RecvScreen2

EchoScreen:     les     di, VideoPtr
                add     di, ScreenPos
                mov     si, offset ScreenPkt
                mov     cx, 250
        rep     movsw

CheckIn10:      cmp     cs:In_Int10, 1
                je      Set_Head

CheckShape:     mov     cx, CursorShape
                cmp     cx, ShapeSave
                je      CheckLocation
                mov     ShapeSave, cx
                mov     ah, 1
                int     10h

CheckLocation:  mov     dx, CursorLoc
                cmp     dx, LocSave
                je      Set_Head
                mov     LocSave, dx
                mov     bh, 0
                mov     ah, 2
                int     10h

Set_Head:       mov     ax, 0040h
                mov     es, ax
                cli
                mov     ax, Head2
                mov     word ptr es:[001Ah], ax
                sti

RecvScreen2:    mov     dx, ds
                mov     ax, offset Screen_Data
                mov     cx, 508
                mov     bp, cs
                mov     bx, offset ScreenRecv
                call    Recv_Msg

ScreenRecvExit: Assume  CS:_TEXT, DS:Nothing
                pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

                cli
                mov     ss, cs:SS_Save2
                mov     sp, cs:SP_Save2
                sti

                retf

;---------------------------------------

Start:          Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax
                mov     PSP, es

                mov     ax, cs
                mov     cs:StackSeg1, ax
                mov     ax, offset OurStack1
                mov     cs:StackOfs1, ax

                mov     ax, cs
                mov     cs:StackSeg2, ax
                mov     ax, offset OurStack2
                mov     cs:StackOfs2, ax

get_dos_vers:   mov     ax, 3000h
                int     21h
                mov     dos_major, al
                mov     dos_minor, ah
                cmp     al, 2
                ja      ipx_test

wrong_dos:      mov     bx, 2
                mov     dx, offset Msg3
                mov     cx, Msg3Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

ipx_test:       mov     ax, 07A00h
                int     2Fh
                cmp     al, 0FFh
                jne     no_ipx
                mov     cs:IPX_ofs, di
                mov     cs:IPX_seg, es
                jmp     short bw_or_color

no_ipx:         mov     bx, 2
                mov     dx, offset Msg4
                mov     cx, Msg4Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

bw_or_color:    mov     ah, 0Fh
                int     10h
                Cmp     AL, 7
                JE      SetMono
                Jmp     LookFurther

SetMono:        Mov     VideoSeg, 0B000h
                Mov     VideoOfs, 0000
                Jmp     LookForSlave

LookFurther:    Mov     bx, 0FF10h
                Mov     ah, 12h
                Int     10h
                Test    bh, 0FEh
                JZ      EGAPresent
                Jmp     SetCGA

EGAPresent:     LES     BX, EGAFlagPtr
                Mov     AL, Byte Ptr ES:[BX]
                Test    AL, 00000101b
                JNZ     SetCGA
                Test    AL, 00000100b
                JNZ     SetMono
                Test    AL, 00000001b
                JNZ     SetMono

EGAIsActive:    Mov     VideoSeg, 0B800h
                Mov     VideoOfs, 0000
                Jmp     LookForSlave

SetCGA:         Mov     VideoSeg, 0B800h
                Mov     VideoOfs, 0000
                Jmp     LookForSlave

CmdLineError:   mov     bx, 2
                mov     dx, offset Msg5
                mov     cx, Msg5Len
                mov     ah, 40h
                int     21h
                jmp     prog_exit

LookForSlave:   Mov     es, PSP
                Mov     di, 0081h
                Mov     bx, 0
                Mov     cx, 0
                Mov     cl, es:[0080h]
                JCXZ    CmdLineError

FindStart:      Cmp     byte ptr es:[di], ' '
                Jne     CmdLineByte
                Inc     di
                Dec     cx
                JCXZ    CmdLineError
                Jmp     FindStart

CmdLineByte:    Mov     al, es:[di]
                Cmp     al, 13
                Je      GetAddress
                Cmp     al, ' '
                Je      GetAddress
                Mov     ObjName [bx], al
                Inc     di
                Inc     bx
                Dec     cx
                JCXZ    GetAddress
                Jmp     CmdLineByte

GetAddress:     Push    ds
                Pop     es
                Mov     si, offset Connection_Rqst
                Mov     di, offset Connection_Reply
                Mov     ah, 0E3h
                Int     21h
                Cmp     NumberConnect, 0
                JE      CmdLineError

                Mov     al, ConnectNum
                Mov     ConnectNumber, al
                Mov     si, offset Internet_Rqst
                Mov     di, offset Internet_Reply
                Mov     ah, 0E3h
                Int     21h
                mov     SocketNumber, 6262h

open_a_socket:  mov     bx, OPEN_SOCKET
                mov     al, 0FFh
                mov     dx, 6161h
                call    cs:IPX
                cmp     al, 0
                je      say_hello
                jmp     prog_exit

say_hello:      mov     bx, 2
                mov     dx, offset Msg2
                mov     cx, Msg2Len
                mov     ah, 40h
                int     21h

Ping_Slave:     mov     dx, ds
                mov     ax, offset Screen_Data
                mov     cx, 8
                mov     bp, 0
                mov     bx, 0
                call    Recv_Msg

                mov     Sess_Flag, 1
                mov     dx, ds
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, 0
                mov     bx, 0
                mov     di, 6262h
                call    Send_Msg

Wait_Ping:      cmp     recv_ecb.In_Use_Flag, 0
                je      Pinged_Back
                mov     ah, 1
                int     16h
                jnz     Test_Esc
                mov     bx, RELINQUISH_CONTROL
                call    cs:IPX
                jmp     Wait_Ping
Test_Esc:       mov     ah, 0
                int     16h
                cmp     al, 27
                jne     Wait_Ping

Ping_Error:     mov     bx, 2
                mov     dx, offset Msg6
                mov     cx, Msg6Len
                mov     ah, 40h
                int     21h
                mov     bx, CLOSE_SOCKET
                mov     al, 0FFh
                mov     dx, 6161h
                call    cs:IPX
                jmp     prog_exit

Pinged_Back:    cmp     recv_ecb.Return_Code, 0
                jne     Ping_Error

ChkPing:        cmp     ScreenPos, -1
                jne     Ping_Error

RecvScreen:     mov     dx, ds
                mov     ax, offset Screen_Data
                mov     cx, 508
                mov     bp, cs
                mov     bx, offset ScreenRecv
                call    Recv_Msg

ResetKBD:       mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax

save_int9:      mov     ax, 3509h
                int     21h
                mov     cs:oldint09_seg, ES
                mov     cs:oldint09_ofs, BX

save_int10:     mov     ax, 3510h
                int     21h
                mov     cs:oldint10_seg, ES
                mov     cs:oldint10_ofs, BX

install_int9:   push    ds
                mov     dx, offset Int_09
                push    cs
                pop     ds
                mov     ax, 2509h
                int     21h
                pop     ds

install_int10:  push    ds
                mov     dx, offset Int_10
                push    cs
                pop     ds
                mov     ax, 2510h
                int     21h
                pop     ds

                mov     Done, 0
while_not_done: cmp     Done, 0
                je      while_not_done

deinstall_int9: push    ds
                mov     dx, cs:oldint09_ofs
                mov     ds, cs:oldint09_seg
                mov     ax, 2509h
                int     21h
                pop     ds

deinstall_10:   push    ds
                mov     dx, cs:oldint10_ofs
                mov     ds, cs:oldint10_seg
                mov     ax, 2510h
                int     21h
                pop     ds

ResetKBD2:      mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax

CnclRecv:       call    Cancel_Recv

                mov     bx, CLOSE_SOCKET
                mov     al, 0FFh
                mov     dx, 6161h
                call    cs:IPX

prog_exit:      mov     bx, 2
                mov     dx, offset Msg8
                mov     cx, Msg8Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

                End     Start


