
;----------------------------------------------------
;
;       SLAVE -- allow another PC (on a NetWare LAN)
;       to control this one.  (see CONTROL.ASM)
;
;       Version 1.0
;
;       (c) 1990 Barry Nance
;
;----------------------------------------------------

                DOSSEG
                .MODEL small

StdIn           =       0000
StdOut          =       0001
StdErr          =       0002


OPEN_SOCKET             =       00h
CLOSE_SOCKET            =       01h
GET_LOCAL_TARGET        =       02h
SEND_PACKET             =       03h
LISTEN_FOR_PACKET       =       04h
SCHEDULE_EVENT          =       05h
CANCEL_EVENT            =       06h
GET_INTERVAL_MARKER     =       08h
GET_INTERNETWORK_ADDRESS =      09h
RELINQUISH_CONTROL      =       0Ah
DISCONNECT              =       0Bh

ECB             Struc
                DD      ?
 ESR_Address    DD      ?
 In_Use_Flag    DB      ?
 Return_Code    DB      ?
 Socket_Number  DW      ?
                DB      16 Dup(?)
 Immediate_Addr DB      6 Dup(?)
 Packet_Count   DW      ?
 Packet1_Addr   DD      ?
 Packet1_Size   DW      ?
 Packet2_Addr   DD      ?
 Packet2_Size   DW      ?
ECB             EndS

IPX_Header      Struc
 Checksum       DW      ?
 Len            DW      ?
 Trans_Control  DB      ?
 Packet_Type    DB      ?
 Dest_Network   DB      4 Dup(?)
 Dest_Node      DB      6 Dup(?)
 Dest_Socket    DW      ?
 Source_Network DB      4 Dup(?)
 Source_Node    DB      6 Dup(?)
 Source_Socket  DW      ?
IPX_Header      EndS

                .DATA
EGAFlagPtr      Label   DWord
EGAFlagOfs      DW      0487h
EGAFlagSeg      DW      0

Msg1            DB      "SLAVE is now waiting for CONTROL to make contact."
                DB      13, 10
Msg1Len         =       $-Msg1

Msg2            DB      "Early versions of DOS not supported."
                DB      13, 10
Msg2Len         =       $-Msg2

Msg4            DB      "ERROR--IPX not active."
                DB      13, 10
Msg4Len         =       $-Msg4

                .STACK 200h
                .CODE

;---------------------------------------
send_ecb        ECB     <>
recv_ecb        ECB     <>
send_header     IPX_Header <>
recv_header     IPX_Header <>

our_psp         DW      0
dos_major       DB      0
dos_minor       DB      0
SessionActive   DB      0
InInt8          DB      0

IPX             Label   DWord
IPX_ofs         DW      0
IPX_seg         DW      0

oldint08        Label   DWord
oldint08_ofs    DW      0
oldint08_seg    DW      0

VideoPtr        Label   DWord
VideoOfs        DW      0
VideoSeg        DW      0
ScreenSave      DB      4000 Dup(0)

Screen_Data     Label   Byte
  ScreenPos     DW      0
  CursorShape   DW      0
  CursorLoc     DW      0
  Head2         DW      0
  ScreenPkt     DB      500 Dup(0)

Kbd_Data        Label   Byte
  KbdFlag1      DB      0
  KbdFlag2      DB      0
  AltInput      DB      0
  Sess_Flag     DW      0
  Tail          DW      0
  KbdBuffer     DW      16 Dup(0)

QuadrantCounter DW      0
Quadrant        DW      8
Quadrant_Ofs    DW      0

SS_Save1        DW      0
SP_Save1        DW      0
StackSeg1       DW      0
StackOfs1       DW      0

                DW      256 Dup(0)
OurStack1       DW      0

SS_Save2        DW      0
SP_Save2        DW      0
StackSeg2       DW      0
StackOfs2       DW      0

                DW      256 Dup(0)
OurStack2       DW      0

;---------------------------------------

                Assume  CS:_TEXT, DS:_TEXT, ES:Nothing

;
;       enter Receive with:
;       DX:AX - address of buffer
;       CX    - number of bytes to receive
;       BP:BX - address of ESR routine
;

Recv_Msg        Proc    Near
                push    ds
                pop     es
                mov     word ptr recv_ecb.ESR_Address+2, bp
                mov     word ptr recv_ecb.ESR_Address, bx
                mov     recv_ecb.Socket_Number, 6262h
                mov     recv_ecb.Packet_Count, 2
                mov     recv_ecb.Packet1_Size, 30
                mov     bx, offset recv_header
                mov     word ptr recv_ecb.Packet1_Addr+2, dx
                mov     word ptr recv_ecb.Packet1_Addr, bx
                mov     recv_ecb.Packet2_Size, CX
                mov     word ptr recv_ecb.Packet2_Addr+2, dx
                mov     word ptr recv_ecb.Packet2_Addr, ax
                mov     bx, LISTEN_FOR_PACKET
                mov     si, offset recv_ecb
                call    cs:IPX
                ret
Recv_Msg        EndP

;---------------------------------------

;
;       enter Send with:
;       DX:AX - address of buffer
;       CX    - number of bytes to send
;       BP:BX - address of ESR routine
;       DI    - destination socket
;

Send_Msg        Proc    Near
                push    ds
                pop     es
                mov     word ptr send_ecb.ESR_Address+2, bp
                mov     word ptr send_ecb.ESR_Address, bx
                mov     send_ecb.Socket_Number, 6262h
                mov     send_ecb.Packet_Count, 2
                mov     send_ecb.Packet1_Size, 30
                mov     bx, offset send_header
                mov     word ptr send_ecb.Packet1_Addr+2, dx
                mov     word ptr send_ecb.Packet1_Addr, bx
                mov     send_ecb.Packet2_Size, CX
                mov     word ptr send_ecb.Packet2_Addr+2, dx
                mov     word ptr send_ecb.Packet2_Addr, ax

                mov     send_header.Dest_Socket, di

                mov     cx, 3
                mov     si, offset recv_ecb.Immediate_Addr
                mov     di, offset send_ecb.Immediate_Addr
        rep     movsw

                mov     send_header.Packet_Type, 4
                mov     cx, 5
                mov     si, offset recv_header.Source_Network
                mov     di, offset send_header.Dest_Network
        rep     movsw

                mov     bx, SEND_PACKET
                mov     si, offset send_ecb
                call    cs:IPX
                ret
Send_Msg        EndP

                Assume  CS:_TEXT, DS:Nothing, ES:Nothing

Int_08:         pushf
                call    cs:oldint08

I8_Sw_Stack1:   mov     cs:SS_Save1, ss
                mov     cs:SP_Save1, sp
                mov     ss, cs:StackSeg1
                mov     sp, cs:StackOfs1

                sti
                cld

I8_save_regs:   push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_TEXT
                mov     ax, cs
                mov     ds, ax

                mov     QuadrantCounter, 0

I8_Semaphore:   Cmp     InInt8, 0
                JE      I8_Sess_Switch

                Jmp     I8_RestoreRegs

I8_Sess_Switch: cmp     SessionActive, 1
                je      I8_ChkHotIRQs

br_to_exit:     jmp     Int08Exit

I8_ChkHotIRQs:  mov     InInt8, 1
                Mov     AL, 0bh
                Out     20h, AL
                In      AL, 20h
                Cmp     AL, 0
                JE      I8_ChkScreen

                Jmp     Int08Exit

I8_ChkScreen:   cmp     send_ecb.In_Use_Flag, 0
                jne     br_to_exit

Next_Quadrant:  inc     Quadrant
                add     Quadrant_Ofs, 500
                cmp     Quadrant, 9
                jne     ChkThisSection

                mov     Quadrant, 1
                mov     Quadrant_Ofs, 0

ChkThisSection: les     di, VideoPtr
                mov     ax, Quadrant_Ofs
                mov     si, offset ScreenSave
                add     si, ax
                add     di, ax
                mov     cx, 250
        repe    cmpsw
                jne     I8_SaveScreen

                inc     QuadrantCounter
                cmp     QuadrantCounter, 8
                je      ChkShape
                jmp     I8_ChkScreen

ChkShape:       mov     ax, 0040h
                mov     es, ax
                mov     ax, word ptr es:[0060h]
                cmp     ax, CursorShape
                jne     I8_SaveScreen

                mov     ax, word ptr es:[0050h]
                cmp     ax, CursorLoc
                jne     I8_SaveScreen

                jmp     Int08Exit

I8_SaveScreen:  push    cs
                pop     es
                mov     ax, Quadrant_Ofs
                mov     di, offset ScreenSave
                lds     si, VideoPtr
                add     si, ax
                add     di, ax
                mov     cx, 250
        rep     movsw
                push    cs
                pop     ds

I8_BldPacket:   mov     ax, Quadrant_Ofs
                mov     ScreenPos, ax
                mov     ax, 0040h
                mov     es, ax
                mov     ax, word ptr es:[0060h]
                mov     CursorShape, ax
                mov     ax, word ptr es:[0050h]
                mov     CursorLoc, ax
                mov     ax, word ptr es:[001Ah]
                mov     Head2, ax

                mov     ax, cs
                mov     es, ax
                mov     si, offset ScreenSave
                add     si, Quadrant_Ofs
                mov     di, offset ScreenPkt
                mov     cx, 250
        rep     movsw

I8_SendScreen:  mov     dx, cs
                mov     ax, offset Screen_Data
                mov     cx, 508
                mov     bp, 0
                mov     bx, 0
                mov     di, 6161h
                call    Send_Msg

Int08Exit:      mov     InInt8, 0

I8_RestoreRegs: pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

I8_Sw_Stack2:   cli
                mov     ss, cs:SS_Save1
                mov     sp, cs:SP_Save1

                iret

                Assume  CS:_TEXT, DS:Nothing

;---------------------------------------

Kbd_Receive:    mov     cs:SS_Save2, ss
                mov     cs:SP_Save2, sp
                mov     ss, cs:StackSeg2
                mov     sp, cs:StackOfs2

                sti
                cld
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_TEXT
                mov     ax, cs
                mov     ds, ax

Chk_RetCode:    cmp     recv_ecb.Return_Code, 0
                je      ChkDone

                jmp     KR_RecvKbd

ChkDone:        cmp     Sess_Flag, -1
                je      KR_CloseSess

                cmp     Sess_Flag, 1
                je      KR_OpenSess

                jmp     KR_StuffBuffer

KR_CloseSess:   mov     SessionActive, 0
                mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax
                jmp     KR_RecvKbd

KR_OpenSess:    mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax

KR_ResetScrn:   mov     di, offset ScreenSave
                mov     ax, 0
                mov     cx, 2000
        rep     stosw
                mov     CursorShape, 0
                mov     CursorLoc, 0

PingBack:       mov     ScreenPos, -1
                mov     dx, cs
                mov     ax, offset Screen_Data
                mov     cx, 8
                mov     bp, 0
                mov     bx, 0
                mov     di, 6161h
                call    Send_Msg

KR_WaitCplt:    cmp     send_ecb.In_Use_Flag, 0
                je      MakeActive
                mov     bx, RELINQUISH_CONTROL
                call    cs:IPX
                jmp     KR_WaitCplt

MakeActive:     mov     SessionActive, 1
                jmp     KR_RecvKbd

KR_StuffBuffer: mov     ax, 0040h
                mov     es, ax
                cli
                mov     al, KbdFlag1
                mov     byte ptr es:[0017h], al
                mov     al, KbdFlag2
                mov     byte ptr es:[0018h], al
                mov     al, AltInput
                mov     byte ptr es:[0019h], al
                mov     ax, Tail
                mov     word ptr es:[001Ch], ax
                mov     di, 001Eh
                mov     si, offset KbdBuffer
                mov     cx, 16
        rep     movsw
                sti

KR_RecvKbd:     mov     dx, cs
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, cs
                mov     bx, offset Kbd_Receive
                call    Recv_Msg

                Assume  CS:_TEXT, DS:Nothing
Kbd_Exit:       pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

                cli
                mov     ss, cs:SS_Save2
                mov     sp, cs:SP_Save2
                sti

                retf

;---------------------------------------

EndResident     Label   Byte
                DB      0

;---------------------------------------

Start:          Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax
                mov     cs:our_psp, es

                mov     ax, cs
                mov     cs:StackSeg1, ax
                mov     ax, offset OurStack1
                mov     cs:StackOfs1, ax

                mov     ax, cs
                mov     cs:StackSeg2, ax
                mov     ax, offset OurStack2
                mov     cs:StackOfs2, ax

save_int8:      mov     ax, 3508h
                int     21h
                mov     cs:oldint08_seg, ES
                mov     cs:oldint08_ofs, BX

get_dos_vers:   mov     ax, 3000h
                int     21h
                mov     cs:dos_major, al
                mov     cs:dos_minor, ah
                cmp     al, 2
                ja      ipx_test

wrong_dos:      mov     bx, 2
                mov     dx, offset Msg2
                mov     cx, Msg2Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

ipx_test:       mov     ax, 07A00h
                int     2Fh
                cmp     al, 0FFh
                jne     no_ipx
                mov     cs:IPX_ofs, di
                mov     cs:IPX_seg, es
                jmp     short bw_or_color

no_ipx:         mov     bx, 2
                mov     dx, offset Msg4
                mov     cx, Msg4Len
                mov     ah, 40h
                int     21h

prog_exit:      mov     ax, 4C00h
                int     21h

bw_or_color:    mov     ah, 0Fh
                int     10h
                Cmp     AL, 7
                JE      SetMono
                Jmp     LookFurther

SetMono:        Mov     cs:VideoSeg, 0B000h
                Mov     cs:VideoOfs, 0000
                Jmp     open_a_socket

LookFurther:    Mov     bx, 0FF10h
                Mov     ah, 12h
                Int     10h
                Test    bh, 0FEh
                JZ      EGAPresent
                Jmp     SetCGA

EGAPresent:     LES     BX, EGAFlagPtr
                Mov     AL, Byte Ptr ES:[BX]
                Test    AL, 00000101b
                JNZ     SetCGA
                Test    AL, 00000100b
                JNZ     SetMono
                Test    AL, 00000001b
                JNZ     SetMono

EGAIsActive:    Mov     cs:VideoSeg, 0B800h
                Mov     cs:VideoOfs, 0000
                Jmp     open_a_socket

SetCGA:         Mov     cs:VideoSeg, 0B800h
                Mov     cs:VideoOfs, 0000

open_a_socket:  mov     bx, OPEN_SOCKET
                mov     al, 0FFh
                mov     dx, 6262h
                call    cs:IPX
                cmp     al, 0
                je      install_int8
                jmp     prog_exit

install_int8:   push    ds
                mov     dx, offset Int_08
                push    cs
                pop     ds
                mov     ax, 2508h
                int     21h
                pop     ds

say_hello:      mov     bx, 2
                mov     dx, offset Msg1
                mov     cx, Msg1Len
                mov     ah, 40h
                int     21h

First_Recv:     mov     dx, cs
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, cs
                mov     bx, offset Kbd_Receive
                call    Recv_Msg

issue_tsr:      Mov     AX, cs
                Sub     AX, cs:our_psp
                Mov     BX, Offset EndResident
                Mov     CX, 4
                Shr     BX, CL
                Inc     BX
                Add     AX, BX
                Mov     DX, AX
                Mov     AH, 31h
                Int     21h

                End     Start


