unit ipx;
{$A-,R-}

{-------------------------------------------}
{ This code was originally published in c't }
{-------------------------------------------}

interface

uses dos;

const  datlen    = 515;
       stringtyp =  16;

Type netadr     = longint;              { aber in Hi-Lo}
     string48   = string[48];
     Hiloword   = word;                 {    "         }
     Node_id    = array[0..5] of byte;  {    "         }

     Process_id = record
                    net    : netadr;
                    node   : node_id;
                    socket : HiLoWord;
                  end;

     Headertyp = record             {hi lo- definiert}
                   checksum     : HiLoWord;
                   ipxlen       : HiLoWord;
                   t_Control    : byte;
                   P_Type       : byte;
                   Destnet      : netadr;
                   Destnode     : node_id;
                   Destsocket   : HiLoWord;
                   Sourcenet    : netadr;
                   Sourcenode   : node_id;
                   Sourcesocket : HiLoWord;
                 end;

     packettyp =record
                  header      : headertyp;
                  datenbuffer : array [1..datlen] of byte;
                end;

     descriptor=record
                  adr     : ^packettyp;
                  len     : word;                       { lo hi }
                end;

     ECBtyp = record
                link      : pointer;
                esradr    : pointer;
                inUse     : byte;
                Completion: byte;
                Socket    : HiLoWord;                    { hi lo}
                IPXarea   : netadr;
                Driverarea: array[1..12] of Byte;
                Immadr    : node_id;                 { hi lo}
                Fragmcount: word;
                Frag1     : descriptor;
              end;


     checktyp = (check,nocheck);
     Str80        = string[80];
     RecLogType   = string[100];
     Str6         = string[6];
     BigStr       = string[255];
     Request_Type = array[1..7] of Byte;
     Reply_Type   = array[1..90] of Char;


Const IPXint       = $7F; { Hier freie Int-Nummer fr IPX einsetzen }
      SourceSocket : HiloWord = swap($DA10);
      DestSocket   : HiloWord = swap($DA11);

Const everynode : node_id = ($FF,$FF,$FF,$FF,$FF,$FF);
      leernode  : node_id = (0,0,0,0,0,0);
      samenet   : netadr  = 0;
      stayopen            = $FF;
      autoclose           = 0;
      openok              = 0;
      schonda             = $FF;
      voll                = $FE;
      Diagnosesocket      = swap($456);

var   ipxp         : procedure;
      myNet        : netadr;
      myNode       : node_id;
      novell       : boolean;
      initresult   : integer;
      regs         : registers;
      Request_Buff : Request_Type;
      Reply_Buff   : Reply_Type;
      i,j          : integer;
      InDosSeg,
      InDosOfs     : word;



Procedure CancelEvent (var ecb);
Procedure CloseSocket (Socket:HiLoWord);
Procedure DisconnectTarget (Net:netadr;Node:Node_id;Socket:HiLoWord);
Procedure GetLocalTarget (Net:netadr;Node:Node_id;Socket:HiLoWord;
                           Var LocalTargetNode:Node_id;
                           var Completion:byte; var TransportTime:Word );
Procedure GetInterNetadr (var Net:netadr;var Node:Node_id);
Function  GetIntervalMarker:word;
procedure listen (var ecb:ecbtyp);
function  OpenSocket (modus:byte; Socket:HiLoWord;
                      var completion:byte;var assignednr:HiLoWord;
                      checkin:checktyp) : byte;
Procedure RelinquishControl;
Procedure ScheduleIPXEvent (DelayTime:word; var ECB);
Procedure send (var ecb:ecbtyp);
Procedure WriteByte (w:byte);
Procedure WriteNet  (n:netadr);
Procedure WriteNode (x:node_id);
Procedure WriteSocket (s:hiloword);
Procedure IpxIntHandler;
Procedure setds;
Function  GetIPXAdr:pointer;
function  InitIPXint : byte;
Procedure setecb (var ecb:ecbtyp; esradr:pointer;  Socket:HiLoWord;
                  wem:node_id;  packetdescriptor:descriptor);
Procedure show_info;
function  ReleaseIpxInt : boolean;
Procedure Error (errmsg:string;errnr:word);
Function  Equalnode (node1,node2:node_id):boolean;
procedure SetDestNode (node1,node2 : node_id);

implementation


{$F+}
procedure WriteByte (w : byte);

const hex : array[0..15] of char='0123456789ABCDEF';

begin
  Write (hex[(w shr 4) and $F]);
  Write (hex[w and $F]);
end;


procedure WriteSocket(s : hiloword);

begin
  WriteByte(lo(s));
  WriteByte(hi(s));
end;


procedure WriteNode (x : node_id);

var i : byte;

begin
  for i := 0 to 5 do
    WriteByte(x[i]);
end;


procedure WriteNet (n : netadr);

var i : byte;
    x : array[0..3] of byte absolute n;

begin
  for i := 0 to 3 do
    WriteByte(x[i]);
end;


procedure Error(errmsg : string; errnr : word);

begin
  writeln(chr(7));
  write(errmsg,' ');
  WriteByte(errnr);
  writeln;
  halt(errnr);
end;


procedure IpxIntHandler;
assembler;

asm
  call ipxp;
  iret
end;


procedure SetDS; { mu zu beginn jeder Eventroutine stehen }
assembler;

asm
  mov  ax,seg @Data
  mov  ds,ax
end;


function GetIpxAdr : pointer;

var reg : registers;

begin
  GetIpxAdr := NIL;
  with reg do
  begin
    ax := $7A00;
    Intr($2F,reg);
    if al <> $0FF then
      exit;
    GetIpxAdr := ptr(es,di);
  end;
end;


function InitIpxInt : byte;

{
   0: alles ok
   1: IPX nicht gefunden
   2: IntIPX schon belegt
}

var altint : pointer;

begin
  InitIpxInt := 0;
  @ipxp  := GetIpxAdr;
  if @ipxp = NIL then
    InitIpxInt := 1
  else
  begin
    GetIntVec(IPXint,altint);
    if altint <> NIL then
      InitIpxInt := 2
    else
      SetIntVec(IPXint,@IPXInthandler);
  end;
end;


function ReleaseIpxInt : boolean;

var AltInt : pointer;

begin
  ReleaseIpxInt := false;
  GetIntVec(IPXint,AltInt);
  if AltInt <> NIL then
  begin
    ReleaseIpxInt := true;
    SetIntVec(IPXint,NIL);
  end;
end;


function EqualNode (node1,node2 : node_id) : boolean;

var i : byte;

begin
  equalnode := true;
  for i := 0 to 5 do
    if node1[i] <> node2[i] then
      equalnode := false;
end;


procedure SetDestNode (node1,node2 : node_id);

var i : byte;

begin
  for i := 0 to 5 do
    node2[i] := node1[i];
end;

{ ****** alle IPX-Funktionen ****** }

var request,reply  : Process_ID;

procedure IPXfunction(nr : byte; var reg : registers);

begin
  reg.bx:=nr;
  reg.ds:=dseg;
  intr(IPXInt,reg);
end;


procedure SetECB (var ecb : ecbtyp; esradr : pointer;  Socket : HiLoWord;
                  wem : node_id; packetdescriptor : descriptor);

begin
  ecb.link       := NIL;
  ecb.esradr     := esradr;
  ecb.Socket     := Socket;
  ecb.immadr     := wem;
  ecb.inuse      := 0;
  ecb.fragmcount := 1;
  ecb.frag1      := PacketDescriptor;
end;


function OpenSocket(modus          : byte;
                    Socket         : HiLoWord;
                    var completion : byte;
                    var assignednr : HiLoWord;
                    Checkin        : CheckTyp) : byte;

var reg : registers;

begin
  OpenSocket := 2;
  reg.al := modus;
  reg.dx := Socket;
  ipxfunction(0,reg);
  completion := reg.al;
  assignednr := reg.dx;

  if checkin = check then
  begin
    case completion of
      OpenOk  : OpenSocket := 0;
      schonda : OpenSocket := 1;
      voll    : OpenSocket := 2;
    end;
  end;
end;


procedure CloseSocket(Socket:HiLoWord);

var reg : registers;

begin
  reg.dx := Socket;
  IPXfunction(1,reg);
end;


Procedure GetLocalTarget (Net:netadr;Node:Node_id;socket:HiLoWord;
                           Var LocalTargetNode:Node_id;
                           var completion:byte; var TransportTime:Word );
{ nicht von EventRoutine aufrufen !}

var Locadr:Node_id absolute reply;
var reg:registers;

begin
  request.net:=Net;
  request.node:=Node;
  request.socket:=Socket;
  reg.ES:=seg(request); reg.SI:=ofs(request);
  reg.DI:=ofs(reply);
  IPXfunction (2,reg);
  Completion:=Reg.al;
  TransportTime:=Reg.cx;
  LocalTargetNode:=Locadr;
end;


procedure Send(var ecb : ecbtyp);

var reg : registers;

begin
  reg.es := seg(ecb);
  reg.si := ofs(ecb);
  ipxfunction(3,reg);
end;


procedure listen(var ecb : ecbtyp);

var reg : registers;

begin
  reg.es := seg(ecb);
  reg.si := ofs(ecb);
  ipxfunction(4,reg);
end;


procedure ScheduleIpxEvent(DelayTime : word; var ECB);

var reg : registers;

begin
  reg.ax := DelayTime;
  reg.es := seg(ECB);
  reg.si := ofs(ECB);
  IpxFunction(5,reg);
end;


procedure CancelEvent(var ecb);

var reg : registers;

begin
  reg.es := seg(ecb);
  reg.si := ofs(ecb);
  ipxfunction(6,reg);
end;


function GetIntervalMarker : word;

var reg : registers;

begin
  IPXfunction(8,reg);
  getIntervalMarker := reg.ax;
end;


procedure GetInterNetadr(var Net : netadr; var Node : Node_id);

{ nicht von EventRoutine aufrufen !}

var reg : registers;

begin
  reg.es := seg(reply);
  reg.si := ofs(reply);
  ipxfunction(9,reg);
  Net    := reply.net;
  Node   := reply.node;
end;


procedure RelinquishControl;

var reg : registers;

begin
  IPXfunction($A,reg);
end;


procedure DisconnectTarget(Net : netadr; Node : Node_id; Socket : HiLoWord);

{ nicht von EventRoutine aufrufen !}

var reg : registers;

begin
  reg.es         := seg(request);
  reg.si         := ofs(request);
  request.net    := Net;
  request.node   := Node;
  request.socket := Socket;
  ipxfunction($B,reg);
end;


procedure Show_Info;

begin
  {  SetIntVec(IPXint,@IPXInthandler); }
  GetInterNetadr(MyNet,MyNode);
  write('Meine Netzwerkadresse ist : $');
  WriteNet(MyNet);
  writeln;
  write('Meine Knotennummer        : $');
  WriteNode(MyNode);
  writeln;
end;


begin

  regs.ah := $34;       { Adresse InDos-Flag ermitteln }
  MsDos(regs);
  InDosSeg := regs.es;
  InDosOfs := regs.bx;

end.   { --- OF UNIT IPX --- }
