unit ipxinit;

interface

uses crt,dos,ipx;

type  Buf512          = array[1..512] of byte;

var   Completion      : byte;
      AssignedNr      : HiloWord;
      UserData        : string;
      SendPacket,
      RecvPacket      : PacketTyp;
      SendPktDesc,
      RecvPktDesc     : descriptor;
      DestECB,
      SourceECB       : ECBTyp;
      LocalTarget,
      ChannelNode,
      DestNode        : Node_ID;
      DestNet         : NetAdr;
      Online,
      ChannelFree,ok  : boolean;
      InitCode        : integer;
      MsgPointer      : byte;
      MsgBuffer       : array[1..515] of byte;


procedure SendBuffer(len : integer; cmd : byte; IpxData : Buf512);
function  MainIpxInit : boolean;
procedure ShutdownIpx;

implementation


procedure RequestInt; far;

var daten : word;
    i     : integer;


begin
  SetDS;
  Inline($FB);
  with RecvPacket do
  begin
    with Header do
    begin
      if DestECB.Completion <> 0 then
        error('Error on receive: ',DestECB.Completion);
      if P_Type = 16 then
      begin
        daten := swap(ipxlen) - SizeOf(HeaderTyp);
        if not EqualNode(SourceNode,MyNode) then
        begin
          if MsgPointer < 1 then
            inc(MsgPointer);
          for i := 1 to daten do
            MsgBuffer[i] := datenbuffer[i];
        end;
      end;
    end;
  end;
  Listen(DestECB);
end;


procedure SendBuffer(len : integer; cmd : byte; IpxData : Buf512);

var i : integer;

begin
  SendPktDesc.len := SizeOf(HeaderTyp) + len;
  SendPktDesc.adr := @SendPacket;
  with SendPacket do
  begin
    datenbuffer[1] := lo(len);
    datenbuffer[2] := hi(len);
    datenbuffer[3] := cmd;
    for i := 1 to 512 do
      datenbuffer[i + 3] := IpxData[i];
    Header.DestNet    := DestNet;
    Header.DestNode   := DestNode;
    Header.DestSocket := DestSocket;
    Header.P_Type     := 16;
  end;
  SetECB(SourceECB,NIL,SourceSocket,DestNode,SendPktDesc);
  Send(SourceECB);
  repeat
    { }
  until SourceECB.InUse = 0;
  if SourceECB.Completion <> 0 then
    error('Error on transmit: ',SourceECB.completion);
  delay(10);
end;


function MainIpxInit : boolean;

begin
  MainIpxInit := false;
  MsgPointer  := 0;
  InitCode    := InitIpxInt;
  if (InitCode = 0) then
  begin
    GetInterNetAdr(MyNet,MyNode);
    DestNet  := MyNet;
    DestNode := EveryNode;
    if OpenSocket(StayOpen,SourceSocket,Completion,AssignedNr,Check) <> 0 then
    begin
      ok := ReleaseIpxInt;
      writeln('Socket #1 nicht verfgbar.');
      exit;
    end;
    if OpenSocket(StayOpen,DestSocket,Completion,AssignedNr,Check) <> 0 then
    begin
      CloseSocket(SourceSocket);
      ok := ReleaseIpxInt;
      writeln('Socket #2 nicht verfgbar.');
      exit;
    end;
    ChannelNode := EveryNode;
    RecvPktDesc.adr := @RecvPacket;
    RecvPktDesc.len := SizeOf(HeaderTyp) + datlen;
    SetECB(DestECB,@RequestInt,DestSocket,LeerNode,RecvPktDesc);
    Listen(DestECB);
    MainIpxInit := true;
  end
  else
  begin
    case InitCode of
      1 : writeln('IPX-Treiber nicht geladen.');
      2 : writeln('Interrupt 7Ah bereits belegt.');
    end;
  end;
end;


procedure ShutdownIpx;

begin
  if SourceECB.InUse <> 0 then
    CancelEvent(SourceECB);
  CloseSocket(DestSocket);
  CloseSocket(SourceSocket);
  ok := ReleaseIPXint;
end;



end.  { --- OF UNIT IPXINIT --- }

