{$M $D000,0,128000}
program MiniIpxFileServer;

uses crt,dos,pro,ipx,ipxinit;


var  StopServer,aus   : boolean;
     ServerMode       : byte;
     clsec,security   : word;
     datbuf           : Buf512;
     cmd,dlen         : integer;
     secstr,
     srvdatei,
     tmpstr,
     LocalFile        : string;
     sep,taste        : byte;
     sum1             : longint;
     UnknownServerAdr : boolean;
     fil              : file;
     CtrlFile         : text;
     FilEntry,
     LstFile          : string;
     OldWindow        : WinPtr;


procedure ReadBuffer(var datb : Buf512);

var i : integer;

begin
  dlen := (MsgBuffer[1] + (256 * MsgBuffer[2])) - 3;
  cmd  := MsgBuffer[3];
  for i := 1 to dlen do
    datb[i] := MsgBuffer[i + 3];
  if MsgPointer > 0 then
    dec(MsgPointer);
end;


procedure writec(x,y : byte; s : string);

var i : integer;

begin
  while length(s) < 47 do
    s := s + ' ';
  gotoxy(x,y);
  write(s);
end;


function TransmitFile : boolean;

var i,rest    : integer;
    dateiname : string;
    fsiz      : longint;
    srvfile   : file;
    fbuf      : Buf512;
    next,
    cancel    : boolean;


begin
  TransmitFile := false;
  dateiname := '';
  for i := 1 to dlen - 2 do
    dateiname := dateiname + chr(datbuf[i]);
  writec(27,10,'File request');
  writec(27,12,dateiname);
  delay(1000);
  clsec := datbuf[dlen - 1] + (256 * datbuf[dlen]);
  if clsec <> security then
    dateiname := ' ';
  assign(srvfile,dateiname);
  (*$I-*)reset(srvfile,1);(*$I+*)
  if IoResult = 0 then
  begin
    cancel := false;
    fsiz := FileSize(srvfile);
    gotoxy(27,14);
    write(fsiz:8);
    repeat
      blockread(srvfile,fbuf,512,rest);
      next := false;
      repeat
        SendBuffer(rest + 3,0,fbuf);
        repeat until (MsgPointer > 0) or keypressed;
        if (MsgPointer > 0) then
        begin
          ReadBuffer(datbuf);
          if cmd = 6 then next := true else
          if cmd = 24 then
          begin
            rest := 0;
            next := true;
          end
        end
        else
        begin
          if readkey = #27 then
          begin
            next := true;
            rest := 0;
            cancel := true;
          end;
        end;
      until next;
    until (rest <> 512);
    close(srvfile);
    if not cancel then
      SendBuffer(3,4,datbuf)
    else
      SendBuffer(3,24,datbuf);
  end
  else
  begin
    SendBuffer(3,9,datbuf);
    writec(27,12,'No such file');
    delay(2000);
  end;
  TransmitFile := true;
  writec(27,10,' ');
  writec(27,12,' ');
  writec(27,14,' ');
end;


procedure ErrMsg;

begin
  writeln('IPXSERVE V0.2                                (c)1994 R. Luettecke');
  writeln;
  writeln('Usage: IPXSERVE [ -c | -s | -r ]');
  writeln('                   |    |    |');
  writeln('                   |    |    +-------- Release IPX interrupt');
  writeln('                   |    +------------- Server-Mode');
  writeln('                   +------------------ Client-Mode');
  writeln;
  writeln('See documentation about necessary environment-variables.');
  writeln;
  halt;
end;


procedure ClearField(x : byte);

begin
  farbe(1,7,0);
  if x = 0 then
  begin
    writep(30,10,'                                            ');
    writep(30,12,'                                            ');
  end;
  writep(30,14,'        ');
  writep(30,16,'00:00:00');
  writep(30,18,'00:00:00');
end;


procedure MainMenu(x : byte);

begin
  farbe(15,4,0);
  Shadow_Frame(1,1,79,3);
  writep(3,2,'Public Domain Version                                   (c)1994 R.Luettecke');
  farbe(15,1,0);
  if x = 0 then
  begin
    Shadow_Frame(15,8,75,16);
    writep(17, 8,' IPX-SERVER  V0.2 ');
    writep(17,10,'Control :');
    writep(17,12,'Message :');
    writep(17,14,'Bytes   :');
    writep(62,16,' ESC - QUIT ');
    cursor(0);
  end
  else
  begin
    Shadow_Frame(15,8,75,20);
    writep(17, 8,' IPX-CLIENT  V0.2 ');
    writep(33,20,' F1 - SINGLE  F5 - BY LIST  ESC - QUIT ');
    writep(17,10,'Server File:');
    writep(17,12,'Local-File :');
    writep(17,14,'Bytes      :');
    writep(17,16,'Start-Time :');
    writep(17,18,'Stop-Time  :');
    ClearField(0);
  end;
end;


function ReceiveFile(Sdat,LocDat : string) : boolean;

var flen : integer;

begin
  ReceiveFile := false;
  UnknownServerAdr := true;
  writep(30,10,sdat);
  writep(30,12,locdat);
  ClearField(1);
  if Sdat = 'SHUTDOWN' then
  begin
    SendBuffer(3,2,datbuf);
    writep(30,12,'Server stopped by client');
    aus := true;
    exit;
  end;
  if pos('BATCH',Sdat) = 1 then
  begin
    flen := length(sdat);
    for i := 1 to flen do
      datbuf[i] := ord(sdat[i]);
    datbuf[flen + 1] := lo(security);
    datbuf[flen + 2] := hi(security);
    SendBuffer(length(Sdat) + 5,3,datbuf);
    farbe(1,7,1);
    writep(30,14,'--wait--');
    farbe(1,7,0);
    cursor(0);
    MsgPointer := 0;
    cmd := 99;
    repeat
      if (MsgPointer > 0) then
      begin
        ReadBuffer(datbuf);
        if cmd = 6 then
          ReceiveFile := true;
      end;
      if keypressed then
      begin
        if readkey = #27 then
          cmd := 10;
      end;
    until (cmd = 15) or (cmd = 10) or (cmd = 6);
    writep(30,14,'        ');
    exit;
  end;
  cursor(0);
  flen := length(sdat);
  for i := 1 to flen do
    datbuf[i] := ord(sdat[i]);
  datbuf[flen + 1] := lo(security);
  datbuf[flen + 2] := hi(security);
  sum1 := 0;
  assign(fil,Locdat);
  (*$I-*)reset(fil);(*$I+*)
  if IoResult = 0 then
  begin
    close(fil);
    ok := DialogBox(vm,FALSE,'',LocDat,'exists','Overwrite ?');
    farbe(1,7,0);
  end;
  if ok then
  begin
    (*$I-*)rewrite(fil,1);(*$I+*)
    if IoResult = 0 then
    begin
      writep(30,16,what_time);
      farbe(1,7,1);
      writep(30,14,'--wait--');
      farbe(1,7,0);
      SendBuffer(length(sdat) + 5,1,datbuf);
      MsgPointer := 0;
      cmd := 99;
      repeat
        if (MsgPointer > 0) then
        begin
          ReadBuffer(datbuf);
          if UnknownServerAdr then
          begin
            SetDestNode(SendPacket.Header.DestNode,
                        RecvPacket.Header.SourceNode);
            UnknownServerAdr := false;
          end;
          if cmd = 0 then
          begin
            blockwrite(fil,datbuf,dlen);
            sum1 := sum1 + dlen;
            SendBuffer(3,6,datbuf);
          end
          else
            SendBuffer(3,15,datbuf);
        end;
        if keypressed then
        begin
          if readkey = #27 then
            cmd := 10;
        end;
      until (cmd = 4) or (cmd = 9) or (cmd = 10) or (cmd = 24);
      close(fil);
      case cmd of
         4 : begin
               writep(30,18,what_time);
               gotoxy(30,14);
               write(sum1:8);
               ReceiveFile := true;
             end;
         9 : begin
               writep(30,10,'File not found / Access denied');
               click;
               ClearField(1);
               erase(fil);
               delay(2000);
             end;
        10 : begin
               erase(fil);
               SendBuffer(3,24,datbuf);
               aus := true;
             end;
        24  : begin
                writep(30,10,'Transmission cancelled');
                click;
                delay(2000);
                erase(fil);
              end;
      end;
    end
    else
      writep(30,12,'Invalid Local-File');
  end;
end;



begin
  farbe(7,0,0);
  clrscr;
  srvdatei  := '';
  localfile := '';
  secstr := GetEnv('IPXPWD');
  if secstr = '' then
    ErrMsg;
  security := crcstr(secstr);
  if ParamCount = 1 then
  begin
    if ParamStr(1) = '-r' then
    begin
      ok := ReleaseIpxInt;
      if ok then
        writeln('IPX Interrupt $7F set to NIL.')
      else
        writeln('IPX Interrupt was not hooked.');
      exit;
    end
    else if ParamStr(1) = '-s' then ServerMode := 1 else
         if ParamStr(1) = '-c' then ServerMode := 2 else
           ErrMsg;
  end;
  new(OldWindow);
  if MainIpxInit then
  begin
    case ServerMode of
      1 : begin
            { Server }
            StopServer := false;
            MainMenu(0);
            repeat
              writec(27,10,'Idle');
              if MsgPointer > 0 then
              begin
                ReadBuffer(datbuf);
                case cmd of
                  1 : begin
                        SetDestNode(SendPacket.Header.DestNode,
                                    RecvPacket.Header.SourceNode);
                        ok := TransmitFile;
                        if not ok then
                          StopServer := true;
                      end;
                  2 : begin
                        writec(27,12,'Server-Shutdown by client');
                        StopServer := true;
                      end;
                  3:  begin
                        clsec := datbuf[dlen - 1] + (256 * datbuf[dlen]);
                        if clsec = security then
                        begin
                          tmpstr := '';
                          for i := 1 to dlen - 2 do
                            tmpstr := tmpstr + chr(datbuf[i]);
                          writec(27,10,'Executing batch');
                          tmpstr := copy(tmpstr,6,length(tmpstr) - 5);
                          TrimLeft(tmpstr);
                          writec(27,12,tmpstr);
                          Save_Window(1,1,80,25,OldWindow);
                          gotoxy(1,18);
                          SwapVectors;
                          exec(GetEnv('COMSPEC'),'/C ' + tmpstr);
                          SwapVectors;
                          Restore_Window(1,1,80,25,OldWindow);
                          if DosError = 0 then
                            SendBuffer(3,6,datbuf)
                          else
                            SendBuffer(3,15,datbuf);
                          writec(27,12,' ');
                        end;
                      end;
                end;
              end;
              if keypressed then
              begin
                if readkey = #27 then
                begin
                  StopServer := true;
                  aus := true;
                end else tictac;
              end;
            until StopServer;
          end;
      2 : begin
            { Client }
            aus := false;
            MainMenu(1);
            repeat
              farbe(15,1,0);
              writep(33,20,' F1 - SINGLE  F5 - BY LIST  ESC - QUIT ');
              cursor(0);
              repeat
                scankey(taste);
              until (taste = F1) or (taste = F5) or (taste = ESC);
              case taste of
                 F1 : begin
                        farbe(15,1,0);
                        writep(33,20,' F10 - START  ESC - QUIT ');
                        repeat
                          srvdatei := einlesen(srvdatei,44,30,10,1,4,TRUE);
                          if (not Eingaben_Ende) and (not Eingaben_Abbr) then
                            localfile := einlesen(localfile,44,30,12,1,4,TRUE);
                        until Eingaben_Abbr or (Eingaben_Ende and
                                                (length(srvdatei) > 0) and
                                                (length(localfile) > 0) or
                                                (srvdatei = 'SHUTDOWN') or
                                                (pos('BATCH',srvdatei) = 1));
                        if Eingaben_Abbr then
                          aus := true
                        else
                        begin
                          ok := ReceiveFile(srvdatei,LocalFile);
                          if (pos('BATCH',srvdatei) = 1) then
                          begin
                            if not ok then
                              writep(30,12,'*** Batch Error *** ')
                            else
                              writep(30,12,'*** No Error *** ');
                          end;
                        end;
                      end;
                 F5 : begin
                        { Liste }
                        farbe(15,1,0);
                        writep(33,20,' F10 - START  ESC - QUIT ');
                        LstFile := einlesen('',44,30,10,1,4,FALSE);
                        if not Eingaben_Abbr then
                        begin
                          assign(CtrlFile,LstFile);
                          (*$I-*)reset(CtrlFile);(*$I+*)
                          if IoResult = 0 then
                          begin
                            while not eof(CtrlFile) do
                            begin
                              ClearField(0);
                              readln(CtrlFile,FilEntry);
                              DeleteSpace(FilEntry);
                              FilEntry := UpStr(FilEntry);
                              sep := pos(',',FilEntry);
                              if sep <> 0 then
                              begin
                                srvdatei  := copy(FilEntry,1,sep - 1);
                                LocalFile := copy(FilEntry,sep + 1,
                                                  length(FilEntry) - sep);
                                ok := ReceiveFile(srvdatei,LocalFile);
                                delay(1000);
                              end;
                            end;
                            close(CtrlFile);
                          end
                          else
                            writep(30,10,'CONTROL FILE NOT FOUND            ');
                        end;
                      end;
                ESC : aus := true;
              end;
            until aus;
          end;
    end;
    ShutdownIpx;
  end;
  farbe(7,0,0);
  gotoxy(1,24);
  cursor(1);
end.





