/* laser.c
 *
 * Laser Disk Access Program
 * runs on the pc that calls the laser disk
 * by Patrick L. McGillan
 *    University of Wisconsin - Superior
 *
 * with special thanks to Paul McGinnis, AST Research, Inc.
 * whose programs on compuserve inspired these programs
 *
 */


#include "netwrk.h"

struct REGPACK r;

struct {
  int	length ;
  char	function;
  char	station ;
} outpacket ;

struct {
  int	length ;
  char	uniqueid[4] ;
  int	type ;
  char	objectname[48] ;
  char	logtime[8] ;
} whoami ;

struct {
  int	length ;
  char	network[4] ;
  char	host[6] ;
  char	socket[2] ;
} map ;


main()
{
  int chr, done = 0;
  char *fname, *direct;
  char far * user_name;

  clrscr();

  system ("p:\\public\\netbios");

  block = (NCB far *) malloc(sizeof(NCB));
  buf1 = (char far *) malloc(512);
  buf2 = (char far *) malloc(512);
  message = (char far *) malloc(80);
  user_name = (char far *) malloc(16);

  printf ("\n\nLaser Disk Access Program");
  printf ("\nby Patrick L. McGillan");
  printf ("\n   University of Wisconsin - Superior");
  printf ("\n\nGenerating your Network Name entry . . .");
  get_user();
  make_user();

  while (!done)
  {
    done = 1;

    printf ("\n\nNow I need two pieces of information . . .");

    printf ("\nFilename: ");  gets (fname);

    printf ("\nDirectory: "); gets (direct);

    strcpy (message, "c:\\");
    if (strlen(direct) > 0)
    {
      strcat (message, direct);
      strcat (message, "\\");
    }
    strcat (message, fname);

    call_user();

    send_fnam();

    recv_file(fname);

    printf ("\n\nCopy more files (y/n) <n> ");
    if ((chr = toupper(getch())) == 'Y')
      done = 0;

  }
  delete_user();
}



make_user()
{
  unsigned char ret_code;

  printf ("\nMaking: %s", whoami.objectname);

  block -> NCB_COMMAND = ADD_NAME_WAIT;   /* Use default time-out values */
  block -> NCB_LANA_NUM = 0;
  block -> NCB_STO = 0;
  block -> NCB_RTO = 0;
  strncpy(block -> NCB_NAME, whoami.objectname, 16);  /* Copy name to NCB   */
  strncpy(block -> NCB_CALLNAME, "*", 16);  /* Check all names on net  */
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  if ((ret_code) && (ret_code != 0x0d))
    printf("\nBad return code = %02Xh", ret_code);
}



delete_user()
{
  printf ("\n\nDeleting User name");
  block -> NCB_COMMAND = DELETE_NAME_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
}



call_user()
{
  unsigned char ret_code;

  printf ("\n\nCalling User . . .");
  block -> NCB_STO = 0;
  strncpy(block -> NCB_CALLNAME, "Laser Disk", 16);
  block -> NCB_COMMAND = CALL_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  return (ret_code == 0x05);
}



send_fnam()
{
  unsigned char ret_code;

  printf ("\n\nSending File Spec: %Fs", message);
  block -> NCB_STO = 0;
  block -> NCB_BUFFER_OFFSET = FP_OFF(message);
  block -> NCB_BUFFER_SEGMENT = FP_SEG(message);
  block -> NCB_LENGTH = strlen(message);
  block -> NCB_COMMAND = SEND_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  if (ret_code)
  {
    printf("\nError number = %02Xh", ret_code);
    delete_user();
  }
}



wait()
{
    byte done;

    do
    {
        done = block->NCB_CMD_CPLT;
        if (kbhit()) return(1);
    } while (done == 0xff);
}


hang_up()
{
  block -> NCB_COMMAND = HANG_UP_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
}


recv(buf)
char far * buf;
{
  unsigned char ret_code;

  block -> NCB_STO = 0;
  block -> NCB_BUFFER_OFFSET = FP_OFF(buf);
  block -> NCB_BUFFER_SEGMENT = FP_SEG(buf);
  block -> NCB_LENGTH = 512;
  block -> NCB_COMMAND = RECEIVE_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  return (ret_code);
}


recv_file(fname)
char *fname;
{
  if ((disk = fopen(fname, "a+b")) == NULL)
  {
    printf ("\n\nERROR OPENING FILE: %s", fname);
    hang_up();
    return;
  }

  printf ("\n\nLocal File: %s opened for writing", fname);
  printf ("\nReceiving File ");
  if (recv(buf1)) { close_file(); return; }

  while (1)
  {
    if (wait()) { close_file(); return; }
    bytes = block->NCB_LENGTH;

    printf (".");

    if (bytes == 0) { close_file(); return; }
    if (recv(buf2)) { close_file(); return; }
    fwrite(buf1, bytes, 1, disk);
    if (wait()) { close_file(); return; }
    bytes = block->NCB_LENGTH;

    printf (".");

    if (bytes == 0) { close_file(); return; }
    if (recv(buf1)) { close_file(); return; }
    fwrite (buf2, bytes, 1, disk);
  }
}


close_file()
{
  printf ("\n\n\nFile Transfer Complete!");
  fclose(disk);
  hang_up();
}

/********************************************************************
    WHO.C
       Alternate menu function for Novell Netware

       First code : 10/13/87

    thanks to who ever put this on compuserve
    used as a function to get a users login name

********************************************************************/

get_user()
{
  int count,station,physical ;

  r.r_ds=_DS ;
  r.r_es=_DS ;
  r.r_ax=(0xdc00) ;
  intr(0x21,&r) ;
  station=(r.r_ax & 0xff) ;
  r.r_ax=(0xee00) ;
  intr(0x21,&r) ;
  physical=r.r_ax ;
  r.r_si=(int)&outpacket ;
  r.r_di=(int)&whoami ;
  r.r_ax= (0xe300) ;
  whoami.length=sizeof(whoami) ;
  outpacket.length=sizeof(outpacket) ;
  outpacket.function=22 ;
  outpacket.station=station ;
  intr(0x21,&r) ;
  r.r_si=(int)&outpacket ;
  r.r_di=(int)&map ;
  r.r_ax=0xe300 ;
  outpacket.length=sizeof(outpacket) ;
  outpacket.function=19 ;
  outpacket.station=station ;
  map.length=sizeof(map) ;
  intr(0x21,&r) ;
  physical=map.host[5] ;
  printf("\nYou are user %s, at station %i, connection %i.\n",
  	  whoami.objectname,station,physical) ;
}
