/* player.c
 *
 * Laser Disk Access Program
 * runs on the pc that supports the laser disk
 * by Patrick L. McGillan
 *    University of Wisconsin - Superior
 *
 * with special thanks to Paul McGinnis, AST Research, Inc.
 * whose programs on compuserve inspired these programs
 *
 */


#include "netwrk.h"


main()
{
  int done;
  char *fname;
  char far * user_name;

  clrscr();

  system ("p:public\\netbios");

  block = (NCB far *) malloc(sizeof(NCB));
  buf1 = (char far *) malloc(512);
  buf2 = (char far *) malloc(512);
  message = (char far *) malloc(80);

  printf ("\n\nLaser Disk Access Program");
  printf ("\nby Patrick L. McGillan");
  printf ("\n   University of Wisconsin - Superior");
  printf ("\n\nGenerating Network Laser Disk entry . . .");
  make_user();

  while (1)
  {
    printf ("\n\nWaiting for a user to call . . .");

    listen();

    get_fnam();

    printf ("\nMessage Received");
    printf ("\nFrom User: <%Fs>", block->NCB_CALLNAME);
    printf ("\nWants file name: %Fs", message);

    strcpy (fname, message);

    if (chk_fname(fname))
      send_file(fname);

    hang_up();
  }
}



make_user()
{
  unsigned char ret_code;

  block -> NCB_COMMAND = ADD_NAME_WAIT;   /* Use default time-out values */
  block -> NCB_LANA_NUM = 0;
  block -> NCB_STO = 0;
  block -> NCB_RTO = 0;
  strncpy(block -> NCB_NAME, "Laser Disk", 16);  /* Copy name to NCB   */
  strncpy(block -> NCB_CALLNAME, "*", 16);  /* Check all names on net  */
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  if ((ret_code) && (ret_code != 0x0d))
  {
    printf("Bad return code = %02Xh\n", ret_code);
    exit (1);
  }
}



listen()
{
  unsigned char ret_code;

  strncpy(block -> NCB_NAME, "Laser Disk", 16);  /* Copy name to NCB   */
  strncpy(block -> NCB_CALLNAME, "*", 16);  /* Check all names on net  */
  block -> NCB_RTO = 0;
  block -> NCB_COMMAND = LISTEN_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  if (ret_code)
    printf("Error number = %02Xh\n", ret_code);
}



get_fnam()
{
  unsigned char ret_code;

  block -> NCB_RTO = 0;
  block -> NCB_BUFFER_OFFSET = FP_OFF(message);
  block -> NCB_BUFFER_SEGMENT = FP_SEG(message);
  block -> NCB_LENGTH = 80;
  block -> NCB_COMMAND = RECEIVE_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  pokeb(FP_SEG(message), FP_OFF(message) + block -> NCB_LENGTH, 0);
  if (ret_code)
    printf("Error number = %02Xh\n", ret_code);
}



send(buf)
char far * buf;
{
  unsigned char ret_code;

  block -> NCB_STO = 0;
  block -> NCB_BUFFER_OFFSET = FP_OFF(buf);
  block -> NCB_BUFFER_SEGMENT = FP_SEG(buf);
  block -> NCB_LENGTH = bytes;
  block -> NCB_COMMAND = SEND_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
  ret_code = _AL;
  return (ret_code);
}



chk_fname(fname)
char *fname;
{
  int done;
  struct ffblk file;

  done = findfirst (fname, &file, 0x3f);

  return (!done);
}



send_file(fname)
char *fname;
{
  int disk;

  disk = fopen (fname, "r+b");
  printf ("\nSending File: %s", fname);

  while (1)
  {
    bytes = fread (buf1, 1, 512, disk);
    if (bytes < 0) { hang_up(); return; }
    if (send(buf1)) { hang_up(); return; }
    if (bytes == 0) { fclose(disk); hang_up(); return; }
    bytes = fread (buf2, 1, 512, disk);
    if (wait()) { hang_up(); return; }
    if (send(buf2)) { hang_up(); return; }
    if (wait()) { hang_up(); return; }
    if (bytes == 0) { fclose(disk); hang_up(); return; }
  }
}


wait()
{
    byte done;

    do
      done = block->NCB_CMD_CPLT;
    while (done == 0xff);
}


hang_up()
{
  printf ("\nHanging up connection");
  block -> NCB_COMMAND = HANG_UP_WAIT;
  _ES = FP_SEG(block);
  _BX = FP_OFF(block);
  _AX = 0x100;
  geninterrupt(0x5c);
}

