
#include <string.h>
#include <stdio.h>

#include <nit.h>
#include <ntt.h>
#include <niterror.h>

WORD conID;
long ID;
int numdrive;
char chdrive;
char path[255];
char server[48];
BYTE dir;

main(int argc,char *argv[])
{
char *searchPath;
int err;
fprintf(stderr,"SETOWNER 0.1 Copyright Salford University Network Services 1993\n");
if(argc!=3)
	{
	fprintf(stderr,"Usage:\n");
	fprintf(stderr,"\tSetowner <Drive Letter> <UserName>\n");
	return 900;
	};
err=GetBinderyObjectID(argv[2],OT_USER,&ID);
if (err)
	{
	fprintf(stderr,"User %s does not exist\n",strupr(argv[2]));
	return err;
	};
chdrive=toupper(argv[1][0]);
numdrive=chdrive-65;
err=GetFullPath(numdrive,path);
if (err)
	{
	fprintf(stderr,"DRIVE %c: DOES NOT EXIST\n",chdrive);
	return 1;
	}
err=GetDriveInformation(numdrive,&conID,&dir);
searchPath=StripFileServerFromPath(path,server);

printf("Scanning [%s.../.../...]\n",searchPath);
ScanAll(searchPath);

return 0;
}

ScanAll(char *Search)
{
NWDIR_ENTRY dirEntry;
NWFILE_ENTRY fileEntry;
int err;
char Server[48];
char Vol[16];
char Direct[255];
char Full[255];
char fs[255];
char ds[255];
BYTE time[4],Mask;
LONG sequence;
LONG sequence2;
int er;
sequence  = -1;
sequence2 = -1;
err=0;
while(!err)
	{
	strcpy(fs,Search);
	strcat(fs,"/*");
	err=ScanFileEntry(conID,dir,fs,0x00,&sequence2,&fileEntry);
	if (!err)
		{
		DisFile(&fileEntry);
		er=SetEntry(conID,dir,0x00,sequence2,M_OWNER_ID,&fileEntry);
		if (er==0)
			printf("\tSet\n");
		else printf("\tNot set\n");
		};
	};
err=0;
while(!err)
	{
	strcpy(ds,Search);
	strcat(ds,"/*");
	err=ScanDirEntry(conID,dir,ds,0x00,&sequence,&dirEntry);
	if (!err)
		{
		DisDir(&dirEntry);
		er=SetEntry(conID,dir,0x00,sequence,M_OWNER_ID,&dirEntry);
		if (er==0)
			printf("\tSet\n");
		else printf("\tNot set\n");
		ParsePath(Search,Server,Vol,Direct);
		strcpy(Full,Vol);
		strcat(Full,":");
		strcat(Full,Direct);
		strcat(Full,"/");
		dirEntry.name[dirEntry.nameLength]='\0';
		strcat(Full,dirEntry.name);
		printf("\tScanning [%s../..]\n",Full);
		ScanAll(Full);
		};
	};
return 0;
}

DisDir(NWDIR_ENTRY *dirEntry)
{
int err;
char Directory[255];
char User[48];
WORD type;
memmove(Directory,dirEntry->name,dirEntry->nameLength);
Directory[dirEntry->nameLength]='\0';
/*printf("DIRECTORY : %-12s",Directory);*/
err=GetBinderyObjectName(dirEntry->ownerID,User,&type);
/*printf("    %s",User);*/
dirEntry->ownerID=ID;
return err;
}

DisFile(NWFILE_ENTRY *fileEntry)
{
int err;
char FileName[13];
char User[48];
WORD type;

memmove(FileName,fileEntry->name,fileEntry->nameLength);
FileName[fileEntry->nameLength]='\0';
printf("\tFILE : %-12s",FileName);
err=GetBinderyObjectName(fileEntry->ownerID,User,&type);
printf("    %s",User);
fileEntry->ownerID=ID;
return err;
}

