;Program:	NPrtScrn
;Programmer:	Ken McKinlay
;Synatx:	NPRTSCRN	- to load
;		NPRTSCRN U	- to unload
;Hot-key:	RightShift-PrintScreen
;Description:	This program is a TSR designed to flush the print buffer
;		anytime the print screen is performed.  This permits the
;		print screen to be immediately sent to the printer.
;E-Mail:	Questions and comments may be sent to Compuserve 71531,3150.
;Disclaimer:	The program is provided AS IS.  Kenneth I McKinlay can not
;		be held responsible for any problems caused by this program.

code	segment	para	public	'code'
	assume	cs:code
	org	0100h
begin:	jmp	init

program	db	"NPrtScrn 1.0  (c) 1993  Ken McKinlay",13,10
	db	"Hotkey is RShift-PrintScrn",13,10,"$"
	db	1ah

; Patch points for the program
keycode	db	37h		;Scancode for printscreen key
shftkey	db	01h		;Shift state for the rightshift key

;Other variables
int09H	dd	?		;Interrupt 9h vector

;KBInt intercepts and handles the keyboard interrupt 9h
kbint	proc	far
	pushf			;Save flags
	push	ax		;Save AX since it gets modified in this routine

	sti			;Interrupts on
	in	al,60h		;Get the scancode
	cmp	al,cs:[keycode]
	jne	nothot		;Exit if not the keycode specified
	mov	ah,2		;Get the keyboard shift status
	int	16h
	and	al,0fh		;Mask off the upper 4 bits
	cmp	al,cs:[shftkey]
	jne	nothot		;Exit if the shift state is not right
	jmp	prtscrn		;Jump to the print screen
nothot:	pop	ax		;Exit to the BIOS int 9h
	popf
	jmp	cs:int09H
;
; Reset the keyboard controller and interrupt controller
;
prtscrn:cli			;Interrupts off
	in	al,61h		;Reset the keyboard controller
	mov	ah,al
	or	al,80h
	out	61h,al
	xchg	ah,al
	mov	al,20h		;Signal EOI to interrupt
	out	20h,al		; controller
	sti			;Interrupts back on
	int	05h		;Print screen call

	push	dx		;Save registers
	mov	ah,0dfh		;LPT capture function
	mov	dl,3		; Sub-function 3
	mov	dh,0
	int	21h		;Flush the buffer

	pop	dx
	pop	ax		;Restore AX and flags
	popf
	iret
kbint	endp
;
; Initialize the TSR
;
insflag	db	0

init	proc	near
	assume	cs:code, ds:code

	jmp	init0			;Jump over text

errmsg1	db	"Usage: NPrtScrn [U]$"
errmsg2	db	"Not installed$"
errmsg3	db	"Cannot Uninstall$"
errmsg4	db	"Already Installed$"
outtext	db	"Uninstalled$"

;
; See if a copy is already resident in memory
;
init0:
	cld			;Clear DF for string ops
	mov	word ptr [begin],0
	xor	bx,bx		;Zero BX for start
	mov	ax,cs		;Keep CS value in AX
init1:	inc	bx		;Increment search segment value
	mov	es,bx
	cmp	ax,bx		;Not installed if current
	je	parse1		; segment is reached
	mov	si,offset begin	;Search this segment for ASCII
	mov	di,si		; fingerprint
	mov	cx,16
	repe	cmpsb
	jne	init1		;Loop back if not found
	mov	insflag,1	;Set installed flag
;
;Parse the command line for entries
;
parse1:	mov	si,81h		;Point SI to command line
parse2:	lodsb			;Get a character
	cmp	al,20h		;Skip it if it is a space
	je	parse2
	cmp	al,0dh		;Exit loop when a carriage return
	je	install		; is encountered
	and	al,0dfh		;Capitalize the character
	cmp	al,"U"		;Branch to uninstall code if
	je	uninst		; character is a "U"
;
; An error was encountered in parsing.  Display error message and exit.
;
error1:	mov	dx,offset errmsg1
error2:	mov	ah,9		;Display the message
	int	21h
	mov	ax,4c01h	;Exit with errorlevel = 1
	int	21h
;
; Uninstall the program
;
uninst:	mov	dx,offset errmsg2
	cmp	insflag,0	;Error if program isn't installed
	je	error2
	call	remove		;Call uninstall routine
	mov	dx,offset errmsg3
	jc	error2		;error if uninstall failed
	mov	dx,offset outtext
	mov	ah,9		;Display uninstall message
	int	21h
	mov	ax,4c00h	;Exit with errorlevel=0
	int	21h
;
; make sure NPrtScrn isn;t already installed
;
install:mov	dx,offset errmsg4
	cmp	insflag,0		;Exit on error if program is already installed
	jne	error2
;
; Hook into the interrupt 9h and deallocate the environment block
;
setvec:	mov	ax,3509h	;Save the old interrupt 9h vector
	int	21h
	mov	word ptr int09H,bx
	mov	word ptr int09H[2],es
	mov	ax,2509h	;Set the new interrupt 9h vector
	mov	dx,offset kbint
	int	21h
	mov	ax,ds:[2ch]	;Deallocate the program's
	mov	es,ax		; environment block
	mov	ah,49h
	int	21h
;
; Display copyright notice, the terminate and remain resident in memory
;
	mov	ah,9		;Display copyright
	mov	dx,offset program
	int	21h
	mov	ax,3100h
	mov	dx,(offset init - offset code + 15 +128) shr 4
	int	21h
init	endp
;
; Remove deallocated the block addressed by ES and restores the vectors
;  to their previous state.
;
remove	proc	near
	mov	cx,es		;abort if the interrupt vector has been
	mov	ax,3509h	; altered since installation
	int	21h
	mov	ax,es
	cmp	ax,cx
	jne	r_error
;
; Free the memory given to the original program block
;
	mov	es,cx		;Ask DOS to free it
	mov	ah,49h
	int	21h
	jc	r_error		;Exit if call failed
;
; Restore the vector to the pre-installation state
;
	push	ds
	assume	ds:nothing
	mov	ax,2509h	;Restore interrupt 9h vector
	lds	dx,es:[int09H]
	int	21h
	pop	ds
	assume	ds:code
	not	word ptr es:[begin]	;Destory the ASCII fingerprint
	clc			;Clear CF for exit
	ret
r_error:stc			;Set CF to indicate program
	ret			; could not be uninstalled
remove	endp

code	ends
	end	begin
