/*****************************************************************************
* WAKEUP.C
*
* 91-02-08 Matt Hagen, Novell, Inc.
*****************************************************************************/

#include <nwtypes.h>
#include <conio.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

void PollRoutine(
	void);

/*****************************************************************************
* main
*****************************************************************************/

main(
	int argc,
	char *argv[])
{
	int ccode;
	int pollThread;

	pollThread=BeginThread(PollRoutine,NULL,NULL,NULL);
	if(pollThread==EFAILURE)
		Breakpoint(1);

	ThreadSwitch();

	while(TRUE)
	{
		delay(5000);
		ccode=ResumeThread(pollThread);

		switch(ccode)
		{
			case ESUCCESS:
				ConsolePrintf("  Main thread: I woke up Poll thread.\n");
				break;

			case EWRNGKND:
				ConsolePrintf("  Main thread: Poll thread already awake.\n");
				break;

			case EBADHNDL:
				ConsolePrintf("  Main thread: Bad handle.\n");
				break;

			default:
				ConsolePrintf("  Main thread: ResumeThread() error = %d.\n",ccode);
				break;
		}
	}
}

/*****************************************************************************
* PollRoutine
*****************************************************************************/

void PollRoutine(
	void)
{
	while(TRUE)
	{
		delay(20000);

		ConsolePrintf("  Poll thread: I woke up.\n");
	}
}

/****************************************************************************/
/****************************************************************************/
