/*****************************************************************************
* Project:	Server Statistics Program
* File:		TOTAL.C
* Author:	Matt Hagen, Novell, Inc.
* Date:		91-05-22
*****************************************************************************/

#include <nwtypes.h>
#include <stdio.h>
#include <ss.h>

#define COL_FIRST 0
#define ROW_FIRST 0
#define ROW_COUNT 25

/*****************************************************************************
* main
*****************************************************************************/

main()
{
	int c;
	int count;
	int length;
	struct StatStructure *cStat;
	struct StatStructure *tStat;

	HideInputCursor();

	cStat=GetStatList();
	count=GetStatCount();
	length=GetStatLength();

	if(count>ROW_COUNT)
		count=ROW_COUNT;

	for(c=0,tStat=cStat;c<count;c++,tStat=tStat->link)
		printf("%2d-%s\n",c+1,&tStat->description);

	while(TRUE)
	{
		gotoxy(COL_FIRST,ROW_FIRST);
		for(c=0,tStat=cStat;c<count;c++,tStat=tStat->link)
		{
			gotoxy(4+length,wherey());
			printf("%10u\n",tStat->loTotal);
		}

		delay(1000);
	}
}

/****************************************************************************/
/****************************************************************************/
