/*****************************************************************************
* Project:
* File:		EXIST.C
* Authors:	Morgan Adair & Matt Hagen, Novell, Inc.
* Date:		91-06-25
*****************************************************************************/

#include <stdio.h>
#include <nit.h>
#include <niterror.h>
#include <nxt.h>
#include <diag.h>
#include <dos.h>

/*****************************************************************************
* main
*****************************************************************************/

void main(void)
{
	BYTE		componentList[54];
	BeginDiagnosticStruct	networkAddress;
	int		connection;
	int		component;
	AllResponseData	response;
	IPXSPXVersion	responseData;
	int		ccode;
	WORD		connectionNum;
	WORD		connectionID;
	union REGS	regs;
	struct SREGS	sregs;
	char		serverName[48];
	BYTE		majorVer, minorVer, revLevel;
	char		name[48];

/* Communication Protocols */
/* IPX/SPX present */

	if (IPXInitialize() == IPX_NOT_INSTALLED)
		printf("IPX is NOT loaded.\n");
	else {
		printf("IPX IS loaded.\n");

		if (SPXInitialize(NULL, NULL, NULL, NULL) == SPX_NOT_INSTALLED)
			printf("SPX is NOT loaded.\n");
		else
			printf("SPX IS loaded.\n");

/* IPX/SPX Version */

		IPXGetInternetworkAddress((BYTE *)&networkAddress);
		if (BeginDiagnostics(&networkAddress, &connectionID, componentList) != SUCCESSFUL)
			printf("Unable to get IPX/SPX versions\n");
		else {
			component = FindComponentOffset(componentList, IPX_SPX_COMPONENT);
			if (component == -1)
				printf("Unable to get IPX/SPX versions\n");
				if (GetIPXSPXVersion(connectionID, component, &response, &responseData) != SUCCESSFUL)
					printf("Unable to get IPX/SPX versions\n");
				else {
					printf("IPX Version: %d.%02d\n", responseData.IPXMajorVersion, responseData.IPXMinorVersion);
					printf("SPX Version: %d.%02d\n", responseData.SPXMajorVersion, responseData.SPXMinorVersion);
				}
		}
		EndDiagnostics(connectionID);
	}

/* NetWare DOS Shell */

	connectionID = GetDefaultConnectionID();

	if (connectionID == NULL) {
		printf("The shell is NOT loaded.\n");
		/* if shell is not loaded,
		   there is nothing left to live for */
		return;
	} else {
		printf("The shell IS loaded.\n");
		ccode = GetNetWareShellVersion(&majorVer, &minorVer, &revLevel);
		printf("Shell Version: %d.%d, Rev %c\n", majorVer, minorVer, revLevel+'A');
	}

/* NetBIOS */

	regs.h.ah = 0x35;	/* AH = Interrupt 21h Funtion 35h--
					Get Interrupt Vector */
	regs.h.al = 0x5C;	/* AL = Interrupt vector to get */
	intdosx(&regs, &regs, &sregs);
	switch (sregs.es) {
		/* ES returns segment of pointer to ISR */
		case 0x0000  :
		case 0xF000  : printf("NetBIOS is NOT loaded.\n");
			       break;
		default      : printf("NetBIOS IS loaded.\n");
	}


/* Connection Information */

	for (connection=1; connection<=8; connection++) {
		if (IsConnectionIDInUse(connection) == 1) {
			SetPreferredConnectionID(connection);
			connectionNum = GetConnectionNumber();
			ccode = GetConnectionInformation(connectionNum, name, NULL, NULL, NULL);
			if (ccode == 0) {
				GetFileServerName(connection, serverName);
				printf("Connection ID %d is logged in to %s as %s.\n", connection, serverName, name);
			} else
				printf("Connection ID %d is attached only.\n", connection);
		} else
			printf("Connection ID %d is unused.\n", connection);
	}
}
