#include <prolog.h>

#define CHARGE_RECORD			1
#define NOTE_RECORD			2

#define CONNECT_TIME_CHARGE_NOTE	1
#define DISK_STORAGE_CHARGE_NOTE	2
#define LOGIN_NOTE			3
#define LOGOUT_NOTE			4
#define ACCOUNT_LOCKED_NOTE		5
#define SERVER_TIME_MODIFIED_NOTE	6

typedef struct CONNECT_TIME_CHARGE {
	LONG	connectTime;
	LONG	requestCount;
	WORD	bytesReadHi;
	WORD	bytesRead2;
	WORD	bytesReadLo;
	WORD	bytesWrittenHi;
	WORD	bytesWritten2;
	WORD	bytesWrittenLo;
} CONNECT_TIME_CHARGE;

typedef struct DISK_STORAGE_CHARGE {
	LONG	blocksOwned;
	LONG	numberOfHalfHours;
} DISK_STORAGE_CHARGE;

typedef struct UNKNOWN_CHARGE {
	BYTE	comment;
} UNKNOWN_CHARGE;

typedef struct {
	LONG	amount;
	WORD	chargeType;
	union CHARGE_COMMENT {
		struct CONNECT_TIME_CHARGE	connectTimeCharge;
		struct DISK_STORAGE_CHARGE	diskStorageTimeCharge;
		struct UNKNOWN_CHARGE		unknownCharge;
	} chargeComment;
} CHARGE_RECORD_STRUCT;

typedef struct LOGIN_NOTE_STRUCT {
	LONG	net;
	LONG	nodeHigh;
	WORD	nodeLow;
} LOGIN_NOTE_STRUCT;

typedef struct LOGOUT_NOTE_STRUCT {
	LONG	net;
	LONG	nodeHigh;
	WORD	nodeLow;
} LOGOUT_NOTE_STRUCT;

typedef struct SERVER_TIME_MOD_STRUCT {
	BYTE	year;
	BYTE	month;
	BYTE	day;
	BYTE	hour;
	BYTE	minute;
	BYTE	second;
} SERVER_TIME_MOD_STRUCT;

typedef struct ACCOUNT_LOCKED_STRUCT {
	LONG	net;
	LONG	nodeHigh;
	WORD	nodeLow;
} ACCOUNT_LOCKED_STRUCT;

typedef struct UNKNOWN_NOTE_STRUCT {
	BYTE	comment;
} UNKNOWN_NOTE_STRUCT;

typedef struct {
	WORD	noteType;
	union NOTE_COMMENT {
		struct LOGIN_NOTE_STRUCT	loginNote;
		struct LOGOUT_NOTE_STRUCT	logoutNote;
		struct SERVER_TIME_MOD_STRUCT	serverTimeNote;
		struct ACCOUNT_LOCKED_STRUCT	accountLockedNote;
		struct UNKNOWN_NOTE_STRUCT	unknownNote;
	} noteComment;
} NOTE_RECORD_STRUCT;

typedef struct {
	WORD	length;
	LONG	serverID;
	BYTE	timeStamp[6];
	BYTE	recordType;
	BYTE	completionCode;	/* if record is a note, this field is reserved */
	WORD	serviceType;
	LONG	clientID;
	union CHARGE_OR_NOTE {
		CHARGE_RECORD_STRUCT	charge;
		NOTE_RECORD_STRUCT	note;
	} chargeOrNote;
} ACCT_RECORD;
