/*****************************************************************************
* File:		BTRIEVE.H       --     Btrieve defines and function prototype
* Author:	Morgan B. Adair
* Date:		12/15/91
*****************************************************************************/

#ifndef __BTRIEVE_H

#define __BTRIEVE_H

/* Extended Type Flags */

#define BT_KEY_STR_TYPE		0
#define BT_KEY_INT_TYPE		1
#define BT_KEY_DUP		1
#define BT_KEY_MOD		2
#define BT_KEY_BIN		4
#define BT_KEY_NULL		8
#define BT_KEY_ZSTR_TYPE	11
#define BT_KEY_SEG		16
#define BT_KEY_ALT_COL_SEQ	32
#define BT_KEY_DESC		64
#define BT_KEY_SUPP		128
#define BT_KEY_EXT_TYPE		256
#define BT_KEY_MANUAL		512

/* Operation Codes */

#define	BT_OPEN				0
#define	BT_CLOSE			1
#define	BT_INSERT			2
#define	BT_UPDATE			3
#define	BT_DELETE			4
#define	BT_GET_EQUAL			5
#define	BT_GET_NEXT			6
#define	BT_GET_PREVIOUS			7
#define	BT_GET_GREATER			8
#define	BT_GET_GREATER_OR_EQUAL		9
#define	BT_GET_LESS			10
#define	BT_GET_LESS_OR_EQUAL		11
#define	BT_GET_FIRST			12
#define	BT_GET_LAST			13
#define	BT_CREATE			14
#define	BT_STAT				15
#define	BT_EXTEND			16
#define	BT_SET_DIRECTORY		17
#define	BT_GET_DIRECTORY		18
#define	BT_BEGIN_TRANSACTION		19
#define	BT_END_TRANSACTION		20
#define	BT_ABORT_TRANSACTION		21
#define	BT_GET_POSITION			22
#define	BT_GET_DIRECT			23
#define	BT_STEP_NEXT			24
#define	BT_STOP				25
#define	BT_VERSION			26
#define	BT_UNLOCK			27
#define	BT_RESET			28
#define	BT_SET_OWNER			29
#define	BT_CLEAR_OWNER			30
#define	BT_CREATE_SUPP_INDEX		31
#define	BT_DROP_SUPP_INDEX		32
#define	BT_STEP_FIRST			33
#define	BT_STEP_LAST			34
#define	BT_STEP_PREVIOUS		35
#define	BT_GET_NEXT_EXTENDED		36
#define	BT_GET_PREVIOUS_EXTENDED	37
#define	BT_STEP_NEXT_EXTENDED		38
#define	BT_STEP_PREVIOUS_EXTENDED	39
#define	BT_INSERT_EXTENDED		40

/* Status Codes */

#define BT_SUCCESS	 			0
#define BT_INVALID_OPERATION			1
#define BT_IO_ERROR				2
#define BT_FILE_NOT_OPEN			3
#define BT_KEY_VALUE_NOT_FOUND			4
#define BT_DUPLICATE_KEY_VALUE			5
#define BT_INVALID_KEY_NUMBER			6
#define BT_DIFFERENT_KEY_NUMBER			7
#define BT_INVALID_POSITIONING			8
#define BT_END_OF_FILE				9
#define BT_MODIFIABLE_KEY_VALUE_ERR		10
#define BT_INVALID_FILENAME			11
#define BT_FILE_NOT_FOUND			12
#define BT_EXTENDED_FILE_ERROR			13
#define BT_PREIMAGE_OPEN_ERROR			14
#define BT_PREIMAGE_IO_ERROR			15
#define BT_EXPANSION_ERROR			16
#define BT_CLOSE_ERROR				17
#define BT_DISK_FULL				18
#define BT_UNRECOVERABLE_ERROR			19
#define BT_RECORD_MANAGER_INACTIVE		20
#define BT_KEY_BUFFER_TOO_SHORT			21
#define BT_DATA_BUFFER_LENGTH			22
#define BT_POSITION_BLOCK_LENGTH		23
#define BT_PAGE_SIZE_ERROR			24
#define BT_CREATE_IO_ERROR			25
#define BT_NUMBER_OF_KEYS			26
#define BT_INVALID_KEY_POSITION			27
#define BT_INVALID_RECORD_LENGTH		28
#define BT_INVALID_KEY_LENGTH			29
#define BT_NOT_A_BTRIEVE_FILE			30
#define BT_FILE_ALREADY_EXTENDED		31
#define BT_EXTEND_IO_ERROR			32
#define BT_INVALID_EXTENSION_NAME		34
#define BT_DIRECTORY_ERROR			35
#define BT_TRANSACTION_ERROR			36
#define BT_TRANSACTION_IS_ACTIVE		37
#define BT_TRANSACTION_CONTROL_FILE_ERROR	38
#define BT_END_ABORT_TRANSACTION_ERROR		39
#define BT_TRANSACTION_MAX_FILES		40
#define BT_OPERATION_NOT_ALLOWED		41
#define BT_INCOMPLETE_ACCELERATED_ACCESS	42
#define BT_INVALID_RECORD_ADDRESS		43
#define BT_NULL_KEY_PATH			44
#define BT_INCONSISTENT_KEY_FLAGS		45
#define BT_ACCESS_TO_FILE_DENIED		46
#define BT_MAXIMUM_OPEN_FILES			47
#define BT_INVALID_ALTERNATE_SEQ_DEFINED	48
#define BT_KEY_TYPE_ERROR			49
#define BT_OWNER_ALREADY_SET			50
#define BT_INVALID_OWNER			51
#define BT_ERROR_WRITING_CACHE			52
#define BT_INVALID_INTERFACE			53
#define BT_VARIABLE_PAGE_ERROR			54
#define BT_AUTOINCREMENT_ERROR			55
#define BT_INCOMPLETE_INDEX			56
#define BT_COMPRESSION_BUFFER_TOO_SHORT		58
#define BT_FILE_ALREADY_EXISTS			59
#define BT_REJECT_COUNT_REACHED			60
#define BT_WORK_SPACE_TOO_SMALL			61
#define BT_INCORRECT_DESCRIPTOR			62
#define BT_DEADLOCK_DETECTED			78
#define BT_CONFLICT				80
#define BT_LOCK_ERROR				81
#define BT_LOST_POSITION			82
#define BT_READ_OUTSIDE_TRANSACTION		83
#define BT_RECORD_IN_USE			84
#define BT_FILE_IN_USE				85
#define BT_FILE_TABLE_FULL			86
#define BT_HANDLE_TABLE_FULL			87
#define BT_INCOMPATIBLE_MODE_ERROR		88
#define BT_REDIRECTED_DEVICE_TABLE_FULL		90
#define BT_SERVER_ERROR				91
#define BT_TRANSACTION_TABLE_FULL		92
#define BT_INCOMPATIBLE_LOCK_TYPE		93
#define BT_PERMISSION_ERROR			94
#define BT_SESSION_NO_LONGER_VALID		95
#define BT_COMM_ENVIRONMENT_ERROR		96
#define BT_DATA_MESSAGE_TOO_SMALL		97
#define BT_INTERNAL_TRANSACTION_ERROR		98

int BTRV(int OP, char *POS_BLK, char *DATA_BUF, int *DATA_LEN, char *KEY_BUF, int KEY_NUM);

#endif
