/*****************************************************************************
* Project:  Workstation inventory
* File:		DATAFILE.H
* Author:	Morgan B. Adair
* Date:		12/15/91
*****************************************************************************/

#include "recdecl.h"

typedef struct KeySpec {
	int	keyPos;
	int	keyLen;
	int	keyFlag;
	char	notUsed[4];
	char	keyType;
	char	reserved[5];
} KEY_SPEC;

typedef struct FileSpec {
	int	recordLength;
	int	pageSize;
	int	indexCount;
	char	unused[4];
	int	fileFlags;
	char	reserved[2];
	int	preAlloc;
	struct	KeySpec	keyBuf[NUMBER_OF_KEY_SEGS];
} FILE_SPEC;

void LoadBtrieve(void);
int UnloadBtrieve(void);
int BtrieveIsLoaded(void);
int DataFileExists(char *filePath);
int OpenDataFile(char *filePath);
int CreateDataFile(char *filePath);
int SearchItem(WS_INVENTORY_RECORD *entry);
int InsertItem(WS_INVENTORY_RECORD *entry);
int UpdateItem(WS_INVENTORY_RECORD *entry);
int ListItems(void);
int CloseDataFile(void);
