/*****************************************************************************
* Project:  Workstation inventory
* File:		RECDECL.H
* Author:	Morgan B. Adair
* Date:		12/15/91
*****************************************************************************/

#ifndef _RECDECL_H

#define _RECDECL_H

#define NUMBER_OF_KEYS		1
#define NUMBER_OF_KEY_SEGS	2
#define KEY0_SIZE		12

#define MAX_FLOPPY_DRIVES	2
#define MAX_HARD_DRIVES		2

#define MAX_BINDERY_OBJ_NAME	48

typedef struct {
	BYTE	network[4];
	BYTE	node[6];
	char	userName[MAX_BINDERY_OBJ_NAME];
	BYTE	IPXmajorVersion;
	BYTE	IPXminorVersion;
	BYTE	SPXmajorVersion;
	BYTE	SPXminorVersion;
	BYTE	shellMajorVersion;
	BYTE	shellMinorVersion;
	BYTE	shellRevisionLevel;
	BYTE	machineModel;
	BYTE	machineSubmodel;
	WORD	processorType;
	WORD	coprocessorType;
	int	conventionalMemoryK;
	WORD	extendedMemoryK;
	WORD	expandedMemoryK;
	int	videoHardware;
	int	alternateVideoHardware;
	BYTE	DOSversionMajor;
	BYTE	DOSversionMinor;
	BYTE	NICtype[80];
	BYTE	numPrintersInstalled;
	BYTE	numSerialPorts;
	BYTE	mouseType;
	WORD	mouseDriverVersion;
	BYTE	numFloppyDrives;
	BYTE	floppyDriveType[MAX_FLOPPY_DRIVES];
	BYTE	numHardDrives;
	LONG	hardDriveSize[MAX_HARD_DRIVES];
} WS_INVENTORY_RECORD;

#endif

