#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nit.h>
#include "btrieve.h"
#include "datafile.h"

#define PROGRAM_NAME "VIEWINVN"

void Usage(void);

void main(int argc, char **argv)
{
	char	dbPath[80] = "\\PUBLIC\\INVENTRY.BTR";
	int	iLoadedBtrieve = FALSE;
	int	status;

	if (argc == 2)
		strcpy(dbPath, argv[1]);
	else if (argc > 2) {
		printf("%s--view records in data file created by INVENTRY program\n", PROGRAM_NAME);
		printf("Usage:\n");
		printf("\t%s [path]\n", PROGRAM_NAME);
		printf("\tpath     data file path\n");
		printf("\t         default path is %s\n", dbPath);
		exit(1);
	}

	if (!(DataFileExists(dbPath))) {
		printf("%s: data file %s not found\n", PROGRAM_NAME, dbPath);
		exit(1);
	}

	if (!(BtrieveIsLoaded())) {
		LoadBtrieve();
		if (!(BtrieveIsLoaded())) {
			printf("Unable to load Btrieve record manager\n");
			exit(1);
		}
		iLoadedBtrieve = TRUE;
	}

	status = OpenDataFile(dbPath);
	if (status) {
		printf("Unable to open file %s\n", dbPath);
		printf("Btrieve error code %d\n", status);
		exit(1);
	}

	status = ListItems();
	if (status) {
		printf("Unable to display inventory data\n");
		printf("Btrieve error code %d\n", status);
	}

	status = CloseDataFile();
	if (status) {
		printf("Unable to close inventory data file\n");
		printf("Btrieve error code %d\n", status);
	}

	if (iLoadedBtrieve) {
		status = UnloadBtrieve();
		if (status) {
			printf("Unable to unload Btrieve record manager\n");
			printf("Btrieve error code %d\n", status);
		}
	}
}
