Type ServerInfoType
    serverName As String * 48
    netwareVer As String * 1
    netwareSubVer As String * 1
    maxConnSupported As Long
    connInUse As Long
    maxVolsSupported As Integer
    revisionLevel As String * 1
    sftLevel As String * 1
    ttsLevel As String * 1
    peakConnsUsed As Long
    accountingVer As String * 1
    vapVer As String * 1
    queueingVer As String * 1
    printServVer As String * 1
    virtualConsoleVer As String * 1
    securityRestrictLevel As String * 1
    internetBridgeSupp As String * 1
End Type

' Bindery object type definitions
Global Const OT_WILD = -1               ' Matches any type
Global Const OT_UNKNOWN = 0             ' Unknown object type
Global Const OT_USER = 1                ' The object is a "user"
Global Const OT_USER_GROUP = 2          ' A group of users
Global Const OT_PRINT_QUEUE = 3         ' Services print queues
Global Const OT_FILE_SERVER = 4         ' The object serves files
Global Const OT_JOB_SERVER = 5
Global Const OT_GATEWAY = 6
Global Const OT_PRINT_SERVER = 7
Global Const OT_ARCHIVE_QUEUE = 8
Global Const OT_ARCHIVE_SERVER = 9      ' Services backup jobs
Global Const OT_JOB_QUEUE = 10
Global Const OT_ADMINISTRATION = 11
Global Const OT_REMOTE_BRIDGE_SERVER = 38

Global Const MAX_CONNS = 1

'NetWare DLL calls
Declare Function GetDefaultConnectionID Lib "nwwrkstn.dll" () As Long
Declare Sub GetFileServerName Lib "nwserver.dll" (ByVal Conn%, ByVal serverName$)
Declare Function GetDLLVersion Lib "NWCore.DLL" (ByVal DLLName$, MajorVer%, MinorVer%, RevLevel%, BetaLevel%) As Integer
Declare Function GetConnectionID Lib "NWWrkstn.DLL" (ByVal FileServerName$, ConnectionID%) As Integer
Declare Function GetPrimaryConnectionID Lib "NWWrkstn.DLL" () As Integer
Declare Sub SetPreferredConnectionID Lib "NWWrkstn.DLL" (ByVal ConnectID%)
Declare Function GetConnectionNumber Lib "NWConn.DLL" () As Long
Declare Function GetConnectionInformation Lib "NWConn.DLL" (ByVal ConnectNo&, ByVal ObjectName$, ObjectType%, ObjectID&, ByVal LoginTime$) As Integer
Declare Function GetServerInformation Lib "NWServer.DLL" (ByVal structSize%, serverInfo As ServerInfoType) As Integer
Declare Function GetObjectConnectionNumbers Lib "NWConn.DLL" (oName$, ByVal oType%, numConns&, connList As Any, ByVal maxConns&) As Integer
Declare Function SendBroadcastMessage Lib "NWMsg.DLL" (msg$, connList As Any, resultList$, ByVal numConns%) As Integer

Declare Function ScanBinderyObject Lib "NWBind.DLL" (ByVal SearchObjName$, ByVal SearchObjectType%, ObjectID&, ByVal ObjectName$, ObjectType%, HasProperties%, ObjectFlag%, ObjectSec%) As Integer

Global connList(5) As Long
Global resultList As String * 5

