 {ͻ
   Prog.: BiSample                               Target Platforms :      
   Desc : Sample program for bindery services    - real Mode             
                                                 - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program BiSample;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvMain,
  NvBindry;

{
              VAR declarations
 }

var
  Input         : Char;
  Result        : Byte;
  i,j           : Integer;

{
              procedure bindery A
 }

procedure BinderyA;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Open bindery');
  GotoXY(5,8);
  write('Desc : Opens the server-bindery, supervisor privilege required ');
  GotoXY(5,10);
  write('Call : function OpenBindery:boolean;');
  GotoXY(5,12);
  write('Reply : True if bindery successfull opened');
  GotoXY(5,22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if OpenBindery then
  begin
    GotoXY(10,4);
    write('Bindery successfull opened');
  end
  else
  begin
    GotoXY(10,4);
    write('Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery B
 }

procedure BinderyB;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Close bindery, supervisor privilege required');
  GotoXY(5,8);
  write('Desc : Closes the server-bindery ');
  GotoXY(5,10);
  write('Call : function CloseBindery:boolean;');
  GotoXY(5,12);
  write('Reply : True if bindery successfull closed');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if CloseBindery then
  begin
    GotoXY(10,4);
    write('Bindery successfull closed');
  end
  else
  begin
    GotoXY(10,4);
    write('Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery C
 }

procedure BinderyC;

var
  SecLevel : Byte;
  ObjId    : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get bindery access level ');
  GotoXY(5,8);
  write('Desc : Gets the access level required for bindery-services');
  GotoXY(5,10);
  write('Call : function GetBinderyAccessLevel(Var SecLevels : Byte;');
  GotoXY(5,11);
  write('       var ObjId: LongInt):boolean;');
  GotoXY(5,13);
  write('Reply : Security-level and bindery object id, returns false if');
  GotoXY(5,14);
  write('        Error during execution');
  GotoXY(5,22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if GetBinderyAccessLevel(SecLevel,ObjId) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Successfull');
    GotoXY(10,6);
    write(' Security level = ',SecLevel);
    GotoXY(10,8);
    write(' Object id      = ',ObjId);
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write('Error during execution');
  end;
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery D
 }

procedure BinderyD;

var
  NewObj : tBinderyObj;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Create bindery object');
  GotoXY(5,8);
  write('Desc : Creates an new bindery object');
  GotoXY(5,10);
  write('Call : function CreateBinderyObject(BinderyObject : BinderyObj):Byte;');
  GotoXY(5,12);
  write('Request : Bindery object = Object flag : 00h static,01h dynamic ');
  GotoXY(5,13);
  write('                           Object security level');
  GotoXY(5,14);
  write('                           Object typ (see Nvmain)');
  GotoXY(5,15);
  write('                           Object name');
  GotoXY(5,17);
  write('Reply   : Error code (See Nvmain error-codes)');
  GotoXY(5,22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Flag          : ');
  readln(NewObj.ObjectFlag);
  GotoXY(10,5);
  Write(' Security      : ');
  readln(NewObj.ObjectSec);
  GotoXY(10,6);
  Write(' Object typ    : ');
  readln(NewObj.ObjectType);
  GotoXY(10,7);
  Write(' Object name   : ');
  readln(NewObj.ObjectName);
  ClrScr;
  GotoXY(10,4);
  Result := CreateBinderyObject(NewObj);
  if Result = neSuccessfull then
    write(' Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery E
 }

procedure BinderyE;

var
  DelObj : tBinderyObj;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Delete bindery object');
  GotoXY(5,8);
  write('Desc : Deletes an bindery object');
  GotoXY(5,10);
  write('Call : function DeleteBinderyObject(BinderyObject : BinderyObj):Byte;');
  GotoXY(5,12);
  write('Request : Bindery Object = Object typ (see Nvmain)');
  GotoXY(5,13);
  write('                           Object name');
  GotoXY(5,17);
  write('Reply   : Error code (See Nvmain error-codes)');
  GotoXY(5,22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Typ           : ');
  readln(DelObj.ObjectType);
  GotoXY(10,5);
  Write(' Name          : ');
  readln(DelObj.ObjectName);
  Result := DeleteBinderyObject(DelObj);
  ClrScr;
  GotoXY(10,4);
  if Result = neSuccessfull then
    write(' Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery F
 }

procedure BinderyF;

var
  NewName : String;
  NewObj  : tBinderyObj;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Rename bindery object');
  GotoXY(5,8);
  write('Desc : Renames an bindery object');
  GotoXY(5,10);
  write('Call : ');
  GotoXY(2,11);
  write('function RenameBinderyObject(NewName : String;BinderyObject : BinderyObj):Byte;');
  GotoXY(5,13);
  write('Request : New name = Objects new name');
  GotoXY(5,14);
  write('          Bindery object = Object typ (see Nvmain)');
  GotoXY(5,15);
  write('                           Object name');
  GotoXY(5,17);
  write('Reply   : Error code (See NvMain error-codes)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' New name      : ');
  readln(NewName);
  GotoXY(10,5);
  Write(' Object typ    : ');
  readln(NewObj.ObjectType);
  GotoXY(10,6);
  Write(' Object name   : ');
  readln(NewObj.ObjectName);
  Result := RenameBinderyObject(NewName,NewObj);
  ClrScr;
  GotoXY(10,4);
  if Result = neSuccessfull then
    write(' Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery G
 }

procedure BinderyG;

var
  Obj   : tBinderyObj;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get bindery object id');
  GotoXY(5,8);
  write('Desc : Gets the object id of an bindery object');
  GotoXY(5,10);
  write('Call : function GetBinderyObjId(Var Obj : BinderyObj):Byte;');
  GotoXY(5,12);
  write('Request : Bindery Object type = Object typ (see Nvmain)');
  GotoXY(5,13);
  write('                  Object name = Name of object');
  GotoXY(5,15);
  write('Reply   : Bindery object id   = Object id of the object');
  GotoXY(5,17);
  write('          Error code (See Nvmain error-codes)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object typ    : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name   : ');
  readln(Obj.ObjectName);
  Result := GetBinderyObjId(Obj);
  if Result = neSuccessfull then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Successfull');
    GotoXY(10,6);
    write(' Object name = ',Obj.ObjectName);
    GotoXY(10,8);
    write(' Object id   = ',Obj.ObjectId);
  end
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery H
 }

procedure BinderyH;

var
  Obj   : tBinderyObj;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get bindery object name');
  GotoXY(5,8);
  write('Desc : Returns the object-name of the object-id');
  GotoXY(5,10);
  write('Call : function GetBinderyObjName(Var Obj : BinderyObj):Byte;');
  GotoXY(5,13);
  write('Request : Object-id ');
  GotoXY(5,15);
  write('Reply   : Obj.Object-name');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object id (1 Supervisor for example) : ');
  readln(Obj.ObjectId);
  Result := GetBinderyObjName(Obj);
  ClrScr;
  GotoXY(10,4);
  if Result = neSuccessfull then
  begin
    write(' Successfull');
    GotoXY(10,6);
    write(' Object name = ',Obj.ObjectName);
    GotoXY(10,8);
    write(' Object id   = ',Obj.ObjectId);
    GotoXY(10,10);
    write(' Object typ  = ',Obj.ObjectType);
  end
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery I
 }

procedure BinderyI;

var
  Obj   : tBinderyObj;
  Typ   : Integer;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Scan bindery object');
  GotoXY(5,6);
  write('Desc : Scan an bindery object typ');
  GotoXY(5,8);
  write('Call : function ScanBinderyObject(Var Obj : BinderyObj):Byte;');
  GotoXY(5,10);
  write('Request : Obj.ObjectTyp = Object typ to scan (See NvMain)');
  GotoXY(5,11);
  write('          Obj.ObjectId  = Last object id,if you want to search with');
  GotoXY(5,12);
  write('                          Wildcard first put -1 and then for every ');
  GotoXY(5,13);
  write('                          next call the id replied after the call  ');
  GotoXY(5,14);
  write('          Obj.Name      = Name of the object * for all');
  GotoXY(5,16);
  write('Reply   : Obj.Name      = Name of the object ');
  GotoXY(5,17);
  write('          Obj.Id        = Object id');
  GotoXY(5,18);
  write('          Obj.Type      = Typ of object');
  GotoXY(5,19);
  write('          Obj.Flag      = Object flag,00h static 01h dynamic');
  GotoXY(5,20);
  write('          Obj.Sec       = Object - security');
  GotoXY(5,21);
  write('          Obj.Prop      = Object - property 00h no,FFh yes');
  GotoXY(5,22);
  write('Error code returned by function,not displayed in this example !!!');
  GotoXY(5,24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object typ to scan :');
  Readln(Typ);
  Obj.ObjectId := -1;
  Obj.Objecttype := Typ;
  Obj.Objectname := '*';
  ClrScr;
  GotoXY(10,3);
  Write(' First call');
  GotoXY(10,5);
  Write(' Object id   : ',Obj.ObjectId);
  GotoXY(10,6);
  Write(' Object type : ',Obj.ObjectType);
  GotoXY(10,7);
  Write(' Object name : ',Obj.ObjectName);
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
  while ScanBinderyObject(Obj) = 0 do
  begin
    ClrScr;
    GotoXY(10,4);
    Write(' Object id   : ',Obj.ObjectId);
    GotoXY(10,5);
    Write(' Object type : ',Obj.ObjectType);
    GotoXY(10,6);
    Write(' Object name : ',Obj.ObjectName);
    GotoXY(10,7);
    Write(' Object flag : ',Obj.ObjectFlag);
    GotoXY(10,8);
    Write(' Object sec  : ',Obj.ObjectSec);
    GotoXY(10,9);
    Write(' Object prop : ',Obj.ObjectProperty);
    GotoXY(5,22);
    write(' Press key to continue ');
    Input := UpCase(ReadKey);
    Obj.ObjectName := '*';
    Obj.Objecttype := Typ;
  end;
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery J
 }

procedure BinderyJ;

var
  Obj   : tBinderyObj;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Change bindery object security');
  GotoXY(5,8);
  write('Desc : Changes the security of an bindery object');
  GotoXY(5,10);
  Write('Call : function ChangeBinderyObjectSecurity(Var Obj : BinderyObj):Byte;');
  GotoXY(5,12);
  Write('Request : Obj.ObjectSec   = New security of the object');
  GotoXY(5,13);
  Write('          Obj.ObjectTyp   = Typ of object');
  GotoXY(5,14);
  Write('          Obj.ObjectName  = Name of object to change Level');
  GotoXY(5,15);
  Write('Reply   : Error code (See NvMain)');
  GotoXY(5,22);
  write(' Press key to start function (a to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' New security level : ');
  readln(Obj.ObjectSec);
  GotoXY(10,5);
  Write(' Object typ         : ');
  readln(Obj.ObjectType);
  GotoXY(10,6);
  Write(' Object name        : ');
  readln(Obj.ObjectName);
  Result := ChangeBinderyObjectSecurity(Obj);
  ClrScr;
  GotoXY(10,4);
  if Result = neSuccessfull then
    write(' Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery K
 }

procedure BinderyK;

var
  Obj           : tBinderyObj;
  OldPassword,
  NewPassword   : String;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Change bindery object password');
  GotoXY(5,8);
  write('Desc : Changes the password of an bindery object');
  GotoXY(5,10);
  write('Call : function ChangeBinderyObjectPassword(Var Obj : BinderyObj;');
  GotoXY(5,11);
  write('                          OldPassword,NewPassword : String):Byte;');
  GotoXY(5,12);
  write('Request : Bindery Object = Object typ (see Nvmain)');
  GotoXY(5,13);
  write('                           Object name');
  GotoXY(5,14);
  write('          OldPassWord    = Old password of object');
  GotoXY(5,15);
  write('          NewPassWord    = New password of object');
  GotoXY(5,17);
  write('Reply   : Error code (See Nvmain error-codes)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object typ    : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name   : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Old password  : ');
  readln(OldPassword);
  GotoXY(10,7);
  Write(' New password  : ');
  readln(NewPassword);
  Result := ChangeBinderyObjectPassword(Obj,OldPassword,NewPassword);
  if Result = neSuccessfull then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Successfull');
    GotoXY(10,6);
    write(' Object name = ',Obj.ObjectName);
    GotoXY(10,8);
    write(' Object id   = ',Obj.ObjectId);
  end
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery L
 }

procedure BinderyL;

var
  Obj  : tBinderyObj;
  Prop : tProperty;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Create property');
  GotoXY(5,8);
  write('Desc : Creates an property for an object');
  GotoXY(5,10);
  write('Call : function CreateProperty(Obj : BinderyObj;Prop : Property):Byte;');
  GotoXY(5,12);
  write('Request : Obj.ObjectType    = Object typ for property');
  GotoXY(5,13);
  write('          Obj.ObjectName    = Object name');
  GotoXY(5,14);
  write('          Prop.PropertyFlag = Propertys flag ');
  GotoXY(5,15);
  write('          Prop.PropertySec  = Propertys security');
  GotoXY(5,16);
  write('          Prop.PropertyName = Name of property');
  GotoXY(5,18);
  write('Reply   : Error code (See Nvmain)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object type       : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Property flag     : ');
  readln(Prop.PropertyFlag);
  GotoXY(10,7);
  Write(' Property security : ');
  readln(Prop.PropertySec);
  GotoXY(10,8);
  Write(' Property name     : ');
  readln(Prop.PropertyName);
  Result := CreateProperty(Obj,Prop);
  ClrScr;
  GotoXY(10,4);
  if Result = neSuccessFull then
    write(' Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery M
 }

procedure BinderyM;

var
  Obj  : tBinderyObj;
  Prop : tProperty;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Delete property');
  GotoXY(5,8);
  write('Desc : Deletes an property of an object');
  GotoXY(5,10);
  write('Call : function DeleteProperty(Obj : BinderyObj;var Prop : Property):Byte;');
  GotoXY(5,12);
  write('Request : Obj.ObjectType    = Object typ for property');
  GotoXY(5,13);
  write('          Obj.ObjectName    = Object name');
  GotoXY(5,14);
  write('          Prop.PropertyName = Name of property');
  GotoXY(5,16);
  write('Reply   : Error code (See Nvmain)');
  GotoXY(5,22);
  write(' Press key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object typ        : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Property name     : ');
  readln(Prop.PropertyName);
  Result := DeleteProperty(Obj,Prop);
  ClrScr;
  GotoXY(10,4);
  if Result = neSuccessfull then
    write(' Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery N
 }

procedure BinderyN;

var
  Obj   : tBinderyObj;
  Prop  : tProperty;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Read property value');
  GotoXY(5,8);
  write('Desc : Reads the value of an property');
  GotoXY(5,10);
  write('Call :');
  GotoXY(5,11);
  write('function ReadPropertyValue(Obj : BinderyObj;var Prop : Property):Byte;');
  GotoXY(5,13);
  write('Request : Obj.ObjectType     = Object typ for property');
  GotoXY(5,14);
  write('          Obj.ObjectName     = Object name');
  GotoXY(5,15);
  write('          Prop.PropertySeg   = Property segment 01h on first call');
  GotoXY(5,16);
  write('          Prop.PropertyName  = Name of property');
  GotoXY(5,18);
  write('Reply   : Prop.PropertyValue = Property values ');
  GotoXY(5,19);
  write('          Prop.MoreSegments  = More segments 00h no,FFh yes');
  GotoXY(5,20);
  write('          Prop.PropertyFlags = Property flags');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object type       : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Property name     : ');
  readln(Prop.PropertyName);
  i := 0;
  repeat
    Inc(i);
    Prop.PropertySeg := i;
    GotoXY(10,2);
    Write(' Segment : ',i);
    Result := ReadPropertyValue(Obj,Prop);
    ClrScr;
    GotoXY(10,2);
    write(' Error-result  : $', Convert2Hex(Result));
    GotoXY(10,4);
    Write(' Segment : ',i);
    GotoXY(10,6);
    writeln(' Bindery value (only 1-60): ');
    for j := 1 to 60 do
    begin
      GotoXY(j,8);
      Write(Char(Prop.PropertyValue[j]));
    end;
    GotoXY(10,12);
    write(' More segments  : ',Prop.MoreSegments);
    GotoXY(10,4);
    write(' Property flags : ',Prop.PropertyFlag);
    GotoXY(5,22);
    write(' Press key to continue ');
    Input := UpCase(ReadKey);
    GotoXY(5,22);
    write(' Press key to continue ');
    Input := UpCase(ReadKey);
  until (Prop.MoreSegments = 0) or (Result <> neSuccessfull);
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery O
 }

procedure BinderyO;

var
  dummy          : String;
  Obj            : tBinderyObj;
  Prop           : tProperty;
  EraseRemaining : boolean;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Write property value');
  GotoXY(5,8);
  write('Desc : Writes the value of an property ( Be careful, use a dummy-user !!!!)');
  GotoXY(5,10);
  write('Call : function WritePropertyValue(Obj : tBinderyObj;');
  GotoXY(5,11);
  write('                                   var Prop : tProperty;');
  GotoXY(5,12);
  write('                                   EraseRemaining : boolean):Byte;');
  GotoXY(5,14);
  write('Request : Obj.ObjectType     = Object typ for property');
  GotoXY(5,14);
  write('          Obj.ObjectName     = Object name');
  GotoXY(5,15);
  write('          Prop.PropertySeg   = Property segment 01h on first call');
  GotoXY(5,16);
  write('          Prop.PropertyName  = Name of property');
  GotoXY(5,17);
  write('          Prop.PropertyValue = Property values ');
  GotoXY(5,18);
  write('          EraseRemaining     = Erase remaing segments');
  GotoXY(5,20);
  write('Reply   : Prop.PropertyFlags = Property flags');
  GotoXY(5,21);
  write('          Error-code (see NvMain);');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object type       : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Erase remaing (Y/N) : ');
  readln(Dummy);
  if Upcase(dummy[1]) = 'Y' then
    EraseRemaining := true
  else
    EraseRemaining := false;
  GotoXY(10,7);
  Write(' Property name     : ');
  readln(Prop.PropertyName);
  GotoXY(10,8);
  Write(' Property value    : ');
  readln(dummy);

  for i := 1 to length(Dummy) do prop.propertyvalue[i] := Byte(dummy[i]);
  GotoXY(10,2);
  Prop.PropertySeg := 1;
  Result := WritePropertyValue(Obj, Prop, EraseRemaining);

  ClrScr;
  GotoXY(10,2);
  write(' Error-result  : $', Convert2Hex(Result));

  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery P
 }

procedure BinderyP;

var
  Obj   : tBinderyObj;
  Prop  : tProperty;
  Seq   : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Scan property');
  GotoXY(5,8);
  write('Desc : Scans the properties of an object');
  GotoXY(5,10);
  write('Call : function ScanProperty(Obj : BinderyObj;');
  GotoXY(5,11);
  write('       var Prop : Property;var Seq : LongInt):Byte;');
  GotoXY(5,13);
  write('Request : Obj.ObjectType     = Object type to scan for property');
  GotoXY(5,14);
  write('          Obj.ObjectName     = Object name to scan');
  GotoXY(5,15);
  write('          Prop.PropertySeg   = Property segment FFFFh on first call');
  GotoXY(5,16);
  write('          Prop.PropertyName  = Name of property');
  GotoXY(5,18);
  write('Reply   : Prop.PropertyName  = Name of property');
  GotoXY(5,19);
  write('          Prop.PropertyFlags = Property flags');
  GotoXY(5,20);
  write('          Prop.PropertySec   = Property security');
  GotoXY(5,21);
  write('          Prop.PropertyValue = Property value');
  GotoXY(5,22);
  write('          Prop.MoreProp      = More properties');
  GotoXY(5,24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object type       : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Property name     : ');
  readln(Prop.PropertyName);
  ClrScr;
  Seq := -1;
  Prop.MoreSegments := $FF;
  result := 0;
  while (Prop.MoreSegments = $FF) and (Result <> $FB) do
  begin
    Result := ScanProperty(Obj, Prop, Seq);
    GotoXY(10,2);
    writeln(' Result  : $', Convert2Hex(Result));
    GotoXY(10,4);
    write('PropertyName  : ', Prop.PropertyName);
    GotoXY(10,5);
    write('PropertyFlags : ', Prop.PropertyFlag);
    GotoXY(10,6);
    write('PropertySec   : ', Prop.PropertySec);
    GotoXY(10,7);
    write('PropertyValue : ', Prop.PropValueFlag);
    GotoXY(10,8);
    write('MoreProp      : ', Prop.MoreSegments);
    GotoXY(5,22);
    write(' Press key to continue ');
    Input := UpCase(ReadKey);
  end;
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery Q
 }

procedure BinderyQ;

var
  Obj   : tBinderyObj;
  Prop  : tProperty;
  Seq   : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Change property security');
  GotoXY(5,8);
  write('Desc : Changes the security of an property');
  GotoXY(5,10);
  write('Call : function ChangePropertySecurity(Obj : tBinderyObj;');
  GotoXY(5,11);
  write('                                       var Prop : tProperty):Byte;');
  GotoXY(5,13);
  write('Request : Obj.ObjectType     = Object type to scan for property');
  GotoXY(5,14);
  write('          Obj.ObjectName     = Object name to scan');
  GotoXY(5,15);
  write('          Prop.PropertySec   = New property security');
  GotoXY(5,16);
  write('          Prop.PropertyName  = Name of property');
  GotoXY(5,18);
  write('Reply   : Error-code (See NvMain)');
  GotoXY(5,24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object type       : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Property name     : ');
  readln(Prop.PropertyName);
  GotoXY(10,7);
  Write(' Property sec      : ');
  readln(Prop.PropertySec);
  ClrScr;
  result := 0;
  Result := ChangePropertySecurity(Obj, Prop);

  GotoXY(10,2);
  writeln(' Result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery R
 }

procedure BinderyR;

var
  Obj   : tBinderyObj;
  Prop  : tProperty;
  Seq   : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Verify bindery object password');
  GotoXY(5,8);
  write('Desc : Verifies the password of an bindery object');
  GotoXY(5,10);
  write('Call : function VerifyBinderyPassword(Obj : tBinderyObj):Byte;');
  GotoXY(5,12);
  write('Request : Obj.ObjectType     = Object type to verify');
  GotoXY(5,14);
  write('          Obj.ObjectName     = Object name to verify');
  GotoXY(5,16);
  write('          Obj.Password       = Password to verify');
  GotoXY(5,18);
  write('Reply   : Error-code (see NvMain)');
  GotoXY(5,24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object type       : ');
  readln(Obj.ObjectType);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(Obj.ObjectName);
  GotoXY(10,6);
  Write(' Password    : ');
  readln(Obj.ObjectPassword);
  Result := VerifyBinderyPassword(Obj);
  ClrScr;
  GotoXY(10,2);
  writeln(' Result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery S
 }

procedure BinderyS;

var
  ObjSet   : tBinderyObjSet;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Add bindery object to set');
  GotoXY(5,8);
  write('Desc : Add a bindery object to an set');
  GotoXY(5,10);
  write('Call : function AddBinderyObject2Set(ObjSet : tBinderyObjSet):Byte;');
  GotoXY(5,12);
  write('Request : ObjSet.ObjectType   = Typ of object');
  GotoXY(5,13);
  write('          ObjSet.ObjectName   = Name of object');
  GotoXY(5,14);
  write('          ObjSet.ProprtyName  = Name of property');
  GotoXY(5,15);
  write('          ObjSet.MemberTyp    = Typ of member');
  GotoXY(5,16);
  write('          ObjSet.MemberName   = member-name');
  GotoXY(5,18);
  write('Reply   : Error-code (See Nvmain)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object typ        : ');
  readln(ObjSet.ObjectTyp);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(ObjSet.ObjectName);
  GotoXY(10,6);
  Write(' Property name     : ');
  readln(ObjSet.PropertyName);
  GotoXY(10,7);
  Write(' Member type      : ');
  readln(ObjSet.MemberTyp);
  GotoXY(10,8);
  Write(' Member name       : ');
  readln(ObjSet.MemberName);
  Result := AddBinderyObject2Set(ObjSet);
  GotoXY(5, 10);
  write(' Result   : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery T
 }

procedure BinderyT;

var
  ObjSet  : tBinderyObjSet;
  Prop    : tProperty;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write(' Delete bindery object from set');
  GotoXY(5,8);
  write('Desc : Deletes an bindery object from an existing set');
  GotoXY(5,10);
  write('Call : function DeleteBinderyObjectFromSet(ObjSet : tBinderyObjSet):Byte;');
  GotoXY(5,12);
  write('Request : ObjSet.ObjectType   = Typ of object');
  GotoXY(5,13);
  write('          ObjSet.ObjectName   = Name of object');
  GotoXY(5,14);
  write('          ObjSet.ProprtyName  = Name of property');
  GotoXY(5,15);
  write('          ObjSet.MemberTyp    = Typ of member');
  GotoXY(5,16);
  write('          ObjSet.MemberName   = member-name');
  GotoXY(5,18);
  write('Reply   : Error-code (See Nvmain)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object typ        : ');
  readln(ObjSet.ObjectTyp);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(ObjSet.ObjectName);
  GotoXY(10,6);
  Write(' Property name     : ');
  readln(ObjSet.PropertyName);
  GotoXY(10,7);
  Write(' Member type      : ');
  readln(ObjSet.MemberTyp);
  GotoXY(10,8);
  Write(' Member name       : ');
  readln(ObjSet.MemberName);
  Result := DeleteBinderyObjectFromSet(ObjSet);
  GotoXY(5, 10);
  write(' Result   : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery U
 }

procedure BinderyU;

var
  ObjSet   : tBinderyObjSet;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Is object in set');
  GotoXY(5,8);
  write('Desc : Test`s if the bindery object is in the set');
  GotoXY(5,10);
  write('Call : function IsObjectInSet(ObjSet : tBinderyObjSet):Byte;');
  GotoXY(5,12);
  write('Request : ObjSet.ObjectType   = type of object');
  GotoXY(5,13);
  write('          ObjSet.ObjectName   = Name of object');
  GotoXY(5,14);
  write('          ObjSet.ProprtyName  = Name of property');
  GotoXY(5,15);
  write('          ObjSet.MemberTyp    = Typ of member');
  GotoXY(5,16);
  write('          ObjSet.MemberName   = Member name');
  GotoXY(5,18);
  write('Reply   : Error-code (See Nvmain)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object typ        : ');
  readln(ObjSet.ObjectTyp);
  GotoXY(10,5);
  Write(' Object name       : ');
  readln(ObjSet.ObjectName);
  GotoXY(10,6);
  Write(' Property name     : ');
  readln(ObjSet.PropertyName);
  GotoXY(10,7);
  Write(' Member typ       : ');
  readln(ObjSet.MemberTyp);
  GotoXY(10,8);
  Write(' Member name       : ');
  readln(ObjSet.MemberName);

  Result := IsObjectInSet(ObjSet);

  ClrScr;
  GotoXY(5,10);
  write(' Result   : $', Convert2Hex(Result));

  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery V
 }

procedure BinderyV;

var
  Acc   : tAccount;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Submit account charge');
  GotoXY(5,8);
  write('Desc : Submits an account charge');
  GotoXY(5,10);
  write('Call : function SubmitAccountCharge(Acc : Account):Byte;');
  GotoXY(5,12);
  write('Request : Acc.ServiceType  = Service type of object');
  GotoXY(5,13);
  write('          Acc.AccCharged   = Amount to be charged');
  GotoXY(5,14);
  write('          Acc.PriorHold    = Amount of prior hold to be cancelled');
  GotoXY(5,15);
  write('          Acc.BinderyType  = Bindery object type');
  GotoXY(5,16);
  write('          Acc.CommentType  = Type of comment 8000h-FFFFh for experimental');
  GotoXY(5,17);
  write('          Acc.ObjectName   = Name of object');
  GotoXY(5,18);
  write('          Acc.Comment      = Account comment');
  GotoXY(5,20);
  write('Reply   : Error-code (See NvBindery');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Service type      : ');
  readln(Acc.ServiceType);
  GotoXY(10,5);
  Write(' Account charged   : ');
  readln(Acc.AccCharged);
  GotoXY(10,6);
  Write(' Prior hold        : ');
  readln(Acc.PriorHold);
  GotoXY(10,7);
  Write(' Bindery type      : ');
  readln(Acc.BinderyType);
  GotoXY(10,8);
  Write(' Comment type      : ');
  readln(Acc.CommentType);
  GotoXY(10,9);
  Write(' Object name       : ');
  readln(Acc.ObjectName);
  GotoXY(10,10);
  Write(' Comment           : ');
  readln(Acc.Comment);
  ClrScr;
  Result := SubmitAccountCharge(Acc);
  GotoXY(10,4);
  write(' Result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery W
 }

procedure BinderyW;

var
  Acc   : tAccount;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Submit account hold');
  GotoXY(5,8);
  write('Desc : Submits an account hold');
  GotoXY(5,10);
  write('Call : function SubmitAccountHold(Acc : Account):Byte;');
  GotoXY(5,12);
  write('Request : Acc.AccReserved  = Amount of account balance to reserve');
  GotoXY(5,13);
  write('          Acc.BinderyType  = Bindery object type');
  GotoXY(5,14);
  write('          Acc.ObjectName   = Name of object');
  GotoXY(5,16);
  write('Reply   : Error-code (See NvMain)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Account reserved  : ');
  readln(Acc.AccReserved);
  GotoXY(10,5);
  Write(' Bindery type      : ');
  readln(Acc.BinderyType);
  GotoXY(10,6);
  Write(' Object name       : ');
  readln(Acc.ObjectName);
  ClrScr;
  GotoXY(10,4);
  Result := SubmitAccountHold(Acc);

  write('  Result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery Y
 }

procedure BinderyY;

var
  Acc   : tAccount;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Submit account note');
  GotoXY(5,8);
  write('Desc : Submits an account note');
  GotoXY(5,10);
  write('Call : function SubmitAccountNote(Acc : Account):Byte;');
  GotoXY(5,12);
  write('Request : Acc.ServiceType  = Service type of object');
  GotoXY(5,13);
  write('          Acc.AccCharged   = Amount to be charged');
  GotoXY(5,14);
  write('          Acc.PriorHold    = Amount of prior hold to be cancelled');
  GotoXY(5,15);
  write('          Acc.BinderyType  = Bindery object type');
  GotoXY(5,16);
  write('          Acc.CommentType  = Type of comment 8000h-FFFFh for experimental');
  GotoXY(5,17);
  write('          Acc.ObjectName   = Name of object');
  GotoXY(5,18);
  write('          Acc.Comment      = Account comment');
  GotoXY(5,20);
  write('Reply   : Error-code (See Nvmain)');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Service type      : ');
  readln(Acc.ServiceType);
  GotoXY(10,5);
  Write(' Account charged   : ');
  readln(Acc.AccCharged);
  GotoXY(10,6);
  Write(' Prior hold        : ');
  readln(Acc.PriorHold);
  GotoXY(10,7);
  Write(' Bindery type      : ');
  readln(Acc.BinderyType);
  GotoXY(10,8);
  Write(' Comment type      : ');
  readln(Acc.CommentType);
  GotoXY(10,9);
  Write(' Object name       : ');
  readln(Acc.ObjectName);
  GotoXY(10,10);
  Write(' Comment           : ');
  readln(Acc.Comment);
  ClrScr;
  GotoXY(10,4);
  write(' Result : $', Convert2Hex(SubmitAccountCharge(Acc)));
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure bindery 1
 }

procedure Bindery1;

var
  AccStatus   : tAccountStatus;
  ObjectName  : String;
  ObjectTyp   : Word;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell bindery unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get account status');
  GotoXY(5,8);
  write('Desc : Gets an objects account status');
  GotoXY(1,10);
  writeln('   Call : function GetAccountStatus(var AccStatus : tAccountStatus;');
  writeln('                                    ObjectTyp : Word):Byte;');
  writeln('                                    var ObjectName : String;',^j^m);
  writeln('  Request : ObjectTyp     = Object tpye');
  writeln('            ObjectName    = Name of object',^j^m);
  writeln('  Reply   : AccStatus     = status list of object');
  writeln('            Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Object-type      : ');
  readln(ObjectTyp);
  GotoXY(10,5);
  Write(' Object-name      : ');
  readln(ObjectName);
  ClrScr;
  GotoXY(10,4);
  Result := GetAccountStatus(AccStatus, ObjectName, ObjectTyp);
  GotoXY(5,10);
  writeln(' Result : $', Convert2Hex(Result));
  if Result = neSuccessfull then
  begin
    with AccStatus do
    begin
      writeln(' Account balance   : ', AccBalance);
      writeln(' Credit limit      : ', CreditLimit,^j^m);
      writeln(' Press key to continue');
      readln;
      writeln('Server list : ');
      for i := 1 to 16 do
      begin
        writeln(' Server id       : ', ServerList[i].ServerId);
        writeln(' Server amount   : ', ServerList[i].ServerAmount);
      end;
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                   Main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for bindery unit (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5,4);
    write('A : Open bindery,##');
    GotoXY(5,5);
    write('B : Close bindery,##');
    GotoXY(5,6);
    write('C : Get bindery access level,##');
    GotoXY(5,7);
    write('D : Create bindery object,##');
    GotoXY(5,8);
    write('E : Delete bindery object,##');
    GotoXY(5,9);
    write('F : Rename bindery object,##');
    GotoXY(5,10);
    write('G : Get bindery object id,##');
    GotoXY(5,11);
    write('H : Get bindery object name,##');
    GotoXY(5,12);
    write('I : Scan bindery object,##');
    GotoXY(5,13);
    write('J : Change bindery object security,##');
    GotoXY(5,14);
    write('K : Change bindery object password,##');
    GotoXY(5,15);
    write('L : Create property,##');
    GotoXY(5,16);
    write('M : Delete property,##');
    GotoXY(5,17);
    write('N : Read property value,##');
    GotoXY(5,18);
    write('O : Write property value,##');
    GotoXY(45,4);
    write('P : Scan property,##');
    GotoXY(45,5);
    write('Q : Change property security,##');
    GotoXY(45,6);
    write('R : Verify bindery password,##');
    GotoXY(45,7);
    write('S : Add bindery object to set,##');
    GotoXY(45,8);
    write('T : Delete bindery obj from set,##');
    GotoXY(45,9);
    write('U : Is bindery object in set,##');
    GotoXY(45,10);
    write('V : Submit account charge');
    GotoXY(45,11);
    write('W : Submit account hold');
    GotoXY(45,12);
    write('Y : Submit account note');
    GotoXY(45,13);
    write('1 : Get account status');
    GotoXY(20,20);
    write('X : Exit program, choose function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : BinderyA;
      'B' : BinderyB;
      'C' : BinderyC;
      'D' : BinderyD;
      'E' : BinderyE;
      'F' : BinderyF;
      'G' : BinderyG;
      'H' : BinderyH;
      'I' : BinderyI;
      'J' : BinderyJ;
      'K' : BinderyK;
      'L' : BinderyL;
      'M' : BinderyM;
      'N' : BinderyN;
      'O' : BinderyO;
      'P' : BinderyP;
      'Q' : BinderyQ;
      'R' : BinderyR;
      'S' : BinderyS;
      'T' : BinderyT;
      'U' : BinderyU;
      'V' : BinderyV;
      'W' : BinderyW;
      'X' : halt(0);
      'Y' : BinderyY;
      '1' : Bindery1;
    end;
  until false;
end.

