 {ͻ
   Prog.: FiSampl2                               Target Platforms :      
   Desc : Sample program for file services       - real Mode             
          part II                                - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program FiSampl2;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvMain,
  NvFile;

{
              VAR declarations
 }

var
  Input : Char;
  i,j   : Integer;

{
              procedure File A
 }

procedure FileA;

var
  Path      : String;
  Error,
  Handle,
  Flags,
  Rights    : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get effective Directory Rights');
  GotoXY(5,8);
  write('Desc : Gets the effective Directory Rights of an Directory');
  GotoXY(5,10);
  write('Call : function GetDirRights(Path : String;Handle : Byte;');
  GotoXY(5,11);
  Write('       Rights : Byte):Byte;');
  GotoXY(5,13);
  write('Request  : Path                = Diretory Path to get Rights');
  GotoXY(5,14);
  write('           Handle              = Handle of Directory');
  GotoXY(5,16);
  write('Reply    : Rights              = effective Dir-Rights (see Nvmain)');
  GotoXY(5,17);
  write('           Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Path          : ');
  readln(Path);
  GetDirHandle(Handle,Flags,'F');
  Error := GetDirRights(Path,Handle,Rights);
  case Error of
    Successfull           :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Successfull ',Rights);
      GotoXY(10,5);
      Write(' The Rights for this Directory : ');
        GotoXY(44,5);
        if Rights and ReadAllowed <> 0 then
          write(' Read allowed')
        else
          write(' Read not allowed');
        GotoXY(44,6);
        if Rights and WriteAllowed <> 0 then
          write(' Write allowed')
        else
          write(' Write not allowed');
        GotoXY(44,7);
        if Rights and CreateAllowed <> 0 then
          write(' Create allowed')
        else
          write(' Create not allowed');
        GotoXY(44,8);
        if Rights and EraseAllowed <> 0 then
          write(' Erase allowed')
        else
          write(' Erase not allowed');
        GotoXY(44,9);
        if Rights and AccessControl <> 0 then
          write(' Access Control')
        else
          write(' No Access Control');
        GotoXY(44,10);
        if Rights and FileScan <> 0 then
          write(' File-Scan')
        else
          write(' File-Scan');
        GotoXY(44,11);
        if Rights and ModifyAllowed <> 0 then
          write(' Modify allowed')
        else
          write(' Modify not allowed');
        GotoXY(44,12);
        if Rights = Supervisory then
          write(' Supervisory')
        else
          write(' No Supervisory');
    end;
    CallerLacksPriv       :
    begin
      ClrScr;
      GotoXY(10,4);
      write(' Caller lacks Privlege');
    end;
    NotPermittSearchDir   :
    begin
      ClrScr;
      GotoXY(10,4);
      write(' Not permitted to search Directory');
    end;
    FileNotFound          :
    begin
      ClrScr;
      GotoXY(10,4);
      write(' File not found');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File B
 }

procedure FileB;

var
  Path      : String;
  Error,
  Handle,
  Flags,
  Grant,
  Revoke    : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Modify Maximum Rights Mask');
  GotoXY(5,8);
  write('Desc : Sets the maximum Directory Rights of an Directory');
  GotoXY(5,10);
  write('Call : function ModifyDirRights(Path : String;');
  GotoXY(5,11);
  write('       Handle,Grant,Revoke : Byte):Byte;');
  GotoXY(5,13);
  write('Request  : Path                = Diretory Path to get Rights');
  GotoXY(5,14);
  write('           Handle              = Handle of Directory');
  GotoXY(5,15);
  write('           Grant               = Rights to grant');
  GotoXY(5,16);
  write('           Revoke              = Rights to revoke');
  GotoXY(5,18);
  write('Reply    : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,2);
  write('ReadAllowed      = 5');
  GotoXY(10,3);
  write('WriteAllowed     = 6');
  GotoXY(10,4);
  write('CreateAllowed    = 11');
  GotoXY(10,5);
  write('EraseAllowed     = 16');
  GotoXY(10,6);
  write('AccessControl    = 32');
  GotoXY(10,7);
  write('FileScan         = 64');
  GotoXY(10,8);
  write('ModifyAllowed    = 128');
  GotoXY(10,9);
  write('Supervisory      = 255');
  GotoXY(10,11);
  Write(' Path             : ');
  readln(Path);
  GetDirHandle(Handle,Flags,'F');
  GotoXY(10,12);
  Write(' Rights to grant  : ');
  readln(Grant);
  GotoXY(10,13);
  Write(' Rights to revoke : ');
  readln(Revoke);
  Error := ModifyDirRights(Path,Handle,Grant,Revoke);
  case Error of
    Successfull           :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Successfull ');
    end;
    NoModifyPrivileges     :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Not permitted to modify');
    end;
    NonExistentVol       :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Non existent Volume');
    end;
    InvalidPath          :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Invalid Path');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File C
 }

procedure FileC;

var
  NewDir    : String;
  Error,
  Handle,
  Flags,
  DirRights : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Create Directory');
  GotoXY(5,8);
  write('Desc : Creates an new Directory');
  GotoXY(5,10);
  write('Call : function CreateDirectory(NewDir : String;');
  GotoXY(5,11);
  write('       Handle,DirRights : Byte):Byte;');
  GotoXY(5,13);
  write('Request  : NewDir              = Diretory to create');
  GotoXY(5,14);
  write('           Handle              = Handle of Directory');
  GotoXY(5,15);
  write('           DirRights           = Rights of Dir to create');
  GotoXY(5,17);
  write('Reply    : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,2);
  write('ReadAllowed      = 5');
  GotoXY(10,3);
  write('WriteAllowed     = 6');
  GotoXY(10,4);
  write('CreateAllowed    = 11');
  GotoXY(10,5);
  write('EraseAllowed     = 16');
  GotoXY(10,6);
  write('AccessControl    = 32');
  GotoXY(10,7);
  write('FileScan         = 64');
  GotoXY(10,8);
  write('ModifyAllowed    = 128');
  GotoXY(10,9);
  write('Supervisory      = 255');
  GotoXY(10,11);
  Write(' New Directory    : ');
  readln(NewDir);
  GetDirHandle(Handle,Flags,'F');
  GotoXY(10,12);
  Write(' Directory Rights : ');
  readln(DirRights);
  Error := CreateDirectory(NewDir,Handle,DirRights);
  case Error of
    Successfull           :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Successfull ');
    end;
    NoCreatePrivileges     :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Not permitted to create Directory');
    end;
    NonExistentVol       :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' Non existent Volume');
    end;
    NoSuchObject         :
    begin
      ClrScr;
      GotoXY(10,3);
      write(' No such Object');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File D
 }

procedure FileD;

var
  DelDir    : String;
  Error,
  Handle,
  Flags     : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Delete Directory');
  GotoXY(5,8);
  write('Desc : Deletes an Directory');
  GotoXY(5,10);
  write('Call : function DeleteDirectory(Path : String;Handle : Byte):Byte;');
  GotoXY(5,12);
  write('Request  : Path                = Diretory to delete');
  GotoXY(5,13);
  write('           Handle              = Handle of Directory');
  GotoXY(5,15);
  write('Reply    : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Directory to delete : ');
  readln(DelDir);
  GetDirHandle(Handle,Flags,'F');
  Error := DeleteDirectory(DelDir,Handle);
  ClrScr;
  GotoXY(10,3);
  write(' Error : $' ,Convert2Hex(Error));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File E
 }

procedure FileE;

var
  OldPath,
  NewName     : String;
  Error,
  Handle,
  Flags     : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Rename Directory');
  GotoXY(5,8);
  write('Desc : Renames an Directory');
  GotoXY(5,10);
  write('Call : function RenameDirectory(OldPath,NewName : String;');
  GotoXY(5,11);
  write('       Handle : Byte):Byte;');
  GotoXY(5,13);
  write('Request  : OldPath             = Path of Directory (Network Styled)');
  GotoXY(5,14);
  write('           NewName             = New Name of Directory (only Name !)');
  GotoXY(5,15);
  write('           Handle              = Handle of Directory');
  GotoXY(5,17);
  write('Reply    : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Directory to rename : ');
  readln(OldPath);
  GotoXY(10,5);
  Write(' New Name            : ');
  readln(NewName);
  GetDirHandle(Handle,Flags,'F');
  Error := RenameDirectory(OldPath,NewName,Handle);
  GotoXY(10,3);
  write(' Error  : $ ', Convert2Hex(Error));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File F
 }

procedure FileF;

var
  Path  : String;
  Trustee : tTrusteeRec;
  Handle,
  Seq,
  Flags : byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Scan directory for trustee');
  GotoXY(5,8);
  write('Desc : Scans an directory for trustees');
  GotoXY(5,10);
  write('Call : function ScanTrustees(var Trustee : TrusteeRec;');
  GotoXY(5,11);
  write('       Path : String;Handle,Seq : Byte):boolean;');
  GotoXY(5,13);
  write('Request : Path        = Path to scan (Network styled path !!)');
  GotoXY(5,14);
  write('          Handle      = Directory-handle of path');
  GotoXY(5,15);
  write('          Seq         = Sequenze number call first 00 then inc');
  GotoXY(5,17);
  write('Reply   : false if no more trustees');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Path          : ');
  readln(Path);
  GetDirHandle(Handle,Flags,'F');
  Seq := 1;
  while ScanTrustees(Trustee,Path,Handle,Seq) do
  begin
    ClrScr;
    with Trustee do
    begin
      GotoXY(10,4);
      Write(' Dirname                      : ',DirName);
      GotoXY(10,5);
      Write(' Creation date/time (packed)  : ');
      for i := 1 to 4 do write(CrDateTime[i]);
      GotoXY(10,6);
      Write(' Dir-owner id                 : ',Owner);
      GotoXY(10,7);
      Write(' Trustees id                  : ');
      for i := 0 to 4 do
      begin
        GotoXY(42,7 + i);
        write('No : ',i,' ',Trustees[i]);
      end;
      GotoXY(10,13);
      Write(' Trustees dir-rights          : ');
      for i := 0 to 4 do
      begin
        GotoXY(42,13 + i);
        write('No : ',i,' ',TrusteeRight[i],' ');
      end;
      GotoXY(5,22);
      write(' Press key to continue ');
      Input := UpCase(ReadKey);
    end;
    Inc(Seq);
  end;
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File G
 }

procedure FileG;

var
  Path          : String;
  Trustee       : tTrusteeRec;
  Handle,
  Flags         : byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Add trustee to directory');
  GotoXY(5,8);
  write('Desc : Adds an trustee to directory');
  GotoXY(5,10);
  write('Call : function AddTrustee(Trustee : TrusteeRec;');
  GotoXY(5,11);
  write('Handle : Byte;Path : String):Byte;');
  GotoXY(5,11);
  write('       Path : String;Handle,Seq : Byte):boolean;');
  GotoXY(5,13);
  write('Request : Path                    = Path to add trustee (network styled)');
  GotoXY(5,14);
  write('          Handle                  = Directory-handle of path');
  GotoXY(5,15);
  write('          Trustee.TrusteeId       = Object Id of new trustee');
  GotoXY(5,16);
  write('          Trustee.TrusteeRight    = Rights for new trustee');
  GotoXY(5,18);
  write('Reply   : Error-Code (see Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Path          : ');
  readln(Path);
  GotoXY(10,5);
  Write(' Trustee-Id    : ');
  readln(Trustee.Trustees[0]);
  GotoXY(10,6);
  Write(' Trustee-Rights: ');
  readln(Trustee.TrusteeRight[0]);
  GetDirHandle(Handle,Flags,'F');
  case AddTrustee(Trustee,Handle,Path) of
    SuccessFull          :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Successfull !');
    end;
    NoModifyPrivileges     :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Not permitted to modify Trustees !');
    end;
    NoSuchObject         :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Not such an Object');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File H
 }

procedure FileH;

var
  Path  : String;
  Trustee : tTrusteeRec;
  Handle,
  Flags : byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Delete Trustee from Directory');
  GotoXY(5,8);
  write('Desc : Deletes an Trustee from an Directory');
  GotoXY(5,10);
  write('Call : function DeleteTrustee(Trustee : TrusteeRec;');
  GotoXY(5,11);
  write('Handle : Byte;Path : String):Byte;');
  GotoXY(5,11);
  write('       Path : String;Handle,Seq : Byte):boolean;');
  GotoXY(5,13);
  write('Request : Path                    = Path to add Trustee (Network Styled)');
  GotoXY(5,14);
  write('          Handle                  = Directory-Handle of Path');
  GotoXY(5,15);
  write('          Trustee.TrusteeId[0]    = Object Id of new Trustee');
  GotoXY(5,17);
  write('Reply   : Error-Code (see Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Path          : ');
  readln(Path);
  GotoXY(10,5);
  Write(' Trustee-Id    : ');
  readln(Trustee.Trustees[0]);
  GetDirHandle(Handle,Flags,'F');
  case DeleteTrustee(Trustee,Handle,Path) of
    SuccessFull          :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Successfull !');
    end;
    NonExistentVol       :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Volume doesn`t exist');
    end;
    InvalidPath          :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Invalid Path');
    end;
    NoModifyPrivileges     :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Not permitted to modify Trustees !');
    end;
    NoSuchObject         :
    begin
      ClrScr;
      GotoXY(10,4);
      Write('Not such an Object');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File I
 }

procedure FileI;

var
  Drive  : Char;
  Volume : tVolInfo;
  Handle,
  Flags  : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get volume information with handle (V)');
  GotoXY(5,8);
  write('Desc : Gets extended information about an volume');
  GotoXY(5,10);
  write('Call : function GetVolumeInfo(Var Volume :VolInfo;DirHandle : Byte):boolean;');
  GotoXY(5,12);
  write('Request : DirHandle          = Handle of an Drive mapped to the Volume');
  GotoXY(5,14);
  write('Reply   : SecPerBlock        = Sectors per Blocks');
  GotoXY(5,15);
  write('          TotalBlocks        = Total Blocks on Volume');
  GotoXY(5,16);
  write('          AvailBlocks        = Available Blocks on Volume');
  GotoXY(5,17);
  write('          TotalDirSlots      = Total Directory Slots');
  GotoXY(5,18);
  write('          AvailDirSlots      = Available Directory Slots');
  GotoXY(5,19);
  write('          VolName            = Name of Volume');
  GotoXY(5,20);
  write('          VolRemovable       = true if Volume removable');
  GotoXY(5,21);
  write('          Error-Code returned by Function (see NVMain)');
  GotoXY(5,22);
  write(' See also "Get volume info with number" !!');
  GotoXY(5,23);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Drive to get Vol-Info : ');
  readln(Drive);
  GetDirHandle(Handle, Flags, Drive);
  if GetVolumeInfoWithHandle(Volume, Handle) then
  begin
    ClrScr;
    GotoXY(10,4);
    Writeln(' Successfull done ');
    with Volume do
    begin
      GotoXY(10,6);
      write('Sectors per Blocks           : ',SecPerBlock);
      GotoXY(10,7);
      write('Total Blocks on Volume       : ',TotalBlocks);
      GotoXY(10,8);
      write('Available Blocks on Volume   : ',AvailBlocks);
      GotoXY(10,9);
      write('Total Directory Slots        : ',TotalDirSlots);
      GotoXY(10,10);
      write('Available Directory Slots    : ',AvailDirSlots);
      GotoXY(10,11);
      write('Name of Volume               : ',VolName);
      GotoXY(10,12);
      write('Volume removable             : ',VolRemovable);
    end;
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    Writeln(' Error during Execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File J
 }

procedure FileJ;

var
  VolNo  : Byte;
  Volume : tExtVolInfo;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get extended volume information (V)');
  GotoXY(5,8);
  write('Desc : Gets extended Information about an volume');
  GotoXY(5,10);
  write('Call : function GetExtendedVolumeInfo(Var Volume : tExtVolInfo;');
  GotoXY(5,11);
  write('                                      VolumeNo : Byte):boolean;');
  GotoXY(5,13);
  write('Request : DirHandle          = Handle of an Drive mapped to the Volume');
  GotoXY(5,15);
  write('Reply   : TotalBlocks        = Total blocks of volume');
  GotoXY(5,16);
  write('          FreeBlocks         = Free blocks on volume');
  GotoXY(5,17);
  write('          PurgeableBlocks    = Purgebale blocks on Volume');
  GotoXY(5,18);
  write('          NotYetPurgable     = Not yet purgebale blocks');
  GotoXY(5,19);
  write('          TotalDirEntries    = Total directory entries');
  GotoXY(5,20);
  write('          AvailDirEntries    = Available directory entries');
  GotoXY(5,21);
  write('          Flags              = Volume flags');
  GotoXY(5,22);
  write('          SectorsPerBlock    = Sectory per block');
  GotoXY(5,23);
  write('          VolumeName         = Volume name');
  GotoXY(5,24);
  write('          Error-Code returned by Function (see NVMain)');
  GotoXY(5,25);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Vol-no to get vol-info : ');
  readln(VolNo);
  if GetExtendedVolumeInfo(Volume, VolNo) then
  begin
    ClrScr;
    GotoXY(10,4);
    Writeln(' Successfull done ');
    with Volume do
    begin
      GotoXY(10,6);
      write('Total blocks                 : ',TotalBlocks);
      GotoXY(10,7);
      write('Free blocks on volume        : ',FreeBlocks);
      GotoXY(10,8);
      write('Purgebale blocks             : ',PurgableBlocks);
      GotoXY(10,9);
      write('Not yet purgebale            : ',NotYetPurgable);
      GotoXY(10,10);
      write('Total directory entries      : ',TotalDirEntries);
      GotoXY(10,11);
      write('Available directory entries  : ',AvailDirEntries);
      GotoXY(10,12);
      write('Flags                        : ',Flags);
      GotoXY(10,13);
      write('Sectors per block            : ',SectorsPerBlock);
      GotoXY(10,14);
      write('Volume name                  : ',VolumeName);
    end;
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    Writeln(' Error during Execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File K
 }

procedure FileK;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Numbers of local Drives');
  GotoXY(5,8);
  write('Desc : Gets the Number of Local Drives as set in Lastdrive in Config.Sys');
  GotoXY(5,10);
  write('Call       : function LocalDrives:Byte;');
  GotoXY(5,12);
  write('Reply      : Number of Local Drives');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Writeln(' Number of local Drives =  ',LocalDrives);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File L
 }

procedure FileL;

var
  IdTable    : DriveTable;
  i          : Integer;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Drive Connection Id');
  GotoXY(5,8);
  write('Desc : Gets the 32 Byte Table of the Connection-Ids of the Drives');
  GotoXY(5,11);
  write('Call : procedure GetDriveConnId(Var IDTable : DriveTable);');
  GotoXY(5,13);
  write('Reply  : Id-Table,each Byte containts the Number of Server to which');
  GotoXY(5,14);
  write('         the Drive is connected or zero if not mapped');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetDriveConnId(IDTable);
  Writeln;
  for i := 1 to 26 do
  begin
    Write('   Drive : ',Chr(i+64));
    if IdTable[i] = 0 then
      WriteLn(' not mapped to an Network Drive')
    else
      WriteLn(' connected to Server : ',IdTable[i]);
    if i = 23 then
    begin
      write(' Press Key to continue ');
      Input := UpCase(ReadKey);
      ClrScr;
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File M
 }

procedure FileM;

var
  FlagTable    : DriveTable;
  i          : Integer;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Drive Flag Table');
  GotoXY(5,8);
  write('Desc : Gets the 32 Byte Flag Table');
  GotoXY(5,11);
  write('Call : procedure GetDriveFlagTable(Var FlagTable : DriveTable);');
  GotoXY(5,13);
  write('Reply  : Flag-Table,each Byte containts the Mapping of the Drive');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetDriveFlagTable(FlagTable);
  Writeln;
  for i := 1 to 26 do
  begin
    Write('   Drive : ',Chr(i+64));
    case FlagTable[i] of
      DriveNotMapped    : WriteLn(' Drive not mapped');
      PermNetDrive      : WriteLn(' Permanent Network Drive');
      TempNetDrive      : Writeln(' Temporaery Network Drive');
      MappedLocal       : Writeln(' Mapped to local Drive');
      LocalPermNetDrive : Writeln(' Local permanent Network Drive');
      LocalTempNetDrive : Writeln(' Local temporaery Network Drive');
    end;
    if i = 23 then
    begin
      write(' Press Key to continue ');
      Input := UpCase(ReadKey);
      ClrScr;
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File N
 }

procedure FileN;

var
  HandleTable   : DriveTable;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Drive Handle Table');
  GotoXY(5,8);
  write('Desc : Gets the Handle of each Drive');
  GotoXY(5,10);
  write('Call : procedure GetDriveHandleTable(Var HandleTable : DriveTable);');
  GotoXY(5,12);
  write('Request : HandleTable      = Handle Table which contains the Handles');
  GotoXY(5,13);
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetDriveHandleTable(HandleTable);
  Writeln;
  for i := 1 to 26 do
  begin
    WriteLn('   Drive ',Chr(i+64),' : ',HandleTable[i]);
    if i = 23 then
    begin
      write(' Press Key to continue ');
      Input := UpCase(ReadKey);
      ClrScr;
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File O
 }

procedure FileO;

var
  VolName       : String;
  VolNo         : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get Volume Number');
  GotoXY(5,6);
  write('Desc : Gets the Volume Number of an Volume');
  GotoXY(5,8);
  write('Call : function GetVolumeNumber(VolumeName : String;var VolNo : Byte):Byte;');
  GotoXY(5,10);
  write('Request : VolumeName     = Name of Volume');
  GotoXY(5,12);
  write('Reply   : VolNo          = Number of Volume');
  GotoXY(5,13);
  write('          Error returned by function ()ers of logical Drives');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Volume-Name : ');
  readln(VolName);
  case GetVolumeNumber(VolName,VolNo) of
    SuccessFull      :
    begin
      GotoXY(10,4);
      Writeln('Successfull,Volume-Number  : ',VolNo);
    end;
    NonExistentVol   :
    begin
      GotoXY(10,4);
      Writeln('Volume doesn`t exist');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File P
 }

procedure FileP;

var
  VolName       : String;
  VolNo         : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get Volume Name');
  GotoXY(5,6);
  write('Desc : Gets the Volume Name of an Volume-Number');
  GotoXY(5,8);
  write('Call : function GetVolumeName(VolNo : Byte;var VolumeName : String):Byte;');
  GotoXY(5,10);
  write('Request : VolNo          = Number of volume');
  GotoXY(5,12);
  write('Reply   : VolName        = Name of volume');
  GotoXY(5,13);
  write('          Error returned by function');
  GotoXY(5,22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Volume-No : ');
  readln(VolNo);
  case GetVolumeName(VolNo,VolName) of
    SuccessFull      :
    begin
      GotoXY(10,4);
      Writeln('Successfull,Volume-Name   : ',VolName);
    end;
    NonExistentVol   :
    begin
      GotoXY(10,4);
      Writeln('Volume doesn`t exist');
    end;
  end;
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File Q
 }

procedure FileQ;

var
  Drive         : Char;
  RootPath      : String;
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Map Root Directory');
  GotoXY(5,8);
  write('Desc : Maps an Directory to an Drive,');
  GotoXY(5,11);
  write('Call : function MapRootDirectory(Drive : Byte;RootPath : String):boolean;');
  GotoXY(5,13);
  write('Request : Drive = Drive No to root Network-Drive,');
  GotoXY(5,14);
  write('RootPath = Path to root ');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Drive : ');
  readln(Drive);
  GotoXY(10,5);
  Write(' Root Path  : ');
  readln(RootPath);
  ClrScr;
  Result := MapRootDirectory(Ord(UpCase(Drive)) - 64,RootPath);
  case Result of
    Successfull   :
    begin
      GotoXY(10,4);
      Writeln(' Successfull Done ! ');
    end;
    PathNotFound  :
    begin
      GotoXY(10,4);
      Writeln(' Path not found ! ');
    end;
    InvalidDrive  :
    begin
      GotoXY(10,4);
      Writeln(' Invalid Drive ! ');
    end;
    NotSameDevice :
    begin
      GotoXY(10,4);
      Writeln(' Not same Device ! ');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File R
 }

procedure FileR;

var
  Drive         : Char;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Delete Map Root Directory');
  GotoXY(5,8);
  write('Desc : Deletes an Drive Mapping');
  GotoXY(5,10);
  write('Call : procedure DeleteMapRootDirectory(Drive : Byte);');
  GotoXY(5,12);
  write('Request : Drive = Drive No to delete');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Drive : ');
  readln(Drive);
  DeleteMapRootDirectory(Ord(UpCase(Drive)) -64);
  ClrScr;
  GotoXY(10,4);
  Writeln(' Done ! ');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File S
 }

procedure FileS;

var
  Drive         : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Drive Depth');
  GotoXY(5,8);
  write('Desc : Gets the relative Drive Depth of an Fake Root Directory');
  GotoXY(5,10);
  write('Call : function GetDriveDepth(Drive : Byte):Byte;');
  GotoXY(5,12);
  write('Request : Drive = Drive No to get Depth');
  GotoXY(5,12);
  write('Reply   : Drive Depth by functions,FFh if no Fake Root');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Drive-no : ');
  readln(Drive);
  ClrScr;
  GotoXY(10,4);
  Writeln(' Drive Depth = ',GetDriveDepth(Drive));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File T
 }

procedure FileT;

var
  DirHandle     : Byte;
  Path          : String;
  DirEntry      : tDirEntry;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Convert path to dir-entry');
  GotoXY(5,8);
  write('Desc : Converts the path to volume-no and dir entry-id');
  GotoXY(5,10);
  write('Call : function ConvertPathToDirEntry(DirHandle : Byte;');
  GotoXY(5,11);
  write('                                      DirPath : String;');
  GotoXY(5,12);
  write('                                      var DirEntry : tDirEntry):Byte;');
  GotoXY(5,14);
  write('Request : DirHandle = Handle of directory');
  GotoXY(5,15);
  write('          DirPath   = Path of directory');
  GotoXY(5,16);
  write('Reply   : DirEntry  = Volume-no and dir entry-id');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Dir-handle : ');
  readln(DirHandle);
  GotoXY(10,5);
  Write(' Path       : ');
  readln(Path);
  ClrScr;
  ConvertPathToDirEntry(DirHandle, Path, DirEntry);
  GotoXY(10,4);
  Writeln(' DirEntry.VolumeNo = ', DirEntry.VolumeNo);
  GotoXY(10,6);
  Writeln(' DirEntry.EntryId  = ', DirEntry.EntryId);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File U
 }

procedure FileU;
begin
end;

{
              procedure File V
 }

procedure FileV;

var
  Result,
  VolumeNo       : Byte;
  DiskSpaceLimit : LongInt;
  ObjectId       : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Add user disk space restriction');
  GotoXY(5,8);
  write('Desc : adds an disk space restriction for a object');
  GotoXY(5,10);
  write('Call : function AddUserDiskSpaceRestriction(VolumeNo : Byte;');
  GotoXY(5,11);
  write('                                            ObjectId : LongInt;');
  GotoXY(5,12);
  write('                                            DiskSpaceLimit : LongInt):Byte;');
  GotoXY(5,14);
  write('Request : VolumeNo          = Volume-no');
  GotoXY(5,15);
  write('          ObjectId          = Object id of user');
  GotoXY(5,16);
  write('          DiskSpaceLimit    = Disk space to limit user');
  GotoXY(5,18);
  write('Reply   : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Volume-no. : ');
  readln(VolumeNo);
  GotoXY(10,5);
  Write(' Object-id  : ');
  readln(ObjectId);
  GotoXY(10,6);
  Write(' Disk space limit : ');
  readln(DiskSpaceLimit);
  ClrScr;
  Result := AddUserDiskSpaceRestriction(VolumeNo, ObjectId, DiskSpaceLimit);
  GotoXY(10,4);
  Writeln(' Result = $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File W
 }

procedure FileW;

var
  Result,
  VolumeNo       : Byte;
  ObjectId       : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Remove user disk space restriction');
  GotoXY(5,8);
  write('Desc : removes the disk space restriction for a object');
  GotoXY(5,10);
  write('Call : function RemoveUserDiskSpaceRestriction(VolumeNo : Byte;');
  GotoXY(5,11);
  write('                                               ObjectId : LongInt):Byte;');
  GotoXY(5,14);
  write('Request : VolumeNo          = Volume-no');
  GotoXY(5,15);
  write('          ObjectId          = Object id ');
  GotoXY(5,17);
  write('Reply   : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Volume-no. : ');
  readln(VolumeNo);
  GotoXY(10,5);
  Write(' Object-id  : ');
  readln(ObjectId);
  ClrScr;
  Result := RemoveUserDiskSpaceRestriction(VolumeNo,ObjectId);
  GotoXY(10,4);
  Writeln(' Result = ', Result);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File 1
 }

procedure File1;

var
  Result,
  VolumeNo       : Byte;
  ObjectId       : LongInt;
  DiskRestriction,
  DiskSpaceInUse : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get object disk usage and restriction');
  GotoXY(5,8);
  write('Desc : gets the disk usage and restriction of an object');
  GotoXY(5,10);
  write('Call : function GetObjectDiskUsage(VolumeNo : Byte;');
  GotoXY(5,11);
  write('                                   ObjectId : LongInt;');
  GotoXY(5,12);
  write('                                   var DiskRestriction : LongInt;');
  GotoXY(5,13);
  write('                                   var DiskSpaceInUse : LongInt):Byte;');
  GotoXY(5,15);
  write('Request : VolumeNo          = Volume-no');
  GotoXY(5,16);
  write('          ObjectId          = Object id ');
  GotoXY(5,17);
  write('          DiskRestriction   = disk space restriction of object');
  GotoXY(5,16);
  write('          DiskSpaceInUse    = objects disk space in use');
  GotoXY(5,18);
  write('Reply   : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Volume-no. : ');
  readln(VolumeNo);
  GotoXY(10,5);
  Write(' Object-id  : ');
  readln(ObjectId);
  ClrScr;
  Result := GetObjectDiskUsage(VolumeNo, ObjectId, DiskRestriction,
                               DiskSpaceInUse);
  GotoXY(10,4);
  Writeln(' Result = ', Result);
  GotoXY(10,5);
  Writeln(' Disk restriction  = ', DiskRestriction);
  GotoXY(10,6);
  Writeln(' Disk space in use = ', DiskSpaceInUse);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File 2
 }

procedure File2;

var
  Result,
  DirHandle      : Byte;
  DiskSpaceLimit : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set directory disk space restriction ');
  GotoXY(5,8);
  write('Desc : restricts an directory disk space');
  GotoXY(5,10);
  write('Call : function SetDirectoryDiskSpaceRestriction(DirHandle : Byte;');
  GotoXY(5,11);
  write('                                                 DiskSpaceLimit : LongInt):Byte;');
  GotoXY(5,13);
  write('Request : DirHandle         = Directory-handle');
  GotoXY(5,14);
  write('          DiskSpaceLimit    = Disk space limit for directory');
  GotoXY(5,16);
  write('Reply   : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Dir-handle : ');
  readln(DirHandle);
  GotoXY(10,5);
  Write(' Disk space limit : ');
  readln(DiskSpaceLimit);
  ClrScr;
  Result := SetDirectoryDiskSpaceRestriction(DirHandle, DiskSpaceLimit);

  GotoXY(10,4);
  Writeln(' Result = ', Result);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure File 3
 }

procedure File3;

var
  VolumeNo  : Byte;
  Trustee   : tTrusteePath;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Scan bindery objects directory for trustee');
  GotoXY(5, 8);
  write('Desc : Scans an objects trustees path');
  GotoXY(5, 10);
  write('Call : function ScanBindObjectTrusteePath(VolumeNo : Byte;');
  GotoXY(5, 11);
  write('                                         var TrusteePathRecord : tTrusteePath):Byte;');
  GotoXY(5, 13);
  write('Request : VolumeNo          : Volume-no to scan');
  GotoXY(5, 14);
  write('Reply :TrusteePathRecord.NextSeq       : Seq-no (first call 0 !)');
  GotoXY(5, 15);
  write('       TrusteePathRecord.ObjectId      : object id to scan');
  GotoXY(5, 16);
  write('       TrusteePathRecord.AccessMask    : Access-mask of object');
  GotoXY(5, 17);
  write('       TrusteePathRecord.TrusteePath   : trustees path');

  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Volume-no     : ');
  readln(VolumeNo);
  GotoXY(10, 5);
  Write(' Object id     : ');
  readln(Trustee.ObjectId);
  Trustee.NextSeq := 0;
  while ScanBindObjectTrusteePath(VolumeNo, Trustee) = Successfull do
  begin
    ClrScr;
    with Trustee do
    begin
      GotoXY(10,4);
      Write(' Object id                    : ', ObjectId);
      GotoXY(10,5);
      Write(' Access-mask                  : ', AccessMask);
      GotoXY(10,6);
      Write(' Path                         : ', TrusteePath);
      GotoXY(5,22);
      write(' Press Key to continue ');
      Input := UpCase(ReadKey);
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                    main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for file unit II (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5,4);
    write('A : Get effective dir rights (D), ##');
    GotoXY(5,5);
    write('B : Modify maximum rights mask (D),##');
    GotoXY(5,6);
    write('C : Create directory (D), ##');
    GotoXY(5,7);
    write('D : Delete directory (D), ##');
    GotoXY(5,8);
    write('E : Rename directory (D), ##');
    GotoXY(5,9);
    write('F : Scan dir for trustees (D), ##');
    GotoXY(5,10);
    write('G : Add trustee to directory (D), ##');
    GotoXY(5,11);
    write('H : Delete trustee from dir (D), ##');
    GotoXY(5,12);
    write('I : Get vol-info (V), ##');
    GotoXY(5,13);
    write('J : Get ext. vol-information (V), ##');
    GotoXY(5,14);
    write('K : Get no of local drives (V), ##');
    GotoXY(5,15);
    write('L : Get drive connection id (V), ##');
    GotoXY(5,16);
    write('M : Get drive flag table (V), ##');
    GotoXY(5,17);
    write('N : Get drive handle table (V), ##');
    GotoXY(5,18);
    write('O : Get volume number (V), ##');
    GotoXY(5,19);
    write('P : Get volume name (V), ##');
    GotoXY(5, 20);
    write('Q : Map root directory (D), ##');
    GotoXY(5, 21);
    write('R : Delete map root directory (D), ##');
    GotoXY(42, 4);
    write('S : Get relative drive depth (D), ##');
    GotoXY(42, 5);
    write('T : Convert path to dir-entry (D), ##');
    GotoXY(42, 6);
    write('U : ');
    GotoXY(42, 7);
    write('V : Add disk space restriction (V), ##');
    GotoXY(42, 8);
    write('W : Remove disk space rest. (V), ##');
    GotoXY(42, 9);
    write('1 : Get disk usage and rest. (V), ##');
    GotoXY(42, 10);
    write('2 : Set dir disk space rest. (V), ##');
    GotoXY(42, 11);
    write('3 : Scan object trustee paths. (D), ##');
    GotoXY(18,23);
    write('(F) = file,(D) = directory,(V)= volume');
    GotoXY(10,24);
    Write('X : Exit program, choose function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : FileA;
      'B' : FileB;
      'C' : FileC;
      'D' : FileD;
      'E' : FileE;
      'F' : FileF;
      'G' : FileG;
      'H' : FileH;
      'I' : FileI;
      'J' : FileJ;
      'K' : FileK;
      'L' : FileL;
      'M' : FileM;
      'N' : FileN;
      'O' : FileO;
      'P' : FileP;
      'Q' : FileQ;
      'R' : FileR;
      'S' : FileS;
      'T' : FileT;
      'U' : FileU;
      'V' : FileV;
      'W' : FileW;
      '1' : File1;
      '2' : File2;
      '3' : File3;
      'X' : halt(0);
    end;
  until false
end.
