 {ͻ
   Prog.: FiSampl1                               Target Platforms :      
   Desc : Sample program for file services       - real Mode             
          part I                                 - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program FiSample1;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvMain,
  NvFile;

{
              VAR declarations
 }

var
  Input         : Char;
  Result        : Byte;
  i, j          : Integer;

{
              procedure File A
 }

procedure FileA;

var
  FName : String;
  ErrorCode,
  Fattr     : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Get Extended File Attributes');
  GotoXY(5, 8);
  write('Desc : Gets the extended File-Attributes of an File');
  GotoXY(5, 10);
  write('Call : function GetExtendedFileAttributes(FName : String;');
  GotoXY(5, 11);
  write('       var ErrorCode : Byte):Byte;');
  GotoXY(5, 13);
  write('Request  : FName Path and Name of File');
  GotoXY(5, 15);
  write('Reply    : Fileattributes returned by function (See Nvmain)');
  GotoXY(5, 16);
  write('           Error-Code (See Nvmain)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Filename      : ');
  readln(FName);
  FAttr := GetExtendedFileAttributes(FName, ErrorCode);
  case ErrorCode of
    Successfull           :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Successfull File is : ', ^j^m, ^j^m);
      if FAttr and Transactional <> 0 then
        WriteLn(' Transactional ')
      else
        WriteLn(' Not Transactional ');
      if FAttr and Indexed       <> 0 then
        WriteLn(' Indexed ')
      else
        WriteLn(' Not Indexed ');
      if FAttr and ReadAudit     <> 0 then
        WriteLn(' Read Audit ')
      else
        WriteLn(' Not Read Audit ');
      if FAttr and WriteAudit    <> 0 then
        WriteLn(' Write Audit ')
      else
        WriteLn(' Not Write Audit ')
    end;
    CallerLacksPriv       :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Caller lacks Privlege');
    end;
    NotPermittSearchDir   :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Not permitted to search Directory');
    end;
    FileNotFound          :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' File not found');
    end;
  end;
  GotoXY(5, 22);
  write(ErrorCode, ' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File B
 }

procedure FileB;

var
  FName  : String;
  FAttr,
  Result : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Set extended File-Attributes');
  GotoXY(5, 8);
  write('Desc : Set the extended File-Attributes of an File');
  GotoXY(3, 10);
  write('Call : function SetExtendedFileAttributes(FName : String;Attrib : Byte):Byte;');
  GotoXY(5, 12);
  write('Request : FName   = Path and Filename');
  GotoXY(5, 12);
  write('          Attrib  = Fileattribute (See NVFile)');
  GotoXY(5, 12);
  write('Reply   : Error-Code (See NvFile)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  write('Smode1 - Smode6 = 00h - 06h');
  GotoXY(10, 5);
  write('Transactional = 10h');
  GotoXY(10, 6);
  write('Indexed       = 20h');
  GotoXY(10, 7);
  write('ReadAudit     = 40h');
  GotoXY(10, 8);
  write('WriteAudit    = 80h');
  GotoXY(10, 10);
  Write(' Filename       : ');
  readln(FName);
  GotoXY(10, 11);
  Write(' File-Attribute : ');
  readln(FAttr);
  ClrScr;
  GotoXY(10, 4);
  Result := SetExtendedFileAttributes(FName, FAttr);
  case Result of
    SuccessfullSet        : write(' Successfull ');
    CallerLacksPriv       : write(' Caller lacks Privileges');
    NotPermittSearchDir   : write(' Not permitted to search Directory');
    FileNotFound          : write(' File not found');
  else
    write('Annother Error : ', Result);
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File C
 }

procedure FileC;

var
  FName  : String;
  FAttr,
  Result : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Is File shareable');
  GotoXY(5, 8);
  write('Desc : Returns true if File is sharable');
  GotoXY(5, 10);
  write('Call : function IsFileShareable(FName : String):boolean;');
  GotoXY(5, 12);
  write('Request : FName   = Path and Filename (Network Styled)');
  GotoXY(5, 12);
  write('Reply   : true if File is sharable');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Filename       : ');
  readln(FName);
  ClrScr;
  GotoXY(10, 4);
  if IsFileShareable(FName) then
    write('File is shareable')
  else
    write('File is not sharable');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File D
 }

procedure FileD;

var
  FName  : String;
  FAttr,
  Result : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Toggle File sharable');
  GotoXY(5, 8);
  write('Desc : Toggles the Sharable Flags of an File');
  GotoXY(5, 10);
  write('Call : function ToggleShareable(FName : String):boolean;');
  GotoXY(5, 12);
  write('Request : FName   = Path and Filename (Network Styled)');
  GotoXY(5, 14);
  write('Reply   : true if Shareable successfull toggled');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Filename       : ');
  readln(FName);
  ClrScr;
  GotoXY(10, 4);
  if ToggleShareable(FName) then
    write('Successfull')
  else
    write('Error during Execution');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File E
 }

procedure FileE;

var
  FInfo  : tFileInfo;
  Seq    : Word;
  Handle,
  Error,
  Flags  : Byte;
  Drive  : String;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Get File Information');
  GotoXY(5, 6);
  write('Desc : Gets extented Information about an File');
  GotoXY(5, 8);
  write('Call : function GetFileInformation(var FInfo : FileInfo;');
  GotoXY(5, 9);
  write('Handle : Byte;var Seq : Word):boolean;');
  GotoXY(5, 11);
  write('Request : Seq                = Sequenze Number FFFFh on first Call');
  GotoXY(5, 12);
  write('          Handle             = Dir-Handle');
  GotoXY(5, 13);
  write('          Finfo.Fname        = File-Searchspec');
  GotoXY(5, 15);
  write('Reply   : Finfo.FName        = Filename');
  GotoXY(5, 16);
  write('          Finfo.ExtFAttrib   = Ext. File-Attribut');
  GotoXY(5, 17);
  write('          Finfo.Size         = File-Size');
  GotoXY(5, 18);
  write('          Finfo.CrDate       = Date and Time of Creation');
  GotoXY(5, 19);
  write('          Finfo.LastAccess   = Date and Time of Last Access');
  GotoXY(5, 20);
  write('          Finfo.LastUpdate   = Date and Time of Last Update');
  GotoXY(5, 21);
  write('          Finfo.ObjId        = Object Id of Owner');
  GotoXY(5, 22);
  write('          Finfo.LastArchived = Last Archived');
  GotoXY(5, 24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Seq := $FFFF;
  GetDir(0, Drive);
  GetDirHandle(Handle, Flags, Drive[1]);
  FInfo.FName := '*.*';
  Error := 0;
  while Error = 0 do
  begin
    Error := GetFileInformation(FInfo,  Handle,  Seq);
    case Error of
      SuccessFull  :
      begin
        ClrScr;
        with FInfo do
        begin
          GotoXY(10, 4);
          Write(' File-Name              : ', FName);
          GotoXY(10, 5);
          Write(' Ext. File-Attributes   :' );
          if ExtFattrib and Transactional <> 0 then
            Write(' File is transactional ');
          if ExtFattrib and Indexed       <> 0 then
            Write(' File is Indexed ');
          if ExtFattrib and  ReadAudit    <> 0 then
            Write(' File is Read Audit ');
          if ExtFattrib and  WriteAudit   <> 0 then
            Write(' File is Write Audit ');
          if ExtFattrib = 0 then
            Write(' File has no Attributes');
          GotoXY(10, 6);
          Write(' File-Size              : ', Size);
          GotoXY(10, 7);
          Write(' Creation Date (packed) : ', CrDate);
          GotoXY(10, 8);
          Write(' Last Access   (packed) : ', LastAccess);
          GotoXY(10, 9);
          Write(' Last Update   (packed) : ', LastUpdate);
          GotoXY(10, 10);
          Write(' Object Id of Owner     : ', ObjId);
          GotoXY(10,  11);
          Write(' Last Archived (packed) : ', LastArchived);
        end;
        FInfo.FName := '*.*';
        GotoXY(5, 22);
        write(' Press key to continue ');
        Input := UpCase(Readkey);
      end;
      NotPermittSearchDir :
      begin
        GotoXY(10, 4);
        Write(' You are not permitted to search Directory');
      end;
      FileNotFound        :
      begin
        GotoXY(10, 4);
        Write(' File not found');
      end;
    end;
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File F
 }

procedure FileF;

var
  FInfo  : tFileInfo;
  Seq    : Word;
  Handle,
  Error,
  Flags  : Byte;
  Drive  : String;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Set File Information');
  GotoXY(5, 6);
  write('Desc : Sets the extented Information about an File, Supervisor !');
  GotoXY(5, 8);
  write('Call : function SetFileInformation(var FInfo : FileInfo;');
  GotoXY(5, 9);
  write('Handle : Byte;var Seq : Word):boolean;');
  GotoXY(5, 11);
  write('Request : Seq                = Sequenze Number FFFFh on first Call');
  GotoXY(5, 12);
  write('          Handle             = Dir-Handle');
  GotoXY(5, 13);
  write('          Finfo.Fname        = File-Searchspec');
  GotoXY(5, 15);
  write('Reply   : Finfo.FName        = Filename');
  GotoXY(5, 16);
  write('          Finfo.ExtFAttrib   = Ext. File-Attribut');
  GotoXY(5, 17);
  write('          Finfo.Size         = File-Size');
  GotoXY(5, 18);
  write('          Finfo.CrDate       = Date and Time of Creation');
  GotoXY(5, 19);
  write('          Finfo.LastAccess   = Date and Time of Last Access');
  GotoXY(5, 20);
  write('          Finfo.LastUpdate   = Date and Time of Last Update');
  GotoXY(5, 21);
  write('          Finfo.ObjId        = Object Id of Owner');
  GotoXY(5, 22);
  write('          Finfo.LastArchived = Last Archived');
  GotoXY(5, 24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Seq := $FFFF;
  GetDir(0, Drive);
  GetDirHandle(Handle, Flags, Drive[1]);
  FInfo.FName := '*.*';
  Error := 0;
  while Error = 0 do
  begin
    Error := GetFileInformation(FInfo, Handle, Seq);
    case Error of
      SuccessFull  :
      begin
        ClrScr;
        with FInfo do
        begin
          GotoXY(10, 4);
          Write(' File-Name              : ', FName);
          GotoXY(10, 5);
          Write(' Ext. File-Attributes   :' );
          if ExtFattrib and Transactional <> 0 then
            Write(' File is transactional ');
          if ExtFattrib and Indexed       <> 0 then
            Write(' File is Indexed ');
          if ExtFattrib and  ReadAudit    <> 0 then
            Write(' File is Read Audit ');
          if ExtFattrib and  WriteAudit   <> 0 then
            Write(' File is Write Audit ');
          if ExtFattrib = 0 then
            Write(' File has no Attributes');
          GotoXY(10, 6);
          Write(' File-Size              : ', Size);
          GotoXY(10, 7);
          Write(' Creation Date (packed) : ', CrDate);
          GotoXY(10, 8);
          Write(' Last Access   (packed) : ', LastAccess);
          GotoXY(10, 9);
          Write(' Last Update   (packed) : ', LastUpdate);
          GotoXY(10, 10);
          Write(' Object Id of Owner     : ', ObjId);
          GotoXY(10, 11);
          Write(' Last Archived (packed) : ', LastArchived);
          GotoXY(10, 12);
          Write(' Last Sequenze          : ', Seq);
        end;
        FInfo.FName := '*.*';
        GotoXY(5, 22);
        write(' Press key to continue ');
        Input := UpCase(Readkey);
      end;
      NotPermittSearchDir :
      begin
        GotoXY(10, 4);
        Write(' You are not permitted to search Directory');
      end;
      FileNotFound        :
      begin
        GotoXY(10, 4);
        Write(' File not found');
      end;
    end;
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File G
 }

procedure FileG;

var
  CopyBlock   : tFSCopyBlock;
  Copied      : LongInt;
  FName       : String;
  ScrHandle,
  DstHandle   : Word;
  Test        : file;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('File Server File Copy');
  GotoXY(5, 6);
  write('Desc : Copies an File on the same Fileserver');
  GotoXY(5, 8);
  write('Call : function FileServerCopy(var Copy : FSCopyBlock):Byte;');
  GotoXY(5, 9);
  write('Attention : if the Destination File exists and it`s not Zero-Length');
  GotoXY(5, 10);
  Write('it must be deleted otherwise Error !');
  GotoXY(5, 12);
  write('Request : Copy.SourceHandle   = Source File Handle');
  GotoXY(5, 13);
  write('          Copy.DestHandle     = Destination File Handle');
  GotoXY(5, 14);
  write('          Copy.SourceStartOfs = Starting Offset in Source');
  GotoXY(5, 15);
  write('          Copy.DestStartOfs   = Starting Offset in Destination');
  GotoXY(5, 16);
  write('          Copy.BytesToCopy    = Number of Bytes to copy');
  GotoXY(5, 18);
  write('Reply   : Copy.BytesToCopy    = Bytes copied, 0 if Error');
  GotoXY(5, 24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Source-File            : ');
  readln(FName);
  Assign(Test, FName);
  {$I-} ReSet(Test); {$I+}
  if IoResult = 0 then
  begin
    {$I-} Close(Test); {$I+}
    if IoResult = 0 then;
    GotoXY(10, 6);
    Write(' Source-File exist will be opened with function OpenExistingFile');
    ScrHandle := OpenExistingFile(FName, $00);
  end
  else
  begin
    {$I-} Close(Test); {$I+}
    if IoResult = 0 then;
    GotoXY(10, 6);
    Write(' Source-File doesn`t exist will be created with function CreatFile');
    ScrHandle := CreateFile(FName, $00);
  end;
  GotoXY(10, 8);
  Write(' Source-Handle = ', ScrHandle);
  CopyBlock.SourceHandle := ScrHandle;
  GotoXY(10, 10);
  Write(' Destination-File       : ');
  readln(FName);
  Assign(Test, FName);
  {$I-} ReSet(Test); {$I+}
  if IoResult = 0 then
  begin
    {$I-} Close(Test); {$I+}
    if IoResult = 0 then;
    GotoXY(10, 12);
    Write(' Destination-File exist will be opened with function OpenExistingFile');
    DstHandle := OpenExistingFile(FName, $00);
  end
  else
  begin
    {$I-} Close(Test); {$I+}
    if IoResult = 0 then;
    GotoXY(10, 12);
    Write(' Destination-File doesn`t exist will be created with function CreatFile');
    DstHandle := CreateFile(FName, $00);
  end;
  GotoXY(10, 14);
  Write(' Destination-Handle = ', DstHandle);
  CopyBlock.DestHandle := DstHandle;
  GotoXY(5, 16);
  write('Starting Offset in Source      : ');
  Readln(CopyBlock.SourceStartOfs);
  GotoXY(5, 17);
  write('Starting Offset in Destination : ');
  Readln(CopyBlock.DestStartOfs);
  GotoXY(5, 18);
  write('Number of Bytes to copy        : ');
  Readln(CopyBlock.BytesToCopy);
  GotoXY(5, 20);
  write('I`m copying please wait if the File is big');
  Copied := FileServerCopy(CopyBlock);
  if Copied <> 0 then
  begin
    ClrScr;
    GotoXY(10, 4);
    Write(' Successfull ! Bytes copied : ', Copied);
  end
  else
  begin
    write('Error');
  end;
  CloseFile(DstHandle);
  CloseFile(ScrHandle);
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File H
 }

procedure FileH;

var
  Handle,
  Flags       : Byte;
  FName       : String;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Erase Files');
  GotoXY(5, 6);
  write('Desc : Marks Files for deletion, Delete them with Purge deleted Files');
  GotoXY(5, 8);
  write('Call : function EraseFiles(FileSpec : String;Handle : Byte):Byte;');
  GotoXY(5, 10);
  write('Request : FileSpec            = Filespecification, Wildcard allowed');
  GotoXY(5, 11);
  write('          Handle              = Directory Handle');
  GotoXY(5, 13);
  write('Reply   : Error-Code (See Nvmain)');
  GotoXY(5, 24);
  write(' No demo available press key to continue');
  Input := UpCase(Readkey);
end;

{
              procedure File I
 }

procedure FileI;

var
  Salvage  : tSalvagableFiles;
  Result,
  Flags,
  Handle   : Byte;
  Dir      : String;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Scan salvagable files');
  GotoXY(5, 6);
  write('Desc : Scans the salvagable files of an directory');
  GotoXY(5, 8);
  write('Call : function ScanSalvagableFiles(var SalvageFiles : tSalvagableFiles;');
  GotoXY(5, 9);
  write('                                    DirectoryHandle : Byte;');
  GotoXY(5, 10);
  write('                                    FileEntryId : LongInt):Byte; );');
  GotoXY(5, 12);
  write('Request : Directory handle    = directory-hanlde where to scan');
  GotoXY(5, 13);
  write('          File entry id       = entry id -1 for first scan');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
  ClrScr;
  GotoXY(5,  6);
  write('Reply :   Entry id            = entry id of file');
  GotoXY(5,  7);
  write('          Attributes          = file attributes ??');
  GotoXY(5,  8);
  write('          Name space type     = Name spac support type');
  GotoXY(5,  9);
  write('          Name                = Name of salvagable file');
  GotoXY(5,  10);
  write('          Reserved Dt/Ti      = Reserved date/time');
  GotoXY(5,  11);
  write('          Reserved Id         = Reserved id            ');
  GotoXY(5,  12);
  write('          Archived Dt/Ti      = Archived date/time     ');
  GotoXY(5,  13);
  write('          Archiver Id         = Object id of archiver  ');
  GotoXY(5,  14);
  write('          Modify Dt/Ti        = Modify date/time       ');
  GotoXY(5,  15);
  write('          Modifier id         = Modifier object id     ');
  GotoXY(5,  16);
  write('          Data fork size      = Data fork size         ');
  GotoXY(5,  17);
  write('          Last access date    = date of last access    ');
  GotoXY(5,  18);
  write('          Deleted dt/ti       = Deleted date/time      ');
  GotoXY(5,  19);
  write('          Deletor id          = Deletor object id      ');
  GotoXY(5, 24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  Salvage.EntryId := -1;
  repeat
    ClrScr;
    GotoXY(5,  6);
    write('  Scanning current directory');
    GetDir(0,  Dir);
    GetDirHandle(Handle, Flags, Dir[1]);
    Result := ScanSalvagableFiles(Salvage, Handle, Salvage.EntryId);

    with Salvage do
    begin
      GotoXY(1, 8);
      writeln('      Entry id     : ', EntryId);
      writeln('      Attr.        : ', Attributes);
      writeln('      Name Space   : ', NameSpaceType);
      writeln('      Name         : ', Name);
      writeln('      Archiver id  : ', ArchiverId);
      writeln('      Modifier id  : ', ModifierId);
      writeln('      Deletor id   : ', DeletorId);
    end;

    GotoXY(5, 22);
    write(' Press key to continue ');
    Input := UpCase(Readkey);
  until (Result = NoMoreMatchingFiles);
end;

{
              procedure File J
 }

procedure FileJ;

var
  EntryId    : LongInt;
  OldName,
  NewName    : String;
  Flags,
  Handle,
  Result     : Byte;
  Dir        : String;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Recover salvagable files');
  GotoXY(5, 6);
  write('Desc : Recovers an salvagable file');
  GotoXY(5, 8);
  write('Call : function RecoverSalvagableFiles(DirectoryHandle : Byte;');
  GotoXY(5, 9);
  write('                                    FileEntryId : LongInt;');
  GotoXY(5, 10);
  write('                                    OldName,');
  GotoXY(5, 11);
  write('                                    NewName : String):Byte;');
  GotoXY(5, 13);
  write('Request : Directory handle    = directory-handle where to recover');
  GotoXY(5, 14);
  write('          File entry id       = entry id of file (or -1 wildcard)');
  GotoXY(5, 15);
  write('          Old name            = Old file name');
  GotoXY(5, 16);
  write('          New name            = New file name');
  GotoXY(5, 18);
  write('          Reply               = Error-code (see NvMain)');
  GotoXY(5, 24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5, 5);
  write('Directory handle : ');
  Readln(Handle);
  GotoXY(5, 6);
  write('Entry id    : ');
  Readln(EntryId);
  GotoXY(5, 7);
  write('Old name    : ');
  Readln(OldName);
  GotoXY(5, 8);
  write('New name    : ');
  Readln(NewName);

  Result := RecoverSalvagableFile(Handle, EntryId, OldName, NewName);

  GotoXY(5, 10);
  write('Result    : $', Convert2Hex(Result));

  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File K
 }

procedure FileK;

var
  DirectoryHandle : Byte;
  FileEntryId     : LongInt;
  FileName        : String;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Purge salvagable files');
  GotoXY(5, 6);
  write('Desc : Purges salvagebale files of the station');
  GotoXY(5, 8);
  write('Call : function PurgeSalvagableFiles(DirectoryHandle : Byte;');
  GotoXY(5, 9);
  write('                                     FileEntryId : LongInt;');
  GotoXY(5, 10);
  write('                                     FileName : String):Byte;');
  GotoXY(5, 12);
  write('       Request : DirectoryHandle = Dir-handle where to purge');
  GotoXY(5, 13);
  write('                 FileEntryId     = File entry id ');
  GotoXY(5, 14);
  write('                 FileName        = Name of file to purge');
  GotoXY(5, 16);
  write('        Reply       = Error-code (see NvMain)');
  GotoXY(5, 24);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5, 5);
  write('Directory handle : ');
  Readln(DirectoryHandle);
  GotoXY(5, 6);
  write('Entry id    : ');
  Readln(FileEntryId);
  GotoXY(5, 7);
  write('File name    : ');
  Readln(FileName);

  Result := PurgeSalvagableFiles(DirectoryHandle, FileEntryId, FileName);

  GotoXY(5, 10);
  write('Result    : $', Convert2Hex(Result));

  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File L
 }

procedure FileL;

begin

  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File M
 }

procedure FileM;

var
  FileName : String;
  AccessMode : Byte;
  Handle   : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Open existing File');
  GotoXY(5, 8);
  write('Desc : Opens an existing file and returns filehandle');
  GotoXY(2, 10);
  write('Call : function OpenExistingFile(FileName : String;AccessMode : Byte):Word;');
  GotoXY(5, 12);
  write('Request : Filename            = Path and name of file');
  GotoXY(5, 13);
  write('          AccessMode          = Access mode for file (see Nvmain)');
  GotoXY(5, 15);
  write('Reply   : Handle or error-code (See NvMain)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Filename        : ');
  readln(FileName);
  GotoXY(10, 5);
  Write(' Access-Mode (0 for example) : ');
  readln(AccessMode);
  Handle := OpenExistingFile(FileName, AccessMode);
  case Handle of
    Invalidfunction     :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Invalid function');
     end;
    FileNotFound        :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' File not found !');
    end;
    PathNotFound        :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Path not found');
    end;
    ToManyOpenFiles     :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' To many open Files');
    end;
    AccessCodeInvalid   :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Access Code invalid');
    end;
  else
    ClrScr;
    GotoXY(10, 4);
    write(' Successfull Handle ', Handle);
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File N
 }

procedure FileN;

var
  FileName : String;
  FAttrib  : Byte;
  Handle   : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Create File');
  GotoXY(5, 8);
  write('Desc : Creates an File');
  GotoXY(5, 10);
  write('Call : function CreateFile(FileName : String;FAttrib : Byte):Word;');
  GotoXY(5, 12);
  write('Request : Filename            = Path and Name of File to create');
  GotoXY(5, 13);
  write('          FAttrib             = Fileattribute of new File');
  GotoXY(5, 15);
  write('Reply   : Handle or Error-Code (See NvMain Extended Errors');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Filename        : ');
  readln(FileName);
  GotoXY(10, 5);
  Write(' File-Attributt  :');
  readln(FAttrib);
  Handle := CreateFile(FileName, FAttrib);
  case Handle of
    Successfull         :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Error Handle = 0 ');
    end;
    PathNotFound        :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Path not found');
    end;
    ToManyOpenFiles     :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' To many open Files');
    end;
  else
    ClrScr;
    GotoXY(10, 4);
    write(' Successfull Handle := ', Handle);
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File O
 }

procedure FileO;

var
  Handle   : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Close Filehandle');
  GotoXY(5, 8);
  write('Desc : Closes an File-Handle');
  GotoXY(5, 10);
  write('Call : function CloseFile(Handle : Word):boolean;');
  GotoXY(5, 12);
  write('Request : Handle             = Handle to close');
  GotoXY(5, 14);
  write('Reply   : True if Handle was successfull closed');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Handle         : ');
  readln(Handle);
  if CloseFile(Handle) then
  begin
    ClrScr;
    GotoXY(10, 4);
    Write(' Successfull closed');
  end
  else
  begin
    ClrScr;
    GotoXY(10, 4);
    Write(' Error !');
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File P
 }

procedure FileP;

var
  Drive  : Char;
  Path   : String;
  Handle,
  Flags  : Byte;
  Dir    : tDirInfo;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Get Directory Information');
  GotoXY(5, 8);
  write('Desc : Gets extended Information about an Directory');
  GotoXY(5, 10);
  write('Call : function GetDirectoryInfo(var Dir : DirInfo;');
  GotoXY(2, 11);
  Write('       Path : String;DirHandle : Byte):byte;');
  GotoXY(5, 12);
  write('Request : Seq                 = Seq-Number first call 0 then ');
  GotoXY(5, 13);
  write('                                returend Dirnumber + 1');
  GotoXY(5, 14);
  write('          Path                = Path to get Informations (Network-Style)');
  GotoXY(5, 15);
  write('          DirHandle           = Dirhandle of Path');
  GotoXY(5, 16);
  write('Reply   : Dir.DirName         = Name of Directory');
  GotoXY(5, 17);
  write('          Dir.CrDate (packed) = Date of Creation');
  GotoXY(5, 18);
  write('          Dir.ObjId           = Object Id of Owner');
  GotoXY(5, 19);
  write('          Dir.MaxDRights      = Maximum Dir-Rights');
  GotoXY(5, 20);
  write('          Dir.DirNumber       = Directory Entry-Number');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write('Directory-path  : ');
  readln(Path);
  GotoXY(10, 5);
  Write('Drive           : ');
  readln(Drive);
  GetDirHandle(Handle, Flags, Drive);
  Result := GetDirectoryInfo(Dir, Path, Handle);
  ClrScr;
  GotoXY(10, 4);
  if Result = Successfull then
  begin
    write(' Successfull !');
    with Dir do
    begin
      GotoXY(10, 6);
      write('Name of Directory          : ', DirName);
      GotoXY(10, 7);
      write('Date of Creation           : ', CrDate);
      GotoXY(10, 8);
      write('Object Id of Owner         : ', ObjId);
      GotoXY(10, 9);
      write('Maximum Dir-Rights         : ', MaxDirRights);
      GotoXY(10, 10);
      write('Directory Entry-Number     : ', DirNumber);
    end;
  end
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File Q
 }

procedure FileQ;

var
  Path   : String;
  Handle,
  Flags  : Byte;
  Dir    : tDirInfo;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Set Directory Information');
  GotoXY(5, 8);
  write('Desc : Sets the extended Information for an Directory');
  GotoXY(5, 10);
  write('Call : function SetDirectoryInfo(var Dir : DirInfo;');
  GotoXY(5, 11);
  write('       Path : String;DirHandle : Byte):byte;');
  GotoXY(5, 12);
  write('Request : Path                 = Path to set Information (Network-Style)');
  GotoXY(5, 13);
  write('          DirHandle            = Handle of Directory');
  GotoXY(5, 14);
  write('          Dir.CrDate          = Date and Time of Creation');
  GotoXY(5, 15);
  write('          Dir.ObjId           = Object Id of Owner');
  GotoXY(5, 16);
  write('          Dir.MaxDirRights    = Maximum Dir-Rights');
  GotoXY(5, 17);
  write('Reply   : Error-Code (See Nvmain)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write('Creation Date   : ');
  readln(Dir.CrDate);
  GotoXY(10, 5);
  Write('Object-Id       : ');
  readln(Dir.ObjId);
  GotoXY(10, 6);
  Write('Max. Dir-Rights : ');
  readln(Dir.MaxDirRights);
  Path := 'SYS:\BP\NOVELL';
  GetDirHandle(Handle, Flags, 'F');
  Result := SetDirectoryInfo(Dir, Path, Handle);
  ClrScr;
  GotoXY(10, 4);
  if Result = Successfull then
    write(' Successfull !')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File R
 }

procedure FileR;

var
  Dots   : boolean;
  Quest  : Char;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Show Dots');
  GotoXY(5, 8);
  write('Desc : Sets the Dots-Mode On/Off');
  GotoXY(5, 10);
  write('Call : procedure ShowDots(Show : boolean);');
  GotoXY(5, 12);
  write('Request : ShowDots             = if true Dots will be set ON');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write('Show Dots ? (Y/N)  : ');
  Readln(Quest);
  if UpCase(Quest) = 'Y' then
  begin
    ClrScr;
    ShowDots(true);
    GotoXY(10, 4);
    write('Dots are set ON');
  end
  else
  begin
    ClrScr;
    ShowDots(false);
    GotoXY(10, 4);
    write('Dots are set OFF');
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File S
 }

procedure FileS;

var
  Drive  : Char;
  Handle,
  Flags  : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Get Dir Handle');
  GotoXY(5, 8);
  write('Desc : Gets an Directory Handle');
  GotoXY(5, 10);
  write('Call : procedure GetDirHandle(var Handle : Byte;');
  GotoXY(5, 11);
  write('       var Flags : Byte;Drive : Char);');
  GotoXY(5, 13);
  write('Request : Drive                = Drive to get Handle');
  GotoXY(5, 15);
  write('Reply   : Handle               = Drive-Handle');
  GotoXY(5, 16);
  write('          Flags                = Drive Flags');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write('Drive          : ');
  Readln(Drive);
  GetDirHandle(Handle, Flags, Drive);
  ClrScr;
  GotoXY(10, 4);
  write('Handle        : ', Handle);
  GotoXY(10, 5);
  case Flags of
    $00 : write('Flag          : Permanent Handle');
    $01 : write('Flag          : Temporaery Handle');
    $80 : write('Flag          : mapped to local Drive');
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File T
 }

procedure FileT;

var
  Path   : String;
  Drive  : Char;
  Handle : Byte;
  Result : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Allocate temporaery dir handle');
  GotoXY(5, 8);
  write('Desc : Allocates an temp dir-handle, will be closed by EOJ or program-end');
  GotoXY(5, 10);
  write('Call : function AllocateTempDirHandle(var DirHandle : Byte;');
  GotoXY(5, 11);
  write('       Drive : Char;Path : String):boolean;');
  GotoXY(5, 13);
  write('Request : Drive                = Drive to use');
  GotoXY(5, 14);
  write('          Path                 = Network-Drive to map (Network-style)');
  GotoXY(5, 16);
  write('Reply   : Handle               = Drive-handle');
  GotoXY(5, 17);
  write('          Error-Code (See NvMain)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  write('Drive         : ');
  Readln(Drive);
  GotoXY(10, 5);
  write('Path          : ');
  Readln(Path);
  GotoXY(10, 5);
  Result := AllocateTempDirHandle(Handle, Drive, Path);
  ClrScr;
  GotoXY(10, 4);
  if Result = Successfull then
    Write('Successfull Handle = ', Handle)
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File U
 }

procedure FileU;

var
  Path   : String;
  Drive  : Char;
  Handle : Byte;
  Result : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Allocate permanent dir handle');
  GotoXY(5, 8);
  write('Desc : Allocates an permanent dir handle');
  GotoXY(5, 10);
  write('Call : function AllocatePermanentDirHandle(var DirHandle : Byte;');
  GotoXY(5, 11);
  Write('       Drive : Char;Path : String):Byte;');
  GotoXY(5, 13);
  write('Request : Drive                = Drive to use');
  GotoXY(5, 14);
  write('          Path                 = Network-Drive to map (Network-Style)');
  GotoXY(5, 16);
  write('Reply   : Handle               = Drive handle');
  GotoXY(5, 17);
  write('          Error-Code (See Nvmain)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  write('Drive         : ');
  Readln(Drive);
  GotoXY(10, 5);
  write('Path          : ');
  Readln(Path);
  Result := AllocatePermanentDirHandle(Handle, Drive, Path);
  ClrScr;
  GotoXY(10, 4);
  if Result = SuccessFull then
    Write('Successfull handle = ', Handle)
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File V
 }

procedure FileV;

var
  Handle : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Deallocate Dir Handle');
  GotoXY(5, 8);
  write('Desc : Deallocates an Directory Handle');
  GotoXY(5, 10);
  write('Call : function DeAllocateDirHandle(DirHandle : Byte):boolean;');
  GotoXY(5, 12);
  write('Request : Handle               = Handle to deallocate');
  GotoXY(5, 14);
  write('Reply   : true if successfull deallocated');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  write('Handle         : ');
  Readln(Handle);
  if DeAllocateDirHandle(Handle) then
  begin
    ClrScr;
    GotoXY(10, 4);
    Write('Successfull deallocated');
  end
  else
  begin
    ClrScr;
    GotoXY(10, 4);
    Write('Error Handle doesn`t exist');
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File W
 }

procedure FileW;

var
  Target,
  Source        : Byte;
  Path          : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Set Dir Handle');
  GotoXY(5, 8);
  write('Desc : Sets an Target to reference the Directory specified by the');
  GotoXY(5, 9);
  write('       Source-Handle and the Source-Path');
  GotoXY(5, 11);
  write('Call : function SetDirHandle(SourceHandle, TargetHandle : Byte;');
  GotoXY(5, 12);
  write('       Path : String):Byte;');
  GotoXY(5, 14);
  write('Request : SourceHandle         = Source-Handle');
  GotoXY(5, 15);
  write('          TargetHandle         = Target-Handle to reference');
  GotoXY(5, 16);
  write('          Path                 = Source-Path (Network-Style)');
  GotoXY(5, 18);
  write('Reply   : Error-Code (see Nvmain)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  write('Source-Handle      : ');
  Readln(Source);
  GotoXY(10, 5);
  write('Target-Handle      : ');
  Readln(Target);
  GotoXY(10, 6);
  write('Path               : ');
  Readln(Path);
  Result := SetDirHandle(Source, Target, Path);
  ClrScr;
  GotoXY(10, 4);
  if Result = SuccessFull then
    Write('Successfull Handle = ')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure File Y
 }

procedure FileY;

var
  Path  : String;
  Handle,
  Flags  : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Get Directory Path');
  GotoXY(5, 8);
  write('Desc : Gets an network-styled path from handle');
  GotoXY(5, 10);
  write('Call : function GetDirectoryPath(Handle : Byte):String;');
  GotoXY(5, 12);
  write('Request : Handle      = Directory handle of path');
  GotoXY(5, 14);
  write('Reply   : Network-Path');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GetDir(0, Path);
  GotoXY(10, 4);
  Write(' Current Directory   : ', Path);
  GetDirHandle(Handle, Flags, Path[1]);
  Path := GetDirectoryPath(Handle);
  GotoXY(10, 6);
  Write(' Network-Styled Path : ', Path);
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
                   main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for file unit I (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5, 4);
    write('A : Get extended file attributes (F),##');
    GotoXY(5, 5);
    write('B : Set extended file attributes (F),##');
    GotoXY(5, 6);
    write('C : Is file shareable (F),##');
    GotoXY(5, 7);
    write('D : Toggle file shareable (F),##');
    GotoXY(5, 8);
    write('E : Get file information (F),##');
    GotoXY(5, 9);
    write('F : Set file information (F),##');
    GotoXY(5, 10);
    write('G : File server file copy (F),##');
    GotoXY(5, 11);
    write('H : Erase files (F),##');
    GotoXY(5, 12);
    write('I : Scan salvagable files (F),##');
    GotoXY(5, 13);
    write('J : Recover salvagable files (F)');
    GotoXY(5, 14);
    write('K : Purge savageable files (F),##');
    GotoXY(5, 15);
    write('L : ');
    GotoXY(5, 16);
    write('M : Open existing file (F),##');
    GotoXY(5, 17);
    write('N : Create file (F),##');
    GotoXY(5, 18);
    write('O : Close file (F),##');
    GotoXY(5, 19);
    write('P : Get directory information (D),##');
    GotoXY(5, 20);
    write('Q : Set directory information (D),##');
    GotoXY(5, 21);
    write('R : Show dots (D),##');
    GotoXY(44, 4);
    write('S : Get dir handle (D),##');
    GotoXY(44, 5);
    write('T : Allocate temp. dir handle(D),##');
    GotoXY(44, 6);
    write('U : Allocate perm. dir handle (D),##');
    GotoXY(44, 7);
    write('V : DeAllocate dir handle (D),##');
    GotoXY(44, 8);
    write('W : Set dir handle,##');
    GotoXY(44, 9);
    write('Y : Get directory path (D),##');
    GotoXY(18, 23);
    write('(F) = file, (D) = directory, (V)= volume');
    GotoXY(10, 24);
    Write('X : Exit program, choose function :');
    Input := UpCase(Readkey);
    case Input of
      'A' : FileA;
      'B' : FileB;
      'C' : FileC;
      'D' : FileD;
      'E' : FileE;
      'F' : FileF;
      'G' : FileG;
      'H' : FileH;
      'I' : FileI;
      'J' : FileJ;
      'K' : FileK;
      'L' : FileL;
      'M' : FileM;
      'N' : FileN;
      'O' : FileO;
      'P' : FileP;
      'Q' : FileQ;
      'R' : FileR;
      'S' : FileS;
      'T' : FileT;
      'U' : FileU;
      'V' : FileV;
      'W' : FileW;
      'Y' : FileY;
      'X' : halt(0);
    end;
  until false
end.
