 {ͻ
   Prog.: MsSample                               Target Platforms :      
   Desc : Sample program for message services    - real Mode             
                                                 - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program MsSample;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvMain,
  NvMsg;

{
              VAR declarations
 }

var
  Input         : Char;
  i, j          : Integer;

{
               procedure Message A
 }

procedure MessageA;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell message unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Get Broadcast Mode');
  GotoXY(5, 6);
  write('Desc : Gets the current Broadcast Mode');
  GotoXY(5, 8);
  write('Call : function GetBroadCastMode:Byte;');
  GotoXY(5, 10);
  write('Reply    : Broadcast-Mode');
  GotoXY(5, 22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  case GetBroadCastMode of
    bmRecSvWsBroadcast            :
    begin
      GotoXY(5, 10);
      Write('Receive Server and Workstation Broadcast (default)');
    end;
    bmRecSvDisWsBroadcast         :
    begin
      GotoXY(5, 10);
      Write('Recive Server and discard Workstation Broadcast');
    end;
    bmStoreServerBroadcast        :
    begin
      GotoXY(5, 10);
      Write('Store Server Broadcast discard Workstation');
    end;
    bmStoreAllBroadcast           :
    begin
      GotoXY(5, 10);
      Write('Store all Broadcasts');
    end;
  end;
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Message B
 }

procedure MessageB;

var
  BMode : Byte;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell message unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Set Broadcast Mode');
  GotoXY(5, 6);
  write('Desc : Sets the Broadcast Mode');
  GotoXY(5, 8);
  write('Call : function SetBroadcastMode(BMode : Byte):Byte;');
  GotoXY(5, 10);
  write('Request  : BMode       = New Broadcast-Mode');
  GotoXY(5, 12);
  write('Reply    : function returns new Broadcast Mode');
  GotoXY(5, 22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5, 4);
  write('New Broadcast-Mode : ');
  readln(BMode);
  case SetBroadCastMode(BMode) of
    bmRecSvWsBroadcast            :
    begin
      GotoXY(5, 10);
      Write('BMode set to = Receive Server and Workstation Broadcast');
    end;
    bmRecSvDisWsBroadcast         :
    begin
      GotoXY(5, 10);
      Write('BMode set to = Recive Server and discard Workstation Broadcast');
    end;
    bmStoreServerBroadcast        :
    begin
      GotoXY(5, 10);
      Write('BMode set to = Store Server Broadcast discard Workstation');
    end;
    bmStoreAllBroadcast           :
    begin
      GotoXY(5, 10);
      Write('BMode set to = Store all Broadcasts');
    end;
  end;
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Message C
 }

procedure MessageC;

var
  UserList : tConnList;
  Message  : tNetworkMessage;
  Conns    : Byte;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell message unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Send Broadcast Message');
  GotoXY(5, 6);
  write('Desc : Sends an Broadcast to the specified Workstations');
  GotoXY(5, 8);
  write('Call : function SendBroadcast(var UserList : ConnList;');
  GotoXY(5, 8);
  write('       Message : NetworkMessage):boolean;');
  GotoXY(5, 10);
  write('Request   : UserList   = String which contains the Workstations');
  GotoXY(5, 11);
  write('                         to receive Message');
  GotoXY(5, 12);
  write('            Message    = Broadcast Message');
  GotoXY(5, 14);
  write('Reply     : true if successfull done');
  GotoXY(5, 22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  UserList := '';
  repeat
    ClrScr;
    GotoXY(5, 4);
    Write(' Connection-No to recive Broadcast (0 for End) : ');
    readln(Conns);
    UserList := UserList + Chr(Conns);
  until Conns = 0;
  Delete(UserList, Length(UserList), 1);
  GotoXY(5, 5);
  write(' Network Message : ');
  readln(Message);
  if SendBroadcast(UserList, Message) then
  begin
    ClrScr;
    GotoXY(5, 5);
    write(' Successfull done', ^j^m, ^j^m);
    for i := 1 to Length(UserList) do
    begin
      Write(' User No. : ', i, ' ');
      case Ord(UserList[i]) of
        neSuccessfull        : write('received the Message');
        crMessageRejected    : write('rejects the Message');
        crInvalidConnNumber  : write('was an invalid Connection-Number');
        crMessageBlocked     : write('blocks the Message');
      end;
      writeln;
    end;
  end
  else
  begin
    ClrScr;
    GotoXY(5, 5);
    write(' Error !!');
  end;
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Message D
 }

procedure MessageD;

var
  Message  : tNetworkMessage;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell message unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Get Broadcast Message');
  GotoXY(5, 6);
  write('Desc : Gets an stored Network-Message from the Server');
  GotoXY(5, 8);
  write('Call : function GetBroadcast(Var Message : NetWorkMessage):Byte;');
  GotoXY(5, 10);
  write('Reply     : Message    = Network-Message, empty if no Message available');
  GotoXY(5, 11);
  write('            Error-Code (See Nvmain)');
  GotoXY(5, 22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  repeat
   case GetBroadcast(Message) of
     neSuccessfull  :
     begin
       ClrScr;
       GotoXY(5, 5);
       write(' Successfull ');
       GotoXY(5, 7);
       if Message = '' then
         write('No more Message available')
       else
         write('Network Message : ', Message);
     end;
     neQueueFull        :
     begin
       ClrScr;
       GotoXY(5, 5);
       write(' Full Queue !');
     end;
     neOutOfDynWorkSpace :
     begin
       ClrScr;
       GotoXY(5, 5);
       write(' Out of Workspace');
     end;
   end;
   GotoXY(5, 22);
   write(' Press Key to continue ');
   Input := UpCase(ReadKey);
  until Message = '';
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Message E
 }

procedure MessageE;

var
  Message  : tNetworkMessage;

begin
  ClrScr;
  GotoXY(17, 2);
  write(' Novell message unit (C) 1993 by C.Weller');
  GotoXY(25, 4);
  write('Send Console Broadcast');
  GotoXY(5, 6);
  write('Desc : Sends an Broadcast to the Server-Console');
  GotoXY(5, 8);
  write('Call : function ConsoleBroadcast(Message : NetworkMessage):Byte;');
  GotoXY(5, 10);
  write('Request   : Message    = Broadcast Message');
  GotoXY(5, 14);
  write('Reply     : Error-Code (See Nvmain)');
  GotoXY(5, 22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5, 5);
  write(' Network Message : ');
  readln(Message);
  case ConsoleBroadcast(Message) of
    neSuccessfull                  :
    begin
      ClrScr;
      GotoXY(5, 5);
      write(' Successfull done');
    end;
    neQueueFull                    :
    begin
      ClrScr;
      GotoXY(5, 5);
      write(' Full Message Queue');
    end;
    neOutOfDynWorkSpace            :
    begin
      ClrScr;
      GotoXY(5, 5);
      write(' Out of dynamic Workspace');
    end;
  end;
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                     main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for message unit (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
   GotoXY(5, 4);
    write('A : Get broadcast mode, ##');
    GotoXY(5, 5);
    write('B : Set broadcast mode, ##');
    GotoXY(5, 6);
    write('C : Send broadcast-message, ##');
    GotoXY(5, 7);
    write('D : Get broadcast-message, ##');
    GotoXY(5, 8);
    write('E : Send console broadcast, ##');
    GotoXY(18, 22);
    Write('X : Exit program, choose function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : MessageA;
      'B' : MessageB;
      'C' : MessageC;
      'D' : MessageD;
      'E' : MessageE;
      'X' : halt(0);
    end;
  until false;
end.
