 {ͻ
   Prog.: PrSample                               Target Platforms :      
   Desc : Sample program for printer services    - real Mode             
                                                 - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program PrSample;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvFile,
  NvMain,
  NvPrint;

{
              VAR declarations
 }

var
  Input         : Char;
  i,j           : Integer;

{
               procedure Printer A
 }

procedure PrinterA;

var
  CaptureFlags : tCaptureFlagTable;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get Default Capture Flags');
  GotoXY(5,6);
  write('Desc : Gets the default Capture Flags');
  GotoXY(3,8);
  write('Call : procedure GetDefaultCaptureFlags(var CaptureFlags : CaptureFlagTable);');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  GetDefaultCaptureFlags(CaptureFlags);
  ClrScr;
  GotoXY(5,10);
  with CaptureFlags do
  begin
    GotoXY(10,5);
    write('Status                     : ',Status);
    GotoXY(10,6);
    write('PrintFlag                  : ',PrintFlag);
    GotoXY(10,7);
    write('TabSize                    : ',TabSize);
    GotoXY(10,8);
    write('PrinterNo.                 : ',PrinterNo);
    GotoXY(10,9);
    write('Copies                     : ',Copies);
    GotoXY(10,10);
    write('FormType                   : ',FormType);
    GotoXY(10,11);
    write('BannerText                 : ');
    for i := 1 to 13 do write(BannerText[i]);
    GotoXY(10,12);
    write('Default Local Printer      : ',DefLocalPrt);
    GotoXY(10,13);
    write('Timeout in clocks          : ',TimeOut);
    GotoXY(10,14);
    write('Flush Capture on LPT close : ');
    if FlushCapt <> 0 then
      write('Yes')
    else
      write('No');
    GotoXY(10,15);
    write('Max Lines per Page         : ',MaxLines);
    GotoXY(10,16);
    write('Max Chars per Page         : ',MaxChars);
    GotoXY(10,23);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
    ClrScr;
    GotoXY(10,4);
    write('Required Form in Printer   : ');
    for i := 1 to 13 do write(PrtForm[i]);
    GotoXY(10,5);
    write('File Capture Flag          : ',CaptFlag);
    GotoXY(10,6);
    write('Time out                   : ');
    if TimingOut = $FF then
      write('Time-Out counting runing')
    else
      write('No Timeout');
    GotoXY(10,7);
    write('Target Connection Id       : ',TargetConnId);
    GotoXY(10,8);
    write('Capture in Progress        : ');
    if CapInProg = $FF then
      write('Yes')
    else
      write('No');
    GotoXY(10,9);
    write('Job queued for printing    : ');
    if JobQueued = $FF then
      write('Yes')
    else
      write('No');
    GotoXY(10,10);
    write('Bindery Objetc Id          : ',BinderyId);
    GotoXY(10,11);
    write('Printer Job Number         : ',PrintJobNo);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer B
 }

procedure PrinterB;

var
  CaptureFlags : tCaptureFlagTable;
  TempStr      : String[13];

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Set Default Capture Flags');
  GotoXY(5,6);
  write('Desc : Sets the default Capture Flags');
  GotoXY(5,8);
  write('Call : function SetDefaultCaptureFlags');
  GotoXY(5,9);
  write('       (CaptureFlags : CaptureFlagTable):boolean;');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  GetDefaultCaptureFlags(CaptureFlags);
  ClrScr;
  with CaptureFlags do
  begin
    GotoXY(10,5);
    write('PrintFlag                  : ');
    readln(PrintFlag);
    GotoXY(10,6);
    write('TabSize                    : ');
    readln(TabSize);
    GotoXY(10,7);
    write('PrinterNo.                 : ');
    readln(PrinterNo);
    GotoXY(10,8);
    write('Copies                     : ');
    readln(Copies);
    GotoXY(10,9);
    write('FormType                   : ');
    readln(FormType);
    GotoXY(10,10);
    write('BannerText                 : ');
    readln(tempstr);
    FillChar(BannerText,SizeOf(BannerText),0);
    for i := 1 to 13 do BannerText[i] := TempStr[i];
    GotoXY(10,11);
    write('Default Local Printer      : ');
    readln(DefLocalPrt);
    GotoXY(10,12);
    write('Timeout in clocks          : ');
    readln(TimeOut);
    GotoXY(10,13);
    write('Flush Capture on LPT close (Y/N) : ');
    readln(TempStr);
    if UpCase(TempStr[1]) = 'Y' then
      FlushCapt := $00
    else
      FlushCapt := $FF;
    GotoXY(10,14);
    write('Max Lines per Page         : ');
    readln(MaxLines);
    GotoXY(10,15);
    write('Max Chars per Page         : ');
    readln(MaxChars);
    GotoXY(10,16);
    write('Required Form in Printer   : ');
    readln(TempStr);
    FillChar(PrtForm,SizeOf(PrtForm),0);
    for i := 1 to 13 do PrtForm[i] := TempStr[i];
  end;
  writeln;
  if SetDefaultCaptureFlags(CaptureFlags) then
    write('Successfull set')
  else
    write('Error');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer C
 }

procedure PrinterC;

var
  CaptureFlags : tCaptureFlagTable;
  Port         : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get Specific Capture Flags');
  GotoXY(5,6);
  write('Desc : Gets specific Capture Flags');
  GotoXY(3,8);
  write('Call : procedure GetSpecificCaptureFlags(var CaptureFlags : CaptureFlagTable;');
  GotoXY(3,9);
  write('       LPTPort : Byte);');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to get Flags : ');
  readln(Port);
  ClrScr;
  GetSpecificCaptureFlags(CaptureFlags,Port);
  with CaptureFlags do
  begin
    GotoXY(10,5);
    write('Status                     : ',Status);
    GotoXY(10,6);
    write('PrintFlag                  : ',PrintFlag);
    GotoXY(10,7);
    write('TabSize                    : ',TabSize);
    GotoXY(10,8);
    write('PrinterNo.                 : ',PrinterNo);
    GotoXY(10,9);
    write('Copies                     : ',Copies);
    GotoXY(10,10);
    write('FormType                   : ',FormType);
    GotoXY(10,11);
    write('BannerText                 : ');
    for i := 1 to 13 do write(BannerText[i]);
    GotoXY(10,12);
    write('Default Local Printer      : ',DefLocalPrt);
    GotoXY(10,13);
    write('Timeout in clocks          : ',TimeOut);
    GotoXY(10,14);
    write('Flush Capture on LPT close : ');
    if FlushCapt <> 0 then
      write('Yes')
    else
      write('No');
    GotoXY(10,15);
    write('Max Lines per Page         : ',MaxLines);
    GotoXY(10,16);
    write('Max Chars per Page         : ',MaxChars);
    GotoXY(10,23);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
    ClrScr;
    GotoXY(10,4);
    write('Required Form in Printer   : ');
    for i := 1 to 13 do write(PrtForm[i]);
    GotoXY(10,5);
    write('File Capture Flag          : ',CaptFlag);
    GotoXY(10,6);
    write('Time out                   : ');
    if TimingOut = $FF then
      write('Time-Out counting runing')
    else
      write('No Timeout');
    GotoXY(10,7);
    write('Target Connection Id       : ',TargetConnId);
    GotoXY(10,8);
    write('Capture in Progress        : ');
    if CapInProg = $FF then
      write('Yes')
    else
      write('No');
    GotoXY(10,9);
    write('Job queued for printing    : ');
    if JobQueued = $FF then
      write('Yes')
    else
      write('No');
    GotoXY(10,10);
    write('Bindery Objetc Id          : ',BinderyId);
    GotoXY(10,11);
    write('Printer Job Number         : ',PrintJobNo);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer D
 }

procedure PrinterD;

var
  CaptureFlags : tCaptureFlagTable;
  TempStr      : String[13];
  Port         : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Set specific Capture Flags');
  GotoXY(5,6);
  write('Desc : Sets specific Capture Flags');
  GotoXY(5,8);
  write('Call : function SetSpecificCaptureFlags(CaptureFlags : CaptureFlagTable;');
  GotoXY(5,9);
  write('       LPTPort : Byte):boolean;');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to set Flags : ');
  readln(Port);
  ClrScr;
  with CaptureFlags do
  begin
    GotoXY(10,5);
    write('PrintFlag                  : ');
    readln(PrintFlag);
    GotoXY(10,6);
    write('TabSize                    : ');
    readln(TabSize);
    GotoXY(10,7);
    write('PrinterNo.                 : ');
    readln(PrinterNo);
    GotoXY(10,8);
    write('Copies                     : ');
    readln(Copies);
    GotoXY(10,9);
    write('FormType                   : ');
    readln(FormType);
    GotoXY(10,10);
    write('BannerText                 : ');
    readln(tempstr);
    FillChar(BannerText,SizeOf(BannerText),0);
    for i := 1 to 13 do BannerText[i] := TempStr[i];
    GotoXY(10,11);
    write('Default Local Printer      : ');
    readln(DefLocalPrt);
    GotoXY(10,12);
    write('Timeout in clocks          : ');
    readln(TimeOut);
    GotoXY(10,13);
    write('Flush Capture on LPT close (Y/N) : ');
    readln(TempStr);
    if UpCase(TempStr[1]) = 'Y' then
      FlushCapt := $00
    else
      FlushCapt := $FF;
    GotoXY(10,14);
    write('Max Lines per Page         : ');
    readln(MaxLines);
    GotoXY(10,15);
    write('Max Chars per Page         : ');
    readln(MaxChars);
    GotoXY(10,16);
    write('Required Form in Printer   : ');
    readln(TempStr);
    FillChar(PrtForm,SizeOf(PrtForm),0);
    for i := 1 to 13 do PrtForm[i] := TempStr[i];
  end;
  writeln;
  if SetSpecificCaptureFlags(CaptureFlags,Port) then
    write('Successfull set')
  else
    write('Error');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer E
 }

procedure PrinterE;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get local default Printer');
  GotoXY(5,6);
  write('Desc : Returns the default Local Printer');
  GotoXY(5,8);
  write('Call : function GetDefaultLocalPrinter:Byte;');
  GotoXY(5,10);
  write('Reply   : Local Printer');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Default Local Printer : ',GetDefaultLocalPrinter);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer F
 }

procedure PrinterF;

var
  LPTPort : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Set local default Printer');
  GotoXY(5,6);
  write('Desc : Sets the default Local Printer');
  GotoXY(5,8);
  write('Call : function SetDefaultLocalPrinter(LPTPort : Byte):boolean;');
  GotoXY(5,10);
  write('Request : LPTPort Printer to set as local default Printer');
  GotoXY(5,12);
  write('Reply   : Local Printer');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Printer Port to set as default : ');
  readln(LPTPort);
  if SetDefaultLocalPrinter(LPTPort) then
  begin
    ClrScr;
    GotoXY(10,4);
    Write('New local Printer successfull set !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    Write('Error ! Port maybe doesn`t exist ');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer G
 }

procedure PrinterG;

var
  UserName : BannerUserName;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get Banner User');
  GotoXY(5,6);
  write('Desc : Gets the Banner Username');
  GotoXY(5,8);
  write('Call : function GetBannerUser(UserName : BannerUserName):boolean;');
  GotoXY(5,10);
  write('Reply   : UserName     = Banner Username');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if GetBannerUser(UserName) then
  begin
    GotoXY(10,4);
    Write(' Successfull Username : ',UserName);
  end
  else
  begin
    GotoXY(10,4);
    Write(' Error !');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer H
 }

procedure PrinterH;

var
  UserName : BannerUserName;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Set Banner User');
  GotoXY(5,6);
  write('Desc : Sets the Banner Username');
  GotoXY(5,8);
  write('Call : function SetBannerUser(UserName : BannerUserName):boolean;');
  GotoXY(5,10);
  write('Request : UserName     = Banner Username');
  GotoXY(5,12);
  write('Reply   : true if successfull done');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('New Banner Username : ');
  readln(Username);
  ClrScr;
  if SetBannerUser(UserName) then
  begin
    GotoXY(10,4);
    Write(' Successfull done');
  end
  else
  begin
    GotoXY(10,4);
    Write(' Error !');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer I
 }

procedure PrinterI;

var
  Status  : tPrinterStatus;
  Printer : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Printer Status');
  GotoXY(5,8);
  write('Desc : Gets the Status of the specified Printer');
  GotoXY(1,10);
  write('Call : function GetPtrStatus(var Status : PrinterStatus;Printer : Byte):boolean;');
  GotoXY(5,12);
  write('Request : Printer             = Printer-No ');
  GotoXY(5,14);
  write('Reply   : Status.PtrActiv     = true when Printer activ');
  GotoXY(5,15);
  write('          Status.PtrOnline    = true if Printer online');
  GotoXY(5,16);
  write('          Status.PtrForm      = Printer Form');
  GotoXY(5,17);
  write('          Status.PtrTarget    = Target Printer Number');
  GotoXY(5,18);
  write('          Functions returns false if Printer not found');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Printer-No      : ');
  readln(Printer);
  if GetPtrStatus(Status,Printer) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Successfull ');
    with Status do
    begin
      GotoXY(10,6);
      write('Printer activ         : ',PtrActiv);
      GotoXY(10,7);
      write('Printer online        : ',PtrOnline);
      GotoXY(10,8);
      write('Printer Form          : ',PtrForm);
      GotoXY(10,9);
      write('Target Printer Number : ',PtrTarget);
    end;
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' No such Printer');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer J
 }

procedure PrinterJ;

var
  Handle,
  Flags         : Byte;
  FileName      : String;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Specify Capture File');
  GotoXY(5,8);
  write('Desc : Specifies an Capture File');
  GotoXY(2,10);
  write('Call : function SpecifyCaptureFile(DirHandle : Byte;FileName : String):boolean;');
  GotoXY(5,12);
  write('Request : DirHandle           = Dir-Handle of Filename');
  GotoXY(5,13);
  write('          FileName            = Name of Capture-File (Network Styled)');
  GotoXY(5,15);
  write('Reply   : Functions returns true if successfull done');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write(' Filename        : ');
  readln(FileName);
  GetDirHandle(Handle,Flags,'F');
  if SpecifyCaptureFile(Handle,FileName) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Successfull done !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error !');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer K
 }

procedure PrinterK;

var
  ServerConn : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Lpt Capture Status');
  GotoXY(5,8);
  write('Desc : Get the Capture Status');
  GotoXY(5,10);
  write('Call : function GetLPTCaptureStatus(Var ServerConn : Byte):boolean;');
  GotoXY(5,12);
  write('Reply   : ServerConn    = Server Connection of Capture');
  GotoXY(5,13);
  write('          functions returns true if Capture activ');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if GetLPTCaptureStatus(ServerConn) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture activ on Server-Connection : ',ServerConn);
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' No Capture activ');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer L
 }

procedure PrinterL;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Start Lpt Capture');
  GotoXY(5,8);
  write('Desc : Starts the LPT-Capture');
  GotoXY(5,10);
  write('Call : function StartLPTCapture:boolean;');
  GotoXY(5,12);
  write('Reply   : true if Capture started');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if StartLPTCapture then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture started !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer M
 }

procedure PrinterM;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('End Lpt Capture');
  GotoXY(5,8);
  write('Desc : Stops the LPT-Capture');
  GotoXY(5,10);
  write('Call : function EndLPTCapture:boolean;');
  GotoXY(5,12);
  write('Reply   : true if Capture stopped');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if EndLPTCapture then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture stopped !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer N
 }

procedure PrinterN;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Cancle Lpt Capture');
  GotoXY(5,8);
  write('Desc : Ends the LPT-Capture,removes the Job and deletes Capture-File');
  GotoXY(5,10);
  write('Call : function CancelLPTCapture:boolean;');
  GotoXY(5,12);
  write('Reply   : true if Capture successfull ended');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if CancelLPTCapture then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture canceld !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer O
 }

procedure PrinterO;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Flush Lpt Capture');
  GotoXY(5,8);
  write('Desc : Flushes the LPT-Capture');
  GotoXY(5,10);
  write('Call : FlushLPTCapture:boolean;');
  GotoXY(5,12);
  write('Reply   : true if Capture successfull flushed');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if FlushLPTCapture then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture flushed !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer P
 }

procedure PrinterP;

var
  PrinterPort : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Start Specific LPT Capture');
  GotoXY(5,8);
  write('Desc : Start Specific LPT Capture');
  GotoXY(5,10);
  write('Call : function StartSpecificLPTCapture(PrinterPort : Byte):boolean;');
  GotoXY(5,12);
  write('Request : PrinterPort  = Port to start Capture');
  GotoXY(5,14);
  write('Reply   : true if Capture successfull started');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to start Capture  : ');
  readln(PrinterPort);
  if StartSpecificLPTCapture(PrinterPort) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture started');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer Q
 }

procedure PrinterQ;

var
  PrinterPort : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('End Specific LPT Capture');
  GotoXY(5,8);
  write('Desc : Ends specific LPT Capture');
  GotoXY(5,10);
  write('Call : function EndSpecificLPTCapture(PrinterPort : Byte):boolean;');
  GotoXY(5,12);
  write('Request : PrinterPort  = Port to end Capture');
  GotoXY(5,14);
  write('Reply   : true if Capture successfull ended');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to end Capture  : ');
  readln(PrinterPort);
  if EndSpecificLPTCapture(PrinterPort) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture ended');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer R
 }

procedure PrinterR;

var
  PrinterPort : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Cancel Specific LPT Capture');
  GotoXY(5,8);
  write('Desc : Cancel specific LPT Capture');
  GotoXY(5,10);
  write('Call : function CancelSpecificLPTCapture(PrinterPort : Byte):boolean;');
  GotoXY(5,12);
  write('Request : PrinterPort  = Port to cancel Capture');
  GotoXY(5,14);
  write('Reply   : true if Capture successfull canceled');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to cancel Capture  : ');
  readln(PrinterPort);
  if CancelSpecificLPTCapture(PrinterPort) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture canceled');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer S
 }

procedure PrinterS;

var
  PrinterPort : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Flush Specific LPT Capture');
  GotoXY(5,8);
  write('Desc : Flushs specific LPT Capture');
  GotoXY(5,10);
  write('Call : function FlushSpecificLPTCapture(PrinterPort : Byte):boolean;');
  GotoXY(5,12);
  write('Request : PrinterPort  = Port to flush Capture');
  GotoXY(5,14);
  write('Reply   : true if Capture successfull flushed');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to flush Capture  : ');
  readln(PrinterPort);
  if FlushSpecificLPTCapture(PrinterPort) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Capture flushed');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer T
 }

procedure PrinterT;

var
  PrinterPort : Byte;
  QueueId     : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set Printer Capture Queue');
  GotoXY(5,8);
  write('Desc : Sets the Queue of an Printer-Port');
  GotoXY(5,10);
  write('Call : function SetPtrCaptureQueue(PrinterPort : Byte;');
  GotoXY(5,11);
  write('       ObjId : LongInt):boolean;');
  GotoXY(5,13);
  write('Request : PrinterPort  = Port to specify');
  GotoXY(5,14);
  write('          ObjId        = Object Id of Queue');
  GotoXY(5,16);
  write('Reply   : true if Queue successfull set');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to set  : ');
  readln(PrinterPort);
  GotoXY(5,6);
  Write(' Queue-Id         : ');
  readln(QueueId);
  if SetPtrCaptureQueue(PrinterPort,QueueId) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Successfull set !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Printer U
 }

procedure PrinterU;

var
  PrinterPort : Byte;
  QueueId     : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell printer unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set Printer Capture Queue');
  GotoXY(5,8);
  write('Desc : Sets the Queue of an Printer-Port');
  GotoXY(5,10);
  write('Call : function SetPtrCaptureQueue(PrinterPort : Byte;');
  GotoXY(5,11);
  write('       ObjId : LongInt):boolean;');
  GotoXY(5,13);
  write('Request : PrinterPort  = Port to specify');
  GotoXY(5,14);
  write('          ObjId        = Object Id of Queue');
  GotoXY(5,16);
  write('Reply   : true if Queue successfull set');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' LPT-Port to set  : ');
  readln(PrinterPort);
  GotoXY(5,6);
  Write(' Queue-Id         : ');
  readln(QueueId);
  if SetPtrCaptureQueue(PrinterPort,QueueId) then
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Successfull set !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write(' Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                  main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for printer unit (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5,4);
    write('A : Get default capture-flags, ##');
    GotoXY(5,5);
    write('B : Set default capture-flags, ##');
    GotoXY(5,6);
    write('C : Get specific def. capture-flags,##');
    GotoXY(5,7);
    write('D : Set specific capture flags, ##');
    GotoXY(5,8);
    write('E : Get default local printer, ##');
    GotoXY(5,9);
    write('F : Set default local printer, ##');
    GotoXY(5,10);
    write('G : Get banner user-name, ##');
    GotoXY(5,11);
    write('H : Set banner user-name, ##');
    GotoXY(5,12);
    write('I : Get printer status, ##');
    GotoXY(5,13);
    write('J : Specify capture file, ##');
    GotoXY(5,14);
    write('K : Get LPT capture status, ##');
    GotoXY(5,15);
    write('L : Start LPT capture, ##');
    GotoXY(5,16);
    write('M : End LPT capture, ##');
    GotoXY(5,17);
    write('N : Cancel LPT capture, ##');
    GotoXY(5,18);
    write('O : Flush LPT capture, ##');
    GotoXY(44,4);
    write('P : Start specific LPT capture, ##');
    GotoXY(44,5);
    write('Q : End specific LPT capture, ##');
    GotoXY(44,6);
    write('R : Cancel specific LPT capture, ##');
    GotoXY(44,7);
    write('S : Flush specific LPT capture, ##');
    GotoXY(44,8);
    write('T : Set printer capture queue, ##');
    GotoXY(44,9);
    write('U : Set capture print job, ##');
    GotoXY(18,22);
    Write('0 : Exit to Main, X : Exit Program Choose Function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : PrinterA;
      'B' : PrinterB;
      'C' : PrinterC;
      'D' : PrinterD;
      'E' : PrinterE;
      'F' : PrinterF;
      'G' : PrinterG;
      'H' : PrinterH;
      'I' : PrinterI;
      'J' : PrinterJ;
      'K' : PrinterK;
      'L' : PrinterL;
      'M' : PrinterM;
      'N' : PrinterN;
      'O' : PrinterO;
      'P' : PrinterP;
      'Q' : PrinterQ;
      'R' : PrinterR;
      'S' : PrinterS;
      'T' : PrinterT;
      'U' : PrinterU;
      'X' : halt(0);
    end;
  until false;
end.
